/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.frequency;

import com.google.common.base.Joiner;
import com.google.common.collect.LinkedHashMultimap;
import com.vaadin.data.Binder;
import com.vaadin.data.HasValue;
import com.vaadin.event.LayoutEvents;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.ProgressBar;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.event.FieldEvents;
import com.vaadin.v7.shared.ui.label.ContentMode;
import com.vaadin.v7.ui.CheckBox;
import com.vaadin.v7.ui.Field;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.Table;
import com.vaadin.v7.ui.TableFieldFactory;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import org.corpus_tools.annis.ApiException;
import org.corpus_tools.annis.api.SearchApi;
import org.corpus_tools.annis.api.model.FrequencyTableRow;
import org.corpus_tools.annis.api.model.QueryAttributeDescription;
import org.corpus_tools.annis.api.model.QueryLanguage;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.annis.gui.QueryController;
import org.corpus_tools.annis.gui.frequency.FrequencyQueryPanel;
import org.corpus_tools.annis.gui.frequency.FrequencyResultPanel;
import org.corpus_tools.annis.gui.frequency.UserGeneratedFrequencyEntry;
import org.corpus_tools.annis.gui.objects.FrequencyQuery;
import org.corpus_tools.annis.gui.objects.QueryUIState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrequencyQueryPanel
extends VerticalLayout
implements Serializable,
FieldEvents.TextChangeListener {
    private static final long serialVersionUID = -5228968211970200113L;
    private static final Logger log = LoggerFactory.getLogger(FrequencyQueryPanel.class);
    private Table tblFrequencyDefinition;
    private final Button btAdd;
    private final Button btReset;
    private final CheckBox cbAutomaticMode;
    private Button btDeleteRow;
    private Button btShowFrequencies;
    private int counter;
    private FrequencyResultPanel resultPanel;
    private Button btShowQuery;
    private VerticalLayout queryLayout;
    private final Label lblCorpusList;
    private final Label lblAQL;
    private final Label lblErrorOrMsg;
    private transient WeakHashMap<Field<?>, Object> field2ItemID;
    private final ProgressBar pbQuery = new ProgressBar();
    private final QueryUIState state;
    private final QueryController controller;

    public FrequencyQueryPanel(QueryController controller, QueryUIState state) {
        this.state = state;
        this.controller = controller;
        this.setWidth("99%");
        this.setHeight("99%");
        this.setMargin(true);
        this.queryLayout = new VerticalLayout();
        this.queryLayout.setWidth("100%");
        this.queryLayout.setHeight("100%");
        HorizontalLayout queryDescriptionLayout = new HorizontalLayout();
        queryDescriptionLayout.setSpacing(true);
        queryDescriptionLayout.setWidth("100%");
        queryDescriptionLayout.setHeight("-1px");
        this.queryLayout.addComponent((Component)queryDescriptionLayout);
        this.lblCorpusList = new Label("");
        this.lblCorpusList.setCaption("selected corpora:");
        this.lblCorpusList.setWidth("100%");
        this.lblAQL = new Label("");
        this.lblAQL.setCaption("query to analyze:");
        this.lblAQL.setWidth("100%");
        this.lblAQL.addStyleName("corpus-font-force");
        queryDescriptionLayout.addComponent((Component)this.lblCorpusList);
        queryDescriptionLayout.addComponent((Component)this.lblAQL);
        queryDescriptionLayout.setComponentAlignment((Component)this.lblCorpusList, Alignment.MIDDLE_LEFT);
        queryDescriptionLayout.setComponentAlignment((Component)this.lblAQL, Alignment.MIDDLE_RIGHT);
        this.tblFrequencyDefinition = new Table();
        this.tblFrequencyDefinition.setImmediate(true);
        this.tblFrequencyDefinition.setSortEnabled(false);
        this.tblFrequencyDefinition.setSelectable(true);
        this.tblFrequencyDefinition.setMultiSelect(true);
        this.tblFrequencyDefinition.setTableFieldFactory((TableFieldFactory)new FieldFactory(this));
        this.tblFrequencyDefinition.setEditable(true);
        this.tblFrequencyDefinition.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> {
            if (this.tblFrequencyDefinition.getValue() == null || ((Set)this.tblFrequencyDefinition.getValue()).isEmpty()) {
                this.btDeleteRow.setEnabled(false);
            } else {
                this.btDeleteRow.setEnabled(true);
            }
        });
        this.lblErrorOrMsg = new Label("No node with explicit name in OR expression found! When using OR expression you need to explicitly name the nodes you want to include in the frequency analysis with \"#\", like e.g. in <br /><pre>(n1#tok=\"fun\" | n1#tok=\"severity\")</pre>");
        this.lblErrorOrMsg.setContentMode(ContentMode.HTML);
        this.lblErrorOrMsg.addStyleName("embedded-warning");
        this.lblErrorOrMsg.setWidth("100%");
        this.lblErrorOrMsg.setVisible(false);
        this.queryLayout.addComponent((Component)this.lblErrorOrMsg);
        this.tblFrequencyDefinition.setWidth("100%");
        this.tblFrequencyDefinition.setHeight("100%");
        this.tblFrequencyDefinition.setContainerDataSource((Container)state.getFrequencyTableDefinition());
        this.tblFrequencyDefinition.setColumnHeader((Object)"nr", "Node number/name");
        this.tblFrequencyDefinition.setColumnHeader((Object)"annotation", "Selected annotation of node");
        this.tblFrequencyDefinition.setColumnHeader((Object)"comment", "Comment");
        this.tblFrequencyDefinition.addStyleName("corpus-font-force");
        this.tblFrequencyDefinition.setRowHeaderMode(Table.RowHeaderMode.INDEX);
        this.tblFrequencyDefinition.setColumnExpandRatio((Object)"nr", 0.15f);
        this.tblFrequencyDefinition.setColumnExpandRatio((Object)"annotation", 0.35f);
        this.tblFrequencyDefinition.setColumnExpandRatio((Object)"comment", 0.5f);
        this.tblFrequencyDefinition.setVisibleColumns(new Object[]{"nr", "annotation", "comment"});
        this.queryLayout.addComponent((Component)this.tblFrequencyDefinition);
        if (controller != null) {
            this.createAutomaticEntriesForQuery((String)state.getAql().getValue(), state.getQueryLanguage());
            this.updateQueryInfo((String)state.getAql().getValue());
        }
        HorizontalLayout layoutButtons = new HorizontalLayout();
        this.cbAutomaticMode = new CheckBox("Automatic mode", true);
        this.cbAutomaticMode.setImmediate(true);
        this.cbAutomaticMode.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> {
            this.btShowFrequencies.setEnabled(true);
            if (((Boolean)this.cbAutomaticMode.getValue()).booleanValue()) {
                this.tblFrequencyDefinition.removeAllItems();
                if (controller != null) {
                    this.createAutomaticEntriesForQuery((String)this.state.getAql().getValue(), this.state.getQueryLanguage());
                }
            }
        });
        this.btAdd = new Button("Add");
        this.btAdd.addClickListener((Button.ClickListener & Serializable)event -> {
            this.cbAutomaticMode.setValue((Object)Boolean.FALSE);
            int nr = 1;
            for (Object id1 : this.tblFrequencyDefinition.getItemIds()) {
                String textNr = (String)this.tblFrequencyDefinition.getItem(id1).getItemProperty((Object)"nr").getValue();
                try {
                    nr = Math.max(nr, Integer.parseInt(textNr));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (controller != null) {
                List nodes = new LinkedList();
                try {
                    nodes = this.parseQuery((String)this.state.getAql().getValue(), this.state.getQueryLanguage());
                }
                catch (ApiException id1) {
                    // empty catch block
                }
                nr = Math.min(nr, nodes.size() - 1);
                int id2 = this.counter++;
                UserGeneratedFrequencyEntry entry = new UserGeneratedFrequencyEntry();
                entry.setAnnotation("tok");
                entry.setComment("");
                entry.setNr("" + (nr + 1));
                this.state.getFrequencyTableDefinition().addItem((Object)id2, (Object)entry);
            }
        });
        layoutButtons.addComponent((Component)this.btAdd);
        this.btDeleteRow = new Button("Delete selected row(s)");
        this.btDeleteRow.setEnabled(false);
        this.btDeleteRow.addClickListener((Button.ClickListener & Serializable)event -> {
            Object rawValue = this.tblFrequencyDefinition.getValue();
            if (rawValue instanceof Collection) {
                HashSet selected = new HashSet((Collection)rawValue);
                for (Object o : selected) {
                    this.cbAutomaticMode.setValue((Object)Boolean.FALSE);
                    this.tblFrequencyDefinition.removeItem(o);
                }
            }
        });
        layoutButtons.addComponent((Component)this.btDeleteRow);
        layoutButtons.addComponent((Component)this.cbAutomaticMode);
        this.btReset = new Button("Reset to default");
        this.btReset.addClickListener((Button.ClickListener & Serializable)event -> {
            this.cbAutomaticMode.setValue((Object)Boolean.TRUE);
            this.btShowFrequencies.setEnabled(true);
            this.tblFrequencyDefinition.removeAllItems();
            if (controller != null) {
                this.createAutomaticEntriesForQuery((String)this.state.getAql().getValue(), this.state.getQueryLanguage());
            }
        });
        layoutButtons.setComponentAlignment((Component)this.btAdd, Alignment.MIDDLE_LEFT);
        layoutButtons.setComponentAlignment((Component)this.btDeleteRow, Alignment.MIDDLE_LEFT);
        layoutButtons.setComponentAlignment((Component)this.cbAutomaticMode, Alignment.MIDDLE_RIGHT);
        layoutButtons.setExpandRatio((Component)this.btAdd, 0.0f);
        layoutButtons.setExpandRatio((Component)this.btDeleteRow, 0.0f);
        layoutButtons.setExpandRatio((Component)this.cbAutomaticMode, 1.0f);
        layoutButtons.setMargin(true);
        layoutButtons.setSpacing(true);
        layoutButtons.setHeight("-1px");
        layoutButtons.setWidth("100%");
        this.queryLayout.addComponent((Component)layoutButtons);
        this.btShowFrequencies = new Button("Perform frequency analysis");
        this.btShowFrequencies.setDisableOnClick(true);
        this.btShowFrequencies.addClickListener((Button.ClickListener & Serializable)event -> {
            if (controller != null) {
                try {
                    if (this.resultPanel != null) {
                        this.removeComponent((Component)this.resultPanel);
                    }
                    this.queryLayout.setVisible(false);
                    this.pbQuery.setCaption("Please wait, the frequencies analysis can take some time");
                    this.pbQuery.setIndeterminate(true);
                    this.pbQuery.setEnabled(true);
                    this.pbQuery.setVisible(true);
                    controller.executeFrequency(this);
                }
                catch (Exception ex) {
                    this.btShowFrequencies.setEnabled(true);
                }
            }
        });
        this.queryLayout.addComponent((Component)this.btShowFrequencies);
        this.queryLayout.setComponentAlignment((Component)this.tblFrequencyDefinition, Alignment.TOP_CENTER);
        this.queryLayout.setComponentAlignment((Component)layoutButtons, Alignment.TOP_CENTER);
        this.queryLayout.setComponentAlignment((Component)this.btShowFrequencies, Alignment.TOP_CENTER);
        this.queryLayout.setExpandRatio((Component)this.tblFrequencyDefinition, 1.0f);
        this.queryLayout.setExpandRatio((Component)layoutButtons, 0.0f);
        this.queryLayout.setExpandRatio((Component)this.btShowFrequencies, 0.0f);
        this.queryLayout.addLayoutClickListener((LayoutEvents.LayoutClickListener & Serializable)event -> {
            Object itemID;
            Component c = event.getClickedComponent();
            if (c instanceof Field && (itemID = this.getField2ItemID().get(c)) != null) {
                if (!event.isCtrlKey() && !event.isShiftKey()) {
                    this.tblFrequencyDefinition.setValue(null);
                }
                this.tblFrequencyDefinition.select(itemID);
            }
        });
        this.btShowQuery = new Button("New Analysis", (Button.ClickListener & Serializable)event -> this.showQueryDefinitionPanel());
        this.btShowQuery.setVisible(false);
        this.pbQuery.setVisible(false);
        this.addComponent((Component)this.pbQuery);
        this.addComponent((Component)this.queryLayout);
        this.addComponent((Component)this.btShowQuery);
        this.setComponentAlignment((Component)this.btShowQuery, Alignment.TOP_CENTER);
        this.setComponentAlignment((Component)this.pbQuery, Alignment.TOP_CENTER);
        if (controller != null) {
            Binder binder = new Binder();
            binder.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                this.createAutomaticEntriesForQuery((String)this.state.getAql().getValue(), this.state.getQueryLanguage());
                this.updateQueryInfo((String)this.state.getAql().getValue());
            });
            binder.setBean((Object)state);
        }
    }

    public void attach() {
        super.attach();
        if (this.controller != null) {
            this.createAutomaticEntriesForQuery((String)this.state.getAql().getValue(), this.state.getQueryLanguage());
            this.updateQueryInfo((String)this.state.getAql().getValue());
        }
    }

    private void createAutomaticEntriesForQuery(String query, QueryLanguage queryLanguage) {
        if (query == null || query.isEmpty()) {
            return;
        }
        try {
            this.state.getFrequencyTableDefinition().removeAllItems();
            this.lblErrorOrMsg.setVisible(false);
            this.counter = 0;
            List nodes = this.parseQuery(query, queryLanguage);
            Collections.sort(nodes, (o1, o2) -> {
                if (o1.getVariable() == null) {
                    return o2 == null ? 0 : -1;
                }
                return o1.getVariable().compareTo(o2.getVariable());
            });
            LinkedHashMultimap alternativesOfVariable = LinkedHashMultimap.create();
            long maxAlternative = 0L;
            for (Object n : nodes) {
                maxAlternative = Math.max((long)n.getAlternative().intValue(), maxAlternative);
                alternativesOfVariable.put((Object)n.getVariable(), (Object)n.getAlternative());
            }
            LinkedHashSet<String> allowedVariables = new LinkedHashSet<String>();
            for (QueryAttributeDescription n : nodes) {
                if ((long)alternativesOfVariable.get((Object)n.getVariable()).size() != maxAlternative + 1L) continue;
                allowedVariables.add(n.getVariable());
            }
            if (maxAlternative > 0L && allowedVariables.isEmpty()) {
                this.lblErrorOrMsg.setVisible(true);
            }
            HashSet<UserGeneratedFrequencyEntry> generatedEntries = new HashSet<UserGeneratedFrequencyEntry>();
            for (QueryAttributeDescription n : nodes) {
                int id;
                UserGeneratedFrequencyEntry entry;
                if (!allowedVariables.contains(n.getVariable())) continue;
                if (n.getAnnoName() == null) {
                    entry = new UserGeneratedFrequencyEntry();
                    entry.setAnnotation("tok");
                    entry.setComment("automatically created from " + n.getQueryFragment());
                    entry.setNr(n.getVariable());
                    if (generatedEntries.contains(entry)) continue;
                    ++this.counter;
                    this.state.getFrequencyTableDefinition().addItem((Object)id, (Object)entry);
                    generatedEntries.add(entry);
                    continue;
                }
                entry = new UserGeneratedFrequencyEntry();
                entry.setAnnotation(n.getAnnoName());
                entry.setComment("automatically created from " + n.getQueryFragment());
                entry.setNr(n.getVariable());
                if (generatedEntries.contains(entry)) continue;
                ++this.counter;
                this.state.getFrequencyTableDefinition().addItem((Object)id, (Object)entry);
                generatedEntries.add(entry);
            }
        }
        catch (ApiException apiException) {
            // empty catch block
        }
    }

    private WeakHashMap<Field<?>, Object> getField2ItemID() {
        if (this.field2ItemID == null) {
            this.field2ItemID = new WeakHashMap();
        }
        return this.field2ItemID;
    }

    public void notifiyQueryFinished() {
        this.btShowFrequencies.setEnabled(true);
        this.btShowQuery.setVisible(true);
    }

    private List<QueryAttributeDescription> parseQuery(String query, QueryLanguage queryLanguage) throws ApiException {
        if (query == null || query.isEmpty()) {
            return new LinkedList<QueryAttributeDescription>();
        }
        SearchApi api = new SearchApi(Helper.getClient((UI)UI.getCurrent()));
        List nodes = api.nodeDescriptions(query, queryLanguage);
        return nodes;
    }

    public void showQueryDefinitionPanel() {
        this.btShowFrequencies.setEnabled(true);
        this.pbQuery.setVisible(false);
        this.btShowQuery.setVisible(false);
        this.queryLayout.setVisible(true);
        this.resultPanel.setVisible(false);
    }

    public void showResult(List<FrequencyTableRow> result, FrequencyQuery query) {
        this.pbQuery.setVisible(false);
        this.resultPanel = new FrequencyResultPanel(result, query, this);
        this.addComponent((Component)this.resultPanel);
        this.setExpandRatio((Component)this.resultPanel, 1.0f);
        this.queryLayout.setVisible(false);
    }

    public void textChange(FieldEvents.TextChangeEvent event) {
        if (((Boolean)this.cbAutomaticMode.getValue()).booleanValue()) {
            this.createAutomaticEntriesForQuery(event.getText(), this.state.getQueryLanguage());
        }
        this.updateQueryInfo(event.getText());
    }

    private void updateQueryInfo(String query) {
        Set selectedCorpora = this.state.getSelectedCorpora();
        if (selectedCorpora.isEmpty()) {
            this.lblCorpusList.setValue("none");
        } else {
            this.lblCorpusList.setValue(Joiner.on((String)", ").join((Iterable)selectedCorpora));
        }
        if (query == null || query.isEmpty()) {
            this.lblAQL.setValue("<empty query>");
        } else {
            this.lblAQL.setValue(query.replaceAll("[\n\r]+", " "));
        }
    }

    static /* synthetic */ WeakHashMap access$000(FrequencyQueryPanel x0) {
        return x0.getField2ItemID();
    }
}

