/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.frequency;

import com.google.common.base.Joiner;
import com.vaadin.server.FileDownloader;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.server.StreamResource;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.util.AbstractBeanContainer;
import com.vaadin.v7.data.util.DefaultItemSorter;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.data.util.ItemSorter;
import com.vaadin.v7.ui.Table;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.corpus_tools.annis.api.model.FrequencyTableRow;
import org.corpus_tools.annis.gui.components.FrequencyChart;
import org.corpus_tools.annis.gui.frequency.FrequencyQueryPanel;
import org.corpus_tools.annis.gui.frequency.FrequencyResultPanel;
import org.corpus_tools.annis.gui.objects.FrequencyQuery;
import org.corpus_tools.annis.gui.objects.FrequencyTableEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class FrequencyResultPanel
extends VerticalLayout {
    private static final long serialVersionUID = -6481939456466850550L;
    private static final Logger log = LoggerFactory.getLogger(FrequencyResultPanel.class);
    public static final int MAX_NUMBER_OF_CHART_ITEMS = 100;
    private Table tblResult;
    private final Button btDownloadCSV;
    private final FrequencyChart chart;
    private final FrequencyQueryPanel queryPanel;
    private final FrequencyQuery query;

    public static String getCaption(FrequencyTableEntry e) {
        String caption;
        switch (1.$SwitchMap$org$corpus_tools$annis$gui$objects$FrequencyTableEntryType[e.getType().ordinal()]) {
            case 1: {
                caption = "#" + e.getReferencedNode() + "|" + e.getKey();
                break;
            }
            case 2: {
                caption = "#" + e.getReferencedNode() + "|spanned text";
                break;
            }
            default: {
                caption = "<unknown>";
            }
        }
        return caption;
    }

    public FrequencyResultPanel(List<FrequencyTableRow> table, FrequencyQuery query, FrequencyQueryPanel queryPanel) {
        this.query = query;
        this.queryPanel = queryPanel;
        this.setSizeFull();
        this.chart = new FrequencyChart(this);
        this.chart.setHeight("350px");
        this.chart.setVisible(false);
        this.addComponent((Component)this.chart);
        this.btDownloadCSV = new Button("Download as CSV");
        this.btDownloadCSV.setDescription("Download as CSV");
        this.btDownloadCSV.setSizeUndefined();
        this.addComponent((Component)this.btDownloadCSV);
        this.setComponentAlignment((Component)this.btDownloadCSV, Alignment.TOP_RIGHT);
        this.btDownloadCSV.setVisible(false);
        this.btDownloadCSV.setIcon((Resource)FontAwesome.DOWNLOAD);
        this.btDownloadCSV.addStyleName("small");
        this.showResult(table);
    }

    private void addLexicalSort(Container container) {
        DefaultItemSorter sorter = new DefaultItemSorter((Comparator)new IgnoreCaseComparator());
        if (container instanceof IndexedContainer) {
            ((IndexedContainer)container).setItemSorter((ItemSorter)sorter);
        } else if (container instanceof AbstractBeanContainer) {
            ((AbstractBeanContainer)container).setItemSorter((ItemSorter)sorter);
        }
    }

    private void recreateTable(List<FrequencyTableRow> table) {
        if (this.tblResult != null) {
            this.removeComponent((Component)this.tblResult);
        }
        this.tblResult = new Table();
        this.tblResult.setSizeFull();
        this.tblResult.setCaption(table.size() + " items with a total sum of " + table.stream().map(row -> row.getCount()).reduce(0, Integer::sum) + " (query on " + Joiner.on((String)", ").join((Iterable)this.query.getCorpora()) + ")");
        this.tblResult.setSelectable(true);
        this.tblResult.setMultiSelect(false);
        this.tblResult.addStyleName("corpus-font-force");
        if (!table.isEmpty()) {
            FrequencyTableRow firstEntry = table.iterator().next();
            int tupelCount = firstEntry.getValues().size();
            this.tblResult.addContainerProperty((Object)"rank", Integer.class, (Object)-1);
            for (int i = 1; i <= tupelCount; ++i) {
                this.tblResult.addContainerProperty((Object)("tupel-" + i), String.class, (Object)"");
                FrequencyTableEntry e = (FrequencyTableEntry)this.query.getFrequencyDefinition().get(i - 1);
                this.tblResult.setColumnHeader((Object)("tupel-" + i), FrequencyResultPanel.getCaption((FrequencyTableEntry)e));
            }
            this.tblResult.addContainerProperty((Object)"count", Integer.class, (Object)-1L);
            int line = 0;
            for (FrequencyTableRow e : table) {
                Object[] cells = new Object[tupelCount + 2];
                System.arraycopy(e.getValues().toArray(), 0, cells, 1, tupelCount);
                cells[0] = line + 1;
                cells[cells.length - 1] = e.getCount();
                this.tblResult.addItem(cells, (Object)("entry-" + line++));
            }
        }
        this.addLexicalSort(this.tblResult.getContainerDataSource());
        this.addComponent((Component)this.tblResult);
        this.setExpandRatio((Component)this.tblResult, 1.0f);
    }

    public void selectRow(int i) {
        this.tblResult.setValue((Object)("entry-" + i));
        this.tblResult.setCurrentPageFirstItemId((Object)("entry-" + i));
    }

    private void showResult(List<FrequencyTableRow> table) {
        if (this.queryPanel != null) {
            this.queryPanel.notifiyQueryFinished();
        }
        this.recreateTable(table);
        this.btDownloadCSV.setVisible(true);
        FileDownloader downloader = new FileDownloader((Resource)new StreamResource((StreamResource.StreamSource)new CSVResource(table, (List)this.query.getFrequencyDefinition()), "frequency.txt"));
        downloader.extend((AbstractComponent)this.btDownloadCSV);
        this.chart.setVisible(true);
        List<FrequencyTableRow> clippedTable = table;
        if (clippedTable.size() > 100) {
            clippedTable = new ArrayList<FrequencyTableRow>(table.subList(0, 100));
            this.chart.setCaption("Showing historgram of top 100 results, see table below for complete dataset.");
        }
        this.chart.setFrequencyData(clippedTable);
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }
}

