/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.frequency;

import java.io.Serializable;
import java.util.Objects;
import org.corpus_tools.annis.gui.objects.FrequencyTableEntry;
import org.corpus_tools.annis.gui.objects.FrequencyTableEntryType;

public class UserGeneratedFrequencyEntry
implements Serializable {
    private static final long serialVersionUID = -2233620631396727690L;
    private String nr;
    private String annotation;
    private String comment = "manually created";

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserGeneratedFrequencyEntry other = (UserGeneratedFrequencyEntry)obj;
        if (!Objects.equals(this.nr, other.nr)) {
            return false;
        }
        return Objects.equals(this.annotation, other.annotation);
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public String getComment() {
        return this.comment;
    }

    public String getNr() {
        return this.nr;
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + Objects.hashCode(this.nr);
        hash = 53 * hash + Objects.hashCode(this.annotation);
        return hash;
    }

    public void setAnnotation(String annotation) {
        this.annotation = annotation;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setNr(String nr) {
        this.nr = nr;
    }

    public FrequencyTableEntry toFrequencyTableEntry() {
        FrequencyTableEntry result = new FrequencyTableEntry();
        result.setReferencedNode(this.nr);
        if ("tok".equals(this.annotation)) {
            result.setType(FrequencyTableEntryType.span);
        } else {
            result.setType(FrequencyTableEntryType.annotation);
            result.setKey(this.annotation);
        }
        return result;
    }
}

