/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.graphml;

import com.google.common.collect.Multimap;
import com.google.common.collect.Range;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.corpus_tools.annis.api.model.AnnotationComponentType;
import org.corpus_tools.annis.api.model.Component;
import org.corpus_tools.annis.gui.graphml.AbstractGraphMLMapper;
import org.corpus_tools.annis.gui.graphml.DocumentGraphMapper;
import org.corpus_tools.salt.SALT_TYPE;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.STextualRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.GraphTraverseHandler;
import org.corpus_tools.salt.core.SAnnotationContainer;
import org.corpus_tools.salt.core.SGraph;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;

/*
 * Exception performing whole class analysis ignored.
 */
public class DocumentGraphMapper
extends AbstractGraphMLMapper {
    private final SDocumentGraph graph = SaltFactory.createSDocumentGraph();
    private final Set<String> hasOutgoingCoverageEdge = new HashSet();
    private final Set<String> hasOutgoingDominanceEdge = new HashSet();
    private final Set<Pair<String, String>> hasNonEmptyDominanceEdge = new HashSet();

    protected DocumentGraphMapper() {
    }

    public static SDocumentGraph map(File inputFile) throws IOException, XMLStreamException {
        DocumentGraphMapper mapper = new DocumentGraphMapper();
        mapper.execute(inputFile);
        return mapper.graph;
    }

    protected void firstPass(XMLEventReader reader) throws XMLStreamException {
        while (reader.hasNext()) {
            StartElement element;
            XMLEvent event = reader.nextEvent();
            if (!event.isStartElement() || !"edge".equals((element = event.asStartElement()).getName().getLocalPart())) continue;
            Attribute source = element.getAttributeByName(new QName("source"));
            Attribute target = element.getAttributeByName(new QName("target"));
            Attribute label = element.getAttributeByName(new QName("label"));
            if (label == null) continue;
            Component c = DocumentGraphMapper.parseComponent((String)label.getValue());
            if (source == null) continue;
            if (c.getType() == AnnotationComponentType.COVERAGE) {
                this.hasOutgoingCoverageEdge.add(source.getValue());
            } else if (c.getType() == AnnotationComponentType.DOMINANCE) {
                this.hasOutgoingDominanceEdge.add(source.getValue());
            }
            if (target == null || c.getType() != AnnotationComponentType.DOMINANCE || c.getName().isEmpty()) continue;
            this.hasNonEmptyDominanceEdge.add(Pair.of((Object)source.getValue(), (Object)target.getValue()));
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    protected void secondPass(XMLEventReader reader) throws XMLStreamException {
        TreeMap keys = new TreeMap();
        int level = 0;
        boolean inGraph = false;
        Optional optional = Optional.empty();
        Optional optional2 = Optional.empty();
        Optional optional3 = Optional.empty();
        Optional optional4 = Optional.empty();
        Optional optional5 = Optional.empty();
        HashMap<String, String> data = new HashMap<String, String>();
        block31: while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            switch (event.getEventType()) {
                case 1: {
                    ++level;
                    StartElement startElement = event.asStartElement();
                    switch (startElement.getName().getLocalPart()) {
                        case "graph": {
                            if (level != 2) break;
                            inGraph = true;
                            continue block31;
                        }
                        case "key": {
                            if (level != 2) break;
                            this.addAnnotationKey(keys, startElement);
                            continue block31;
                        }
                        case "node": {
                            if (!inGraph || level != 3) break;
                            Attribute id = startElement.getAttributeByName(new QName("id"));
                            if (id == null) continue block31;
                            Optional<String> optional6 = Optional.ofNullable(id.getValue());
                            continue block31;
                        }
                        case "edge": {
                            if (!inGraph || level != 3) break;
                            Attribute source = startElement.getAttributeByName(new QName("source"));
                            Attribute target = startElement.getAttributeByName(new QName("target"));
                            Attribute component = startElement.getAttributeByName(new QName("label"));
                            if (source == null || target == null || component == null) continue block31;
                            Optional<String> optional7 = Optional.ofNullable(source.getValue());
                            Optional<String> optional8 = Optional.ofNullable(target.getValue());
                            Optional<String> optional9 = Optional.ofNullable(component.getValue());
                            continue block31;
                        }
                        case "data": {
                            Attribute key = startElement.getAttributeByName(new QName("key"));
                            if (key == null) break;
                            Optional<String> optional10 = Optional.ofNullable(key.getValue());
                        }
                    }
                    continue block31;
                }
                case 4: {
                    void var6_10;
                    if (!var6_10.isPresent() || !inGraph || level != 4) break;
                    String annoKey = (String)keys.get(var6_10.get());
                    if (annoKey == null) continue block31;
                    data.put(annoKey, event.asCharacters().getData());
                    break;
                }
                case 2: {
                    void var6_10;
                    EndElement endElement = event.asEndElement();
                    switch (endElement.getName().getLocalPart()) {
                        case "graph": {
                            inGraph = false;
                            break;
                        }
                        case "node": {
                            String nodeType;
                            void var5_6;
                            if (var5_6.isPresent() && "node".equals(nodeType = (String)data.get("annis::node_type"))) {
                                SNode n = this.mapNode((String)var5_6.get(), data);
                                this.graph.addNode((Node)n);
                            }
                            Optional optional11 = Optional.empty();
                            data.clear();
                            break;
                        }
                        case "edge": {
                            void var9_22;
                            void var8_18;
                            void var7_14;
                            if (var7_14.isPresent() && var8_18.isPresent() && var9_22.isPresent()) {
                                this.mapAndAddEdge((String)var7_14.get(), (String)var8_18.get(), (String)var9_22.get(), data);
                            }
                            Optional optional12 = Optional.empty();
                            Optional optional13 = Optional.empty();
                            Optional optional14 = Optional.empty();
                            data.clear();
                            break;
                        }
                        case "data": {
                            String annoKey;
                            if (var6_10.isPresent() && (annoKey = (String)keys.get(var6_10.get())) != null && !data.containsKey(annoKey)) {
                                data.put(annoKey, "");
                            }
                            Optional optional15 = Optional.empty();
                            break;
                        }
                    }
                    --level;
                    continue block31;
                }
            }
        }
        Multimap orderRoots = this.graph.getRootsByRelationType(SALT_TYPE.SORDER_RELATION);
        if (orderRoots.isEmpty() && this.graph.getTokens().size() == 1) {
            orderRoots.put((Object)"", this.graph.getTokens().get(0));
        }
        orderRoots.keySet().forEach(name -> {
            ArrayList roots = new ArrayList(orderRoots.get(name));
            if ("salt::NULL".equals(name)) {
                name = null;
            }
            if (name == null || "".equals(name)) {
                this.recreateText(name, roots);
            } else {
                this.addTextToSegmentation(name, roots);
            }
        });
        this.addNodeLayers();
    }

    private void addAnnotationKey(Map<String, String> keys, StartElement event) {
        Attribute id = event.getAttributeByName(new QName("id"));
        Attribute annoKey = event.getAttributeByName(new QName("attr.name"));
        if (id != null && id.getValue() != null && annoKey != null && annoKey.getValue() != null) {
            keys.put(id.getValue(), annoKey.getValue());
        }
    }

    private SNode mapNode(String nodeName, Map<String, String> labels) {
        Object newNode = SaltFactory.createSNode();
        newNode = labels.containsKey("annis::tok") && !this.hasOutgoingCoverageEdge.contains(nodeName) ? SaltFactory.createSToken() : (this.hasOutgoingDominanceEdge.contains(nodeName) ? SaltFactory.createSStructure() : SaltFactory.createSSpan());
        this.setNodeName(newNode, nodeName);
        DocumentGraphMapper.mapLabels((SAnnotationContainer)newNode, labels, (boolean)false);
        return newNode;
    }

    private void mapAndAddEdge(String sourceId, String targetId, String componentRaw, Map<String, String> labels) {
        SNode source = (SNode)this.graph.getNode("salt:/" + sourceId);
        SNode target = (SNode)this.graph.getNode("salt:/" + targetId);
        Component component = DocumentGraphMapper.parseComponent((String)componentRaw);
        if (source != null && target != null && source != target) {
            SRelation rel = null;
            switch (3.$SwitchMap$org$corpus_tools$annis$api$model$AnnotationComponentType[component.getType().ordinal()]) {
                case 1: {
                    if ((component.getName() == null || component.getName().isEmpty()) && this.hasNonEmptyDominanceEdge.contains(Pair.of((Object)sourceId, (Object)targetId))) {
                        return;
                    }
                    rel = this.graph.createRelation(source, target, SALT_TYPE.SDOMINANCE_RELATION, null);
                    break;
                }
                case 2: {
                    rel = this.graph.createRelation(source, target, SALT_TYPE.SPOINTING_RELATION, null);
                    break;
                }
                case 3: {
                    rel = this.graph.createRelation(source, target, SALT_TYPE.SORDER_RELATION, null);
                    break;
                }
                case 4: {
                    if (!(source instanceof SSpan) || !(target instanceof SToken)) break;
                    rel = this.graph.createRelation(source, target, SALT_TYPE.SSPANNING_RELATION, null);
                    break;
                }
            }
            if (rel != null) {
                rel.setType(component.getName());
                DocumentGraphMapper.mapLabels((SAnnotationContainer)rel, labels, (boolean)false);
                this.addEdgeLayers(component, rel);
            }
        }
    }

    private void recreateText(String textName, List<SNode> rootsForText) {
        StringBuilder text = new StringBuilder();
        STextualDS ds = this.graph.createTextualDS("");
        ds.setName(textName);
        HashMap<SToken, Range> token2Range = new HashMap<SToken, Range>();
        for (SNode root : rootsForText) {
            this.graph.traverse(Arrays.asList(root), SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_DEPTH_FIRST, "ORDERING_" + textName, (GraphTraverseHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
        ds.setText(text.toString());
        token2Range.forEach((t, r) -> {
            STextualRelation rel = SaltFactory.createSTextualRelation();
            rel.setSource((Node)t);
            rel.setTarget((Node)ds);
            rel.setStart((Number)((Object)r.lowerEndpoint()));
            rel.setEnd((Number)((Object)r.upperEndpoint()));
            this.graph.addRelation((Relation)rel);
        });
    }

    private void addTextToSegmentation(String name, List<SNode> rootNodes) {
        this.graph.traverse(rootNodes, SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_DEPTH_FIRST, "ORDERING_" + name, (GraphTraverseHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected SGraph getGraph() {
        return this.graph;
    }
}

