/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.media;

import com.vaadin.ui.Notification;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.corpus_tools.annis.gui.VisualizationToggle;
import org.corpus_tools.annis.gui.media.MediaController;
import org.corpus_tools.annis.gui.media.MediaControllerImpl;
import org.corpus_tools.annis.gui.media.MediaPlayer;
import org.corpus_tools.annis.gui.visualizers.LoadableVisualizer;
import org.springframework.stereotype.Component;

@Component
public class MediaControllerImpl
implements MediaController,
Serializable {
    private static final long serialVersionUID = -140882365707323973L;
    private Map<String, List<MediaPlayer>> mediaPlayers;
    private Map<String, MediaPlayer> lastUsedPlayer;
    private Map<MediaPlayer, VisualizationToggle> visToggle;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public MediaControllerImpl() {
        this.lock.writeLock().lock();
        try {
            this.mediaPlayers = new TreeMap();
            this.lastUsedPlayer = new TreeMap();
            this.visToggle = new HashMap();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMediaPlayer(MediaPlayer player, String resultID, VisualizationToggle toggle) {
        if (resultID == null) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            if (this.mediaPlayers.get(resultID) == null) {
                this.mediaPlayers.put(resultID, new LinkedList());
            }
            List playerList = (List)this.mediaPlayers.get(resultID);
            playerList.add(player);
            this.visToggle.put(player, toggle);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void clearMediaPlayers() {
        this.lock.writeLock().lock();
        try {
            this.mediaPlayers.clear();
            this.visToggle.clear();
            this.lastUsedPlayer.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void closeOtherPlayers(MediaPlayer doNotCloseThisOne) {
        for (List playersForID : this.mediaPlayers.values()) {
            for (MediaPlayer player : playersForID) {
                VisualizationToggle t;
                if (player == doNotCloseThisOne || (t = (VisualizationToggle)this.visToggle.get(player)) == null) continue;
                t.toggleVisualizer(false, null);
            }
        }
    }

    private MediaPlayer getPlayerForResult(String resultID) {
        List allPlayers = (List)this.mediaPlayers.get(resultID);
        if (allPlayers != null && allPlayers.size() > 0) {
            MediaPlayer lastPlayer = (MediaPlayer)this.lastUsedPlayer.get(resultID);
            MediaPlayer player = lastPlayer == null ? (MediaPlayer)allPlayers.get(0) : lastPlayer;
            return player;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play(String resultID, double startTime) {
        boolean foundPlayer = false;
        this.lock.readLock().lock();
        try {
            MediaPlayer player = this.getPlayerForResult(resultID);
            if (player != null) {
                this.closeOtherPlayers(player);
                VisualizationToggle t = (VisualizationToggle)this.visToggle.get(player);
                if (t != null) {
                    foundPlayer = true;
                    t.toggleVisualizer(true, (LoadableVisualizer.Callback)new CallbackImpl(player, Double.valueOf(startTime), null));
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (!foundPlayer) {
            Notification.show((String)"Could not play media.", (String)"If this is a match reference open the actual search interface by following the \"Show in ANNIS search interface\" link.", (Notification.Type)Notification.Type.WARNING_MESSAGE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play(String resultID, double startTime, double endTime) {
        boolean foundPlayer = false;
        this.lock.readLock().lock();
        try {
            MediaPlayer player = this.getPlayerForResult(resultID);
            if (player != null) {
                this.closeOtherPlayers(player);
                VisualizationToggle t = (VisualizationToggle)this.visToggle.get(player);
                if (t != null) {
                    foundPlayer = true;
                    t.toggleVisualizer(true, (LoadableVisualizer.Callback)new CallbackImpl(player, Double.valueOf(startTime), Double.valueOf(endTime)));
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (!foundPlayer) {
            Notification.show((String)"Could not play media.", (String)"If this is a match reference open the actual search interface by following the \"Show in ANNIS search interface\" link.", (Notification.Type)Notification.Type.WARNING_MESSAGE);
        }
    }
}

