/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.objects;

import java.util.Map;
import java.util.Objects;
import org.corpus_tools.annis.gui.objects.Query;

public class ContextualizedQuery
extends Query {
    private static final long serialVersionUID = -8291111703807188684L;
    private int leftContext;
    private int rightContext;
    private String segmentation;

    public ContextualizedQuery() {
    }

    public ContextualizedQuery(ContextualizedQuery orig) {
        super((Query)orig);
        this.leftContext = orig.getLeftContext();
        this.rightContext = orig.getRightContext();
        this.segmentation = orig.getSegmentation();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContextualizedQuery other = (ContextualizedQuery)obj;
        return Objects.equals(this.getQuery(), other.getQuery()) && Objects.equals(this.getCorpora(), other.getCorpora()) && Objects.equals(this.leftContext, other.leftContext) && Objects.equals(this.rightContext, other.rightContext) && Objects.equals(this.segmentation, other.segmentation);
    }

    public Map<String, String> getCitationFragmentArguments() {
        Map result = super.getCitationFragmentArguments();
        result.put("cl", "" + this.getLeftContext());
        result.put("cr", "" + this.getRightContext());
        return result;
    }

    public int getLeftContext() {
        return this.leftContext;
    }

    public int getRightContext() {
        return this.rightContext;
    }

    public String getSegmentation() {
        return this.segmentation;
    }

    public int hashCode() {
        return Objects.hash(this.getCorpora(), this.getQuery(), this.leftContext, this.rightContext, this.segmentation);
    }

    public void setLeftContext(int leftContext) {
        this.leftContext = leftContext;
    }

    public void setRightContext(int rightContext) {
        this.rightContext = rightContext;
    }

    public void setSegmentation(String segmentation) {
        this.segmentation = segmentation;
    }
}

