/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.objects;

import com.google.common.base.Splitter;
import java.io.Serializable;
import java.util.List;
import org.corpus_tools.annis.gui.objects.FrequencyTableEntry;
import org.corpus_tools.annis.gui.objects.FrequencyTableEntryType;

public class FrequencyTableEntry
implements Serializable {
    private static final long serialVersionUID = -2064760035133589356L;
    private FrequencyTableEntryType type;
    private String key;
    private String referencedNode;

    public static FrequencyTableEntry parse(String definition) {
        List splitted = Splitter.on((char)':').trimResults().omitEmptyStrings().limit(2).splitToList((CharSequence)definition);
        if (splitted.size() == 2) {
            FrequencyTableEntry entry = new FrequencyTableEntry();
            entry.setReferencedNode((String)splitted.get(0));
            if ("tok".equals(splitted.get(1))) {
                entry.setType(FrequencyTableEntryType.span);
            } else {
                entry.setType(FrequencyTableEntryType.annotation);
                entry.setKey((String)splitted.get(1));
            }
            return entry;
        }
        return null;
    }

    public String getKey() {
        return this.key;
    }

    public String getReferencedNode() {
        return this.referencedNode;
    }

    public FrequencyTableEntryType getType() {
        return this.type;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setReferencedNode(String referencedNode) {
        this.referencedNode = referencedNode;
    }

    public void setType(FrequencyTableEntryType type) {
        this.type = type;
    }

    public String toString() {
        switch (1.$SwitchMap$org$corpus_tools$annis$gui$objects$FrequencyTableEntryType[this.type.ordinal()]) {
            case 1: {
                return this.referencedNode + ":tok";
            }
            case 2: {
                return this.referencedNode + ":" + this.key;
            }
        }
        return super.toString();
    }
}

