/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.objects;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.escape.Escaper;
import com.google.common.escape.Escapers;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessOrder;
import javax.xml.bind.annotation.XmlAccessorOrder;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/*
 * Exception performing whole class analysis ignored.
 */
@XmlRootElement
@XmlAccessorOrder(value=XmlAccessOrder.ALPHABETICAL)
public class Match
implements Serializable {
    private static final long serialVersionUID = 4550139902283358825L;
    private static final Splitter matchSplitter = Splitter.on((String)" ").trimResults().omitEmptyStrings();
    private static final Splitter annoIDSplitter = Splitter.on((String)"::").trimResults().limit(3);
    private static final Escaper spaceEscaper = Escapers.builder().addEscape(' ', "%20").addEscape('%', "%25").build();
    private List<String> saltIDs = new ArrayList();
    private List<String> annos = new ArrayList();

    public static Match parseFromString(String raw) {
        return Match.parseFromString((String)raw, (char)' ');
    }

    private static Match parseFromString(String raw, char separator) {
        Match match = new Match();
        Splitter splitter = matchSplitter;
        if (separator != ' ') {
            splitter = Splitter.on((char)separator).trimResults().omitEmptyStrings();
        }
        for (String singleMatch : splitter.split((CharSequence)raw)) {
            Match.parseSingleMatchComponent((String)singleMatch, (Match)match);
        }
        return match;
    }

    private static void parseSingleMatchComponent(String singleMatch, Match result) {
        String id = "";
        String anno = null;
        List components = annoIDSplitter.splitToList((CharSequence)singleMatch);
        int componentsSize = components.size();
        if (components.size() == 1) {
            id = singleMatch;
        } else {
            Preconditions.checkArgument((componentsSize == 3 || componentsSize == 2 ? 1 : 0) != 0, (Object)"A match containing annotation information always has to have the form ns::name::id  or name::id");
            String ns = "";
            String name = "";
            if (componentsSize == 3) {
                id = (String)components.get(2);
                ns = (String)components.get(0);
                name = (String)components.get(1);
            } else if (componentsSize == 2) {
                id = (String)components.get(1);
                name = (String)components.get(0);
            }
            anno = ns.isEmpty() ? name : ns + "::" + name;
            anno = anno.replace("%20", " ").replace("%25", "%").replace("%2C", ",");
        }
        if (id.startsWith("salt:/")) {
            id = id.substring("salt:/".length());
        }
        result.addSaltId(id, anno);
    }

    private static String singleMatchToString(String id, String anno) {
        if (id != null) {
            String v = id;
            if (anno != null && !anno.isEmpty()) {
                v = spaceEscaper.escape(anno) + "::" + id;
            }
            return v;
        }
        return "";
    }

    private void addSaltId(String id, String anno) {
        if (id != null) {
            this.saltIDs.add(id);
            if (anno == null) {
                this.annos.add("");
            } else {
                this.annos.add(anno);
            }
        }
    }

    private void createEmptyAnnoList() {
        if (this.saltIDs != null) {
            this.annos = new ArrayList(this.saltIDs.size());
            for (int i = 0; i < this.saltIDs.size(); ++i) {
                this.annos.add("");
            }
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Match other = (Match)obj;
        if (this.annos == null ? other.annos != null : !this.annos.equals(other.annos)) {
            return false;
        }
        return !(this.saltIDs == null ? other.saltIDs != null : !this.saltIDs.equals(other.saltIDs));
    }

    @XmlElement(name="anno")
    public List<String> getAnnos() {
        if (this.annos == null || this.annos.size() != this.saltIDs.size()) {
            this.createEmptyAnnoList();
        }
        return this.annos;
    }

    @XmlElement(name="id")
    public List<String> getSaltIDs() {
        return this.saltIDs;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.annos == null ? 0 : this.annos.hashCode());
        result = 31 * result + (this.saltIDs == null ? 0 : this.saltIDs.hashCode());
        return result;
    }

    public void setAnnos(List<String> annos) {
        this.annos = annos;
    }

    public void setSaltIDs(List<String> saltIDs) {
        this.saltIDs = saltIDs;
    }

    public String toString() {
        if (this.saltIDs != null && this.annos != null) {
            Iterator itID = this.saltIDs.iterator();
            Iterator itAnno = this.annos.iterator();
            LinkedList<String> asString = new LinkedList<String>();
            while (itID.hasNext() && itAnno.hasNext()) {
                String u = (String)itID.next();
                String anno = (String)itAnno.next();
                if (u == null) continue;
                asString.add(Match.singleMatchToString((String)u, (String)anno));
            }
            return Joiner.on((String)" ").join(asString);
        }
        return "";
    }
}

