/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.objects;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.corpus_tools.annis.api.model.FindQuery;
import org.corpus_tools.annis.gui.objects.ContextualizedQuery;

public class PagedResultQuery
extends ContextualizedQuery {
    private static final long serialVersionUID = -4589516338778409392L;
    private long offset;
    private int limit;
    private FindQuery.OrderEnum order = FindQuery.OrderEnum.NORMAL;

    public PagedResultQuery() {
    }

    public PagedResultQuery(int contextLeft, int contextRight, long offset, int limit, String segmentation, String query, Set<String> corpora) {
        super.setLeftContext(contextLeft);
        super.setRightContext(contextRight);
        super.setSegmentation(segmentation);
        super.setQuery(query);
        super.setCorpora(corpora);
        this.offset = offset;
        this.limit = limit;
    }

    public PagedResultQuery(PagedResultQuery orig) {
        super((ContextualizedQuery)orig);
        this.offset = orig.getOffset();
        this.limit = orig.getLimit();
        this.order = orig.getOrder();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PagedResultQuery other = (PagedResultQuery)obj;
        return Objects.equals(this.getQuery(), other.getQuery()) && Objects.equals(this.getCorpora(), other.getCorpora()) && Objects.equals(this.getLeftContext(), other.getLeftContext()) && Objects.equals(this.getRightContext(), other.getRightContext()) && Objects.equals(this.getSegmentation(), other.getSegmentation()) && Objects.equals(this.getLimit(), other.getLimit()) && Objects.equals(this.getOffset(), other.getOffset()) && Objects.equals(this.getOrder(), other.getOrder());
    }

    public Map<String, String> getCitationFragmentArguments() {
        Map result = super.getCitationFragmentArguments();
        result.put("s", "" + this.getOffset());
        result.put("l", "" + this.getLimit());
        if (this.getSegmentation() != null) {
            result.put("_seg", this.getSegmentation());
        }
        return result;
    }

    public int getLimit() {
        return this.limit;
    }

    public long getOffset() {
        return this.offset;
    }

    public FindQuery.OrderEnum getOrder() {
        return this.order;
    }

    public int hashCode() {
        return Objects.hash(this.getCorpora(), this.getQuery(), this.getLeftContext(), this.getRightContext(), this.getSegmentation(), this.getLimit(), this.getOffset(), this.getOrder());
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public void setOrder(FindQuery.OrderEnum order) {
        Preconditions.checkNotNull((Object)order, (Object)"The order of a paged result query must never be null.");
        this.order = order;
    }
}

