/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.objects;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.annis.gui.objects.QueryLanguage;

public class Query
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -161321980494167253L;
    private String query;
    private Set<String> corpora;
    private QueryLanguage queryLanguage = QueryLanguage.AQL;

    public Query() {
        this.corpora = new HashSet();
    }

    public Query(Query orig) {
        this.query = orig.getQuery();
        this.corpora = orig.getCorpora();
        this.queryLanguage = orig.getQueryLanguage();
    }

    public Query(String query, QueryLanguage queryLanguage, Set<String> corpora) {
        this.query = query == null ? "" : query;
        this.corpora = corpora == null ? new LinkedHashSet() : corpora;
        this.queryLanguage = queryLanguage;
    }

    public Query clone() throws CloneNotSupportedException {
        return (Query)super.clone();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Query other = (Query)obj;
        return Objects.equals(this.query, other.query) && Objects.equals(this.corpora, other.corpora) && Objects.equals(this.queryLanguage, other.queryLanguage);
    }

    public Map<String, String> getCitationFragmentArguments() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.put("_q", this.getQuery());
        result.put("ql", this.getQueryLanguage().name().toLowerCase());
        result.put("_c", StringUtils.join((Iterable)this.getCorpora(), (String)","));
        return result;
    }

    public Set<String> getCorpora() {
        return this.corpora;
    }

    public String getQuery() {
        return this.query;
    }

    public QueryLanguage getQueryLanguage() {
        return this.queryLanguage;
    }

    public org.corpus_tools.annis.api.model.QueryLanguage getApiQueryLanguage() {
        if (this.queryLanguage == QueryLanguage.AQL_QUIRKS_V3) {
            return org.corpus_tools.annis.api.model.QueryLanguage.AQLQUIRKSV3;
        }
        return org.corpus_tools.annis.api.model.QueryLanguage.AQL;
    }

    public int hashCode() {
        return Objects.hash(this.corpora, this.query, this.queryLanguage);
    }

    public void setCorpora(Set<String> corpora) {
        this.corpora = corpora == null ? new LinkedHashSet() : corpora;
    }

    public void setQuery(String query) {
        this.query = query == null ? "" : query;
    }

    public void setQueryLanguage(QueryLanguage queryLanguage) {
        Preconditions.checkNotNull((Object)queryLanguage, (Object)"The query language of a paged result query must never be null.");
        this.queryLanguage = queryLanguage;
    }

    public String toCitationFragment() {
        Map result = this.getCitationFragmentArguments();
        LinkedList<String> fragmentParts = new LinkedList<String>();
        for (Map.Entry e : result.entrySet()) {
            String value;
            if (((String)e.getKey()).startsWith("_")) {
                value = Helper.encodeBase64URL((String)((String)e.getValue()));
            } else {
                try {
                    value = URLEncoder.encode((String)e.getValue(), StandardCharsets.UTF_8.name());
                }
                catch (UnsupportedEncodingException ex) {
                    value = "";
                }
            }
            fragmentParts.add((String)e.getKey() + "=" + value);
        }
        return StringUtils.join(fragmentParts, (String)"&");
    }
}

