/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.query_references;

import com.google.common.base.Objects;
import com.vaadin.server.ExternalResource;
import com.vaadin.server.Resource;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.BrowserFrame;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.util.BeanItemContainer;
import com.vaadin.v7.data.util.ObjectProperty;
import com.vaadin.v7.event.SelectionEvent;
import com.vaadin.v7.shared.ui.label.ContentMode;
import com.vaadin.v7.ui.Grid;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.TextArea;
import java.io.Serializable;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.corpus_tools.annis.api.model.VisualizerRule;
import org.corpus_tools.annis.gui.AnnisUI;
import org.corpus_tools.annis.gui.CommonUI;
import org.corpus_tools.annis.gui.objects.Match;
import org.corpus_tools.annis.gui.objects.PagedResultQuery;
import org.corpus_tools.annis.gui.visualizers.VisualizerPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriComponentsBuilder;

public class ShareSingleMatchGenerator
extends Window
implements SelectionEvent.SelectionListener {
    private static final long serialVersionUID = -8303684875649384972L;
    private static final Logger log = LoggerFactory.getLogger(ShareSingleMatchGenerator.class);
    private final VerticalLayout layout;
    private final Grid visSelector;
    private final VerticalLayout generatedLinks;
    private final Property<String> directURL;
    private final Property<String> iframeCode;
    private final BrowserFrame preview;
    private final TextArea txtDirectURL;
    private final TextArea txtIFrameCode;
    private final BeanItemContainer<VisualizerRule> visContainer;
    private final Match match;
    private final PagedResultQuery query;
    private final String baseText;
    private final List<VisualizerPlugin> visualizerPlugins;
    private final CommonUI ui;

    public ShareSingleMatchGenerator(CommonUI ui, List<VisualizerRule> visualizers, Match match, PagedResultQuery query, String baseText, List<VisualizerPlugin> visualizerPlugins) {
        this.ui = ui;
        this.match = match;
        this.query = query;
        this.baseText = baseText;
        this.visualizerPlugins = visualizerPlugins;
        this.setResizeLazy(true);
        this.directURL = new ObjectProperty((Object)"");
        this.iframeCode = new ObjectProperty((Object)"");
        this.visContainer = new BeanItemContainer(VisualizerRule.class);
        this.visContainer.addAll(visualizers);
        this.txtDirectURL = new TextArea(this.directURL);
        this.txtDirectURL.setCaption("Link for publications");
        this.txtDirectURL.setWidth("100%");
        this.txtDirectURL.setHeight("-1px");
        this.txtDirectURL.addStyleName("large");
        this.txtDirectURL.addStyleName("shared-text");
        this.txtDirectURL.setWordwrap(true);
        this.txtDirectURL.setReadOnly(true);
        this.txtIFrameCode = new TextArea(this.iframeCode);
        this.txtIFrameCode.setCaption("Code for embedding visualization into web page");
        this.txtIFrameCode.setWidth("100%");
        this.txtIFrameCode.setHeight("-1px");
        this.txtIFrameCode.addStyleName("large");
        this.txtIFrameCode.addStyleName("shared-text");
        this.txtIFrameCode.setWordwrap(true);
        this.txtIFrameCode.setReadOnly(true);
        this.preview = new BrowserFrame();
        this.preview.setCaption("Preview");
        this.preview.addStyleName("shared-text");
        this.preview.setSizeFull();
        this.generatedLinks = new VerticalLayout(new Component[]{this.txtDirectURL, this.txtIFrameCode, this.preview});
        this.generatedLinks.setComponentAlignment((Component)this.txtDirectURL, Alignment.TOP_LEFT);
        this.generatedLinks.setComponentAlignment((Component)this.txtIFrameCode, Alignment.TOP_LEFT);
        this.generatedLinks.setExpandRatio((Component)this.preview, 1.0f);
        this.generatedLinks.setSpacing(false);
        this.visSelector = new Grid((Container.Indexed)this.visContainer);
        this.visSelector.setCaption("Select visualization");
        this.visSelector.setHeight("100%");
        this.visSelector.setColumns(new Object[]{"displayName"});
        this.visSelector.setSelectionMode(Grid.SelectionMode.SINGLE);
        this.visSelector.addSelectionListener((SelectionEvent.SelectionListener)this);
        this.visSelector.select(this.visContainer.getIdByIndex(0));
        this.visSelector.setWidth("300px");
        this.visSelector.getColumn((Object)"displayName").setSortable(false);
        this.generatedLinks.setSizeFull();
        Label infoText = new Label("<p style=\"font-size: 18px\" ><strong>Share your match:</strong>&nbsp;1.&nbsp;Choose the visualization to share. 2.&nbsp;Copy the generated link or code. 3.&nbsp;Share this link with your peers or include the code in your website. </p>", ContentMode.HTML);
        HorizontalLayout hLayout = new HorizontalLayout(new Component[]{this.visSelector, this.generatedLinks});
        hLayout.setSizeFull();
        hLayout.setSpacing(false);
        hLayout.setExpandRatio((Component)this.generatedLinks, 1.0f);
        Button btClose = new Button("Close");
        btClose.setSizeUndefined();
        btClose.addClickListener((Button.ClickListener & Serializable)event -> this.getUI().removeWindow((Window)this));
        this.layout = new VerticalLayout(new Component[]{infoText, hLayout, btClose});
        this.layout.setSizeFull();
        this.layout.setExpandRatio((Component)hLayout, 1.0f);
        this.layout.setSpacing(false);
        this.layout.setComponentAlignment((Component)btClose, Alignment.MIDDLE_CENTER);
        this.setContent((Component)this.layout);
    }

    private URI generatorURLForVisualizer(VisualizerRule entry) {
        String nonContextPath;
        String appContext = this.ui.getServletContext().getContextPath();
        URI appURI = this.ui.getPage().getLocation();
        UriComponentsBuilder result = UriComponentsBuilder.fromUri((URI)appURI).replacePath(appContext).path("embeddedvis").path(entry.getVisType());
        if (entry.getLayer() != null) {
            result = result.queryParam("embedded_ns", new Object[]{entry.getLayer()});
        }
        if (!(nonContextPath = appURI.getPath().substring(appContext.length())).isEmpty()) {
            if (nonContextPath.startsWith("/")) {
                nonContextPath = nonContextPath.substring(1);
            }
            result = result.queryParam("embedded_instance", new Object[]{nonContextPath});
        }
        Optional<VisualizerPlugin> visPlugin = this.visualizerPlugins.stream().filter(vis -> Objects.equal((Object)vis.getShortName(), (Object)entry.getVisType())).findAny();
        result = result.queryParam("embedded_match", new Object[]{this.match.toString()});
        if (visPlugin.isPresent() && visPlugin.get().isUsingText()) {
            result = result.queryParam("embedded_fulltext", new Object[]{"true"});
        }
        result = result.queryParam("embedded_left", new Object[]{this.query.getLeftContext()});
        result = result.queryParam("embedded_right", new Object[]{this.query.getRightContext()});
        if (this.query.getSegmentation() != null) {
            result = result.queryParam("embedded_segmentation", new Object[]{this.query.getSegmentation()});
        }
        result = result.queryParam("embedded_interface", new Object[]{appURI.toASCIIString()});
        if (this.baseText != null) {
            result = result.queryParam("embedded_base", new Object[]{this.baseText});
        }
        for (Map.Entry e : entry.getMappings().entrySet()) {
            if (((String)e.getKey()).startsWith("embedded_")) continue;
            result = result.queryParam((String)e.getKey(), new Object[]{e.getValue()});
        }
        return result.build().toUri();
    }

    public void select(SelectionEvent event) {
        Set selected = event.getSelected();
        if (this.ui instanceof AnnisUI && !selected.isEmpty()) {
            AnnisUI annisUI = (AnnisUI)this.ui;
            this.generatedLinks.setVisible(true);
            URI url = this.generatorURLForVisualizer((VisualizerRule)selected.iterator().next());
            String shortURL = annisUI.getUrlShortener().shortenURL(url, (CommonUI)annisUI);
            this.directURL.setValue((Object)shortURL);
            this.iframeCode.setValue((Object)("<iframe height=\"300px\" width=\"100%\" src=\"" + shortURL + "\"></iframe>"));
            this.preview.setSource((Resource)new ExternalResource(shortURL));
        } else {
            this.generatedLinks.setVisible(false);
        }
    }
}

