/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.querybuilder;

import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.ui.AbstractSelect;
import com.vaadin.v7.ui.ComboBox;
import com.vaadin.v7.ui.TextField;
import java.io.Serializable;
import org.corpus_tools.annis.gui.querybuilder.AQLOperator;
import org.corpus_tools.annis.gui.querybuilder.EdgeWindow;
import org.corpus_tools.annis.gui.querybuilder.NodeWindow;
import org.corpus_tools.annis.gui.querybuilder.TigerQueryBuilderCanvas;

public class EdgeWindow
extends Panel
implements Button.ClickListener {
    private static final long serialVersionUID = 998216092838185489L;
    private static final String CUSTOM = "custom";
    private TigerQueryBuilderCanvas parent;
    private ComboBox cbOperator;
    private Button btClose;
    private NodeWindow source;
    private NodeWindow target;
    private TextField txtOperator;

    public EdgeWindow(TigerQueryBuilderCanvas parent, NodeWindow source, NodeWindow target) {
        this.parent = parent;
        this.source = source;
        this.target = target;
        this.setSizeFull();
        this.addStyleName("borderless");
        this.addStyleName("border-layout");
        this.addStyleName("white-panel");
        VerticalLayout vLayout = new VerticalLayout();
        this.setContent((Component)vLayout);
        vLayout.setMargin(false);
        vLayout.setSpacing(false);
        HorizontalLayout toolbar = new HorizontalLayout();
        toolbar.addStyleName("toolbar");
        toolbar.setWidth("100%");
        toolbar.setHeight("-1px");
        vLayout.addComponent((Component)toolbar);
        Label lblTitle = new Label("AQL Operator");
        lblTitle.setWidth("100%");
        toolbar.addComponent((Component)lblTitle);
        toolbar.setComponentAlignment((Component)lblTitle, Alignment.MIDDLE_LEFT);
        toolbar.setExpandRatio((Component)lblTitle, 1.0f);
        this.btClose = new Button();
        this.btClose.addStyleName("icon-only");
        this.btClose.addStyleName("small");
        this.btClose.setIcon((Resource)FontAwesome.TIMES_CIRCLE);
        this.btClose.setWidth("-1px");
        this.btClose.addClickListener((Button.ClickListener)this);
        toolbar.addComponent((Component)this.btClose);
        toolbar.setComponentAlignment((Component)this.btClose, Alignment.MIDDLE_RIGHT);
        toolbar.setExpandRatio((Component)this.btClose, 0.0f);
        this.cbOperator = new ComboBox();
        this.cbOperator.setNewItemsAllowed(false);
        this.cbOperator.setTextInputAllowed(false);
        this.cbOperator.setNullSelectionAllowed(true);
        this.cbOperator.addItem((Object)CUSTOM);
        this.cbOperator.setItemCaption((Object)CUSTOM, CUSTOM);
        this.cbOperator.setNullSelectionItemId((Object)CUSTOM);
        this.cbOperator.setNewItemHandler((AbstractSelect.NewItemHandler)new NodeWindow.SimpleNewItemHandler(this.cbOperator));
        this.cbOperator.setImmediate(true);
        vLayout.addComponent((Component)this.cbOperator);
        for (AQLOperator o : AQLOperator.values()) {
            this.cbOperator.addItem((Object)o);
            this.cbOperator.setItemCaption((Object)o, o.getDescription() + " (" + o.getOp() + ")");
        }
        this.cbOperator.setValue((Object)AQLOperator.DIRECT_PRECEDENCE);
        this.cbOperator.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> {
            Object val = event.getProperty().getValue();
            if (val instanceof AQLOperator) {
                this.txtOperator.setValue(((AQLOperator)val).getOp());
            }
        });
        this.cbOperator.setWidth("100%");
        this.cbOperator.setHeight("20px");
        this.txtOperator = new TextField();
        this.txtOperator.setValue(".");
        this.txtOperator.setInputPrompt("select operator definition");
        this.txtOperator.setSizeFull();
        this.txtOperator.addValueChangeListener((Property.ValueChangeListener)new OperatorValueChangeListener(this, parent));
        this.txtOperator.setImmediate(true);
        vLayout.addComponent((Component)this.txtOperator);
        vLayout.setExpandRatio((Component)this.cbOperator, 1.0f);
    }

    public void buttonClick(Button.ClickEvent event) {
        if (event.getButton() == this.btClose) {
            this.parent.deleteEdge(this);
        }
    }

    private AQLOperator findAQLOperatorForText(String txt) {
        for (AQLOperator op : AQLOperator.values()) {
            if (!op.getOp().equals(txt)) continue;
            return op;
        }
        return null;
    }

    public String getOperator() {
        String val = (String)this.txtOperator.getValue();
        if (val == null || val.isEmpty()) {
            return "SET_OPERATOR";
        }
        return val;
    }

    public NodeWindow getSource() {
        return this.source;
    }

    public NodeWindow getTarget() {
        return this.target;
    }

    static /* synthetic */ ComboBox access$000(EdgeWindow x0) {
        return x0.cbOperator;
    }

    static /* synthetic */ AQLOperator access$100(EdgeWindow x0, String x1) {
        return x0.findAQLOperatorForText(x1);
    }
}

