/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.querybuilder;

import com.vaadin.event.dd.DropHandler;
import com.vaadin.server.Sizeable;
import com.vaadin.ui.AbsoluteLayout;
import com.vaadin.ui.Component;
import com.vaadin.ui.DragAndDropWrapper;
import com.vaadin.ui.Notification;
import com.vaadin.ui.Panel;
import com.vaadin.ui.UI;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.corpus_tools.annis.ApiException;
import org.corpus_tools.annis.api.CorporaApi;
import org.corpus_tools.annis.api.model.Annotation;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.annis.gui.QueryController;
import org.corpus_tools.annis.gui.querybuilder.EdgeWindow;
import org.corpus_tools.annis.gui.querybuilder.NodeWindow;
import org.corpus_tools.annis.gui.querybuilder.TigerQueryBuilderCanvas;
import org.corpus_tools.annis.gui.widgets.GripDragComponent;
import org.corpus_tools.annis.gui.widgets.SimpleCanvas;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TigerQueryBuilderCanvas
extends Panel {
    private static final long serialVersionUID = 4564976366028699909L;
    private static final Logger log = LoggerFactory.getLogger(TigerQueryBuilderCanvas.class);
    private SimpleCanvas canvas;
    private Map<NodeWindow, GripDragComponent> nodes;
    private List<EdgeWindow> edges;
    private AbsoluteLayout area;
    private AbsoluteDropHandler handler;
    private int number = 0;
    private NodeWindow preparedEdgeSource = null;
    private final QueryController controller;

    public TigerQueryBuilderCanvas(QueryController controller) {
        this.controller = controller;
        this.nodes = new HashMap();
        this.edges = new ArrayList();
        this.setSizeFull();
        this.area = new AbsoluteLayout();
        this.area.setWidth("2000px");
        this.area.setHeight("2000px");
        this.area.addStyleName("no-vertical-drag-hints");
        this.area.addStyleName("no-horizontal-drag-hints");
        this.area.addStyleName("no-box-drag-hints");
        this.canvas = new SimpleCanvas();
        this.canvas.setSizeFull();
        this.canvas.addStyleName("tigerquery-builder-canvas");
        this.handler = new AbsoluteDropHandler(this, this.area);
        DragAndDropWrapper areaPane = new DragAndDropWrapper((Component)this.area);
        areaPane.setWidth("2000px");
        areaPane.setHeight("2000px");
        areaPane.setDropHandler((DropHandler)this.handler);
        this.area.addComponent((Component)this.canvas, "top:0px;left:0px");
        this.setContent((Component)areaPane);
        this.addStyleName("no-vertical-drag-hints");
        this.addStyleName("no-horizontal-drag-hints");
        this.addStyleName("no-box-drag-hints");
    }

    public void addEdge(NodeWindow target) {
        for (Object w : this.nodes.keySet()) {
            w.setPrepareEdgeDock(false);
        }
        if (this.preparedEdgeSource != target) {
            boolean valid = true;
            for (EdgeWindow e : this.edges) {
                if (e.getSource() != this.preparedEdgeSource || e.getTarget() != target) continue;
                valid = false;
                break;
            }
            if (valid) {
                EdgeWindow e = new EdgeWindow(this, this.preparedEdgeSource, target);
                e.setWidth("170px");
                e.setHeight("80px");
                e.addStyleName("tigerquery-builder-overlay");
                this.edges.add(e);
                this.area.addComponent((Component)e);
                this.updateLinesAndEdgePositions();
                this.updateQuery();
            } else {
                Notification.show((String)"There is already such an edge", (Notification.Type)Notification.Type.WARNING_MESSAGE);
            }
        }
    }

    public void addNode() {
        NodeWindow n = new NodeWindow(this.number++, this);
        GripDragComponent panel = new GripDragComponent((Component)n);
        panel.setWidth(275.0f, Sizeable.Unit.PIXELS);
        panel.setHeight(100.0f, Sizeable.Unit.PIXELS);
        this.nodes.put(n, panel);
        this.area.addComponent((Component)panel, "top:" + (10 + 120 * (this.number - 1)) + "px;left:10px");
        this.updateQuery();
    }

    public void clearAll() {
        for (EdgeWindow w : this.edges) {
            this.area.removeComponent((Component)w);
        }
        this.edges.clear();
        for (EdgeWindow w : this.nodes.values()) {
            this.area.removeComponent((Component)w);
        }
        this.nodes.clear();
        this.number = 0;
        this.updateLinesAndEdgePositions();
        this.updateQuery();
    }

    private List<Line2D> createArrow(double x, double y, double direction, double arrowLength) {
        LinkedList<Line2D> result = new LinkedList<Line2D>();
        double dir1 = direction + 0.39269908169872414;
        double dir2 = direction - 0.39269908169872414;
        double end1_x = x - arrowLength * Math.cos(dir1);
        double end1_y = y - arrowLength * Math.sin(dir1);
        double end2_x = x - arrowLength * Math.cos(dir2);
        double end2_y = y - arrowLength * Math.sin(dir2);
        result.add(new Line2D.Double(x, y, end1_x, end1_y));
        result.add(new Line2D.Double(x, y, end2_x, end2_y));
        return result;
    }

    public void deleteEdge(EdgeWindow e) {
        this.area.removeComponent((Component)e);
        this.edges.remove(e);
        this.updateLinesAndEdgePositions();
        this.updateQuery();
    }

    public void deleteNode(NodeWindow n) {
        LinkedList<EdgeWindow> edgesToRemove = new LinkedList<EdgeWindow>();
        for (EdgeWindow e : this.edges) {
            if (e.getSource() != n && e.getTarget() != n) continue;
            edgesToRemove.add(e);
            this.area.removeComponent((Component)e);
        }
        this.edges.removeAll(edgesToRemove);
        this.area.removeComponent((Component)this.nodes.get(n));
        this.nodes.remove(n);
        this.updateLinesAndEdgePositions();
        this.updateQuery();
    }

    public String getAQLQuery() {
        StringBuilder query = new StringBuilder();
        StringBuffer nodeIdentityOperations = new StringBuffer();
        HashMap<NodeWindow, Integer> nodeComponentMap = new HashMap<NodeWindow, Integer>();
        int componentCount = 0;
        for (NodeWindow nodeWindow : this.nodes.keySet()) {
            List constraints = nodeWindow.getConstraints();
            if (componentCount++ > 0) {
                query.append(" & ");
            }
            if (constraints.size() > 0) {
                int nodeComponentCount = 0;
                for (NodeWindow.ConstraintLayout c : constraints) {
                    if (nodeComponentCount++ > 0) {
                        nodeIdentityOperations.append("\n& #").append(componentCount).append(" _=_ #").append(componentCount + 1);
                        query.append(" & ");
                        ++componentCount;
                    }
                    String operator = c.getOperator().replace("~", "=");
                    String quotes = c.getOperator().equals("=") || c.getOperator().equals("!=") ? "\"" : "/";
                    String prefix = "";
                    if (c.getName().trim().isEmpty() || c.getName().trim().equals("tok")) {
                        if (operator.equals("!=")) {
                            prefix = c.getName().trim().isEmpty() ? "tok" + c.getName() + operator : c.getName() + operator;
                        }
                    } else {
                        prefix = c.getName() + operator;
                    }
                    if ("".equals(c.getValue())) {
                        query.append(c.getName());
                        continue;
                    }
                    query.append(prefix).append(quotes).append(c.getValue()).append(quotes);
                }
            } else {
                query.append("node");
            }
            nodeComponentMap.put(nodeWindow, componentCount);
        }
        query.append(nodeIdentityOperations);
        for (EdgeWindow edgeWindow : this.edges) {
            query.append("\n& ");
            query.append('#').append(nodeComponentMap.get(edgeWindow.getSource())).append(" ").append(edgeWindow.getOperator()).append(" ").append("#").append(nodeComponentMap.get(edgeWindow.getTarget()));
        }
        return query.toString();
    }

    public Set<String> getAvailableAnnotationNames() {
        TreeSet<String> result = new TreeSet<String>();
        CorporaApi api = new CorporaApi(Helper.getClient((UI)UI.getCurrent()));
        Set corpusSelection = this.controller.getState().getSelectedCorpora();
        if (corpusSelection != null) {
            for (String corpus : corpusSelection) {
                try {
                    for (Annotation anno : api.nodeAnnotations(corpus, Boolean.valueOf(false), Boolean.valueOf(true))) {
                        result.add(anno.getKey().getName());
                    }
                }
                catch (ApiException ex) {
                    log.error("Could not get node annotations for corpus " + corpus, (Throwable)ex);
                }
            }
        }
        return result;
    }

    public void prepareAddingEdge(NodeWindow sourceNode) {
        this.preparedEdgeSource = sourceNode;
        for (NodeWindow w : this.nodes.keySet()) {
            if (w == sourceNode) continue;
            w.setPrepareEdgeDock(true);
        }
    }

    public void updateLinesAndEdgePositions() {
        this.canvas.getLines().clear();
        for (EdgeWindow e : this.edges) {
            GripDragComponent w1 = (GripDragComponent)this.nodes.get(e.getSource());
            GripDragComponent w2 = (GripDragComponent)this.nodes.get(e.getTarget());
            AbsoluteLayout.ComponentPosition p1 = this.area.getPosition((Component)w1);
            AbsoluteLayout.ComponentPosition p2 = this.area.getPosition((Component)w2);
            float x1 = p1.getLeftValue().floatValue() + w1.getWidth() / 2.0f;
            float y1 = p1.getTopValue().floatValue() + w1.getHeight() / 2.0f;
            float x2 = p2.getLeftValue().floatValue() + w2.getWidth() / 2.0f;
            float y2 = p2.getTopValue().floatValue() + w2.getHeight() / 2.0f;
            float v_x = x2 - x1;
            float v_y = y2 - y1;
            this.canvas.getLines().add(new Line2D.Float(x1, y1, x2, y2));
            AbsoluteLayout.ComponentPosition posEdge = this.area.getPosition((Component)e);
            float vectorLength = (float)Math.sqrt(Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0));
            float xM = x1 + vectorLength / 2.0f * ((x2 - x1) / vectorLength);
            float yM = y1 + vectorLength / 2.0f * ((y2 - y1) / vectorLength);
            double normV_x = v_x / vectorLength;
            double normV_y = v_y / vectorLength;
            double pos1_x = 2.1 * (double)vectorLength / 3.0 * normV_x + (double)x1;
            double pos1_y = 2.1 * (double)vectorLength / 3.0 * normV_y + (double)y1;
            double origDir = Math.atan2(normV_y, normV_x);
            double pos2_x = (double)(1.0f * vectorLength / 3.0f) * normV_x + (double)x1;
            double pos2_y = (double)(1.0f * vectorLength / 3.0f) * normV_y + (double)y1;
            this.canvas.getLines().addAll(this.createArrow(pos1_x, pos1_y, origDir, 20.0));
            this.canvas.getLines().addAll(this.createArrow(pos2_x, pos2_y, origDir, 20.0));
            posEdge.setLeftValue(Float.valueOf(xM - e.getWidth() / 2.0f));
            posEdge.setTopValue(Float.valueOf(yM - e.getHeight() / 2.0f));
        }
        this.canvas.markAsDirty();
    }

    public void updateQuery() {
        this.controller.getState().getAql().setValue((Object)this.getAQLQuery());
    }
}

