/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.requesthandler;

import com.google.common.base.Preconditions;
import com.vaadin.server.RequestHandler;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinResponse;
import com.vaadin.server.VaadinServletResponse;
import com.vaadin.server.VaadinSession;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;
import okhttp3.Response;
import org.apache.commons.io.IOUtils;
import org.corpus_tools.annis.ApiClient;
import org.corpus_tools.annis.ApiException;
import org.corpus_tools.annis.api.CorporaApi;
import org.corpus_tools.annis.gui.CommonUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryRequestHandler
implements RequestHandler {
    private static final long serialVersionUID = -3570539208345869659L;
    private static final Logger log = LoggerFactory.getLogger(BinaryRequestHandler.class);
    private final String prefix;
    private final CommonUI ui;

    public BinaryRequestHandler(String urlPrefix, CommonUI ui) {
        this.prefix = urlPrefix + "/Binary";
        this.ui = ui;
    }

    public boolean handleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response) throws IOException {
        if (request.getPathInfo() != null && request.getPathInfo().startsWith(this.prefix)) {
            if ("GET".equalsIgnoreCase(request.getMethod())) {
                this.sendResponse(session, request, response, true);
                return true;
            }
            if ("HEAD".equalsIgnoreCase(request.getMethod())) {
                this.sendResponse(session, request, response, false);
                return true;
            }
        }
        return false;
    }

    public void sendResponse(VaadinSession session, VaadinRequest request, VaadinResponse pureResponse, boolean sendContent) throws IOException {
        if (!(pureResponse instanceof VaadinServletResponse)) {
            pureResponse.sendError(500, "Binary requests only work with servlets");
        }
        VaadinServletResponse response = (VaadinServletResponse)pureResponse;
        Map binaryParameter = request.getParameterMap();
        String toplevelCorpusName = ((String[])binaryParameter.get("toplevelCorpusName"))[0];
        String[] filePathRaw = (String[])binaryParameter.get("file");
        Preconditions.checkNotNull((Object)filePathRaw, (Object)"No file path given (parameter \"file\"");
        Preconditions.checkArgument((filePathRaw.length > 0 ? 1 : 0) != 0, (Object)"No file path given (parameter \"file\"");
        String filePath = filePathRaw[0];
        CorporaApi api = new CorporaApi(this.ui.getClient());
        ApiClient client = api.getApiClient();
        String localVarPath = "/corpora/{corpus}/files/{name}".replaceAll("\\{corpus\\}", client.escapeString(toplevelCorpusName)).replaceAll("\\{name\\}", client.escapeString(filePath));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        Enumeration originalHeaderNames = request.getHeaderNames();
        while (originalHeaderNames.hasMoreElements()) {
            String headerName = (String)originalHeaderNames.nextElement();
            String headerValue = request.getHeader(headerName);
            localVarHeaderParams.put(headerName, headerValue);
        }
        String[] localVarAccepts = new String[]{"default"};
        String localVarAccept = client.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = client.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        try {
            Call call = client.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, null, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, null);
            Response proxyResponse = call.execute();
            for (String headerName : proxyResponse.headers().names()) {
                response.setHeader(headerName, proxyResponse.header(headerName));
            }
            response.setStatus(proxyResponse.code());
            IOUtils.copy((InputStream)proxyResponse.body().byteStream(), (OutputStream)response.getOutputStream());
        }
        catch (ApiException e) {
            log.error("Could not get binary data from service", (Throwable)e);
            response.sendError(e.getCode(), e.getMessage());
        }
    }
}

