/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.requesthandler;

import com.vaadin.server.RequestHandler;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinResponse;
import com.vaadin.server.VaadinSession;
import java.io.IOException;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.corpus_tools.annis.gui.visualizers.IFrameResource;
import org.corpus_tools.annis.gui.visualizers.IFrameResourceMap;

public class ResourceRequestHandler
implements RequestHandler {
    private static final long serialVersionUID = -8704115274005802537L;
    private final String prefix;

    public ResourceRequestHandler(String urlPrefix) {
        this.prefix = urlPrefix + "/vis-iframe-res/";
    }

    public boolean handleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response) throws IOException {
        if (request.getPathInfo() != null && request.getPathInfo().startsWith(this.prefix)) {
            String uuidString = StringUtils.removeStart((String)request.getPathInfo(), (String)this.prefix);
            UUID uuid = UUID.fromString(uuidString);
            IFrameResourceMap map = (IFrameResourceMap)VaadinSession.getCurrent().getAttribute(IFrameResourceMap.class);
            if (map == null) {
                response.setStatus(404);
            } else {
                IFrameResource res = (IFrameResource)map.get((Object)uuid);
                if (res != null) {
                    response.setStatus(200);
                    response.setContentType(res.getMimeType());
                    response.getOutputStream().write(res.getData());
                }
            }
            return true;
        }
        return false;
    }
}

