/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.resultfetch;

import com.google.common.base.Joiner;
import com.vaadin.ui.UI;
import java.io.File;
import java.util.List;
import java.util.concurrent.Callable;
import org.corpus_tools.annis.api.CorporaApi;
import org.corpus_tools.annis.api.model.SubgraphWithContext;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.annis.gui.graphml.DocumentGraphMapper;
import org.corpus_tools.annis.gui.objects.Match;
import org.corpus_tools.annis.gui.objects.PagedResultQuery;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SaltProject;
import org.eclipse.emf.common.util.URI;

public class SingleResultFetchJob
implements Callable<SaltProject> {
    private final Match match;
    private final PagedResultQuery query;
    private final UI ui;

    public SingleResultFetchJob(Match match, PagedResultQuery query, UI ui) {
        this.match = match;
        this.query = query;
        this.ui = ui;
    }

    @Override
    public SaltProject call() throws Exception {
        CorporaApi api = new CorporaApi(Helper.getClient((UI)this.ui));
        if (Thread.interrupted()) {
            return null;
        }
        SubgraphWithContext subgraphQuery = new SubgraphWithContext();
        subgraphQuery.setNodeIds(this.match.getSaltIDs());
        subgraphQuery.setLeft(Integer.valueOf(this.query.getLeftContext()));
        subgraphQuery.setRight(Integer.valueOf(this.query.getRightContext()));
        subgraphQuery.setSegmentation(this.query.getSegmentation());
        List corpusPath = Helper.getCorpusPath((String)((String)this.match.getSaltIDs().get(0)));
        SaltProject p = SaltFactory.createSaltProject();
        SCorpusGraph cg = p.createCorpusGraph();
        if (!corpusPath.isEmpty()) {
            File graphML = api.subgraphForNodes((String)corpusPath.get(0), subgraphQuery);
            URI docURI = URI.createURI((String)("salt:/" + Joiner.on((char)'/').join((Iterable)corpusPath)));
            SDocument doc = cg.createDocument(docURI);
            SDocumentGraph docGraph = DocumentGraphMapper.map((File)graphML);
            doc.setDocumentGraph(docGraph);
            Helper.addMatchToDocumentGraph((Match)this.match, (SDocumentGraph)doc.getDocumentGraph());
        }
        return p;
    }
}

