/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.resultview;

import com.vaadin.ui.UI;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.corpus_tools.annis.api.model.CorpusConfiguration;
import org.corpus_tools.annis.api.model.VisualizerRule;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.annis.gui.resultview.ResolverProvider;
import org.corpus_tools.annis.gui.resultview.SingleResolverRequest;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.core.SLayer;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolverProviderImpl
implements ResolverProvider,
Serializable {
    private static final long serialVersionUID = 5170826828759716453L;
    private static final Logger log = LoggerFactory.getLogger(ResolverProviderImpl.class);
    private Map<HashSet<SingleResolverRequest>, LinkedHashSet<VisualizerRule>> cacheResolver;

    public ResolverProviderImpl(Map<HashSet<SingleResolverRequest>, LinkedHashSet<VisualizerRule>> cacheResolver) {
        this.cacheResolver = cacheResolver;
    }

    public List<VisualizerRule> getResolverEntries(SDocument doc, UI ui) {
        HashSet<SingleResolverRequest> resolverRequests = new HashSet<SingleResolverRequest>();
        HashSet<String> nodeLayers = new HashSet<String>();
        HashSet<String> edgeLayers = new HashSet<String>();
        if (doc != null && doc.getDocumentGraph() != null) {
            for (SNode n : doc.getDocumentGraph().getNodes()) {
                for (SLayer layer : n.getLayers()) {
                    nodeLayers.add(layer.getName());
                }
            }
            for (SRelation e : doc.getDocumentGraph().getRelations()) {
                for (SLayer layer : e.getLayers()) {
                    try {
                        edgeLayers.add(layer.getName());
                    }
                    catch (NullPointerException ex) {
                        log.warn("NullPointerException when using Salt, was trying to get layer name", (Throwable)ex);
                    }
                }
            }
        }
        String corpusName = ((SNode)doc.getGraph().getRoots().get(0)).getName();
        for (String ns : nodeLayers) {
            resolverRequests.add(new SingleResolverRequest(corpusName, ns, VisualizerRule.ElementEnum.NODE));
        }
        for (String ns : edgeLayers) {
            resolverRequests.add(new SingleResolverRequest(corpusName, ns, VisualizerRule.ElementEnum.EDGE));
        }
        LinkedHashSet<VisualizerRule> matchingRules = new LinkedHashSet<VisualizerRule>();
        if (this.cacheResolver.containsKey(resolverRequests)) {
            matchingRules.addAll((Collection)this.cacheResolver.get(resolverRequests));
        } else {
            CorpusConfiguration corpusConfig = Helper.getCorpusConfig((String)corpusName, (UI)ui);
            if (corpusConfig != null && corpusConfig.getVisualizers() != null) {
                for (VisualizerRule visRule : corpusConfig.getVisualizers()) {
                    for (SingleResolverRequest r : resolverRequests) {
                        if (visRule.getMappings() == null) {
                            visRule.setMappings(new LinkedHashMap());
                        }
                        if (visRule.getElement() != null && !visRule.getElement().equals((Object)r.getType()) || visRule.getLayer() != null && !visRule.getLayer().equals(r.getNamespace())) continue;
                        matchingRules.add(visRule);
                    }
                    this.cacheResolver.put(resolverRequests, matchingRules);
                }
            }
        }
        return new LinkedList<VisualizerRule>(matchingRules);
    }
}

