/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.visualizers.component;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import com.vaadin.server.VaadinSession;
import com.vaadin.ui.UI;
import java.util.List;
import org.apache.tika.Tika;
import org.corpus_tools.annis.ApiException;
import org.corpus_tools.annis.api.CorporaApi;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.annis.gui.VisualizationToggle;
import org.corpus_tools.annis.gui.components.ExceptionDialog;
import org.corpus_tools.annis.gui.components.medialement.MediaElement;
import org.corpus_tools.annis.gui.components.medialement.MediaElementPlayer;
import org.corpus_tools.annis.gui.media.MediaController;
import org.corpus_tools.annis.gui.media.MediaPlayer;
import org.corpus_tools.annis.gui.visualizers.AbstractVisualizer;
import org.corpus_tools.annis.gui.visualizers.VisualizerInput;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SDocument;
import org.springframework.stereotype.Component;

@Component
public class AudioVisualizer
extends AbstractVisualizer {
    private static final long serialVersionUID = 3098842942826409015L;
    private static final Escaper urlParamEscape = UrlEscapers.urlPathSegmentEscaper();
    private final Tika tika = new Tika();

    public MediaElementPlayer createComponent(VisualizerInput input, VisualizationToggle visToggle) {
        List corpusPath = Helper.getCorpusPath((SCorpusGraph)input.getDocument().getGraph(), (SDocument)input.getDocument());
        String binaryServletPath = "";
        String mimeType = null;
        String corpusName = (String)corpusPath.get(corpusPath.size() - 1);
        CorporaApi api = new CorporaApi(Helper.getClient((UI)input.getUI()));
        try {
            List files = api.listFiles(corpusName, Joiner.on((char)'/').join((Iterable)Lists.reverse((List)corpusPath)));
            for (String f : files) {
                String guessedMimeType = this.tika.detect(f);
                if (guessedMimeType == null || !guessedMimeType.startsWith("audio/")) continue;
                binaryServletPath = input.getContextPath() + "/Binary?file=" + urlParamEscape.escape(f) + "&toplevelCorpusName=" + urlParamEscape.escape(corpusName);
                mimeType = guessedMimeType;
            }
        }
        catch (ApiException e) {
            ExceptionDialog.show((Throwable)e, (UI)UI.getCurrent());
        }
        MediaElementPlayer player = new MediaElementPlayer(MediaElement.audio, binaryServletPath, mimeType);
        if (VaadinSession.getCurrent().getAttribute(MediaController.class) != null) {
            ((MediaController)VaadinSession.getCurrent().getAttribute(MediaController.class)).addMediaPlayer((MediaPlayer)player, input.getId(), visToggle);
        }
        return player;
    }

    public String getShortName() {
        return "audio";
    }
}

