/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.visualizers.component;

import com.vaadin.server.Sizeable;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.ui.GridLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.VerticalLayout;
import java.util.regex.Pattern;
import org.corpus_tools.annis.gui.AnnisUI;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.annis.gui.VisualizationToggle;
import org.corpus_tools.annis.gui.objects.RawTextWrapper;
import org.corpus_tools.annis.gui.visualizers.AbstractVisualizer;
import org.corpus_tools.annis.gui.visualizers.VisualizerInput;
import org.springframework.stereotype.Component;

@Component
public class RawTextVisualizer
extends AbstractVisualizer {
    private static final long serialVersionUID = -7314550890894005821L;
    private static final String NO_TEXT = "no text available";
    private static final String PANEL_CLASS = "raw_text";
    private static final String LABEL_CLASS = "raw_text_label";
    private final Pattern whiteSpaceMatcher = Pattern.compile("^\\s+$");

    public Panel createComponent(VisualizerInput visInput, VisualizationToggle visToggle) {
        Label lblText;
        boolean vertical = Boolean.parseBoolean(visInput.getMappings().getOrDefault("vertical", "true"));
        RawTextWrapper texts = visInput.getRawText();
        Panel p = new Panel();
        p.setSizeFull();
        p.addStyleName("borderless");
        p.addStyleName(PANEL_CLASS);
        p.addStyleName("corpus-font-force");
        if (texts == null) {
            Label text = new Label(NO_TEXT);
            text.addStyleName(LABEL_CLASS);
            text.setSizeFull();
            p.setContent((com.vaadin.ui.Component)text);
            return p;
        }
        if (texts.hasMultipleTexts()) {
            Object l = vertical ? new VerticalLayout() : new GridLayout(texts.getTexts().size(), 1);
            l.setSizeFull();
            for (int i = 0; i < texts.getTexts().size(); ++i) {
                String s = (String)texts.getTexts().get(i);
                Label lblText2 = s == null || this.hasOnlyWhiteSpace(s) ? new Label(NO_TEXT) : new Label(s, ContentMode.TEXT);
                if (visInput.getUI() instanceof AnnisUI && !((AnnisUI)visInput.getUI()).getConfig().isDisableRTL() && Helper.containsRTLText((String)s)) {
                    lblText2.addStyleName("rtl");
                }
                lblText2.setCaption("text " + (i + 1));
                lblText2.addStyleName(LABEL_CLASS);
                lblText2.setWidth(98.0f, Sizeable.Unit.PERCENTAGE);
                l.addComponent((com.vaadin.ui.Component)lblText2);
            }
            p.setContent((com.vaadin.ui.Component)l);
            return p;
        }
        if (texts.hasTexts() && !this.hasOnlyWhiteSpace(texts.getFirstText())) {
            lblText = new Label(texts.getFirstText(), ContentMode.TEXT);
            if (visInput.getUI() instanceof AnnisUI && !((AnnisUI)visInput.getUI()).getConfig().isDisableRTL() && Helper.containsRTLText((String)texts.getFirstText())) {
                lblText.addStyleName("rtl");
            }
        } else {
            lblText = new Label(NO_TEXT);
        }
        lblText.setSizeFull();
        lblText.addStyleName(LABEL_CLASS);
        p.setContent((com.vaadin.ui.Component)lblText);
        return p;
    }

    public String getShortName() {
        return PANEL_CLASS;
    }

    public boolean hasOnlyWhiteSpace(String text) {
        return this.whiteSpaceMatcher.matcher(text).matches();
    }

    public boolean isUsingRawText() {
        return true;
    }
}

