/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.visualizers.component.grid;

import java.util.List;
import org.corpus_tools.annis.gui.VisualizationToggle;
import org.corpus_tools.annis.gui.media.MediaController;
import org.corpus_tools.annis.gui.media.PDFController;
import org.corpus_tools.annis.gui.visualizers.AbstractVisualizer;
import org.corpus_tools.annis.gui.visualizers.VisualizerInput;
import org.corpus_tools.annis.gui.visualizers.component.grid.GridComponent;
import org.corpus_tools.annis.gui.visualizers.component.grid.MultipleGridComponent;
import org.corpus_tools.annis.gui.visualizers.component.grid.SingleGridComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GridVisualizer
extends AbstractVisualizer {
    private static final long serialVersionUID = -3086993988435369808L;
    private static final Logger log = LoggerFactory.getLogger(GridVisualizer.class);

    public GridComponent createComponent(VisualizerInput visInput, VisualizationToggle visToggle) {
        MediaController mediaController = (MediaController)visInput.getUI().getSession().getAttribute(MediaController.class);
        PDFController pdfController = (PDFController)visInput.getUI().getSession().getAttribute(PDFController.class);
        Object component = null;
        try {
            List texts = visInput.getDocument().getDocumentGraph().getTextualDSs();
            component = texts.size() == 1 ? new SingleGridComponent(visInput, mediaController, pdfController, true, null) : new MultipleGridComponent(visInput, mediaController, pdfController, true);
        }
        catch (Exception ex) {
            log.error("create {} failed", (Object)GridVisualizer.class.getName(), (Object)ex);
        }
        return component;
    }

    public String getShortName() {
        return "grid";
    }
}

