/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.visualizers.component.kwic;

import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.corpus_tools.annis.gui.media.MediaController;
import org.corpus_tools.annis.gui.media.PDFController;
import org.corpus_tools.annis.gui.visualizers.VisualizerInput;
import org.corpus_tools.annis.gui.visualizers.component.kwic.KWICComponent;
import org.corpus_tools.annis.gui.visualizers.component.kwic.KWICInterface;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.core.SNode;

public class KWICMultipleTextComponent
extends CssLayout
implements KWICInterface {
    private static final long serialVersionUID = 8245889282810831091L;
    List<KWICInterface> kwicPanels;

    public KWICMultipleTextComponent(VisualizerInput visInput, MediaController mediaController, PDFController pdfController) {
        this.setWidth("100%");
        this.setHeight("-1");
        this.kwicPanels = new LinkedList();
        if (visInput != null) {
            List texts = visInput.getDocument().getDocumentGraph().getTextualDSs();
            for (STextualDS t : texts) {
                KWICComponent kwic = new KWICComponent(visInput, mediaController, pdfController, t);
                this.kwicPanels.add(kwic);
                this.addComponent((Component)kwic);
            }
        }
    }

    public boolean setSegmentationLayer(String segmentationName, Map<SNode, Long> markedAndCovered) {
        boolean result = false;
        for (KWICInterface kwic : this.kwicPanels) {
            if (!kwic.setSegmentationLayer(segmentationName, markedAndCovered)) continue;
            result = true;
        }
        return result;
    }

    public void setVisibleTokenAnnos(Set<String> annos) {
        for (KWICInterface kwic : this.kwicPanels) {
            kwic.setVisibleTokenAnnos(annos);
        }
    }
}

