/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.visualizers.component.pdf;

import com.google.common.base.Joiner;
import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import com.vaadin.annotations.JavaScript;
import com.vaadin.ui.AbstractJavaScriptComponent;
import com.vaadin.ui.UI;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.corpus_tools.annis.ApiException;
import org.corpus_tools.annis.api.CorporaApi;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.annis.gui.components.ExceptionDialog;
import org.corpus_tools.annis.gui.visualizers.VisualizerInput;
import org.corpus_tools.annis.gui.visualizers.component.pdf.PDFState;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SDocument;

@JavaScript(value={"pdf.js", "pdf_connector.js"})
public class PDFPanel
extends AbstractJavaScriptComponent {
    private static final long serialVersionUID = 4956567915350147892L;
    private static final Escaper urlParamEscape = UrlEscapers.urlPathSegmentEscaper();
    private VisualizerInput input;
    private int firstPage;
    private int lastPage;
    private final String PDF_ID;

    public PDFPanel(VisualizerInput input, String page) {
        this.input = input;
        if (!"-1".equals(page)) {
            this.firstPage = Integer.parseInt(page.split("-")[0]);
        } else {
            this.firstPage = Integer.parseInt("-1");
            this.lastPage = -1;
        }
        this.lastPage = page.split("-").length > 1 ? Integer.parseInt(page.split("-")[1]) : this.firstPage;
        this.PDF_ID = "pdf-" + UUID.randomUUID();
        this.setId(this.PDF_ID);
        this.addStyleName("pdf-panel");
    }

    public void attach() {
        super.attach();
        this.setSizeUndefined();
        this.getState().binaryURL = this.getBinaryPath(new CorporaApi(Helper.getClient((UI)this.input.getUI())));
        this.getState().pdfID = this.getPDF_ID();
        this.getState().firstPage = this.firstPage;
        this.getState().lastPage = this.lastPage;
    }

    protected String getBinaryPath(CorporaApi api) {
        List corpusPath = Helper.getCorpusPath((SCorpusGraph)this.input.getDocument().getGraph(), (SDocument)this.input.getDocument());
        Collections.reverse(corpusPath);
        String corpusName = (String)corpusPath.get(0);
        try {
            List files = api.listFiles(corpusName, Joiner.on((char)'/').join((Iterable)corpusPath));
            for (String f : files) {
                if (!f.endsWith(".pdf")) continue;
                return this.input.getContextPath() + "/Binary?toplevelCorpusName=" + urlParamEscape.escape(corpusName) + "&file=" + urlParamEscape.escape(f);
            }
        }
        catch (ApiException e) {
            ExceptionDialog.show((Throwable)e, (UI)this.input.getUI());
        }
        return "";
    }

    public String getPDF_ID() {
        return this.PDF_ID;
    }

    protected PDFState getState() {
        return (PDFState)super.getState();
    }
}

