/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.visualizers.component.rst;

import com.vaadin.server.Extension;
import com.vaadin.ui.Component;
import com.vaadin.ui.Panel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.UUID;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.annis.gui.MatchedNodeColors;
import org.corpus_tools.annis.gui.components.CssRenderInfo;
import org.corpus_tools.annis.gui.visualizers.VisualizerInput;
import org.corpus_tools.annis.gui.widgets.JITWrapper;
import org.corpus_tools.salt.SALT_TYPE;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SStructure;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.GraphTraverseHandler;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SGraph;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SProcessingAnnotation;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.util.DataSourceSequence;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSTImpl
extends Panel
implements GraphTraverseHandler {
    private static final long serialVersionUID = 1355629687872757529L;
    private static final String SENTENCE_INDEX = "sentence_index";
    private static final String SENTENCE_LEFT = "sentence_left";
    private static final String SENTENCE_RIGHT = "sentence_right";
    private final JITWrapper jit;
    private Stack<JSONObject> st = new Stack();
    private JSONObject result = new JSONObject();
    private final String ANNOTATION_KEY = "cat";
    private final String RST_RELATION = "rst";
    private final UUID uniqueID = UUID.randomUUID();
    private final String visId;
    private SDocumentGraph graph;
    private final Map<SNode, Long> markedAndCovered;
    private Map<String, String> mappings;
    private String namespace;
    private final Map<SToken, Integer> token2index = new HashMap();
    private final Logger log = LoggerFactory.getLogger(RSTImpl.class);
    private final TreeSet<SStructure> sentences;

    public RSTImpl(VisualizerInput visInput) {
        this.markedAndCovered = visInput.getMarkedAndCovered();
        this.mappings = visInput.getMappings();
        this.namespace = visInput.getNamespace();
        this.visId = "rst_" + this.uniqueID.toString();
        int tokIdx = 0;
        for (SToken tok : visInput.getDocument().getDocumentGraph().getSortedTokenByText()) {
            this.token2index.put(tok, tokIdx++);
        }
        this.sentences = new TreeSet(new /* Unavailable Anonymous Inner Class!! */);
        this.jit = new JITWrapper();
        this.jit.setWidth("100%");
        this.jit.setHeight("-1px");
        this.setContent((Component)this.jit);
        this.jit.setVisData(this.transformSaltToJSON(visInput));
        this.jit.setProperties(visInput.getMappings());
        this.jit.requestRepaint();
        this.addScrollbar();
    }

    public void addExtension(CssRenderInfo renderInfo) {
        super.addExtension((Extension)renderInfo);
    }

    private void addScrollbar() {
        this.setWidth("100%");
        this.getContent().setSizeUndefined();
    }

    private JSONObject appendChild(JSONObject root, JSONObject node, SNode currSnode) {
        try {
            boolean isAppendedToParent = false;
            List in = currSnode.getGraph().getInRelations(currSnode.getId());
            if (in != null) {
                for (SRelation e : in) {
                    if (!this.hasRSTType(e)) continue;
                    if (this.st.size() > 1) {
                        JSONObject tmp = (JSONObject)this.st.pop();
                        this.getOrCreateArray((JSONObject)this.st.peek(), "children").put((Object)node);
                        this.sortChildren((JSONObject)this.st.peek());
                        this.st.push(tmp);
                    } else {
                        this.getOrCreateArray(this.result, "children").put((Object)node);
                    }
                    this.setSentenceSpan(node, (JSONObject)this.st.peek());
                    isAppendedToParent = true;
                    break;
                }
            }
            if (!isAppendedToParent) {
                this.getOrCreateArray(root, "children").put((Object)node);
                this.setSentenceSpan(node, root);
                this.sortChildren(root);
            }
        }
        catch (JSONException ex) {
            this.log.error("cannot append {}", (Object)node, (Object)ex);
        }
        return node;
    }

    public boolean checkConstraint(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SRelation incomingEdge, SNode currNode, long order) {
        if (currNode instanceof SToken) {
            return false;
        }
        return Helper.checkSLayer((String)this.namespace, (SNode)currNode);
    }

    private JSONObject createJsonEntry(SNode currNode) {
        JSONObject jsonData = new JSONObject();
        JSONObject data = new JSONObject();
        StringBuilder sb = new StringBuilder();
        LinkedHashSet token = new LinkedHashSet();
        if (currNode instanceof SStructure) {
            SDocumentGraph dgraph = ((SStructure)currNode).getGraph();
            List edges = currNode.getGraph().getOutRelations(currNode.getId());
            LinkedList<SToken> overlappedToken = new LinkedList<SToken>();
            for (SRelation sedge : edges) {
                if (!(sedge.getTarget() instanceof SToken)) continue;
                overlappedToken.add((SToken)sedge.getTarget());
            }
            token.addAll(dgraph.getSortedTokenByText(overlappedToken));
            Iterator tokIterator = token.iterator();
            while (tokIterator.hasNext()) {
                SToken tok = (SToken)tokIterator.next();
                String text = this.getText(tok);
                String color = this.getHTMLColor(tok);
                if (color != null) {
                    sb.append("<span class=\"rst-token\" style=\"color : ").append(color).append(";\">");
                } else {
                    sb.append("<span class=\"rst-token\">");
                }
                if (tokIterator.hasNext()) {
                    sb.append(text).append(" ");
                } else {
                    sb.append(text);
                }
                sb.append("</span>");
            }
            JSONArray signals = new JSONArray();
            for (SRelation relation : currNode.getInRelations()) {
                if (!this.isSignalNode((SNode)relation.getSource())) continue;
                signals.put((Object)this.jsonizeSignalNode((SNode)relation.getSource()));
            }
            if (signals.length() > 0) {
                data.put("signals", (Object)signals);
            }
        }
        try {
            jsonData.put("id", (Object)this.getUniStrId(currNode));
            jsonData.put("name", (Object)currNode.getName());
            JSONArray edgesJSON = this.getOutGoingEdgeTypeAnnotation(currNode);
            if (token.size() > 0) {
                data.put("sentence", (Object)sb.toString());
            }
            if (edgesJSON != null) {
                data.put("edges", (Object)edgesJSON);
            }
            if (currNode instanceof SStructure && this.isSegment(currNode)) {
                SProcessingAnnotation sentence_idx = currNode.getProcessingAnnotation("sentence_index::sentence_index");
                int index = sentence_idx == null ? -1 : Integer.parseInt(sentence_idx.getValue_STEXT());
                data.put(SENTENCE_LEFT, index);
                data.put(SENTENCE_RIGHT, index);
            }
            jsonData.put("data", (Object)data);
        }
        catch (JSONException ex) {
            this.log.error("problems create entry for {}", (Object)currNode, (Object)ex);
        }
        return jsonData;
    }

    private String getHTMLColor(SToken token) {
        if (!this.markedAndCovered.containsKey(token)) {
            return null;
        }
        int color = (int)((Long)this.markedAndCovered.get(token)).longValue();
        color = Math.min(color > 0 ? color - 1 : color, MatchedNodeColors.values().length - 1);
        return MatchedNodeColors.values()[color].getHTMLColor();
    }

    private JSONArray getOrCreateArray(JSONObject parent, String key) throws JSONException {
        JSONArray array;
        JSONArray jSONArray = array = parent.has(key) ? parent.getJSONArray(key) : null;
        if (array == null) {
            array = new JSONArray();
            parent.put(key, (Object)array);
        }
        return array;
    }

    private JSONArray getOutGoingEdgeTypeAnnotation(SNode node) throws JSONException {
        List out = node.getGraph().getOutRelations(node.getId());
        JSONArray edgeData = new JSONArray();
        if (out == null) {
            return edgeData;
        }
        for (SRelation edge : out) {
            Set annos;
            if (edge.getTarget() instanceof SToken) continue;
            String type = edge.getType();
            String sTypeAsString = "edge";
            if (type != null && !type.isEmpty()) {
                sTypeAsString = type;
            }
            JSONObject jsonEdge = new JSONObject();
            edgeData.put((Object)jsonEdge);
            jsonEdge.put("sType", (Object)sTypeAsString);
            if (edge.getTarget() instanceof SNode) {
                if (this.getRSTType().equals(sTypeAsString)) {
                    jsonEdge.put("to", (Object)this.getUniStrId(node));
                    jsonEdge.put("from", (Object)this.getUniStrId((SNode)edge.getTarget()));
                } else {
                    jsonEdge.put("from", (Object)this.getUniStrId(node));
                    jsonEdge.put("to", (Object)this.getUniStrId((SNode)edge.getTarget()));
                }
            } else {
                throw new JSONException("could not cast to SNode");
            }
            if ((annos = edge.getAnnotations()) == null) continue;
            for (SAnnotation anno : annos) {
                this.getOrCreateArray(jsonEdge, "annotation").put((Object)anno.getValue_STEXT());
            }
        }
        return edgeData;
    }

    private String getRSTType() {
        return this.mappings.getOrDefault("edge", "rst");
    }

    private String getText(SToken currNode) {
        List sSequences = currNode.getGraph().getOverlappedDataSourceSequence((SNode)currNode, new SALT_TYPE[]{SALT_TYPE.STEXT_OVERLAPPING_RELATION});
        if (sSequences == null || sSequences.size() != 1) {
            this.log.error("rst supports only one text and only text level");
            return null;
        }
        this.log.debug("sSequences {}", (Object)sSequences.toString());
        if (((DataSourceSequence)sSequences.get(0)).getDataSource() instanceof STextualDS) {
            STextualDS text = (STextualDS)((DataSourceSequence)sSequences.get(0)).getDataSource();
            int start = ((DataSourceSequence)sSequences.get(0)).getStart().intValue();
            int end = ((DataSourceSequence)sSequences.get(0)).getEnd().intValue();
            return text.getText().substring(start, end);
        }
        this.log.error("{} instead of {}", (Object)((DataSourceSequence)sSequences.get(0)).getDataSource().getClass().getName(), (Object)STextualDS.class.getName());
        return null;
    }

    private String getUniStrId(SNode node) {
        return this.visId + "_" + node.getId();
    }

    private boolean hasRSTType(SRelation e) {
        String type = e.getType();
        if (e.getTarget() instanceof SToken && e.getType() == null) {
            return true;
        }
        return type != null && this.getRSTType().equalsIgnoreCase(type);
    }

    private boolean isSegment(SNode currNode) {
        List edges = currNode.getGraph().getOutRelations(currNode.getId());
        if (edges != null && edges.size() > 0) {
            for (SRelation edge : edges) {
                if (!(edge.getTarget() instanceof SToken)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSignalNode(SNode sNode) {
        return sNode.getAnnotation("default_ns", "signal_type") != null;
    }

    private JSONObject jsonizeSignalNode(SNode node) {
        JSONObject signal = new JSONObject();
        signal.put("type", node.getAnnotation("default_ns", "signal_type").getValue());
        signal.put("subtype", node.getAnnotation("default_ns", "signal_subtype").getValue());
        JSONArray indexes = new JSONArray();
        SAnnotation indexesAnn = node.getAnnotation("default_ns", "signal_indexes");
        if (indexesAnn != null) {
            for (String index : ((String)indexesAnn.getValue()).split(" ")) {
                indexes.put((Object)index);
            }
        }
        signal.put("indexes", (Object)indexes);
        return signal;
    }

    public void nodeLeft(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation edge, SNode fromNode, long order) {
        assert (this.st.size() > 0);
        if (this.st.size() == 1) {
            try {
                this.getOrCreateArray(this.result, "children").put(this.st.pop());
                this.sortChildren(this.result);
            }
            catch (JSONException ex) {
                this.log.error("Problems with adding roots", (Throwable)ex);
            }
        } else {
            JSONObject jsonNode = (JSONObject)this.st.pop();
            this.appendChild((JSONObject)this.st.peek(), jsonNode, currNode);
        }
    }

    public void nodeReached(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation sRelation, SNode fromNode, long order) {
        this.st.push(this.createJsonEntry(currNode));
    }

    private void setSentenceSpan(JSONObject cNode, JSONObject parent) {
        try {
            JSONObject data = cNode.getJSONObject("data");
            int leftPosC = data.getInt(SENTENCE_LEFT);
            int rightPosC = data.getInt(SENTENCE_RIGHT);
            data = parent.getJSONObject("data");
            if (data.has(SENTENCE_LEFT)) {
                data.put(SENTENCE_LEFT, Math.min(leftPosC, data.getInt(SENTENCE_LEFT)));
            } else {
                data.put(SENTENCE_LEFT, leftPosC);
            }
            if (data.has(SENTENCE_RIGHT)) {
                data.put(SENTENCE_RIGHT, Math.max(rightPosC, data.getInt(SENTENCE_RIGHT)));
            } else {
                data.put(SENTENCE_RIGHT, rightPosC);
            }
        }
        catch (JSONException ex) {
            this.log.debug("error while setting left and right position for sentences", (Throwable)ex);
        }
    }

    private void sortChildren(JSONObject root) throws JSONException {
        JSONArray children = root.getJSONArray("children");
        ArrayList<JSONObject> childrenSorted = new ArrayList<JSONObject>(children.length());
        for (int i = 0; i < children.length(); ++i) {
            childrenSorted.add(children.getJSONObject(i));
        }
        Collections.sort(childrenSorted, (o1, o2) -> {
            int o1IdxLeft = 0;
            int o1IdxRight = 0;
            int o2IdxLeft = 0;
            int o2IdxRight = 0;
            try {
                o1IdxLeft = o1.getJSONObject("data").getInt(SENTENCE_LEFT);
                o1IdxRight = o1.getJSONObject("data").getInt(SENTENCE_RIGHT);
                o2IdxLeft = o2.getJSONObject("data").getInt(SENTENCE_LEFT);
                o2IdxRight = o2.getJSONObject("data").getInt(SENTENCE_RIGHT);
            }
            catch (JSONException ex) {
                this.log.error("Could not compare sentence indizes.", (Throwable)ex);
            }
            if (o1IdxLeft + o1IdxRight > o2IdxLeft + o2IdxRight) {
                return 1;
            }
            if (o1IdxLeft + o1IdxRight == o2IdxLeft + o2IdxRight) {
                return 0;
            }
            return -1;
        });
        children = new JSONArray(childrenSorted);
        root.put("children", (Object)children);
    }

    private String transformSaltToJSON(VisualizerInput visInput) {
        this.graph = visInput.getSResult().getDocumentGraph();
        List rootSNodes = this.graph.getRoots();
        ArrayList<SNode> rstRoots = new ArrayList<SNode>();
        for (SNode sNode : rootSNodes) {
            if (!Helper.checkSLayer((String)this.namespace, (SNode)sNode) || this.isSignalNode(sNode)) continue;
            rstRoots.add(sNode);
        }
        if (rootSNodes.size() > 0) {
            this.graph.traverse(rstRoots, SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_DEPTH_FIRST, "getSentences", (GraphTraverseHandler)new /* Unavailable Anonymous Inner Class!! */);
            int i = 1;
            for (SStructure sentence : this.sentences) {
                sentence.createProcessingAnnotation(SENTENCE_INDEX, SENTENCE_INDEX, (Object)Integer.toString(i));
                ++i;
            }
            this.graph.traverse(rstRoots, SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_DEPTH_FIRST, "jsonBuild", (GraphTraverseHandler)this);
        } else {
            this.log.debug("does not find an annotation which matched {}", (Object)"cat");
            this.graph.traverse(rstRoots, SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_DEPTH_FIRST, "jsonBuild", (GraphTraverseHandler)this);
        }
        return this.result.toString();
    }

    static /* synthetic */ Map access$000(RSTImpl x0) {
        return x0.token2index;
    }

    static /* synthetic */ boolean access$100(RSTImpl x0, SNode x1) {
        return x0.isSegment(x1);
    }

    static /* synthetic */ boolean access$200(RSTImpl x0, SNode x1) {
        return x0.isSignalNode(x1);
    }

    static /* synthetic */ TreeSet access$300(RSTImpl x0) {
        return x0.sentences;
    }

    static /* synthetic */ Logger access$400(RSTImpl x0) {
        return x0.log;
    }
}

