/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.visualizers.component.sentstructurejs;

import com.google.gson.Gson;
import com.vaadin.annotations.JavaScript;
import com.vaadin.ui.AbstractJavaScriptComponent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.corpus_tools.annis.gui.MatchedNodeColors;
import org.corpus_tools.annis.gui.visualizers.VisualizerInput;
import org.corpus_tools.annis.gui.visualizers.component.grid.EventExtractor;
import org.corpus_tools.annis.gui.visualizers.component.sentstructurejs.SentStructureJsComponent;
import org.corpus_tools.annis.gui.visualizers.component.sentstructurejs.SentStructureJsState;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SDominanceRelation;
import org.corpus_tools.salt.common.SPointingRelation;
import org.corpus_tools.salt.common.SSpanningRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SFeature;
import org.corpus_tools.salt.core.SLayer;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.util.ExportFilter;
import org.corpus_tools.salt.util.StyleImporter;

/*
 * Exception performing whole class analysis ignored.
 */
@JavaScript(value={"SentStructureJs_Connector.js", "vaadin://jquery.js", "SentStructure.js", "d3.min.js"})
public class SentStructureJsComponent
extends AbstractJavaScriptComponent
implements ExportFilter,
StyleImporter {
    private static final long serialVersionUID = 6393879739107209201L;
    private static final String MAPPING_ALIGNMENT_LABEL = "alignment_label";
    private String containerId;
    private String jsonStr;
    private Map<String, Set<String>> displayedNodeAnnotations = new HashMap();
    private Map<String, Set<String>> displayedPointingRelAnnotations = new HashMap();
    private Map<String, Set<String>> displayedSpanningRelAnnotations = new HashMap();
    private Map<String, Set<String>> displayedDominanceRelAnnotations = new HashMap();
    private final List<String> configurations = new ArrayList();
    private Map<String, String> mappings;

    private static List<String> computeDisplayedRelAnnotations(VisualizerInput input, String relAnnosConfiguration, Class<? extends SRelation> type) {
        if (input == null) {
            return new LinkedList<String>();
        }
        SDocumentGraph graph = input.getDocument().getDocumentGraph();
        Set annotationPool = SentStructureJsComponent.getRelationLevelSet((SDocumentGraph)graph, null, type);
        LinkedList<String> confAnnotations = new LinkedList<String>(annotationPool);
        if (relAnnosConfiguration != null && relAnnosConfiguration.trim().length() > 0) {
            String[] confSplit = relAnnosConfiguration.split(",");
            confAnnotations.clear();
            for (String entry : confSplit) {
                if ((entry = entry.trim()).startsWith("/") && entry.endsWith("/")) {
                    Pattern regex = Pattern.compile(StringUtils.strip((String)entry, (String)"/"));
                    LinkedList<String> matchingAnnotations = new LinkedList<String>();
                    for (String anno : annotationPool) {
                        if (!regex.matcher(anno).matches()) continue;
                        matchingAnnotations.add(anno);
                    }
                    confAnnotations.addAll(matchingAnnotations);
                    annotationPool.removeAll(matchingAnnotations);
                    continue;
                }
                confAnnotations.add(entry);
                annotationPool.remove(entry);
            }
        }
        return confAnnotations;
    }

    private static Set<String> getRelationLevelSet(SDocumentGraph graph, String namespace, Class<? extends SRelation> type) {
        TreeSet<String> result = new TreeSet<String>();
        if (graph != null) {
            List edges = null;
            if (type == SDominanceRelation.class) {
                edges = graph.getDominanceRelations();
            } else if (type == SPointingRelation.class) {
                edges = graph.getPointingRelations();
            } else if (type == SSpanningRelation.class) {
                edges = graph.getSpanningRelations();
            }
            if (edges != null) {
                block0: for (SRelation edge : edges) {
                    Set layers = edge.getLayers();
                    for (SLayer layer : layers) {
                        if (namespace != null && !namespace.equals(layer.getName())) continue;
                        for (SAnnotation anno : edge.getAnnotations()) {
                            result.add(anno.getQName());
                        }
                        continue block0;
                    }
                }
            }
        }
        return result;
    }

    private static boolean includeObject(Set<SAnnotation> objectAnnotations, Map<String, Set<String>> displayedAnnotationsMap) {
        for (SAnnotation objectAnnotation : objectAnnotations) {
            String annotation = objectAnnotation.getName();
            String namespace = objectAnnotation.getNamespace();
            if (!displayedAnnotationsMap.containsKey(annotation)) continue;
            if (displayedAnnotationsMap.get(annotation).isEmpty()) {
                return true;
            }
            if (!displayedAnnotationsMap.get(annotation).contains(namespace)) continue;
            return true;
        }
        return false;
    }

    public SentStructureJsComponent(VisualizerInput visInput) {
        this.mappings = visInput.getMappings();
        this.containerId = "sentstructure_graph_" + visInput.getId();
        for (Annos_Keyword kw : Annos_Keyword.values()) {
            this.configurations.add(visInput.getMappings().get(kw.getValue()));
            this.fillFilterAnnotations(visInput, kw.ordinal());
        }
        SDocument doc = visInput.getDocument();
        doc.getDocumentGraph().sortTokenByText();
        List tokens = doc.getDocumentGraph().getTokens();
        Set layers = doc.getDocumentGraph().getLayers();
        HashMap tokensByLayer = new HashMap();
        for (Object layer : layers) {
            for (SToken token : tokens) {
                if (!token.getLayers().contains(layer)) continue;
                if (tokensByLayer.get(layer) == null) {
                    tokensByLayer.put(layer, new ArrayList());
                }
                ((List)tokensByLayer.get(layer)).add(token);
            }
        }
        HashMap segmentsMap = new HashMap();
        for (Map.Entry entry : tokensByLayer.entrySet()) {
            SLayer layer = (SLayer)entry.getKey();
            List lTokens = (List)entry.getValue();
            segmentsMap.put(layer.getId(), new ArrayList());
            for (SToken token : lTokens) {
                HashMap<String, String> tokenMap = new HashMap<String, String>();
                tokenMap.put("id", layer.getId() + "_" + this.stripId(token.getId()));
                tokenMap.put("type", doc.getDocumentGraph().getText((SNode)token));
                String tokenColor = "black";
                if (visInput.getMarkedAndCovered().containsKey(token)) {
                    tokenColor = MatchedNodeColors.getHTMLColorByMatch((Long)((Long)visInput.getMarkedAndCovered().get(token)));
                }
                tokenMap.put("color", tokenColor);
                tokenMap.put("dep", "ROOT");
                tokenMap.put("lemma", "");
                tokenMap.put("pos", "");
                tokenMap.put("dep_to", "0");
                ((List)segmentsMap.get(layer.getId())).add(tokenMap);
            }
        }
        List pRelations = doc.getDocumentGraph().getPointingRelations();
        HashMap<Pair, String> hashMap = new HashMap<Pair, String>();
        for (Object token : tokens) {
            for (SPointingRelation pRelation : pRelations) {
                if (!token.getInRelations().contains(pRelation) || !tokens.contains(pRelation.getSource()) || !tokens.contains(pRelation.getTarget())) continue;
                SToken sourceToken = (SToken)pRelation.getSource();
                SToken targetToken = (SToken)pRelation.getTarget();
                HashSet intersectLayers = new HashSet(sourceToken.getLayers());
                intersectLayers.retainAll(targetToken.getLayers());
                if (intersectLayers.size() != 0) continue;
                hashMap.put(Pair.of((Object)sourceToken, (Object)targetToken), this.getPointingRelationAnnotation(pRelation));
            }
        }
        ArrayList alignmentsList = new ArrayList();
        for (Map.Entry entry : hashMap.entrySet()) {
            Pair p = (Pair)entry.getKey();
            ArrayList<String> alignment = new ArrayList<String>();
            alignment.add(((SLayer)((SToken)p.getLeft()).getLayers().iterator().next()).getId() + "_" + this.stripId(((SToken)p.getLeft()).getId()));
            alignment.add(((SLayer)((SToken)p.getRight()).getLayers().iterator().next()).getId() + "_" + this.stripId(((SToken)p.getRight()).getId()));
            alignment.add((String)entry.getValue());
            alignmentsList.add(alignment);
        }
        Gson gson = new Gson();
        String string = gson.toJson(segmentsMap);
        String alignmentsJson = gson.toJson(alignmentsList);
        this.jsonStr = "{ \"segments\": " + string + ", \"alignments\": " + alignmentsJson + " }";
    }

    public void attach() {
        super.attach();
        this.setHeight("100%");
        this.setWidth("100%");
        this.getState().jsonStr = this.jsonStr;
        this.getState().containerId = this.containerId;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void fillFilterAnnotations(VisualizerInput visInput, int type) {
        List displayedAnnotations = null;
        Map displayedAnnotationsMap = null;
        switch (type) {
            case 0: {
                displayedAnnotations = EventExtractor.computeDisplayAnnotations((VisualizerInput)visInput, SNode.class);
                displayedAnnotationsMap = this.displayedNodeAnnotations;
                break;
            }
            case 1: {
                displayedAnnotations = SentStructureJsComponent.computeDisplayedRelAnnotations((VisualizerInput)visInput, (String)((String)this.configurations.get(type)), SPointingRelation.class);
                displayedAnnotationsMap = this.displayedPointingRelAnnotations;
                break;
            }
            case 2: {
                displayedAnnotations = SentStructureJsComponent.computeDisplayedRelAnnotations((VisualizerInput)visInput, (String)((String)this.configurations.get(type)), SSpanningRelation.class);
                displayedAnnotationsMap = this.displayedSpanningRelAnnotations;
                break;
            }
            case 3: {
                displayedAnnotations = SentStructureJsComponent.computeDisplayedRelAnnotations((VisualizerInput)visInput, (String)((String)this.configurations.get(type)), SDominanceRelation.class);
                displayedAnnotationsMap = this.displayedDominanceRelAnnotations;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        for (String annotation : displayedAnnotations) {
            void var9_9;
            String anno = null;
            String ns = null;
            Object var9_10 = null;
            if (annotation.contains("::")) {
                String[] annotationParts = annotation.split("::");
                if (annotationParts.length != 2) throw new IllegalArgumentException("The annotation string in resolver_vis_map table is not well formed.");
                anno = annotationParts[1];
                ns = annotationParts[0];
            } else {
                anno = annotation;
            }
            if (displayedAnnotationsMap.containsKey(anno)) {
                Set set = (Set)displayedAnnotationsMap.get(anno);
            } else {
                HashSet hashSet = new HashSet();
            }
            if (ns != null) {
                var9_9.add(ns);
            }
            displayedAnnotationsMap.put(anno, var9_9);
        }
    }

    public String getContainerId() {
        return this.containerId;
    }

    private String getPointingRelationAnnotation(SPointingRelation rel) {
        if (this.mappings.containsKey("alignment_label") && this.mappings.get("alignment_label") != null) {
            Set annos = rel.getAnnotations();
            SAnnotation anno = null;
            for (SAnnotation a : annos) {
                if (!((String)this.mappings.get("alignment_label")).equals(a.getName())) continue;
                anno = a;
                break;
            }
            return anno != null ? anno.getValue_STEXT() : "";
        }
        return "";
    }

    protected SentStructureJsState getState() {
        return (SentStructureJsState)super.getState();
    }

    public boolean includeNode(SNode node) {
        if (node instanceof SToken || this.configurations.get(0) == null) {
            return true;
        }
        Set nodeAnnotations = node.getAnnotations();
        return SentStructureJsComponent.includeObject((Set)nodeAnnotations, (Map)this.displayedNodeAnnotations);
    }

    public boolean includeRelation(SRelation relation) {
        Map displayedRelAnnotations = new HashMap();
        if (relation instanceof SPointingRelation) {
            if (this.configurations.get(1) == null) {
                return true;
            }
            displayedRelAnnotations = this.displayedPointingRelAnnotations;
        }
        if (relation instanceof SSpanningRelation) {
            if (this.configurations.get(2) == null) {
                return true;
            }
            displayedRelAnnotations = this.displayedSpanningRelAnnotations;
        }
        if (relation instanceof SDominanceRelation) {
            if (this.configurations.get(3) == null) {
                return true;
            }
            displayedRelAnnotations = this.displayedDominanceRelAnnotations;
        }
        Set relAnnotations = relation.getAnnotations();
        return SentStructureJsComponent.includeObject((Set)relAnnotations, displayedRelAnnotations);
    }

    public String setHighlightingColor(SNode node) {
        Long matchRaw;
        String color = null;
        SFeature featMatched = node.getFeature("annis", "matchednode");
        Long l = matchRaw = featMatched == null ? null : featMatched.getValue_SNUMERIC();
        if (matchRaw != null) {
            color = MatchedNodeColors.getHTMLColorByMatch((Long)matchRaw);
            return color;
        }
        return color;
    }

    private String stripId(String s) {
        return s.substring(s.lastIndexOf("#") + 1);
    }
}

