/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.visualizers.component.tree;

import com.google.common.base.Objects;
import com.vaadin.ui.UI;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.corpus_tools.annis.gui.AnnisUI;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.annis.gui.visualizers.VisualizerInput;
import org.corpus_tools.annis.gui.visualizers.component.tree.HorizontalOrientation;
import org.corpus_tools.salt.SALT_TYPE;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SDominanceRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.util.DataSourceSequence;

/*
 * Exception performing whole class analysis ignored.
 */
public class AnnisGraphTools
implements Serializable {
    private static final long serialVersionUID = -1478561641149654759L;
    private static final String PRIMEDGE_SUBTYPE = "edge";
    private static final String SECEDGE_SUBTYPE = "secedge";
    private final VisualizerInput input;

    public static HorizontalOrientation detectLayoutDirection(SDocumentGraph docGraph, UI ui) {
        if (ui instanceof AnnisUI && ((AnnisUI)ui).getConfig().isDisableRTL()) {
            return HorizontalOrientation.LEFT_TO_RIGHT;
        }
        int withhRTL = 0;
        for (SToken token : docGraph.getTokens()) {
            if (!Helper.containsRTLText((String)docGraph.getText((SNode)token))) continue;
            ++withhRTL;
        }
        return withhRTL > docGraph.getTokens().size() / 3 ? HorizontalOrientation.RIGHT_TO_LEFT : HorizontalOrientation.LEFT_TO_RIGHT;
    }

    public static String extractAnnotation(Set<SAnnotation> annotations, String namespace, String featureName) {
        if (annotations != null) {
            for (SAnnotation a : annotations) {
                if (!(namespace == null ? a.getName().equals(featureName) : Objects.equal((Object)a.getNamespace(), (Object)namespace) && Objects.equal((Object)a.getName(), (Object)featureName))) continue;
                return a.getValue_STEXT();
            }
        }
        return null;
    }

    public static boolean isTerminal(SNode n, VisualizerInput input) {
        String terminalName = null;
        String terminalNamespace = null;
        if (input != null) {
            terminalName = (String)input.getMappings().get("terminal_name");
            terminalNamespace = (String)input.getMappings().get("terminal_ns");
        }
        if (terminalName == null) {
            return n instanceof SToken;
        }
        SAnnotation anno = n.getAnnotation(terminalNamespace, terminalName);
        return anno != null;
    }

    public AnnisGraphTools(VisualizerInput input) {
        this.input = input;
    }

    private boolean copyNode(DirectedGraph<SNode, SRelation> graph, SNode n, String terminalNamespace, String terminalName) {
        boolean addToGraph = AnnisGraphTools.isTerminal((SNode)n, (VisualizerInput)this.input);
        if (!addToGraph) {
            for (SRelation rel : n.getOutRelations()) {
                if (!this.includeEdge(rel) || !this.copyNode(graph, (SNode)rel.getTarget(), terminalNamespace, terminalName)) continue;
                addToGraph |= true;
                graph.addEdge((Object)rel, (Object)n, (Object)rel.getTarget());
            }
        }
        if (addToGraph) {
            graph.addVertex((Object)n);
        }
        return addToGraph;
    }

    private DirectedGraph<SNode, SRelation> extractGraph(SDocumentGraph docGraph, SNode n, String terminalNamespace, String terminalName) {
        DirectedSparseGraph graph = new DirectedSparseGraph();
        this.copyNode((DirectedGraph)graph, n, terminalNamespace, terminalName);
        for (SDominanceRelation rel : docGraph.getDominanceRelations()) {
            if (!this.hasEdgeSubtype((SRelation)rel, this.getSecEdgeSubType()) || !graph.containsVertex((Object)rel.getTarget()) || !graph.containsVertex((Object)rel.getSource())) continue;
            graph.addEdge((Object)rel, (Object)rel.getSource(), (Object)rel.getTarget());
        }
        return graph;
    }

    public String getPrimEdgeSubType() {
        return this.input.getMappings().getOrDefault("edge_type", "edge");
    }

    public String getSecEdgeSubType() {
        return this.input.getMappings().getOrDefault("secedge_type", "secedge");
    }

    public List<DirectedGraph<SNode, SRelation>> getSyntaxGraphs() {
        SDocumentGraph docGraph = this.input.getDocument().getDocumentGraph();
        String namespace = this.input.getMappings().getOrDefault("node_ns", this.input.getNamespace());
        String terminalName = (String)this.input.getMappings().get("terminal_name");
        String terminalNamespace = (String)this.input.getMappings().get("terminal_ns");
        ArrayList<DirectedGraph<SNode, SRelation>> resultGraphs = new ArrayList<DirectedGraph<SNode, SRelation>>();
        LinkedList<SNode> rootNodes = new LinkedList<SNode>();
        for (SNode n : docGraph.getRootsByRelation(new SALT_TYPE[]{SALT_TYPE.SDOMINANCE_RELATION})) {
            if (!Helper.checkSLayer((String)namespace, (SNode)n)) continue;
            rootNodes.add(n);
        }
        HorizontalOrientation orientation = AnnisGraphTools.detectLayoutDirection((SDocumentGraph)docGraph, (UI)this.input.getUI());
        if (orientation == HorizontalOrientation.LEFT_TO_RIGHT) {
            Collections.sort(rootNodes, (o1, o2) -> {
                DataSourceSequence seq1 = (DataSourceSequence)docGraph.getOverlappedDataSourceSequence(o1, new SALT_TYPE[]{SALT_TYPE.STEXT_OVERLAPPING_RELATION}).get(0);
                DataSourceSequence seq2 = (DataSourceSequence)docGraph.getOverlappedDataSourceSequence(o2, new SALT_TYPE[]{SALT_TYPE.STEXT_OVERLAPPING_RELATION}).get(0);
                return Long.compare(seq1.getStart().longValue(), seq2.getStart().longValue());
            });
        } else if (orientation == HorizontalOrientation.RIGHT_TO_LEFT) {
            Collections.sort(rootNodes, (o1, o2) -> {
                DataSourceSequence seq1 = (DataSourceSequence)docGraph.getOverlappedDataSourceSequence(o1, new SALT_TYPE[]{SALT_TYPE.STEXT_OVERLAPPING_RELATION}).get(0);
                DataSourceSequence seq2 = (DataSourceSequence)docGraph.getOverlappedDataSourceSequence(o2, new SALT_TYPE[]{SALT_TYPE.STEXT_OVERLAPPING_RELATION}).get(0);
                return Long.compare(seq2.getStart().longValue(), seq1.getStart().longValue());
            });
        }
        for (SNode r : rootNodes) {
            resultGraphs.add((DirectedGraph<SNode, SRelation>)this.extractGraph(docGraph, r, terminalNamespace, terminalName));
        }
        return resultGraphs;
    }

    public boolean hasEdgeSubtype(SRelation rel, String edgeSubtype) {
        String type = rel.getType();
        if (type != null && type.isEmpty()) {
            type = null;
        }
        if (this.getPrimEdgeSubType().equals(edgeSubtype)) {
            String string = edgeSubtype = this.input.getMappings().get("edge") != null ? (String)this.input.getMappings().get("edge") : this.getPrimEdgeSubType();
        }
        if (this.getSecEdgeSubType().equals(edgeSubtype)) {
            edgeSubtype = this.input.getMappings().get("secedge") != null ? (String)this.input.getMappings().get("secedge") : this.getSecEdgeSubType();
        }
        boolean result = rel instanceof SDominanceRelation && (type == null && "null".equals(edgeSubtype) || type != null && type.equals(edgeSubtype));
        return result;
    }

    private boolean includeEdge(SRelation e) {
        boolean result = this.hasEdgeSubtype(e, this.getPrimEdgeSubType());
        return result;
    }
}

