/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.visualizers.component.tree;

import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.util.Pair;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.corpus_tools.annis.gui.visualizers.VisualizerInput;
import org.corpus_tools.annis.gui.visualizers.component.tree.AnnisGraphTools;
import org.corpus_tools.annis.gui.visualizers.component.tree.ConstituentLayouter;
import org.corpus_tools.annis.gui.visualizers.component.tree.GraphicsBackend;
import org.corpus_tools.annis.gui.visualizers.component.tree.GraphicsItem;
import org.corpus_tools.annis.gui.visualizers.component.tree.LayoutOptions;
import org.corpus_tools.annis.gui.visualizers.component.tree.NodeStructureData;
import org.corpus_tools.annis.gui.visualizers.component.tree.RectangleSide;
import org.corpus_tools.annis.gui.visualizers.component.tree.TreeElementLabeler;
import org.corpus_tools.annis.gui.visualizers.component.tree.TreeElementStyler;
import org.corpus_tools.annis.gui.visualizers.component.tree.VerticalOrientation;
import org.corpus_tools.salt.SALT_TYPE;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.util.DataSourceSequence;

/*
 * Exception performing whole class analysis ignored.
 */
public class ConstituentLayouter<T extends GraphicsItem> {
    private static final SToken TOKEN_NODE = SaltFactory.createSToken();
    private final AnnisGraphTools GRAPH_TOOLS;
    private final DirectedGraph<SNode, SRelation> graph;
    private final SNode root;
    private final TreeElementLabeler labeler;
    private final GraphicsBackend<T> backend;
    private final Map<SNode, NodeStructureData> dataMap;
    private final TreeElementStyler styler;
    private final VisualizerInput input;

    public ConstituentLayouter(DirectedGraph<SNode, SRelation> graph_, GraphicsBackend<T> backend_, TreeElementLabeler labeler_, TreeElementStyler styler_, VisualizerInput input_, AnnisGraphTools graphTools) {
        this.backend = backend_;
        this.labeler = labeler_;
        this.graph = graph_;
        this.styler = styler_;
        this.input = input_;
        this.GRAPH_TOOLS = graphTools;
        this.root = this.findRoot();
        this.dataMap = new HashMap();
        this.fillHeightMap(this.root, 0, null);
        this.adaptNodeHeights();
    }

    public void adaptNodeHeights() {
        ArrayList allNonterminals = new ArrayList();
        boolean allContinuous = true;
        for (SNode n : this.graph.getVertices()) {
            if (AnnisGraphTools.isTerminal((SNode)n, (VisualizerInput)this.input)) continue;
            allNonterminals.add(this.dataMap.get(n));
            allContinuous &= ((NodeStructureData)this.dataMap.get(n)).isContinuous();
        }
        if (allContinuous) {
            return;
        }
        int level = 1;
        while (true) {
            ArrayList<NodeStructureData> levelNodes = new ArrayList<NodeStructureData>();
            for (NodeStructureData n : allNonterminals) {
                if (n.getHeight() != level) continue;
                levelNodes.add(n);
            }
            if (levelNodes.isEmpty()) {
                return;
            }
            Collections.sort(levelNodes, (o1, o2) -> {
                int o1k = o1.isContinuous() ? 1 : 0;
                int o2k = o2.isContinuous() ? 1 : 0;
                return o1k - o2k;
            });
            int d = this.findFirstContinuous(levelNodes);
            block3: for (int i = 0; i < d; ++i) {
                NodeStructureData iNode = (NodeStructureData)levelNodes.get(i);
                for (int j = i + 1; j < levelNodes.size(); ++j) {
                    NodeStructureData jNode = (NodeStructureData)levelNodes.get(j);
                    if (iNode.getHeight() != jNode.getHeight()) continue;
                    if (jNode.isContinuous()) {
                        if (!iNode.encloses(jNode)) continue;
                        iNode.increaseStep();
                        continue block3;
                    }
                    this.bubbleNode(iNode, jNode);
                }
            }
            ++level;
        }
    }

    private void addSecEdges(TreeLayoutData treeLayout, LayoutOptions options) {
        for (SRelation e : this.graph.getEdges()) {
            if (!this.GRAPH_TOOLS.hasEdgeSubtype(e, this.GRAPH_TOOLS.getSecEdgeSubType())) continue;
            Rectangle2D sourceRect = treeLayout.getRect((SNode)e.getSource());
            Rectangle2D targetRect = treeLayout.getRect((SNode)e.getTarget());
            CubicCurve2D curveData = this.secedgeCurve(treeLayout.getOrientation(), sourceRect, targetRect);
            GraphicsItem secedgeElem = this.backend.cubicCurve(curveData, this.styler.getStroke(e, this.input), this.styler.getEdgeColor(e, this.input));
            secedgeElem.setZValue(-2);
            GraphicsItem arrowElem = this.backend.arrow(curveData.getP1(), curveData.getCtrlP1(), (Rectangle2D)new Rectangle2D.Double(0.0, 0.0, 8.0, 8.0), this.styler.getEdgeColor(e, this.input));
            arrowElem.setZValue(-1);
            arrowElem.setParentItem(secedgeElem);
            Point2D labelPos = this.evaluate(curveData, 0.8);
            GraphicsItem label = this.backend.makeLabel(this.labeler.getLabel(e, this.input), labelPos, this.styler.getFont(e), this.styler.getTextBrush(e), GraphicsBackend.Alignment.CENTERED, this.styler.getShape(e, this.input));
            label.setParentItem(secedgeElem);
            secedgeElem.setParentItem(treeLayout.getParentItem());
        }
    }

    private Point2D addTerminalNode(SNode terminal, TreeLayoutData treeLayout) {
        GraphicsItem label = this.backend.makeLabel(this.labeler.getLabel(terminal, this.input), treeLayout.getTokenPosition(terminal), this.styler.getFont(terminal, this.input), this.styler.getTextBrush(terminal, this.input), GraphicsBackend.Alignment.NONE, this.styler.getShape(terminal, this.input));
        label.setParentItem(treeLayout.getParentItem());
        treeLayout.addNodeRect(terminal, label.getBounds());
        return treeLayout.getDominanceConnector(terminal, label.getBounds());
    }

    private void bubbleNode(NodeStructureData iNode, NodeStructureData jNode) {
        if (iNode.getLeftCorner() < jNode.getLeftCorner() && jNode.getLeftCorner() < iNode.getRightCorner()) {
            if (jNode.getRightCorner() < iNode.getRightCorner()) {
                iNode.increaseStep();
            } else if (jNode.getLeftmostImmediate() < iNode.getRightmostImmediate()) {
                NodeStructureData x = iNode.getArity() < jNode.getArity() ? iNode : jNode;
                x.increaseStep();
            }
        } else if (jNode.getLeftCorner() < iNode.getLeftCorner() && jNode.getLeftCorner() < jNode.getRightCorner()) {
            if (iNode.getRightCorner() < jNode.getRightCorner()) {
                jNode.increaseStep();
            } else if (iNode.getLeftmostImmediate() < jNode.getRightmostImmediate()) {
                NodeStructureData x = iNode.getArity() < jNode.getArity() ? iNode : jNode;
                x.increaseStep();
            }
        }
    }

    private Point2D calculateNodePosition(SNode current, TreeLayoutData treeLayout, LayoutOptions options) {
        double y = treeLayout.getYPosition(current);
        ArrayList<Double> childPositions = new ArrayList<Double>();
        for (SRelation e : this.getOutgoingEdges(current)) {
            SNode child = (SNode)this.graph.getOpposite((Object)current, (Object)e);
            Point2D childPos = AnnisGraphTools.isTerminal((SNode)child, (VisualizerInput)this.input) ? this.addTerminalNode(child, treeLayout) : this.calculateNodePosition(child, treeLayout, options);
            childPositions.add(childPos.getX());
            NodeStructureData childData = (NodeStructureData)this.dataMap.get(child);
            if (childData.canHaveVerticalOverlap()) {
                treeLayout.getNodeList().addVerticalEdgePosition(childData, childPos);
            }
            treeLayout.addEdge((Point2D)new Point2D.Double(childPos.getX(), y), childPos);
            GraphicsItem label = this.backend.makeLabel(this.labeler.getLabel(e, this.input), (Point2D)new Point2D.Double(childPos.getX(), y + (double)(TreeLayoutData.access$300((TreeLayoutData)treeLayout).value * this.styler.getHeightStep()) * 0.5), this.styler.getFont(e), this.styler.getTextBrush(e), GraphicsBackend.Alignment.CENTERED, this.styler.getShape(e, this.input));
            label.setZValue(10);
            label.setParentItem(TreeLayoutData.access$400((TreeLayoutData)treeLayout));
        }
        double xCenter = treeLayout.getNodeList().findBestPosition((NodeStructureData)this.dataMap.get(current), ((Double)Collections.min(childPositions)).doubleValue(), ((Double)Collections.max(childPositions)).doubleValue());
        GraphicsItem label = this.backend.makeLabel(this.labeler.getLabel(current, this.input), (Point2D)new Point2D.Double(xCenter, y), this.styler.getFont(current, this.input), this.styler.getTextBrush(current, this.input), GraphicsBackend.Alignment.CENTERED, this.styler.getShape(current, this.input));
        treeLayout.addNodeRect(current, label.getBounds());
        label.setZValue(11);
        label.setParentItem(treeLayout.getParentItem());
        treeLayout.addEdge((Point2D)new Point2D.Double((Double)Collections.min(childPositions), y), (Point2D)new Point2D.Double((Double)Collections.max(childPositions), y));
        return treeLayout.getDominanceConnector(current, label.getBounds());
    }

    private Map<SNode, Double> computeTokenPositions(LayoutOptions options, int padding) {
        HashMap<SNode, Double> positions = new HashMap<SNode, Double>();
        double x = 0.0;
        boolean first = true;
        List leaves = this.getTokens(options);
        if (leaves.isEmpty()) {
            throw new IllegalStateException("No terminal nodes found");
        }
        GraphicsBackend.Font tokenFont = this.styler.getFont((SNode)leaves.get(0), this.input);
        for (SNode token : leaves) {
            if (first) {
                first = false;
            } else {
                x += (double)this.styler.getTokenSpacing();
            }
            positions.put(token, x);
            x += (double)(2 * padding) + tokenFont.extents(this.labeler.getLabel(token, this.input)).getWidth();
        }
        return positions;
    }

    private double computeTreeHeight() {
        return (double)(((NodeStructureData)this.dataMap.get(this.root)).getHeight() * this.styler.getHeightStep()) + this.styler.getFont((SNode)TOKEN_NODE, this.input).getLineHeight() / 2.0;
    }

    public T createLayout(LayoutOptions options) {
        TreeLayoutData treeLayout = new TreeLayoutData(this, options.getOrientation(), this.computeTokenPositions(options, 5));
        treeLayout.setParentItem(this.backend.group());
        if (options.getOrientation() == VerticalOrientation.TOP_ROOT) {
            treeLayout.setNtStart(this.computeTreeHeight());
            treeLayout.setBaseline(treeLayout.getNtStart() + this.styler.getFont((SNode)TOKEN_NODE, this.input).getLineHeight());
        } else {
            treeLayout.setBaseline(this.styler.getFont((SNode)TOKEN_NODE, this.input).getLineHeight());
            treeLayout.setNtStart(this.styler.getFont((SNode)TOKEN_NODE, this.input).getLineHeight());
        }
        this.calculateNodePosition(this.root, treeLayout, options);
        SRelation e = (SRelation)this.getOutgoingEdges(this.root).get(0);
        GraphicsItem edges = this.backend.makeLines((Collection)treeLayout.getLines(), this.styler.getEdgeColor(e, this.input), this.styler.getStroke(e, this.input));
        edges.setZValue(-4);
        edges.setParentItem(treeLayout.getParentItem());
        this.addSecEdges(treeLayout, options);
        return (T)treeLayout.getParentItem();
    }

    private Point2D evaluate(CubicCurve2D curveData, double t) {
        double u = 1.0 - t;
        return new Point2D.Double(curveData.getX1() * u * u * u + 3.0 * curveData.getCtrlX1() * t * u * u + 3.0 * curveData.getCtrlX2() * t * t * u + curveData.getX2() * t * t * t, curveData.getY1() * u * u * u + 3.0 * curveData.getCtrlY1() * t * u * u + 3.0 * curveData.getCtrlY2() * t * t * u + curveData.getY2() * t * t * t);
    }

    private NodeStructureData fillHeightMap(SNode node, int height, NodeStructureData parent) {
        if (AnnisGraphTools.isTerminal((SNode)node, (VisualizerInput)this.input)) {
            DataSourceSequence seq = (DataSourceSequence)((SDocumentGraph)node.getGraph()).getOverlappedDataSourceSequence(node, new SALT_TYPE[]{SALT_TYPE.STEXT_OVERLAPPING_RELATION}).get(0);
            NodeStructureData structureData = new NodeStructureData(parent);
            structureData.setChildHeight(0);
            structureData.setTokenArity(1L);
            structureData.setLeftCorner(seq.getStart().longValue());
            structureData.setRightCorner(seq.getStart().longValue());
            this.dataMap.put(node, structureData);
            return structureData;
        }
        int maxH = 0;
        long leftCorner = Integer.MAX_VALUE;
        long rightCorner = 0L;
        boolean hasTokenChildren = false;
        long leftmostImmediate = Integer.MAX_VALUE;
        long rightmostImmediate = 0L;
        int tokenArity = 0;
        int arity = 0;
        NodeStructureData structureData = new NodeStructureData(parent);
        for (SNode n : this.graph.getSuccessors((Object)node)) {
            NodeStructureData childData = this.fillHeightMap(n, height + 1, structureData);
            maxH = Math.max(childData.getHeight(), maxH);
            leftCorner = Math.min(childData.getLeftCorner(), leftCorner);
            rightCorner = Math.max(childData.getRightCorner(), rightCorner);
            tokenArity = (int)((long)tokenArity + childData.getTokenArity());
            ++arity;
            if (!AnnisGraphTools.isTerminal((SNode)n, (VisualizerInput)this.input)) continue;
            hasTokenChildren = true;
            leftmostImmediate = Math.min(leftmostImmediate, childData.getLeftCorner());
            rightmostImmediate = Math.max(rightmostImmediate, childData.getLeftCorner());
        }
        structureData.setStep(1);
        structureData.setArity((long)arity);
        structureData.setTokenArity((long)tokenArity);
        structureData.setChildHeight(maxH);
        structureData.setLeftCorner(leftCorner);
        structureData.setRightCorner(rightCorner);
        structureData.setContinuous((long)tokenArity == rightCorner - leftCorner + 1L);
        if (hasTokenChildren) {
            structureData.setLeftmostImmediate(leftmostImmediate);
            structureData.setRightmostImmediate(rightmostImmediate);
        }
        this.dataMap.put(node, structureData);
        return structureData;
    }

    private Pair<RectangleSide> findBestConnection(Rectangle2D sourceRect, Rectangle2D targetRect) {
        Pair result = new Pair((Object)RectangleSide.BOTTOM, (Object)RectangleSide.TOP);
        double minDist = 3.4028234663852886E38;
        for (RectangleSide orig : RectangleSide.values()) {
            for (RectangleSide target : RectangleSide.values()) {
                Point2D o = this.sideMidPoint(sourceRect, orig);
                Point2D t = this.sideMidPoint(targetRect, target);
                double dist = Math.hypot(o.getX() - t.getX(), o.getY() - t.getY());
                if (!(dist < minDist)) continue;
                result = new Pair((Object)orig, (Object)target);
                minDist = dist;
            }
        }
        return result;
    }

    private int findFirstContinuous(List<NodeStructureData> levelNodes) {
        for (int d = 0; d < levelNodes.size(); ++d) {
            if (!levelNodes.get(d).isContinuous()) continue;
            return d;
        }
        return levelNodes.size();
    }

    private SNode findRoot() {
        for (SNode n : this.graph.getVertices()) {
            if (!this.graph.getInEdges((Object)n).isEmpty()) continue;
            return n;
        }
        throw new RuntimeException("Cannot find a root for the graph.");
    }

    private List<SRelation> getOutgoingEdges(SNode current) {
        ArrayList<SRelation> outEdges = new ArrayList<SRelation>();
        for (SRelation e : this.graph.getOutEdges((Object)current)) {
            if (!this.GRAPH_TOOLS.hasEdgeSubtype(e, this.GRAPH_TOOLS.getPrimEdgeSubType())) continue;
            outEdges.add(e);
        }
        Collections.sort(outEdges, (o1, o2) -> {
            int h1 = ((NodeStructureData)this.dataMap.get(this.graph.getOpposite((Object)current, o1))).getHeight();
            int h2 = ((NodeStructureData)this.dataMap.get(this.graph.getOpposite((Object)current, o2))).getHeight();
            return h1 - h2;
        });
        return outEdges;
    }

    private List<SNode> getTokens(LayoutOptions options) {
        ArrayList<SNode> tokens = new ArrayList<SNode>();
        for (SNode n : this.graph.getVertices()) {
            if (!AnnisGraphTools.isTerminal((SNode)n, (VisualizerInput)this.input)) continue;
            tokens.add(n);
        }
        Collections.sort(tokens, options.getHorizontalOrientation().getComparator());
        return tokens;
    }

    private CubicCurve2D secedgeCurve(VerticalOrientation verticalOrientation, Rectangle2D sourceRect, Rectangle2D targetRect) {
        Pair sidePair = this.findBestConnection(sourceRect, targetRect);
        Point2D startPoint = this.sideMidPoint(sourceRect, (RectangleSide)sidePair.getFirst());
        Point2D endPoint = this.sideMidPoint(targetRect, (RectangleSide)sidePair.getSecond());
        double middleX = (startPoint.getX() + endPoint.getX()) / 2.0;
        double middleY = (double)(50 * -verticalOrientation.value) + (startPoint.getY() + endPoint.getY()) / 2.0;
        return new CubicCurve2D.Double(startPoint.getX(), startPoint.getY(), middleX, middleY, middleX, middleY, endPoint.getX(), endPoint.getY());
    }

    private Point2D sideMidPoint(Rectangle2D rect, RectangleSide side) {
        switch (1.$SwitchMap$org$corpus_tools$annis$gui$visualizers$component$tree$RectangleSide[side.ordinal()]) {
            case 1: {
                return new Point2D.Double(rect.getCenterX(), rect.getMinY());
            }
            case 2: {
                return new Point2D.Double(rect.getCenterX(), rect.getMaxY());
            }
            case 3: {
                return new Point2D.Double(rect.getMinX(), rect.getCenterY());
            }
            case 4: {
                return new Point2D.Double(rect.getMaxX(), rect.getCenterY());
            }
        }
        throw new RuntimeException();
    }

    static /* synthetic */ TreeElementStyler access$000(ConstituentLayouter x0) {
        return x0.styler;
    }

    static /* synthetic */ VisualizerInput access$100(ConstituentLayouter x0) {
        return x0.input;
    }

    static /* synthetic */ Map access$200(ConstituentLayouter x0) {
        return x0.dataMap;
    }
}

