/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.visualizers.component.tree;

class NodeStructureData {
    private int height;
    private final NodeStructureData parent;
    private boolean isContinuous;
    private long leftCorner;
    private long rightCorner;
    private long leftmostImmediate = -1L;
    private long rightmostImmediate = -1L;
    private long arity = 0L;
    private long tokenArity;
    private int step = 0;

    public NodeStructureData(NodeStructureData parent_) {
        this.parent = parent_;
    }

    public boolean canHaveVerticalOverlap() {
        if (this.arity == 0L) {
            return this.getHeight() + 1 < this.parent.getHeight();
        }
        return this.isContinuous;
    }

    public boolean encloses(NodeStructureData other) {
        return this.leftCorner < other.leftCorner && this.rightCorner > other.rightCorner;
    }

    public long getArity() {
        return this.arity;
    }

    public int getHeight() {
        return this.height + this.step;
    }

    public long getLeftCorner() {
        return this.leftCorner;
    }

    public long getLeftmostImmediate() {
        return this.leftmostImmediate;
    }

    public NodeStructureData getParent() {
        return this.parent;
    }

    public long getRightCorner() {
        return this.rightCorner;
    }

    public long getRightmostImmediate() {
        return this.rightmostImmediate;
    }

    public long getTokenArity() {
        return this.tokenArity;
    }

    public boolean hasPredecessor(NodeStructureData node) {
        if (node == this.parent) {
            return true;
        }
        if (this.parent == null) {
            return false;
        }
        return this.parent.hasPredecessor(node);
    }

    public boolean hasVerticalEdgeConflict(NodeStructureData other) {
        return this.hasPredecessor(other.parent);
    }

    public void increaseStep() {
        ++this.step;
        this.parent.newChildHeight(this.getHeight());
    }

    public boolean isContinuous() {
        return this.isContinuous;
    }

    private void newChildHeight(int newHeight) {
        if (newHeight > this.height) {
            this.setChildHeight(newHeight);
            if (this.parent != null) {
                this.parent.newChildHeight(this.getHeight());
            }
        }
    }

    public void setArity(long arity) {
        this.arity = arity;
    }

    public void setChildHeight(int height) {
        this.height = height;
    }

    public void setContinuous(boolean isContinuous) {
        this.isContinuous = isContinuous;
    }

    public void setLeftCorner(long leftCorner) {
        this.leftCorner = leftCorner;
    }

    public void setLeftmostImmediate(long leftmostImmediate) {
        this.leftmostImmediate = leftmostImmediate;
    }

    public void setRightCorner(long rightCorner) {
        this.rightCorner = rightCorner;
    }

    public void setRightmostImmediate(long rightmostImmediate) {
        this.rightmostImmediate = rightmostImmediate;
    }

    public void setStep(int newValue) {
        this.step = newValue;
    }

    public void setTokenArity(long tokenArity) {
        this.tokenArity = tokenArity;
    }
}

