/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.visualizers.component.tree;

import com.vaadin.ui.Notification;
import com.vaadin.ui.UI;
import edu.uci.ics.jung.graph.DirectedGraph;
import java.awt.FontFormatException;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import javax.imageio.ImageIO;
import org.corpus_tools.annis.gui.visualizers.VisualizerInput;
import org.corpus_tools.annis.gui.visualizers.component.AbstractImageVisualizer;
import org.corpus_tools.annis.gui.visualizers.component.tree.AnnisGraphTools;
import org.corpus_tools.annis.gui.visualizers.component.tree.ConstituentLayouter;
import org.corpus_tools.annis.gui.visualizers.component.tree.GraphicsBackend;
import org.corpus_tools.annis.gui.visualizers.component.tree.LayoutOptions;
import org.corpus_tools.annis.gui.visualizers.component.tree.TigerTreeVisualizer;
import org.corpus_tools.annis.gui.visualizers.component.tree.TreeElementLabeler;
import org.corpus_tools.annis.gui.visualizers.component.tree.TreeElementStyler;
import org.corpus_tools.annis.gui.visualizers.component.tree.VerticalOrientation;
import org.corpus_tools.annis.gui.visualizers.component.tree.backends.staticimg.AbstractImageGraphicsItem;
import org.corpus_tools.annis.gui.visualizers.component.tree.backends.staticimg.Java2dBackend;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.springframework.stereotype.Component;

@Component
public class TigerTreeVisualizer
extends AbstractImageVisualizer {
    private static final long serialVersionUID = -6254684499926926147L;
    private static final int SIDE_MARGIN = 20;
    private static final int TOP_MARGIN = 40;
    private static final int TREE_DISTANCE = 40;
    public static final String TERMINAL_NAME_KEY = "terminal_name";
    public static final String TERMINAL_NS_KEY = "terminal_ns";
    private transient Java2dBackend backend;
    private final DefaultLabeler labeler = new DefaultLabeler(null);
    private transient DefaultStyler styler;
    private AnnisGraphTools graphtools;

    public TigerTreeVisualizer() throws FontFormatException, IOException {
        this.initTransients();
    }

    private Graphics2D createCanvas(BufferedImage image) {
        Graphics2D canvas = (Graphics2D)image.getGraphics();
        canvas.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        canvas.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        canvas.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        canvas.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        return canvas;
    }

    private Java2dBackend getBackend() {
        if (this.backend == null) {
            this.backend = new Java2dBackend();
        }
        return this.backend;
    }

    public String getContentType() {
        return "image/png";
    }

    public String getShortName() {
        return "tree";
    }

    private void initTransients() throws FontFormatException, IOException {
        this.styler = new DefaultStyler(this, this.getBackend());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, FontFormatException {
        in.defaultReadObject();
        this.initTransients();
    }

    private void renderTree(AbstractImageGraphicsItem item, Graphics2D canvas) {
        ArrayList allItems = new ArrayList();
        item.getAllChildren(allItems);
        Collections.sort(allItems, (o1, o2) -> o1.getZValue() - o2.getZValue());
        for (AbstractImageGraphicsItem c : allItems) {
            c.draw(canvas);
        }
    }

    public void writeOutput(VisualizerInput input, OutputStream outstream) {
        BufferedImage image;
        this.graphtools = new AnnisGraphTools(input);
        LinkedList<AbstractImageGraphicsItem> layouts = new LinkedList<AbstractImageGraphicsItem>();
        double width = 0.0;
        double maxheight = 0.0;
        for (DirectedGraph g : this.graphtools.getSyntaxGraphs()) {
            if (g.getEdgeCount() <= 0 || g.getVertexCount() <= 0) continue;
            ConstituentLayouter cl = new ConstituentLayouter(g, (GraphicsBackend)this.getBackend(), (TreeElementLabeler)this.labeler, (TreeElementStyler)this.styler, input, this.graphtools);
            AbstractImageGraphicsItem item = (AbstractImageGraphicsItem)cl.createLayout(new LayoutOptions(VerticalOrientation.TOP_ROOT, AnnisGraphTools.detectLayoutDirection((SDocumentGraph)input.getDocument().getDocumentGraph(), (UI)input.getUI())));
            Rectangle2D treeSize = item.getBounds();
            maxheight = Math.max(maxheight, treeSize.getHeight());
            width += treeSize.getWidth();
            layouts.add(item);
        }
        if (width == 0.0 || maxheight == 0.0) {
            input.getUI().access(() -> Notification.show((String)"Can't generate tree visualization.", (Notification.Type)Notification.Type.WARNING_MESSAGE));
            image = new BufferedImage(1, 1, 2);
        } else {
            image = new BufferedImage((int)(width + (double)((layouts.size() - 1) * 40) + 40.0), (int)(maxheight + 80.0), 2);
            Graphics2D canvas = this.createCanvas(image);
            double xOffset = 20.0;
            for (AbstractImageGraphicsItem item : layouts) {
                AffineTransform t = canvas.getTransform();
                Rectangle2D bounds = item.getBounds();
                canvas.translate(xOffset, 40.0 + maxheight - bounds.getHeight());
                this.renderTree(item, canvas);
                xOffset += bounds.getWidth() + 40.0;
                canvas.setTransform(t);
            }
        }
        try {
            ImageIO.write((RenderedImage)image, "png", outstream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static /* synthetic */ AnnisGraphTools access$000(TigerTreeVisualizer x0) {
        return x0.graphtools;
    }
}

