/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.visualizers.component.tree.backends.staticimg;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.GlyphMetrics;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.corpus_tools.annis.gui.visualizers.component.tree.GraphicsBackend;
import org.corpus_tools.annis.gui.visualizers.component.tree.Shape;
import org.corpus_tools.annis.gui.visualizers.component.tree.backends.staticimg.AbstractImageGraphicsItem;
import org.corpus_tools.annis.gui.visualizers.component.tree.backends.staticimg.Java2dBackend;

public class LabelItem
extends AbstractImageGraphicsItem {
    private final Font awtFont;
    private final String label;
    private final Point2D pos;
    private final Color color;
    private final Rectangle2D rect;
    private Shape shape;

    public LabelItem(String label_, Point2D pos_, Java2dBackend.Java2dFont font, Color color_, GraphicsBackend.Alignment alignment, Shape shape_) {
        this.color = color_;
        this.label = label_;
        this.awtFont = font.getAwtFont();
        GlyphMetrics gm = this.awtFont.createGlyphVector(Java2dBackend.FRC, this.label.substring(0, 1)).getGlyphMetrics(0);
        Rectangle2D size = font.extents(this.label);
        double text_x = pos_.getX() - size.getWidth() * alignment.getXAlign();
        double text_y = pos_.getY() + shape_.getInternalYOffset(label_, (GraphicsBackend.Font)font, alignment);
        double rect_y = pos_.getY() + size.getHeight() * alignment.getYAlign() - (font.getAscent() + shape_.getYPadding());
        this.rect = new Rectangle2D.Double(text_x + (double)gm.getLSB() - shape_.getXPadding(), rect_y, size.getWidth() + 2.0 * shape_.getXPadding(), font.getLineHeight() + 2.0 * shape_.getYPadding());
        this.pos = new Point2D.Double(text_x - this.rect.getX(), text_y - this.rect.getY());
        this.shape = shape_;
    }

    public void draw(Graphics2D canvas) {
        if (this.shape instanceof Shape.Ellipse) {
            canvas.setStroke(this.shape.getPenStyle());
            canvas.setColor(this.shape.getFillColor());
            canvas.fillOval((int)this.rect.getX(), (int)this.rect.getY(), (int)this.rect.getWidth(), (int)this.rect.getHeight());
            canvas.setColor(this.shape.getStrokeColor());
            canvas.drawOval((int)this.rect.getX(), (int)this.rect.getY(), (int)this.rect.getWidth(), (int)this.rect.getHeight());
        } else if (this.shape instanceof Shape.Rectangle) {
            canvas.setStroke(this.shape.getPenStyle());
            canvas.setColor(this.shape.getFillColor());
            canvas.fillRect((int)this.rect.getX(), (int)this.rect.getY(), (int)this.rect.getWidth(), (int)this.rect.getHeight());
            canvas.setColor(this.shape.getStrokeColor());
            canvas.drawRect((int)this.rect.getX(), (int)this.rect.getY(), (int)this.rect.getWidth(), (int)this.rect.getHeight());
        }
        canvas.setFont(this.awtFont);
        canvas.setColor(this.color);
        canvas.drawString(this.label, (float)(this.pos.getX() + this.rect.getX()), (float)(this.pos.getY() + this.rect.getY()));
    }

    public Rectangle2D getBounds() {
        return this.rect;
    }
}

