/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.visualizers.component.visjs;

import com.google.common.base.Charsets;
import com.vaadin.annotations.JavaScript;
import com.vaadin.annotations.StyleSheet;
import com.vaadin.ui.AbstractJavaScriptComponent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.corpus_tools.annis.gui.MatchedNodeColors;
import org.corpus_tools.annis.gui.visualizers.VisualizerInput;
import org.corpus_tools.annis.gui.visualizers.component.grid.EventExtractor;
import org.corpus_tools.annis.gui.visualizers.component.visjs.VisJsComponent;
import org.corpus_tools.annis.gui.visualizers.component.visjs.VisJsState;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SDominanceRelation;
import org.corpus_tools.salt.common.SPointingRelation;
import org.corpus_tools.salt.common.SSpanningRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SFeature;
import org.corpus_tools.salt.core.SLayer;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.util.ExportFilter;
import org.corpus_tools.salt.util.StyleImporter;
import org.corpus_tools.salt.util.VisJsVisualizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@JavaScript(value={"VisJs_Connector.js", "vaadin://jquery.js", "vis.min.js"})
@StyleSheet(value={"vaadin://themes/annis-visualizer-theme/visjs/vis.min.css"})
public class VisJsComponent
extends AbstractJavaScriptComponent
implements ExportFilter,
StyleImporter {
    private static final long serialVersionUID = -9006240832319119407L;
    private static final Logger log = LoggerFactory.getLogger(VisJsComponent.class);
    private String strNodes;
    private String strEdges;
    private Map<String, Set<String>> displayedNodeAnnotations = new HashMap();
    private Map<String, Set<String>> displayedPointingRelAnnotations = new HashMap();
    private Map<String, Set<String>> displayedSpanningRelAnnotations = new HashMap();
    private Map<String, Set<String>> displayedDominanceRelAnnotations = new HashMap();
    private final List<String> configurations = new ArrayList();

    private static List<String> computeDisplayedRelAnnotations(VisualizerInput input, String relAnnosConfiguration, Class<? extends SRelation> type) {
        if (input == null) {
            return new LinkedList<String>();
        }
        SDocumentGraph graph = input.getDocument().getDocumentGraph();
        Set annotationPool = VisJsComponent.getRelationLevelSet((SDocumentGraph)graph, null, type);
        LinkedList<String> confAnnotations = new LinkedList<String>(annotationPool);
        if (relAnnosConfiguration != null && relAnnosConfiguration.trim().length() > 0) {
            String[] confSplit = relAnnosConfiguration.split(",");
            confAnnotations.clear();
            for (String entry : confSplit) {
                if ((entry = entry.trim()).startsWith("/") && entry.endsWith("/")) {
                    Pattern regex = Pattern.compile(StringUtils.strip((String)entry, (String)"/"));
                    LinkedList<String> matchingAnnotations = new LinkedList<String>();
                    for (String anno : annotationPool) {
                        if (!regex.matcher(anno).matches()) continue;
                        matchingAnnotations.add(anno);
                    }
                    confAnnotations.addAll(matchingAnnotations);
                    annotationPool.removeAll(matchingAnnotations);
                    continue;
                }
                confAnnotations.add(entry);
                annotationPool.remove(entry);
            }
        }
        return confAnnotations;
    }

    private static Set<String> getRelationLevelSet(SDocumentGraph graph, String namespace, Class<? extends SRelation> type) {
        TreeSet<String> result = new TreeSet<String>();
        if (graph != null) {
            List edges = null;
            if (type == SDominanceRelation.class) {
                edges = graph.getDominanceRelations();
            } else if (type == SPointingRelation.class) {
                edges = graph.getPointingRelations();
            } else if (type == SSpanningRelation.class) {
                edges = graph.getSpanningRelations();
            }
            if (edges != null) {
                block0: for (SRelation edge : edges) {
                    Set layers = edge.getLayers();
                    for (SLayer layer : layers) {
                        if (namespace != null && !namespace.equals(layer.getName())) continue;
                        for (SAnnotation anno : edge.getAnnotations()) {
                            result.add(anno.getQName());
                        }
                        continue block0;
                    }
                }
            }
        }
        return result;
    }

    private static boolean includeObject(Set<SAnnotation> objectAnnotations, Map<String, Set<String>> displayedAnnotationsMap) {
        for (SAnnotation objectAnnotation : objectAnnotations) {
            String annotation = objectAnnotation.getName();
            String namespace = objectAnnotation.getNamespace();
            if (!displayedAnnotationsMap.containsKey(annotation)) continue;
            if (displayedAnnotationsMap.get(annotation).isEmpty()) {
                return true;
            }
            if (!displayedAnnotationsMap.get(annotation).contains(namespace)) continue;
            return true;
        }
        return false;
    }

    public VisJsComponent(VisualizerInput visInput) {
        for (Annos_Keyword kw : Annos_Keyword.values()) {
            this.configurations.add(visInput.getMappings().get(kw.getValue()));
            this.fillFilterAnnotations(visInput, kw.ordinal());
        }
        SDocument doc = visInput.getDocument();
        try (ByteArrayOutputStream osNodes = new ByteArrayOutputStream();
             ByteArrayOutputStream osEdges = new ByteArrayOutputStream();){
            VisJsVisualizer visualizer = new VisJsVisualizer(doc, (ExportFilter)this, (StyleImporter)this);
            visualizer.setNodeWriter((OutputStream)osNodes);
            visualizer.setEdgeWriter((OutputStream)osEdges);
            visualizer.buildJSON();
            this.strNodes = osNodes.toString(Charsets.UTF_8.name());
            this.strEdges = osEdges.toString(Charsets.UTF_8.name());
            osNodes.close();
            osEdges.close();
        }
        catch (IOException e) {
            log.error("Could not write the VisJS output", (Throwable)e);
        }
    }

    public void attach() {
        super.attach();
        this.setHeight("100%");
        this.setWidth("100%");
        this.getState().strNodes = this.strNodes;
        this.getState().strEdges = this.strEdges;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void fillFilterAnnotations(VisualizerInput visInput, int type) {
        List displayedAnnotations = null;
        Map displayedAnnotationsMap = null;
        switch (type) {
            case 0: {
                displayedAnnotations = EventExtractor.computeDisplayAnnotations((VisualizerInput)visInput, SNode.class);
                displayedAnnotationsMap = this.displayedNodeAnnotations;
                break;
            }
            case 1: {
                displayedAnnotations = VisJsComponent.computeDisplayedRelAnnotations((VisualizerInput)visInput, (String)((String)this.configurations.get(type)), SPointingRelation.class);
                displayedAnnotationsMap = this.displayedPointingRelAnnotations;
                break;
            }
            case 2: {
                displayedAnnotations = VisJsComponent.computeDisplayedRelAnnotations((VisualizerInput)visInput, (String)((String)this.configurations.get(type)), SSpanningRelation.class);
                displayedAnnotationsMap = this.displayedSpanningRelAnnotations;
                break;
            }
            case 3: {
                displayedAnnotations = VisJsComponent.computeDisplayedRelAnnotations((VisualizerInput)visInput, (String)((String)this.configurations.get(type)), SDominanceRelation.class);
                displayedAnnotationsMap = this.displayedDominanceRelAnnotations;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        for (String annotation : displayedAnnotations) {
            void var9_9;
            String anno = null;
            String ns = null;
            Object var9_10 = null;
            if (annotation.contains("::")) {
                String[] annotationParts = annotation.split("::");
                if (annotationParts.length != 2) throw new IllegalArgumentException("The annotation string in resolver_vis_map table is not well formed.");
                anno = annotationParts[1];
                ns = annotationParts[0];
            } else {
                anno = annotation;
            }
            if (displayedAnnotationsMap.containsKey(anno)) {
                Set set = (Set)displayedAnnotationsMap.get(anno);
            } else {
                HashSet hashSet = new HashSet();
            }
            if (ns != null) {
                var9_9.add(ns);
            }
            displayedAnnotationsMap.put(anno, var9_9);
        }
    }

    protected VisJsState getState() {
        return (VisJsState)super.getState();
    }

    public boolean includeNode(SNode node) {
        if (node instanceof SToken || this.configurations.get(0) == null) {
            return true;
        }
        Set nodeAnnotations = node.getAnnotations();
        return VisJsComponent.includeObject((Set)nodeAnnotations, (Map)this.displayedNodeAnnotations);
    }

    public boolean includeRelation(SRelation relation) {
        Map displayedRelAnnotations = new HashMap();
        if (relation instanceof SPointingRelation) {
            if (this.configurations.get(1) == null) {
                return true;
            }
            displayedRelAnnotations = this.displayedPointingRelAnnotations;
        }
        if (relation instanceof SSpanningRelation) {
            if (this.configurations.get(2) == null) {
                return true;
            }
            displayedRelAnnotations = this.displayedSpanningRelAnnotations;
        }
        if (relation instanceof SDominanceRelation) {
            if (this.configurations.get(3) == null) {
                return true;
            }
            displayedRelAnnotations = this.displayedDominanceRelAnnotations;
        }
        Set relAnnotations = relation.getAnnotations();
        return VisJsComponent.includeObject((Set)relAnnotations, displayedRelAnnotations);
    }

    public String setHighlightingColor(SNode node) {
        Long matchRaw;
        String color = null;
        SFeature featMatched = node.getFeature("annis", "matchednode");
        Long l = matchRaw = featMatched == null ? null : featMatched.getValue_SNUMERIC();
        if (matchRaw != null) {
            color = MatchedNodeColors.getHTMLColorByMatch((Long)matchRaw);
            return color;
        }
        return color;
    }
}

