/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.visualizers.htmlvis;

import java.util.List;
import org.apache.commons.lang3.Validate;
import org.corpus_tools.annis.gui.visualizers.htmlvis.AnnotationNameMatcher;
import org.corpus_tools.annis.gui.visualizers.htmlvis.SpanMatcher;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SNode;

public class AnnotationNameAndValueMatcher
implements SpanMatcher {
    private AnnotationNameMatcher nameMatcher;
    private String annotationValue;

    public AnnotationNameAndValueMatcher(String annotationNamespace, String annotationName, String annotationValue) {
        Validate.notNull((Object)annotationName, (String)"The annotation name parameter must never be null.", (Object[])new Object[0]);
        Validate.notNull((Object)annotationValue, (String)"The annotation value parameter must never be null.", (Object[])new Object[0]);
        this.nameMatcher = new AnnotationNameMatcher(annotationNamespace, annotationName);
        this.annotationValue = annotationValue;
    }

    public String getAnnotationValue() {
        return this.annotationValue;
    }

    public AnnotationNameMatcher getNameMatcher() {
        return this.nameMatcher;
    }

    public List<String> getRequiredAnnotationNames() {
        return this.nameMatcher.getRequiredAnnotationNames();
    }

    public String matchedAnnotation(SNode node) {
        SAnnotation anno;
        String match;
        if ((node instanceof SSpan || node instanceof SToken) && (match = this.nameMatcher.matchedAnnotation(node)) != null && (anno = node.getAnnotation(match)) != null && this.annotationValue.equals(anno.getValue_STEXT())) {
            return match;
        }
        return null;
    }

    public void setAnnotationValue(String annotationValue) {
        this.annotationValue = annotationValue;
    }

    public void setNameMatcher(AnnotationNameMatcher nameMatcher) {
        this.nameMatcher = nameMatcher;
    }
}

