/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.visualizers.htmlvis;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.corpus_tools.annis.gui.visualizers.htmlvis.SpanMatcher;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SNode;

public class AnnotationNameMatcher
implements SpanMatcher {
    private String annotationName;

    public AnnotationNameMatcher(String annotationNamespace, String annotationName) {
        Validate.notNull((Object)annotationName, (String)"The annotation name parameter must never be null.", (Object[])new Object[0]);
        this.annotationName = annotationNamespace == null || annotationNamespace.isEmpty() ? annotationName : annotationNamespace + "::" + annotationName;
    }

    public String getAnnotationName() {
        return this.annotationName;
    }

    public List<String> getRequiredAnnotationNames() {
        return Arrays.asList(this.annotationName);
    }

    public String matchedAnnotation(SNode node) {
        if (node instanceof SSpan || node instanceof SToken) {
            for (SAnnotation anno : node.getAnnotations()) {
                if (!this.annotationName.equals(anno.getName()) && !this.annotationName.equals(anno.getQName())) continue;
                return anno.getQName();
            }
        }
        return null;
    }
}

