/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.visualizers.htmlvis;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.google.common.base.Joiner;
import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import com.vaadin.ui.Notification;
import com.vaadin.ui.Panel;
import com.vaadin.ui.TextArea;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.v7.shared.ui.label.ContentMode;
import com.vaadin.v7.ui.Label;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.corpus_tools.annis.ApiException;
import org.corpus_tools.annis.api.CorporaApi;
import org.corpus_tools.annis.gui.AnnisBaseUI;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.annis.gui.MatchedNodeColors;
import org.corpus_tools.annis.gui.VisualizationToggle;
import org.corpus_tools.annis.gui.visualizers.AbstractVisualizer;
import org.corpus_tools.annis.gui.visualizers.VisualizerInput;
import org.corpus_tools.annis.gui.visualizers.htmlvis.AnnotationNameAndValueMatcher;
import org.corpus_tools.annis.gui.visualizers.htmlvis.AnnotationNameMatcher;
import org.corpus_tools.annis.gui.visualizers.htmlvis.HTMLVis;
import org.corpus_tools.annis.gui.visualizers.htmlvis.OutputItem;
import org.corpus_tools.annis.gui.visualizers.htmlvis.PseudoRegionMatcher;
import org.corpus_tools.annis.gui.visualizers.htmlvis.SpanHTMLOutputter;
import org.corpus_tools.annis.gui.visualizers.htmlvis.TokenMatcher;
import org.corpus_tools.annis.gui.visualizers.htmlvis.VisParser;
import org.corpus_tools.annis.gui.visualizers.htmlvis.VisParserException;
import org.corpus_tools.annis.gui.visualizers.htmlvis.VisualizationDefinition;
import org.corpus_tools.annis.gui.visualizers.htmlvis.WebFont;
import org.corpus_tools.annis.gui.visualizers.htmlvis.WebFontList;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.SStructuredNode;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.SMetaAnnotation;
import org.corpus_tools.salt.core.SNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HTMLVis
extends AbstractVisualizer {
    private static final long serialVersionUID = 4917299874730026082L;
    private static final Logger log = LoggerFactory.getLogger(HTMLVis.class);
    private static final Escaper urlPathEscape = UrlEscapers.urlPathSegmentEscaper();
    private Map<SNode, Long> mc;
    private String tokenColor = "";
    private boolean hitMark = true;

    public Panel createComponent(VisualizerInput vi, VisualizationToggle vt) {
        Panel scrollPanel = new Panel();
        scrollPanel.setSizeFull();
        Label lblResult = new Label("ERROR", ContentMode.HTML);
        lblResult.setSizeUndefined();
        List corpusPath = Helper.getCorpusPath((SCorpusGraph)vi.getDocument().getGraph(), (SDocument)vi.getDocument());
        String corpusName = (String)corpusPath.get(corpusPath.size() - 1);
        corpusName = urlPathEscape.escape(corpusName);
        String wrapperClassName = "annis-wrapped-htmlvis-" + corpusName.replaceAll("[^0-9A-Za-z-]", "_");
        scrollPanel.addStyleName(wrapperClassName);
        String visConfigName = (String)vi.getMappings().get("config");
        String hitMarkConfig = vi.getMappings().getOrDefault("hitmark", "true");
        this.hitMark = Boolean.parseBoolean(hitMarkConfig);
        this.mc = vi.getMarkedAndCovered();
        VisualizationDefinition[] definitions = this.parseDefinitions(corpusName, vi.getMappings(), (UI)vi.getUI());
        if (definitions != null) {
            lblResult.setValue(this.createHTML(vi.getSResult().getDocumentGraph(), definitions, (UI)vi.getUI()));
            String labelClass = vi.getMappings().getOrDefault("class", "htmlvis");
            lblResult.addStyleName(labelClass);
            this.injectWebFonts(visConfigName, corpusName, (UI)vi.getUI());
            this.injectCSS(visConfigName, corpusName, wrapperClassName, (UI)vi.getUI());
        }
        if (vi.getMappings().containsKey("debug")) {
            TextArea txtDebug = new TextArea();
            txtDebug.setValue(lblResult.getValue());
            txtDebug.setReadOnly(true);
            txtDebug.setWidth("100%");
            Label sep = new Label("<hr/>", ContentMode.HTML);
            VerticalLayout layout = new VerticalLayout(new com.vaadin.ui.Component[]{txtDebug, sep, lblResult});
            layout.setSizeUndefined();
            scrollPanel.setContent((com.vaadin.ui.Component)layout);
        } else {
            scrollPanel.setContent((com.vaadin.ui.Component)lblResult);
        }
        return scrollPanel;
    }

    public String createHTML(SDocumentGraph graph, VisualizationDefinition[] definitions, UI ui) {
        HashMap<VisualizationDefinition, Integer> instruction_priorities = new HashMap<VisualizationDefinition, Integer>();
        TreeMap outputStartTags = new TreeMap();
        TreeMap outputEndTags = new TreeMap();
        StringBuilder sb = new StringBuilder();
        List token = graph.getSortedTokenByText();
        HashMap<VisualizationDefinition[], Long> token2index = new HashMap<VisualizationDefinition[], Long>();
        long i = 0L;
        for (VisualizationDefinition[] t : token) {
            token2index.put(t, i++);
        }
        Boolean bolMetaTypeFound = false;
        HashMap<String, String> meta = new HashMap<String, String>();
        int def_priority = 0;
        for (VisualizationDefinition vis : definitions) {
            if (vis.getOutputter().getType() == SpanHTMLOutputter.Type.META_NAME) {
                bolMetaTypeFound = true;
            } else {
                if (vis.getMatcher() instanceof AnnotationNameMatcher) {
                    instruction_priorities.put(vis, def_priority);
                } else if (vis.getMatcher() instanceof AnnotationNameAndValueMatcher) {
                    instruction_priorities.put(vis, def_priority);
                } else if (vis.getMatcher() instanceof TokenMatcher) {
                    instruction_priorities.put(vis, def_priority);
                }
                --def_priority;
            }
            vis.getOutputter().setMeta(meta);
        }
        if (bolMetaTypeFound.booleanValue()) {
            Object strDocName = "";
            String strCorpName = "";
            strDocName = graph.getDocument().getName();
            List corpusPath = Helper.getCorpusPath((SCorpusGraph)graph.getDocument().getGraph(), (SDocument)graph.getDocument());
            strCorpName = (String)corpusPath.get(corpusPath.size() - 1);
            List metaData = Helper.getMetaDataDoc((String)strCorpName, (String)strDocName, (UI)ui);
            for (SMetaAnnotation metaDatum : metaData) {
                meta.put(metaDatum.getName(), metaDatum.getValue_STEXT());
            }
        }
        for (SToken t : token) {
            this.tokenColor = "";
            if (this.mc.containsKey(t) && this.hitMark) {
                this.tokenColor = MatchedNodeColors.getHTMLColorByMatch((Long)((Long)this.mc.get(t)));
            }
            for (VisualizationDefinition vis : definitions) {
                String matched = vis.getMatcher().matchedAnnotation((SNode)t);
                if (matched == null) continue;
                vis.getOutputter().outputHTML((SStructuredNode)t, matched, outputStartTags, outputEndTags, this.tokenColor, instruction_priorities.getOrDefault(vis, 0).intValue(), token2index);
            }
        }
        List spans = graph.getSpans();
        if (spans != null && !spans.isEmpty()) {
            for (VisualizationDefinition vis : definitions) {
                for (SSpan span : spans) {
                    String matched;
                    this.tokenColor = "";
                    if (this.mc.containsKey(span) && this.hitMark) {
                        this.tokenColor = MatchedNodeColors.getHTMLColorByMatch((Long)((Long)this.mc.get(span)));
                    }
                    if ((matched = vis.getMatcher().matchedAnnotation((SNode)span)) == null) continue;
                    vis.getOutputter().outputHTML((SStructuredNode)span, matched, outputStartTags, outputEndTags, this.tokenColor, instruction_priorities.getOrDefault(vis, 0).intValue(), token2index);
                }
            }
        }
        int minStartTagPos = ((Long)outputStartTags.firstKey()).intValue();
        int maxEndTagPos = ((Long)outputEndTags.lastKey()).intValue();
        for (VisualizationDefinition vis : definitions) {
            if (vis.getMatcher() instanceof PseudoRegionMatcher) {
                PseudoRegionMatcher.PseudoRegion psdRegionType = ((PseudoRegionMatcher)vis.getMatcher()).getPsdRegion();
                int positionStart = 0;
                int positionEnd = 0;
                if (!outputEndTags.isEmpty() && !outputStartTags.isEmpty() && psdRegionType != null) {
                    switch (1.$SwitchMap$org$corpus_tools$annis$gui$visualizers$htmlvis$PseudoRegionMatcher$PseudoRegion[psdRegionType.ordinal()]) {
                        case 1: {
                            positionEnd = Integer.MIN_VALUE;
                            positionStart = Integer.MIN_VALUE;
                            instruction_priorities.put(vis, def_priority);
                            break;
                        }
                        case 2: {
                            positionEnd = Integer.MAX_VALUE;
                            positionStart = Integer.MAX_VALUE;
                            instruction_priorities.put(vis, def_priority);
                            break;
                        }
                        case 3: {
                            positionStart = minStartTagPos;
                            positionEnd = maxEndTagPos;
                            instruction_priorities.put(vis, def_priority);
                            break;
                        }
                    }
                }
                switch (1.$SwitchMap$org$corpus_tools$annis$gui$visualizers$htmlvis$SpanHTMLOutputter$Type[vis.getOutputter().getType().ordinal()]) {
                    case 1: {
                        String strMetaVal = (String)meta.get(vis.getOutputter().getMetaname().trim());
                        if (strMetaVal == null) {
                            throw new NullPointerException("no such metadata name in document: '" + vis.getOutputter().getMetaname().trim() + "'");
                        }
                        vis.getOutputter().outputAny((long)positionStart, (long)positionEnd, ((PseudoRegionMatcher)vis.getMatcher()).getAnnotationName(), strMetaVal, outputStartTags, outputEndTags, instruction_priorities.getOrDefault(vis, 0).intValue());
                        break;
                    }
                    case 2: {
                        vis.getOutputter().outputAny((long)positionStart, (long)positionEnd, ((PseudoRegionMatcher)vis.getMatcher()).getAnnotationName(), vis.getOutputter().getConstant(), outputStartTags, outputEndTags, instruction_priorities.getOrDefault(vis, 0).intValue());
                        break;
                    }
                    case 3: {
                        vis.getOutputter().outputAny((long)positionStart, (long)positionEnd, ((PseudoRegionMatcher)vis.getMatcher()).getAnnotationName(), "", outputStartTags, outputEndTags, instruction_priorities.getOrDefault(vis, 0).intValue());
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 6: {
                        break;
                    }
                }
            }
            TreeSet indexes = new TreeSet();
            indexes.addAll(outputStartTags.keySet());
            indexes.addAll(outputEndTags.keySet());
            for (Long i2 : indexes) {
                List unsortedStart = (List)outputStartTags.get(i2);
                TreeSet<OutputItem> itemsStart = new TreeSet<OutputItem>();
                if (unsortedStart != null) {
                    for (OutputItem s : unsortedStart) {
                        itemsStart.add(s);
                    }
                }
                Iterator it = itemsStart.iterator();
                boolean first = true;
                while (it.hasNext()) {
                    OutputItem s = (OutputItem)it.next();
                    if (!first) {
                        sb.append("-->");
                    }
                    first = false;
                    sb.append(s.getOutputString());
                    if (!it.hasNext()) continue;
                    sb.append("<!--\n");
                }
                List unsortedEnd = (List)outputEndTags.get(i2);
                TreeSet<OutputItem> itemsEnd = new TreeSet<OutputItem>();
                if (unsortedEnd != null) {
                    for (OutputItem s : unsortedEnd) {
                        itemsEnd.add(s);
                    }
                }
                LinkedList itemsEndReverse = new LinkedList(itemsEnd);
                Collections.reverse(itemsEndReverse);
                for (OutputItem s : itemsEndReverse) {
                    sb.append(s.getOutputString());
                }
            }
        }
        return sb.toString();
    }

    private JsonMapper createJsonMapper() {
        JsonMapper jsonMapper = new JsonMapper();
        jsonMapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        jsonMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return jsonMapper;
    }

    public List<String> getFilteredNodeAnnotationNames(String toplevelCorpusName, String documentName, Map<String, String> mappings, UI ui) {
        LinkedHashSet result = null;
        VisualizationDefinition[] definitions = this.parseDefinitions(toplevelCorpusName, mappings, ui);
        if (definitions != null) {
            for (VisualizationDefinition def : definitions) {
                List sub = def.getMatcher().getRequiredAnnotationNames();
                if (sub == null) {
                    result = null;
                    break;
                }
                if (result == null) {
                    result = new LinkedHashSet();
                }
                result.addAll(sub);
            }
        }
        if (result == null) {
            return null;
        }
        return new LinkedList<String>(result);
    }

    public String getShortName() {
        return "html";
    }

    private void injectCSS(String visConfigName, String corpusName, String wrapperClassName, UI ui) {
        CorporaApi api = new CorporaApi(Helper.getClient((UI)ui));
        InputStream inStreamCSSRaw = null;
        if (visConfigName == null) {
            inStreamCSSRaw = HTMLVis.class.getResourceAsStream("htmlvis.css");
        } else {
            try {
                File f = api.getFile(corpusName, urlPathEscape.escape(corpusName) + "/" + visConfigName + ".css");
                f.deleteOnExit();
                inStreamCSSRaw = new FileInputStream(f);
            }
            catch (ApiException ex) {
                if (ex.getCode() != 404) {
                    log.error("Could not retrieve the HTML visualizer web-font configuration file", (Throwable)ex);
                    ui.access(() -> Notification.show((String)"Could not retrieve the HTML visualizer web-font configuration file", (String)ex.getMessage(), (Notification.Type)Notification.Type.ERROR_MESSAGE));
                }
            }
            catch (FileNotFoundException ex) {
                log.error("Just downloaded file not found", (Throwable)ex);
            }
        }
        if (inStreamCSSRaw != null) {
            try (InputStream inStreamCSS = inStreamCSSRaw;){
                String cssContent = IOUtils.toString((InputStream)inStreamCSS);
                if (ui instanceof AnnisBaseUI) {
                    ((AnnisBaseUI)ui).injectUniqueCSS(cssContent, wrapperClassName);
                }
            }
            catch (IOException ex) {
                log.error("Could not parse the HTML visualizer CSS file", (Throwable)ex);
                Notification.show((String)"Could not parse the HTML visualizer CSS file", (String)ex.getMessage(), (Notification.Type)Notification.Type.ERROR_MESSAGE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void injectWebFonts(String visConfigName, String corpusName, UI ui) {
        block23: {
            CorporaApi api = new CorporaApi(Helper.getClient((UI)ui));
            try {
                File f = api.getFile(corpusName, urlPathEscape.escape(corpusName) + "/" + visConfigName + ".fonts.json");
                f.deleteOnExit();
                try (FileInputStream inStreamJSON = new FileInputStream(f);){
                    JsonMapper mapper = this.createJsonMapper();
                    WebFontList fontConfigList = (WebFontList)mapper.readValue((InputStream)inStreamJSON, WebFontList.class);
                    for (WebFont fontConfig : fontConfigList.getWebFonts()) {
                        if (fontConfig == null || fontConfig.getName() == null) continue;
                        StringBuilder sb = new StringBuilder();
                        sb.append("@font-face {\n");
                        sb.append("  font-family: '" + fontConfig.getName() + "';\n");
                        sb.append("  font-weight: '" + fontConfig.getWeight() + "';\n");
                        sb.append("  font-style: '" + fontConfig.getStyle() + "';\n");
                        LinkedList<String> sourceDefs = new LinkedList<String>();
                        for (Map.Entry src : fontConfig.getSources().entrySet()) {
                            sourceDefs.add("url('" + (String)src.getValue() + "') format('" + (String)src.getKey() + "')");
                        }
                        if (!sourceDefs.isEmpty()) {
                            sb.append("  src: ");
                            sb.append(Joiner.on((String)",\n    ").join(sourceDefs));
                            sb.append(";\n");
                        }
                        sb.append("}\n");
                        if (!(ui instanceof AnnisBaseUI)) continue;
                        ((AnnisBaseUI)ui).injectUniqueCSS(sb.toString());
                    }
                }
                catch (IOException ex) {
                    log.error("Could not parse the HTML visualizer web-font configuration file", (Throwable)ex);
                    Notification.show((String)"Could not parse the HTML visualizer web-font configuration file", (String)ex.getMessage(), (Notification.Type)Notification.Type.ERROR_MESSAGE);
                }
                finally {
                    Files.deleteIfExists(f.toPath());
                }
            }
            catch (IOException ex) {
                log.error("Unexpected input/output exception", (Throwable)ex);
            }
            catch (ApiException ex) {
                if (ex.getCode() == 404) break block23;
                log.error("Could not retrieve the HTML visualizer web-font configuration file", (Throwable)ex);
                ui.access(() -> Notification.show((String)"Could not retrieve the HTML visualizer web-font configuration file", (String)ex.getMessage(), (Notification.Type)Notification.Type.ERROR_MESSAGE));
            }
        }
    }

    public boolean isUsingText() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public VisualizationDefinition[] parseDefinitions(String toplevelCorpusName, Map<String, String> mappings, UI ui) {
        InputStream inStreamConfigRaw = null;
        String visConfigName = mappings.get("config");
        if (visConfigName == null) {
            inStreamConfigRaw = HTMLVis.class.getResourceAsStream("defaultvis.config");
        } else {
            CorporaApi api = new CorporaApi(Helper.getClient((UI)ui));
            try {
                File file = api.getFile(toplevelCorpusName, urlPathEscape.escape(toplevelCorpusName) + "/" + visConfigName + ".config");
                inStreamConfigRaw = new FileInputStream(file);
            }
            catch (ApiException e) {
                if (e.getCode() != 404) {
                    log.error("Exception while getting the HTML visualizer configuration", (Throwable)e);
                }
            }
            catch (IOException e) {
                log.error("Exception while getting the HTML visualizer configuration", (Throwable)e);
            }
        }
        if (inStreamConfigRaw == null) {
            Notification.show((String)("ERROR: html visualization configuration \"" + visConfigName + "\" not found in database"), (Notification.Type)Notification.Type.ERROR_MESSAGE);
            return null;
        }
        try (InputStream inStreamConfig = inStreamConfigRaw;){
            VisParser p = new VisParser(inStreamConfig);
            VisualizationDefinition[] visualizationDefinitionArray = p.getDefinitions();
            return visualizationDefinitionArray;
        }
        catch (IOException | VisParserException ex) {
            log.error("Could not parse the HTML visualization configuration file", ex);
            Notification.show((String)"Could not parse the HTML visualization configuration file", (String)ex.getMessage(), (Notification.Type)Notification.Type.ERROR_MESSAGE);
        }
        return null;
    }
}

