/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.visualizers.htmlvis;

import com.google.common.escape.Escaper;
import com.google.common.html.HtmlEscapers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.annis.gui.visualizers.htmlvis.OutputItem;
import org.corpus_tools.annis.gui.visualizers.htmlvis.SpanHTMLOutputter;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.SStructuredNode;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SNode;

public class SpanHTMLOutputter {
    public static final String NULL_VAL = "NULL";
    private static final Escaper htmlEscaper = HtmlEscapers.htmlEscaper();
    private Type type = Type.EMPTY;
    private String element = "div";
    private String attribute;
    private String style = "";
    private String constant;
    private String metaname;
    private HashMap<String, String> hshMeta = new HashMap();
    private String tokenColor;

    public String getAttribute() {
        return this.attribute;
    }

    public String getConstant() {
        return this.constant;
    }

    public String getElement() {
        return this.element;
    }

    public HashMap<String, String> getMeta() {
        return this.hshMeta;
    }

    public String getMetaname() {
        return this.metaname;
    }

    public String getStyle() {
        return this.style;
    }

    public Type getType() {
        return this.type;
    }

    private void outputAnnotation(SStructuredNode span, String matchedQName, SortedMap<Long, List<OutputItem>> outputStartTags, SortedMap<Long, List<OutputItem>> outputEndTags, int priority, Map<SToken, Long> token2index) {
        if (span.getGraph() instanceof SDocumentGraph) {
            String value;
            SDocumentGraph graph = (SDocumentGraph)span.getGraph();
            List coveredTokens = graph.getOverlappedTokens((SNode)span);
            if (coveredTokens.isEmpty()) {
                return;
            }
            coveredTokens = graph.getSortedTokenByText(coveredTokens);
            long left = token2index.get(coveredTokens.get(0));
            long right = token2index.get(coveredTokens.get(coveredTokens.size() - 1));
            SAnnotation matchedAnnotation = this.type == Type.META_NAME ? span.getAnnotation("meta::" + this.constant) : span.getAnnotation(matchedQName);
            switch (1.$SwitchMap$org$corpus_tools$annis$gui$visualizers$htmlvis$SpanHTMLOutputter$Type[this.type.ordinal()]) {
                case 1: {
                    value = this.constant;
                    break;
                }
                case 2: {
                    String original = this.constant;
                    String innerValue = matchedAnnotation == null ? NULL_VAL : matchedAnnotation.getValue_STEXT();
                    String innerAnno = matchedAnnotation == null ? NULL_VAL : matchedAnnotation.getName();
                    value = original.replaceAll("%%value%%", innerValue);
                    value = value.replaceAll("%%anno%%", innerAnno);
                    break;
                }
                case 3: {
                    value = matchedAnnotation == null ? NULL_VAL : matchedAnnotation.getValue_STEXT();
                    break;
                }
                case 4: {
                    value = htmlEscaper.escape(matchedAnnotation == null ? NULL_VAL : matchedAnnotation.getValue_STEXT());
                    break;
                }
                case 5: {
                    value = matchedAnnotation == null ? NULL_VAL : matchedAnnotation.getName();
                    break;
                }
                case 6: {
                    value = matchedAnnotation.getValue() == null ? NULL_VAL : matchedAnnotation.getValue().toString();
                    matchedQName = "meta::" + this.metaname;
                    break;
                }
                default: {
                    value = "";
                }
            }
            this.outputAny(left, right, matchedQName, value, outputStartTags, outputEndTags, priority);
        }
    }

    public void outputAny(long left, long right, String matchedQName, String value, SortedMap<Long, List<OutputItem>> outputStartTags, SortedMap<Long, List<OutputItem>> outputEndTags, int priority) {
        String startTag = "<" + this.element;
        if (!this.style.isEmpty()) {
            if (this.style.contains(":") || this.style.contains(";")) {
                startTag = startTag + " style=\"" + this.style + "\" ";
            } else {
                startTag = startTag + " class=\"" + this.style + "\" ";
                String colorStyle = " style=\" color:" + this.tokenColor + "\" ";
                startTag = startTag + colorStyle;
            }
        }
        String inner = "";
        String endTag = "</" + this.element + ">";
        if (this.attribute == null || this.attribute.isEmpty()) {
            inner = value;
        } else {
            startTag = startTag + " " + this.attribute + "=\"" + value + "\"";
        }
        startTag = startTag + ">";
        if (outputStartTags.get(left) == null) {
            outputStartTags.put(left, new ArrayList());
        }
        if (outputEndTags.get(right) == null) {
            outputEndTags.put(right, new ArrayList());
        }
        if (NULL_VAL.equals(this.element)) {
            startTag = "";
            endTag = "";
        }
        if (!inner.isEmpty()) {
            startTag = startTag + inner;
        }
        OutputItem itemStart = new OutputItem();
        itemStart.setOutputString(startTag);
        itemStart.setLength(right - left);
        itemStart.setqName(matchedQName);
        itemStart.setPriority(priority);
        OutputItem itemEnd = new OutputItem();
        if (endTag.isEmpty()) {
            itemEnd.setOutputString(endTag + "<!-- end of non-span output -->");
        } else {
            itemEnd.setOutputString(endTag + "<!-- end of \"" + this.style + "\" -->");
        }
        itemEnd.setLength(right - left);
        itemEnd.setqName(matchedQName);
        itemEnd.setPriority(priority);
        ((List)outputStartTags.get(left)).add(itemStart);
        ((List)outputEndTags.get(right)).add(itemEnd);
    }

    public void outputHTML(SStructuredNode node, String matchedQName, SortedMap<Long, List<OutputItem>> outputStartTags, SortedMap<Long, List<OutputItem>> outputEndTags, String tokenColor, int priority, Map<SToken, Long> token2index) {
        this.tokenColor = tokenColor;
        if (node instanceof SToken && "tok".equals(matchedQName)) {
            SToken tok = (SToken)node;
            this.outputToken(tok, outputStartTags, outputEndTags, priority, token2index);
        } else if (node instanceof SSpan || node instanceof SToken) {
            this.outputAnnotation(node, matchedQName, outputStartTags, outputEndTags, priority, token2index);
        } else {
            throw new IllegalArgumentException("node must be either a SSpan or SToken");
        }
    }

    private void outputToken(SToken tok, SortedMap<Long, List<OutputItem>> outputStartTags, SortedMap<Long, List<OutputItem>> outputEndTags, int priority, Map<SToken, Long> token2index) {
        String value;
        long index = token2index.get(tok);
        switch (1.$SwitchMap$org$corpus_tools$annis$gui$visualizers$htmlvis$SpanHTMLOutputter$Type[this.type.ordinal()]) {
            case 1: {
                value = this.constant;
                break;
            }
            case 3: {
                value = Helper.getSpannedText((SToken)tok);
                break;
            }
            case 4: {
                value = htmlEscaper.escape(Helper.getSpannedText((SToken)tok));
                break;
            }
            case 5: {
                value = "tok";
                break;
            }
            default: {
                value = "";
            }
        }
        this.outputAny(index, index, "tok", value, outputStartTags, outputEndTags, priority);
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public void setConstant(String constant) {
        this.constant = constant;
    }

    public void setElement(String element) {
        this.element = element;
    }

    public void setMeta(HashMap<String, String> meta) {
        this.hshMeta = meta;
    }

    public void setMetaname(String metaname) {
        this.metaname = metaname;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public void setType(Type type) {
        this.type = type;
    }
}

