/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.visualizers.iframe;

import com.vaadin.ui.Component;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.UUID;
import org.corpus_tools.annis.gui.VisualizationToggle;
import org.corpus_tools.annis.gui.visualizers.AbstractVisualizer;
import org.corpus_tools.annis.gui.visualizers.IFrameResource;
import org.corpus_tools.annis.gui.visualizers.IFrameResourceMap;
import org.corpus_tools.annis.gui.visualizers.ResourcePlugin;
import org.corpus_tools.annis.gui.visualizers.VisualizerInput;
import org.corpus_tools.annis.gui.widgets.AutoHeightIFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIFrameVisualizer
extends AbstractVisualizer
implements ResourcePlugin {
    private static final long serialVersionUID = -1795397545146765258L;
    private static final Logger log = LoggerFactory.getLogger(AbstractIFrameVisualizer.class);

    public Component createComponent(VisualizerInput vis, VisualizationToggle visToggle) {
        URI base;
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        this.writeOutput(vis, (OutputStream)outStream);
        IFrameResource res = new IFrameResource();
        res.setData(outStream.toByteArray());
        res.setMimeType(this.getContentType());
        UUID uuid = UUID.randomUUID();
        vis.getUI().access(() -> {
            IFrameResource cfr_ignored_0 = (IFrameResource)((IFrameResourceMap)vis.getUI().getSession().getAttribute(IFrameResourceMap.class)).put((Object)uuid, (Object)res);
        });
        try {
            String ctx = vis.getUI().getServletContext().getContextPath();
            if (!ctx.endsWith("/")) {
                ctx = ctx + "/";
            }
            base = new URI(ctx);
        }
        catch (URISyntaxException e) {
            log.warn("Getting context failed, falling back to using the complete URL, which will fail if ANNIS used with an instance URL", (Throwable)e);
            base = vis.getUI().getPage().getLocation();
        }
        AutoHeightIFrame iframe = new AutoHeightIFrame(base.resolve("vis-iframe-res/" + uuid.toString()));
        return iframe;
    }

    public String getCharacterEncoding() {
        return "utf-8";
    }

    public String getContentType() {
        return "text/html";
    }

    public abstract void writeOutput(VisualizerInput var1, OutputStream var2);
}

