/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.visualizers.iframe;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.corpus_tools.annis.gui.visualizers.VisualizerInput;
import org.corpus_tools.annis.gui.visualizers.iframe.AbstractIFrameVisualizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WriterVisualizer
extends AbstractIFrameVisualizer {
    private static final long serialVersionUID = 701253176280879107L;
    private static final Logger log = LoggerFactory.getLogger(WriterVisualizer.class);

    public void writeOutput(VisualizerInput input, OutputStream outstream) {
        try {
            OutputStreamWriter writer = new OutputStreamWriter(outstream, this.getCharacterEncoding());
            this.writeOutput(input, (Writer)writer);
            writer.flush();
        }
        catch (IOException ex) {
            log.error("Exception when writing visualizer output.", (Throwable)ex);
            StringWriter strWriter = new StringWriter();
            ex.printStackTrace(new PrintWriter(strWriter));
            try {
                outstream.write(strWriter.toString().getBytes("UTF-8"));
            }
            catch (IOException ex1) {
                log.error(null, (Throwable)ex);
            }
        }
    }

    public abstract void writeOutput(VisualizerInput var1, Writer var2);
}

