/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.visualizers.iframe.dependency;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.annis.gui.MatchedNodeColors;
import org.corpus_tools.annis.gui.visualizers.VisualizerInput;
import org.corpus_tools.annis.gui.visualizers.iframe.WriterVisualizer;
import org.corpus_tools.salt.SALT_TYPE;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SPointingRelation;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.SAbstractAnnotation;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SLayer;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.util.DataSourceSequence;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class VakyarthaDependencyTree
extends WriterVisualizer {
    private static final long serialVersionUID = -1024879577323484644L;
    private static final Logger log = LoggerFactory.getLogger(VakyarthaDependencyTree.class);
    private final String MAPPING_NODE_KEY = "node_key";
    private Map<String, String> mappings;

    private String getAnnotation(SNode node) {
        if (this.mappings.containsKey("node_key") && this.mappings.get("node_key") != null) {
            Set annos = node.getAnnotations();
            SAnnotation anno = null;
            for (SAnnotation a : annos) {
                if (!((String)this.mappings.get("node_key")).equals(a.getName())) continue;
                anno = a;
                break;
            }
            return anno != null ? anno.getQName() + "=" + anno.getValue_STEXT() : "";
        }
        return "";
    }

    public String getShortName() {
        return "arch_dependency";
    }

    private String getText(SNode node, VisualizerInput input) {
        SDocumentGraph sDocumentGraph = input.getSResult().getDocumentGraph();
        List sequences = sDocumentGraph.getOverlappedDataSourceSequence(node, new SALT_TYPE[]{SALT_TYPE.STEXT_OVERLAPPING_RELATION});
        if (sequences != null && sequences.size() > 0) {
            return ((STextualDS)((DataSourceSequence)sequences.get(0)).getDataSource()).getText().substring(((DataSourceSequence)sequences.get(0)).getStart().intValue(), ((DataSourceSequence)sequences.get(0)).getEnd().intValue());
        }
        return "";
    }

    public void printHTMLOutput(VisualizerInput input, Writer writer, TreeSet<SNode> selectedNodes) {
        SDocumentGraph sDocumentGraph = input.getSResult().getDocumentGraph();
        for (SNode n : sDocumentGraph.getNodes()) {
            if (!this.selectNode(n)) continue;
            selectedNodes.add(n);
        }
        HashMap<SNode, Integer> node2Int = new HashMap<SNode, Integer>();
        int count = 0;
        for (SNode tok : selectedNodes) {
            node2Int.put(tok, count++);
        }
        try {
            this.println("<html>", writer);
            this.println("<head>", writer);
            LinkedList<String> fontsText = new LinkedList<String>();
            LinkedList<String> fontsDep = new LinkedList<String>();
            if (input.getFont() != null) {
                fontsText.add(input.getFont().getName());
                fontsDep.add(input.getFont().getName());
                this.println("<link href=\"" + input.getFont().getUrl() + "\" rel=\"stylesheet\" type=\"text/css\" >", writer);
            }
            fontsText.add("sans-serif");
            fontsDep.add("serif");
            this.println("<script type=\"text/javascript\" src=\"" + input.getResourcePath("vakyartha/jquery.js") + "\"></script>", writer);
            this.println("<script type=\"text/javascript\" src=\"" + input.getResourcePath("vakyartha/raphael-min.js") + "\"></script>", writer);
            this.println("<script type=\"text/javascript\" src=\"" + input.getResourcePath("vakyartha/vakyarthaDependency.js") + "\"></script>", writer);
            this.println("<script type=\"text/javascript\">", writer);
            this.println("fcolors={};", writer);
            this.println("shownfeatures=[\"t\"];", writer);
            this.println("tokens=new Object();", writer);
            count = 0;
            for (SNode node : selectedNodes) {
                JSONObject vakyarthaObject = new JSONObject();
                String completeAnnotation = this.getAnnotation(node);
                String annotationValue = completeAnnotation.replaceFirst(".*=", "");
                String text = this.getText(node, input);
                if (this.mappings.containsKey("node_key")) {
                    vakyarthaObject.put("t", (Object)annotationValue);
                } else {
                    vakyarthaObject.put("t", (Object)text);
                }
                vakyarthaObject.put("annotation", (Object)annotationValue);
                vakyarthaObject.put("text", (Object)text);
                vakyarthaObject.put("tooltip", (Object)completeAnnotation);
                JSONObject govs = new JSONObject();
                List sEdges = node.getGraph().getInRelations(node.getId());
                for (SRelation e : sEdges) {
                    if (!(e instanceof SPointingRelation)) continue;
                    SPointingRelation sRelation = (SPointingRelation)e;
                    boolean includeEdge = true;
                    if (input.getNamespace() != null) {
                        includeEdge = false;
                        if (sRelation.getLayers() != null) {
                            for (SLayer layer : sRelation.getLayers()) {
                                if (!input.getNamespace().equals(layer.getName())) continue;
                                includeEdge = true;
                                break;
                            }
                        }
                    }
                    if (!includeEdge) continue;
                    SNode source = (SNode)sRelation.getSource();
                    String label = sRelation.getAnnotations().stream().findFirst().map(SAbstractAnnotation::getValue_STEXT).orElse("");
                    if (sRelation.getSource() == null || !node2Int.containsKey(source)) continue;
                    govs.put(String.valueOf(node2Int.get(source)), (Object)label);
                }
                vakyarthaObject.put("govs", (Object)govs);
                JSONObject attris = new JSONObject();
                JSONObject tAttris = new JSONObject();
                String tokenColor = "black";
                if (input.getMarkedAndCovered().containsKey(node)) {
                    tokenColor = MatchedNodeColors.getHTMLColorByMatch((Long)((Long)input.getMarkedAndCovered().get(node)));
                }
                tAttris.put("fill", (Object)tokenColor);
                tAttris.put("font", (Object)("11px " + StringUtils.join(fontsText, (String)",")));
                attris.put("t", (Object)tAttris);
                JSONObject depAttris = new JSONObject();
                depAttris.put("fill", (Object)"#999");
                depAttris.put("font-style", (Object)"italic");
                depAttris.put("font", (Object)("12px " + StringUtils.join(fontsDep, (String)",")));
                attris.put("deptext", (Object)depAttris);
                vakyarthaObject.put("attris", (Object)attris);
                writer.append("tokens[").append("" + count++).append("]=");
                writer.append(vakyarthaObject.toString().replaceAll("\n", " "));
                writer.append(";\n");
            }
            this.println("</script>", writer);
            this.println("</head>", writer);
            this.println("<body id=\"holder\">", writer);
            this.println("</body>", writer);
            this.println("</html>", writer);
        }
        catch (JSONException ex) {
            log.error(null, (Throwable)ex);
        }
        catch (IOException ex) {
            log.error(null, (Throwable)ex);
        }
    }

    private void println(String s, int indent, Writer writer) throws IOException {
        for (int i = 0; i < indent; ++i) {
            writer.append("\t");
        }
        writer.append(s);
        writer.append("\n");
    }

    private void println(String s, Writer writer) throws IOException {
        this.println(s, 0, writer);
    }

    private boolean selectNode(SNode n) {
        String annoKey = null;
        if (this.mappings.containsKey("node_key")) {
            annoKey = (String)this.mappings.get("node_key");
        }
        if (annoKey == null) {
            return n instanceof SToken;
        }
        Set annos = n.getAnnotations();
        for (SAnnotation a : annos) {
            if (!annoKey.equals(a.getName())) continue;
            return true;
        }
        return false;
    }

    public void writeOutput(VisualizerInput input, Writer writer) {
        this.mappings = input.getMappings();
        Map token2index = Helper.createToken2IndexMap((SDocumentGraph)input.getSResult().getDocumentGraph(), null);
        TreeSet selectedNodes = new TreeSet(new /* Unavailable Anonymous Inner Class!! */);
        this.printHTMLOutput(input, writer, selectedNodes);
    }
}

