/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.widgets.grid;

import com.google.common.base.Preconditions;
import com.vaadin.server.PaintException;
import com.vaadin.server.PaintTarget;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.LegacyComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.corpus_tools.annis.gui.MatchedNodeColors;
import org.corpus_tools.annis.gui.media.MediaController;
import org.corpus_tools.annis.gui.media.PDFController;
import org.corpus_tools.annis.gui.widgets.grid.GridEvent;
import org.corpus_tools.annis.gui.widgets.grid.Row;

public class AnnotationGrid
extends AbstractComponent
implements LegacyComponent {
    private static final long serialVersionUID = -2901375462165700931L;
    private Map<String, ArrayList<Row>> rowsByAnnotation;
    private transient MediaController mediaController;
    private transient PDFController pdfController;
    private String resultID;
    private String tokRowKey = "tok";
    private boolean showCaption = true;
    private Set<String> annosWithNamespace;
    private boolean escapeHTML = true;

    public AnnotationGrid(MediaController mediaController, PDFController pdfController, String resultID) {
        this.mediaController = mediaController;
        this.pdfController = pdfController;
        this.resultID = resultID;
    }

    public AnnotationGrid(String resultID, String tokRowKey) {
        this(null, null, resultID);
        if (tokRowKey != null) {
            this.tokRowKey = tokRowKey;
        }
    }

    public void changeVariables(Object source, Map<String, Object> variables) {
        if (variables.containsKey("play") && this.mediaController != null && this.resultID != null) {
            String playString = (String)variables.get("play");
            String[] split = playString.split("-");
            if (split.length == 1) {
                this.mediaController.play(this.resultID, Double.parseDouble(split[0]));
            } else if (split.length == 2) {
                this.mediaController.play(this.resultID, Double.parseDouble(split[0]), Double.parseDouble(split[1]));
            }
        }
        if (variables.containsKey("openPDF") && this.pdfController != null && this.resultID != null) {
            this.pdfController.openPDF(this.resultID, (String)variables.get("openPDF"));
        }
    }

    public Set<String> getAnnosWithNamespace() {
        return this.annosWithNamespace;
    }

    public Map<String, ArrayList<Row>> getRowsByAnnotation() {
        return this.rowsByAnnotation;
    }

    private ArrayList<String> getStyles(GridEvent event, String annoName) {
        ArrayList<String> styles = new ArrayList<String>();
        if (this.tokRowKey.equals(annoName)) {
            styles.add("token");
        } else if (event.isSpace()) {
            styles.add("space");
        } else if (event.isGap()) {
            styles.add("gap");
        } else {
            styles.add("single_event");
        }
        if (event.getMatch() != null) {
            styles.add("v-table-cell-content-" + MatchedNodeColors.colorClassByMatch((Long)event.getMatch()));
        }
        return styles;
    }

    public String getTokRowKey() {
        return this.tokRowKey;
    }

    public boolean isShowCaption() {
        return this.showCaption;
    }

    public void paintContent(PaintTarget target) throws PaintException {
        target.addAttribute("escapeHTML", this.escapeHTML);
        if (this.rowsByAnnotation != null) {
            target.startTag("rows");
            for (Map.Entry anno : this.rowsByAnnotation.entrySet()) {
                for (Row row : (ArrayList)anno.getValue()) {
                    target.startTag("row");
                    target.addAttribute("caption", (String)anno.getKey());
                    target.addAttribute("show-caption", this.showCaption);
                    target.addAttribute("show-namespace", this.showNamespaceForAnno((String)anno.getKey()));
                    if (row.getStyle() != null) {
                        target.addAttribute("style", row.getStyle());
                    }
                    ArrayList rowEvents = row.getEvents();
                    Collections.sort(rowEvents, (o1, o2) -> Integer.compare(o1.getLeft(), o2.getLeft()));
                    target.startTag("events");
                    for (GridEvent event : rowEvents) {
                        ArrayList styles;
                        target.startTag("event");
                        target.addAttribute("id", event.getId());
                        target.addAttribute("left", event.getLeft());
                        target.addAttribute("right", event.getRight());
                        target.addAttribute("value", event.getValue());
                        if (event.getTooltip() != null) {
                            target.addAttribute("tooltip", event.getTooltip());
                        }
                        if (event.getStartTime() != null) {
                            target.addAttribute("startTime", event.getStartTime().doubleValue());
                            if (event.getEndTime() != null) {
                                target.addAttribute("endTime", event.getEndTime().doubleValue());
                            }
                        }
                        if (event.getPageNumber() != null) {
                            target.addAttribute("openPDF", event.getPageNumber());
                        }
                        if ((styles = this.getStyles(event, (String)anno.getKey())).size() > 0) {
                            target.addAttribute("style", styles.toArray());
                        }
                        target.addAttribute("highlight", event.getCoveredIDs().toArray());
                        target.endTag("event");
                    }
                    target.endTag("events");
                    target.endTag("row");
                }
            }
            target.endTag("rows");
        }
    }

    public void setAnnosWithNamespace(Set<String> annosWithNamespace) {
        this.annosWithNamespace = annosWithNamespace;
    }

    public void setEscapeHTML(boolean escapeHTML) {
        this.escapeHTML = escapeHTML;
    }

    public void setRowsByAnnotation(Map<String, ArrayList<Row>> rowsByAnnotation) {
        this.rowsByAnnotation = rowsByAnnotation;
    }

    public void setShowCaption(boolean showCaption) {
        this.showCaption = showCaption;
    }

    public void setTokRowKey(String tokRowKey) {
        Preconditions.checkNotNull((Object)tokRowKey);
        this.tokRowKey = tokRowKey;
    }

    private boolean showNamespaceForAnno(String qname) {
        if (this.annosWithNamespace != null) {
            return this.annosWithNamespace.contains(qname);
        }
        return false;
    }
}

