Object.assign(window.search, {"doc_urls":["index.html#introduction","interface/index.html#using-the-annis-interface","interface/search-form.html#search-form","interface/result-window.html#result-window","interface/query-builder.html#query-builder","aql/index.html#annis-query-language-aql","aql/word-forms.html#searching-for-word-forms","aql/annotations.html#searching-for-annotations","aql/regex.html#searching-using-regular-expressions","aql/trees.html#searching-for-trees","aql/pointing.html#searching-for-pointing-relations","aql/export.html#exporting-results","aql/frequency.html#frequency-analysis","aql/operators.html#complete-list-of-operators","aql/operators.html#unsupported-operators","aql/compatibility-mode.html#differences-in-compatibility-mode","aql/compatibility-mode.html#indirect-precedence-is-limited-to-a-maximum-distance-of-50","aql/compatibility-mode.html#non-reflexive-operator-is-only-applied-locally","aql/compatibility-mode.html#meta-is-still-allowed"],"index":{"documentStore":{"docInfo":{"0":{"body":57,"breadcrumbs":2,"title":1},"1":{"body":18,"breadcrumbs":6,"title":3},"10":{"body":270,"breadcrumbs":10,"title":3},"11":{"body":393,"breadcrumbs":8,"title":2},"12":{"body":153,"breadcrumbs":8,"title":2},"13":{"body":271,"breadcrumbs":10,"title":3},"14":{"body":49,"breadcrumbs":9,"title":2},"15":{"body":26,"breadcrumbs":10,"title":3},"16":{"body":29,"breadcrumbs":13,"title":6},"17":{"body":88,"breadcrumbs":12,"title":5},"18":{"body":39,"breadcrumbs":10,"title":3},"2":{"body":204,"breadcrumbs":7,"title":2},"3":{"body":162,"breadcrumbs":7,"title":2},"4":{"body":220,"breadcrumbs":7,"title":2},"5":{"body":120,"breadcrumbs":8,"title":4},"6":{"body":206,"breadcrumbs":10,"title":3},"7":{"body":278,"breadcrumbs":8,"title":2},"8":{"body":282,"breadcrumbs":12,"title":4},"9":{"body":222,"breadcrumbs":8,"title":2}},"docs":{"0":{"body":"ANNIS is an open source, browser-based search and visualization architecture for multi-layer corpora. It can be used to search for complex graph structures of annotated nodes and edges forming a variety of linguistic structures, such as constituent or dependency syntax trees, coreference, rhetorical structure and parallel alignment edges, span annotations and associated multi-modal data (audio/video). In this online help, you can learn more about how to use the ANNIS interface and the query language AQL . Additional documentation is available from the homepage at http://corpus-tools.org/annis/documentation.html.","breadcrumbs":"Introduction » Introduction","id":"0","title":"Introduction"},"1":{"body":"The ANNIS interface is comprised of several areas, the most important of which are the search form on the left side and the results tab on the right side. Screenshot of the ANNIS user interface","breadcrumbs":"Using the ANNIS interface » Using the ANNIS interface","id":"1","title":"Using the ANNIS interface"},"10":{"body":"Pointing relations are used to express an arbitrary directed relationship between two elements (terminals or non-terminals) without implying dominance or coverage inheritance. For instance, in the GUM corpus, elements in the ref: namespace may point to each other to express coreference or anaphoric relations. The following query searches for two entity annotations, which specify whether a discourse referent is a person, or an animal, a location, an object, an abstract etc. entity=\"person\" & entity!=\"person\" & #1 ->coref #2 Using the pointing relation operator -> with the type coref, the first entity, which should be a person, is said to be coreferent with its antecedent, the second entity, which is not a person. In practice, this will usually occur due to \"bridging\", where something like a whole (e.g. an organization such as a 'research team') implies the existence of its part (e.g. persons, such as 'the scientists'). To see a visualization of the coreference relations, open the coreference annotation layer in the GUM corpus. In the image below, one of the matches for the above query is highlighted in red (die Seeburger und einige Groß-Glienicker ... sie 'the Seeburgers and some Groß-Glienickers... they'). Other discourse referents in the text (marked with an underline) may be clicked on, causing coreferential chains containing them to be highlighted as well. Note that discourse referents may overlap, leading to multiple underlines: Die Seeburger 'the Seeburgers' is a shorter discourse referent overlapping with the larger one ('the Seeburgers and some Groß-Glienickers'), and each referent has its own underline. Annotations of the coreference edges of each relation can be viewed by hovering of the appropriate underline. The pointing relation operator can also search for longer chains of coreference, using the asterisk extension shown below: entity=\"organization\" ->coref* entity=\"person\" This finds all organizations that point back to a person at any point along the preceding coreference chain. It is also possible to specify annotations of pointing relations, which for coreference in the GUM corpus mark what kind of coreference is used: anaphoric, cataphoric, lexical coreference, apposition, or bridging. To find appositions of place entities, use the following query: entity=\"place\" ->coref[type=\"appos\"] entity=\"place\" Another way to use pointing relations is found in syntactic dependency trees. The queries in this case can use both pointing relation types and annotations too, as in the following query: pos=/VV[PZ]/ & tok & #1 ->dep[func=\"dobj\"] #2 OR (using a shortcut): pos=/VV[PZ]/ ->dep[func=\"dobj\"] tok This query searches for a present tense lexical verb (with the part-of-speech VVZ or VVP) and a token, with a pointing relation of the type 'dep' (for dependency) between the two, annotated with func=\"dobj\" (the function 'direct object'). The result can be viewed with the arch dependency visualizer, which shows the verb 'shows' and its object 'location'.","breadcrumbs":"ANNIS Query Language (AQL) » Searching for Pointing Relations » Searching for Pointing Relations","id":"10","title":"Searching for Pointing Relations"},"11":{"body":"To export search results, open the menu \"More\" between the Search and History buttons and select \"Export\": Enter the query whose results you want to export as usual in the AQL box. Note that you do not need to carry out the query first . You can enter the query and export without pressing Search before. Several exporter modules can be selected from the Export tab shown below. The SimpleTextExporter simply gives the text for all tokens in each search result, including context, in a one-row-per-hit format. The tokens covered by the match area are marked with square brackets and the results are numbered, as in the following example: 0. of the International Brotherhood of [Magicians] Wednesday , October 9 , 1. Magic Month in the United [States] . Wikinews spoke with William 2. of the International Brotherhood of [Magicians] , about the current state 3. - \" Scarne on Card [Tricks] \" and \" Scarne on 4. and \" Scarne on Magic [Tricks] \" . That started me The TokenExporter adds all annotations of each token separated by slashes (e.g. dogs/NNS/dog for a token dogs annotated with a part-of-speech NNS and a lemma dog). The GridExporter adds all annotations available for the span of retrieved tokens, with each annotation layer in a separate line. Annotations are separated by spaces and the hierarchical order of annotations is lost, though the span of tokens covered by each annotation may optionally be given in square brackets (to turn this off use the optional parameter numbers=false in the ‘Parameters’ box). The user can specify annotation layers to be exported in the additional ‘Annotation Keys’ box, and annotation names should be separated by comas, as in the image above. Metadata annotations can also be exported by entering “metakeys=” and a list of comma separated metadata names in the Parameters box. If nothing is specified, all available annotations and no metadata will be exported. Multiple options are separated by a semicolon, e.g. the Parameters metakeys=type,docname;numbers=false. An example output with token numbers and the part of speech (pos) and syntactic category annotations looks as follows. 0. tok of the International Brotherhood of Magicians Wednesday pos IN[1-1] DT[2-2] NP[3-3] NP[4-4] IN[5-5] NPS[6-6] NP[7-7] cat S[1-6] VP[1-6] NP[1-6] PP[1-6] NP[2-4] PP[5-6] NP[6-6] NP[7-12] Meaning that the annotation cat=\"NP\" applies to tokens 1-6 in the search result, and so on. Note that when specifying annotation layers, if the reserved name 'tok' is not specified, the tokens themselves will not be exported (annotations only). The WekaExporter outputs the format used by the WEKA machine learning tool . Only the attributes of the search elements (#1, #2 etc. in AQL) are outputted, and are separated by commas. The order and name of the attributes is declared in the beginning of the export text, as in this example: @relation name @attribute #1_id string\n@attribute #1_span string\n@attribute #1_anno_const:cat string\n@attribute #2_id string\n@attribute #2_span string\n@attribute #2_anno_GUM:claws5 string\n@attribute #2_anno_GUM:lemma string\n@attribute #2_anno_GUM:pos string @data '11318611','the current state','NP','11318616','current','AJ0','current','JJ'\n'11318686','magic','NP','11318688','magic','AJ0','magic','JJ'\n'11318757','some basic tricks','NP','11318760','basic','AJ0','basic','JJ' The export shows the properties of an NP node dominating a token with the part-of-speech JJ. Since the token also has other attributes, such as the lemma and part of speech tags, these are also retrieved. It is also possible to output metadata annotations per hit using the WekaExporter. To do so, use the parameter metakeys=meta1,meta2 etc. For example, if your documents have a metadata annotation called 'genre', you may export it for each search result as a further column using metakeys=genre in the parameters box. The CSVExporter behaves much like the WekaExporter, except that the Weka header specifying the content of the columns is not used (useful for importing into spreadsheet programs such as Excel or Calc). Note that exporting may be slow if the result set is large.","breadcrumbs":"ANNIS Query Language (AQL) » Exporting Results » Exporting Results","id":"11","title":"Exporting Results"},"12":{"body":"To perform a frequency analysis, enter the query whose results you want to analyze as usual in the AQL box. Note that you do not need to carry out the query first . Next, open the menu “More” between the Search and History buttons and select “Frequency Analysis”: The interface will open the frequency analysis tab shown below. Initially, rows will be generated for the nodes present in the query. For example, two rows are automatically generated for the following query, which finds any pair of consecutive tokens: tok . tok Clicking on “Perform frequency analysis” will produce a breakdown of all consecutive token bigrams in the corpus. The frequency graph will only show the first 500 elements, but the table below it will give the entire list of values, which can also be exported as a CSV file . To edit the analysis or analyze a new query, click the New Analysis button. It is also possible to add annotations to the analysis that were not in the original query, provided that these are expected to belong to some other node in the query. For example, the tokens in the GUM corpus also have part-of-speech and lemma information. We can replace the lines in the analysis specifying that tok values should be counted with pos values, which gives us part-of-speech bigrams. We can also add a lemma annotation belonging to the first search element, by clicking the Add button and entering the node definition number and annotation name we are interested in: As a result, we will get a count for each combination of values grouped by the first and second tokens' parts-of-speech, as well as the first token's lemma.","breadcrumbs":"ANNIS Query Language (AQL) » Frequency Analysis » Frequency Analysis","id":"12","title":"Frequency Analysis"},"13":{"body":"AQL currently includes the following operators: Operator Description Illustration Notes . direct precedence For non-terminal nodes, precedence is determined by the right-most and left-most terminal children. In corpora with multiple segmentations the layer on which consecutivity holds may be specified with .layer .* indirect precedence For specific sizes of precedence spans, .n,m can be used, e.g. .3,4 - between 3 and 4 token distance; the default maximum distance for .* is 50 tokens. As above, segmentation layers may be specified, e.g. .layer,3,4 ^ directly near or Same as precedence, but in either order. In corpora with multiple segmentations the layer on which consecutivity holds may be specified with ^layer ^* indirectly near or Like indirect precedence in either order. The form ^n,m can be used, e.g. ^3,4 - between 3 and 4 token distance; the default maximum distance for ^* is 50 tokens. As above, segmentation layers may be specified, e.g. ^layer,3,4 > direct dominance A specific edge type may be specified, e.g. >secedge to find secondary edges. Edge labels are specified in brackets, e.g. >[func=\"OA\"] for an edge with the function 'object, accusative' >* indirect dominance For specific distance of dominance, >n,m can be used, e.g. >3,4 - dominates with 3 to 4 edges distance @* part of sub-corpus Left attribute is part of a sub-corpus having the attribute of the right-hand side. For specific distance range in the sub-corpus hierarchy, @n,m can be used. _=_ identical coverage Applies when two annotations cover the exact same span of tokens _i_ inclusion Applies when one annotation covers a span identical to or larger than another _o_ overlap _l_ left aligned Both elements span an area beginning with the same token _r_ right aligned Both elements span an area ending with the same token == value identity A = B The value of the annotation or token A is identical to that of B (this operator does not bind, i.e. the nodes must be connected by some other criteria too) != value difference A ≠ B The value of the annotation or token A is different from B (this operator does not bind, i.e. the nodes must be connected by some other criteria too) ->LABEL labeled pointing relation A labeled, directed relationship between two elements. Annotations can be specified with ->LABEL[annotation=\"VALUE\"] ->LABEL * indirect pointing relation An indirect labeled relationship between two elements. The length of the chain may be specified with ->LABEL n,m for relation chains of length n to m #x:arity=n arity Specifies the amount of directly dominated children that the searched node has _ident_ node identity True for two attributes that belong to the same node","breadcrumbs":"ANNIS Query Language (AQL) » Complete List of Operators » Complete List of Operators","id":"13","title":"Complete List of Operators"},"14":{"body":"The following operators have been available in the legacy version ANNIS3, but are not yet implemented in the newest ANNIS version. Operator Description Illustration Notes _ol_ and _or_ Overlap, but only on the left or right side >@l left-most child >@r right-most child $ common parent node $* common ancestor node #x:tokenarity=n tokenarity Specifies the length of the span of tokens covered by the node #x:root root Specifies that the node is not dominated by any other node within its namespace s","breadcrumbs":"ANNIS Query Language (AQL) » Complete List of Operators » Unsupported operators","id":"14","title":"Unsupported operators"},"15":{"body":"Previous versions of ANNIS might have a slightly different interpretation of the semantics of AQL. By choosing the compatibility mode in the search options, you can emulate the old behavior. The compatibility mode (also called \"quirks mode\") has the following differences to the standard AQL semantics.","breadcrumbs":"ANNIS Query Language (AQL) » Differences in Compatibility Mode » Differences in Compatibility Mode","id":"15","title":"Differences in Compatibility Mode"},"16":{"body":"Indirect precedence (.*) was limited to a maximum distance of 50 in older versions for performance reasons. E.g. the query tok .* tok is effectively tok .1,50 tok. Depending on the text length of the documents, the compatibility mode might return fewer matches than the normal mode.","breadcrumbs":"ANNIS Query Language (AQL) » Differences in Compatibility Mode » Indirect Precedence is limited to a maximum distance of 50","id":"16","title":"Indirect Precedence is limited to a maximum distance of 50"},"17":{"body":"The operands of non-reflexive operators must be different. In standard AQL, a new match can be only included if the new match is different to all other matches. In contrast, the compatibility mode only enforces direct non-reflexivity. E.g. in the query node & node & node & #1 _o_ #2 & #2 _o_ #3 the first node must be different from the second node and the second node must be different from the third. In compatibility mode, it is allowed that #1 and #3 reference the same match because there is no non-reflexive operator directly between them. You would need to change the query to node & node & node & #1 _o_ #2 & #2 _o_ #3 & #1 _o_ #3 to enforce that these operand are not the same. The standard mode will not include a match if #1 and #3 reference the same match per default. This does not affect the addition of matches if the operator is reflexive.","breadcrumbs":"ANNIS Query Language (AQL) » Differences in Compatibility Mode » Non-reflexive operator is only applied locally","id":"17","title":"Non-reflexive operator is only applied locally"},"18":{"body":"Meta data constraints have been replaced with the part-of operator @* and will result in a syntax error for the normal query mode. In the compatibility mode, meta:: is still allowed. Be aware that meta data constraints like meta::doc=\"mydocumentname\" are applied to all conjunctions of the disjunction, which is seems counter-intuitive. E.g the query. (pos=\"NN\" | lemma=\"be\" & meta::age=\"20\") effectively becomes (pos=\"NN\" & meta::age=\"20\" | lemma=\"be\" & meta::age=\"20\")","breadcrumbs":"ANNIS Query Language (AQL) » Differences in Compatibility Mode » meta:: is still allowed","id":"18","title":"meta:: is still allowed"},"2":{"body":"ANNIS search form The Search Form can be found on the left of the interface window. It's bottom part shows the list of currently available corpora. By clicking on the line with the corpus name, it is possible to select which corpora should be searched in (hold down 'ctrl' to select multiple corpora simultaneously). You may also configure groups of corpora or type in the filter box to view subsets of the corpora. The \"AQL\" field at the top of the form is used for inputting queries manually (see the tutorials on the ANNIS Query Language from the ANNIS website). As soon as one or several corpora are selected and a query is entered or modified, the query will be validated automatically and possible errors in the query syntax will be commented on in the \"Status\" box below (which says \"valid query\" in the image above). Once a valid query has been entered, pressing the \"Search\" button will retrieve the number of matching positions and documents in the selected corpora in the Status box and open the Result tab to display the first set of matches. ANNIS search options In order to get more control over the search you can click on \"Search Options\" to unfold more detailed search options. The context surrounding the matching expressions in the result list ist determined by the \"Left Context\" and \"Right Context\" options and can be changed on each side (by default up to 20 tokens). You can also configure how many results are shown per page, what order results are shown in (ascending, descending or random) and for some corpora, you can select alternative segmentation layers to visualize data (relevant for languages with multiple tokens per word form, etc., such as Arabic). Entire texts can also be viewed using special document visualizations or by clicking on the document icon next to each corpus name, if available. The \"Query Language\" option allows to switch between the default AQL dialect and an compatibility mode emulating the behavior of the older ANNIS3. Make sure to use the latest version for all new queries.","breadcrumbs":"Using the ANNIS interface » Search Form » Search Form","id":"2","title":"Search Form"},"3":{"body":"ANNIS result window toolbar The result window shows search results in pages of 10 hits each by default (this can be changed in the Search Form). The toolbar at the top of the window allows you to navigate between these pages. The \"Token Annotations\" button on the toolbar allows you to toggle the token based annotations, such as lemmas and parts-of-speech, on or off for you convenience. You can use hyperlinks to your queries by copying the current browser URL for e-mail or citation purposes, allowing others to reproduce your query. If your corpus contains multiple alternative text layers or segmentations (e.g. normalized and un-normalized text), you may switch between these on the fly by using the \"base text\" menu. KWIC concordance in ANNIS The result list itself initially shows a KWIC (key word in context) concordance of matching positions in the selected corpora, with the matching regions marked in color and the context in black on either side. Colors in the result match the colors of search expressions in the search box (red for the search item #1, purple for #2, etc.). Context can be adjusted for individual search results up to the maximum allowed for the current corpus. Token annotations are displayed in gray under each token, and hovering over them with the mouse will show the annotation name and namespace. More complex annotation levels can be expanded, if available, by clicking on the plus icon next to the level's name, e.g. dependencies and referent information for the annotations in the dependency tree and grid views in the picture below. visualization of different annotation levels","breadcrumbs":"Using the ANNIS interface » Result Window » Result Window","id":"3","title":"Result Window"},"4":{"body":"To open the graphical query builder, click on the Query Builder button. On the left-hand side of the toolbar at the top of the query builder canvans, you will see the Add Node button. Use this button to define nodes to be searched for (tokens, non-terminal nodes or annotations). Creating nodes and modifying them on the canvas will immediately update the AQL field in the Search Form with your query, though updating the query on the Search Form will not create a new graph in the Query Builder. The Query Builder tab and the Create Node button In each node you create you may click on The Add Node button to specify an annotation value. The annotation name can be typed in or selected from a drop down list once a corpus is selected. The operator field in the middle allows you to choose between an exact match (the '=' symbol) or wildcard search using Regular Expressions (the '~' symbol). The annotation value is given on the right, and should NOT be surrounded by quotations (see the example below). It is also possible to specify multiple annotations applying to the same position by clicking on The Add Node button multiple times. Clicking on The Clear all nodes button will delete the values in the node. To search for word forms, simply choose \"tok\" as the field name on the left. A node with no data entered will match any node, that is an underspecified token or non-terminal node or annotation. Query Builder node To specify the relationship between nodes, first click on the \"Edge\" link at the top left of one node, and then click the \"Dock\" link which becomes available on the other nodes. An edge will connect the nodes with an extra box from which operators may be selected (see below). For operators allowing additional labels (e.g. the dominance operator > allows edge labels to be specified), you may type directly into the edge's operator box, as in the example with a \"func\" label in the image below. Note that the node clicked on first (where the \"Edge\" button was clicked) will be the first node in the resulting quey, i.e. if this is the first node it will dominate the second node (#1 > #2) and not the other way around, as also represented by the arrows along the edge. Connecting nodes with an edge","breadcrumbs":"Using the ANNIS interface » Query Builder » Query Builder","id":"4","title":"Query Builder"},"5":{"body":"ANNIS comes with its own query language called ANNIS Query Language (AQL). AQL is based on the concept of searching for annotation attributes and relations between them. A search is formulated by defining each token, non-terminal node or annotation being searched for as an element. An element can be a token (simply text between quotes: \"dogs\" or else tok=\"dogs\") or an attribute-value pair (such as tok=\"dogs\", or optionally with a namespace: tiger:cat=\"PP\"). Note that different corpora can have completely different annotation names and values - these are not specified by ANNIS. Underspecified tokens or nodes in general may be specified using tok and node respectively. Once all elements are declared, relations between the elements (or edges) are specified which must hold between them. The elements are referred back to serially using variable numbers, and linguistic operators bind them together, e.g. #1 > #2 meaning the first element dominates the second in a tree or graph. Operators define the possible overlap and adjacency relations between annotation spans, as well as recursive hierarchical relations between nodes. Some operators also allow specific labes to be specified in addition to the operator (see the operator list ).","breadcrumbs":"ANNIS Query Language (AQL) » ANNIS Query Language (AQL)","id":"5","title":"ANNIS Query Language (AQL)"},"6":{"body":"To search for word forms in ANNIS, simply select a corpus (in this example the freely available GUM corpus ) and enter a search string between double quotation marks, e.g.: \"do\" Note that the search is case sensitive , so it will not find cases of capitalized 'Do', for example at the beginning of a sentence. In order to find both options, you can either look for one form OR the other using the pipe sign ( | ): \"do\" | \"Do\" or else you can use regular expressions , which must be surrounded by slashes ( / ) instead of quotation marks: /[Dd]o/ To look for a sequence of multiple word forms, enter your search terms separated by & and then specify that the relation between the elements is one of precedence , as signified by the period ( . ) operator: \"do\" & \"n't\" & #1 . #2 The expression #1 . #2 signifies that the first element (\"do\") precedes the second element (\"n't\"). Alternatively, you can also place the operator directly between the search elements as a shortcut . The following shortcut query is equivalent to the one above: \"do\" . \"n't\"` For indirect precedence (where other tokens may stand between the search terms), use the .* operator: /[Dd]o/ & \"n't\" & \"any\" & #1 . #2 & #2 .* #3 OR using shortcuts: /[Dd]o/ . \"n't\" .* \"any\" The queries above find sequences beginning with the token \"Do\" or \"do\", followed directly by \"n't\", which must be followed either directly or indirectly (.*) by \"any\". A range of allowed distances can also be specified numerically as follows: /[Nn]ot/ & \"all\" & #1 .1,5 #2 OR: /[Nn]ot/ .1,5 \"all\" Meaning the two words \"not\" and \"all\" may appear at a distance of 1 to 5 tokens. The operator .* allows a distance of up to 50 tokens by default, so searching with .1,50 is the same as using .* instead. Greater distances (e.g. .1,100 for 'within 100 tokens') should always be specified explicitly. Finally, we can add metadata restrictions to the query, which filter out documents not matching our definitions. Metadata attributes must be connected to other non-meta attributes with the @* (part-of) operator: \"want\" & \"to\" & #1 .1,5 #2\n& type=\"interview\" & #1 @* #2 To view metadata for a search result or for a corpus, press the \"i\" icon next to it in the result window or in the search form respectively.","breadcrumbs":"ANNIS Query Language (AQL) » Searching for Word Forms » Searching for Word Forms","id":"6","title":"Searching for Word Forms"},"7":{"body":"Annotations may be searched for using an annotation name and value. The names of the annotations vary from corpus to corpus, though many corpora contain part-of-speech and lemma annotations with the names pos and lemma respectively (annotation names are case sensitive ). For example, to search for all forms of the verb be in the GUM corpus, simply select the GUM corpus and enter: lemma=\"be\" Negative searches are also possible using != instead of =. For negated tokens (word forms) use the reserved attribute tok. For example: lemma!=\"be\" or: tok!=\"be\" Metadata attributes can also be negated: lemma=\"be\" @* type!=\"interview\" To only find finite forms of a verb in GUM, use the part-of-speech (pos) annotation concurrently with lemma, and specify that both the lemma and pos should apply to the same element. For example for inflected forms of the verb give : lemma=\"give\" & pos=/VV.+/ & #1 _=_ #2 OR (using a shortcut): lemma=\"give\" _=_ pos=/VV.+/ The regular expression /VV.+/ means a part of speach that begins with VV (verb), but has additional characters (.+), such as for past tense (VVD) or gerund (VVG). The expression #1 _=_ #2 uses the span identity operator to specify that the first annotation and the second annotation apply to exactly the same position in the corpus. Annotations can also apply to longer spans than a single token: for example, in GUM, the annotation entity signifies the entity type of a discourse referent. This annotation can also apply to phrases longer than one token. The following query finds spans containing a discourse referent who is a person: entity=\"person\" If the corpus contains more than one annotation type named entity, a namespace may be added to disambiguate these annotations (for example, the entity annotation in the GUM corpus has the namespace ref:, so we can search for ref:entity=\"person\"). The namespace may always be dropped, but if there are multiple annotations with the same name but different namespaces, dropping the namespace will find all of those annotations. If you drop the value of the annotation, you can also search for any corpus positions that have that annotation, without constraining the value. For example, the following query finds all annotated entities in the GUM corpus, whether or not they are a person: entity In order to view the span of tokens to which the entity annotation applies, enter the query and click on \"Search\", then open the referents layer to view the grid containing the span. Further operators can test the relationships between potentially overlapping annotations in spans. For example, the operator _i_ examines whether one annotation fully contains the span of another annotation (the i stands for 'includes'): head & infstat=\"new\" & #1 _i_ #2 OR (using a shortcut): head _i_ infstat=\"new\" This query finds information structurally new discourse referents (infstat=\"new\") contained within headings (head).","breadcrumbs":"ANNIS Query Language (AQL) » Searching for Annotations » Searching for Annotations","id":"7","title":"Searching for Annotations"},"8":{"body":"When searching for word forms and annotation values, it is possible to employ wildcards as placeholders for a variety of characters, using Regular Expression syntax (see e.g. http://www.regular-expressions.info/ for detailed information). [1] To search for wildcards use slashes instead of quotation marks to surround your search term. For example, you can use the period (.) to replace any single character: tok=/ca./ This finds word forms such as \"cat\", \"can\", \"car\", \"cap\" etc. It is also possible to make characters optional by following them with a question mark (?) . The following example finds cases of \"car\" and \"cart\", since the \"t\" is optional: tok=/cart?/ It is also possible to specify an arbitrary number of repetitions, with an asterisk (*) signifying zero or more occurrences and a plus (+) signifying at least one occurrence. For example, the first query below finds \"o\", \"of\", and \"off\" (since the asterisk means zero or more times the preceding \"f\"), while the second finds \"of\" and \"off\", since at least one \"f\" must be found: tok=/of*/ tok=/of+/ It is possible to combine these operators with the period operator to mean any number of occurrences of an arbitrary character. For example, the query below searches for pos (part-of-speech) annotations that begin with \"VV\", corresponding to all forms of lexical verbs (the auxiliaries \"be\" and \"have\" are tagged VB... and VH... respectively). The string \"VV\" means that the result must begin with \"VV\", the period stands for any character, and the asterisk means that 'any character' can be repeated zero or more time, as above. pos=/VV.*/ This finds both finite verbs (\"VVZ\", \"VVP\", \"VVD\") and non-finite ones (\"VV\") or gerunds (\"VVG\"). It is also possible to search for explicit alternatives by either specifying characters in square brackets or longer strings in round brackets separated by pipe symbols . The first example below finds either \"of\" or \"on\" (i.e. \"o\" followed by either \"f\" or \"n\") while the second example finds lemma annotations that are either \"be\" or \"have\". tok=/o[nf]/ lemma=/(be|have)/ Finally, negative searches can be used as usual with the exclamation point, and regular expressions can generally be used also in edge annotations. For example, if we search for trees (see also Searching for Trees ) where a lexical verb dominates another token with a dependency edge not containing 'obj', we can use a wildcard to rule out all edges labels containing those letters. This will give us all non-object dependants of lexical verbs: pos=/VV.*/ & tok & #1 ->dep[func!=/.*obj.*/] #2 OR (using a shortcut): pos=/VV.*/ ->dep[func!=/.*obj.*/] tok While there is the POSIX-standard for regular expressions, different search engines might use slightly different syntax and support different types of search constraints, e.g. when searching for Unicode characters. ANNIS used to rely on the PostgreSQL regular expression implementation but now uses the Rust library regex. See https://docs.rs/regex#syntax for the currently supported regular expresssion syntax, as provided by this library.","breadcrumbs":"ANNIS Query Language (AQL) » Searching using Regular Expressions » Searching using Regular Expressions","id":"8","title":"Searching using Regular Expressions"},"9":{"body":"In corpora containing hierarchical structures, annotations such as syntax trees can be searched for by defining terminal or none-terminal node annotations, functional dependencies and their values (for dependencies see see Searching for Pointing Relations ). A simple search for prepostional phrases in the GUM corpus looks like this: const:cat=\"PP\" If the corpus contains no more than one annotation called cat, the optional namespace, in this case const:, may be dropped. This finds all PP nodes in the corpus. You can also search for the NP being dominated by the PP like this: cat=\"PP\" & cat=\"NP\" & #1 > #2 OR (using a shortcut): cat=\"PP\" > cat=\"NP\" To find all PP nodes directly dominating an adverb, you can combine a search for syntactic category and part-of-speech (pos) values (in this case \"RB\" for adverb). The query below gives the shortcut form: cat=\"PP\" > pos=\"RB\" The operator > signifies direct dominance , which must hold between the first and the second element. Once the Query Result tab is shown you may open the \"constituents\" annotation layer to see the corresponding tree. Note that since the context is set to a number of tokens left and right of the search term, the tree for the whole sentence may not be retrieved, though you can change the amount of tokens at the top of each search result, or for all search results in the Search Options tab. To make sure that the whole clause is always included, you may want to specifically search for the clause or sentence dominating the PP. To do so, specify the sentence in another element and use the indirect dominance ( >* ) operator: cat=\"ROOT\" >* cat=\"PP\" > pos=\"RB\" If the annotations in the corpus support it, you may also look for edge labels. Using the following query will find all adverbial modifier NPs, dominated by some node through an edge labeled ADV. Since we do not know anything about the modified node, we simply use the node element as a place holder. This element can match any node or annotation in the graph: node >[const:func=\"ADV\"] cat=\"NP\" Again, the namespace const: is optional and only important if there are multiple 'func' annotations. It is also possible to negate the label of the dominance edge as in the following query: cat >[func!=\"TMP\"] cat which finds all syntactic categories (value unspecified) dominating another syntactic category with a label other than \"TMP\".","breadcrumbs":"ANNIS Query Language (AQL) » Searching for Trees » Searching for Trees","id":"9","title":"Searching for Trees"}},"length":19,"save":true},"fields":["title","body","breadcrumbs"],"index":{"body":{"root":{"0":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}},"1":{",":{"1":{"0":{"0":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"0":{"df":2,"docs":{"16":{"tf":1.0},"6":{"tf":1.0}}},"df":1,"docs":{"6":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"0":{"0":{"df":1,"docs":{"6":{"tf":1.0}}},"df":1,"docs":{"3":{"tf":1.0}}},"1":{"3":{"1":{"8":{"6":{"1":{"1":{"'":{",":{"'":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"6":{"'":{",":{"'":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"c":{"'":{",":{"'":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"'":{",":{"'":{"1":{"1":{"3":{"1":{"8":{"6":{"8":{"8":{"'":{",":{"'":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"c":{"'":{",":{"'":{"a":{"df":0,"docs":{},"j":{"0":{"'":{",":{"'":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"c":{"'":{",":{"'":{"df":0,"docs":{},"j":{"df":0,"docs":{},"j":{"df":1,"docs":{"11":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{"5":{"7":{"'":{",":{"'":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"11":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"df":1,"docs":{"11":{"tf":1.0}}},"_":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{":":{"c":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":10,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":2.0},"17":{"tf":2.23606797749979},"3":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":2.6457513110645907},"7":{"tf":1.7320508075688772},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}},"2":{"0":{"df":1,"docs":{"2":{"tf":1.0}}},"_":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{":":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"w":{"df":0,"docs":{},"s":{"5":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"o":{"df":1,"docs":{"11":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":10,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.7320508075688772},"17":{"tf":2.0},"3":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":2.6457513110645907},"7":{"tf":1.7320508075688772},"8":{"tf":1.0},"9":{"tf":1.0}}},"3":{",":{"4":{"df":1,"docs":{"13":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":4,"docs":{"11":{"tf":1.4142135623730951},"13":{"tf":1.7320508075688772},"17":{"tf":2.23606797749979},"6":{"tf":1.0}}},"4":{"df":2,"docs":{"11":{"tf":1.7320508075688772},"13":{"tf":1.7320508075688772}}},"5":{"0":{"0":{"df":1,"docs":{"12":{"tf":1.0}}},"df":3,"docs":{"13":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"6":{"tf":1.0}}},"df":2,"docs":{"11":{"tf":1.0},"6":{"tf":1.0}}},"6":{"df":1,"docs":{"11":{"tf":2.8284271247461903}}},"7":{"df":1,"docs":{"11":{"tf":1.0}}},"9":{"df":1,"docs":{"11":{"tf":1.0}}},"_":{"=":{"_":{"df":2,"docs":{"13":{"tf":1.0},"7":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"_":{"df":2,"docs":{"13":{"tf":1.0},"7":{"tf":1.7320508075688772}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"l":{"_":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}},"o":{"_":{"df":2,"docs":{"13":{"tf":1.0},"17":{"tf":2.23606797749979}}},"df":0,"docs":{},"l":{"_":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}},"r":{"_":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"_":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}}},"a":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":6,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"13":{"tf":1.4142135623730951},"2":{"tf":1.0},"6":{"tf":1.4142135623730951},"8":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"c":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"13":{"tf":1.0}}}}},"df":0,"docs":{}},"d":{"d":{"df":4,"docs":{"11":{"tf":1.4142135623730951},"12":{"tf":1.7320508075688772},"4":{"tf":1.7320508075688772},"6":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":6,"docs":{"0":{"tf":1.0},"11":{"tf":1.0},"17":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0}}}}},"df":1,"docs":{"7":{"tf":1.0}},"j":{"a":{"c":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"v":{"df":1,"docs":{"9":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"b":{"df":1,"docs":{"9":{"tf":1.4142135623730951}},"i":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.0}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":2,"docs":{"0":{"tf":1.0},"13":{"tf":1.4142135623730951}}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":7,"docs":{"17":{"tf":1.0},"18":{"tf":1.4142135623730951},"2":{"tf":1.0},"3":{"tf":2.0},"4":{"tf":1.7320508075688772},"5":{"tf":1.0},"6":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"10":{"tf":1.0},"4":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":4,"docs":{"2":{"tf":1.0},"3":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.0}}}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":3,"docs":{"6":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"13":{"tf":1.0},"9":{"tf":1.0}}}}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"12":{"tf":3.0}}}},"z":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}}}},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"14":{"tf":1.0}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"10":{"tf":1.0}}}},"n":{"df":0,"docs":{},"i":{"df":9,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.7320508075688772},"14":{"tf":1.0},"15":{"tf":1.0},"2":{"tf":2.0},"3":{"tf":1.4142135623730951},"5":{"tf":2.0},"6":{"tf":1.0},"8":{"tf":1.0}},"s":{"3":{"df":2,"docs":{"14":{"tf":1.0},"2":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"t":{"df":11,"docs":{"0":{"tf":1.4142135623730951},"10":{"tf":2.449489742783178},"11":{"tf":4.242640687119285},"12":{"tf":1.7320508075688772},"13":{"tf":2.23606797749979},"3":{"tf":2.6457513110645907},"4":{"tf":2.449489742783178},"5":{"tf":2.0},"7":{"tf":4.898979485566356},"8":{"tf":2.0},"9":{"tf":2.6457513110645907}}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":5,"docs":{"10":{"tf":1.0},"13":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"6":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"df":6,"docs":{"11":{"tf":1.0},"13":{"tf":1.4142135623730951},"17":{"tf":1.0},"18":{"tf":1.0},"4":{"tf":1.0},"7":{"tf":2.23606797749979}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"10":{"tf":1.0}}}}}}}}},"q":{"df":0,"docs":{},"l":{"df":9,"docs":{"0":{"tf":1.0},"11":{"tf":1.4142135623730951},"12":{"tf":1.0},"13":{"tf":1.0},"15":{"tf":1.4142135623730951},"17":{"tf":1.0},"2":{"tf":1.4142135623730951},"4":{"tf":1.0},"5":{"tf":1.7320508075688772}}}},"r":{"a":{"b":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"10":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"10":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"a":{"df":3,"docs":{"1":{"tf":1.0},"11":{"tf":1.0},"13":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"13":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"4":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"4":{"tf":1.0}}}}}},"s":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":2,"docs":{"10":{"tf":1.0},"8":{"tf":1.7320508075688772}}}}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":5,"docs":{"11":{"tf":3.3166247903554},"13":{"tf":1.7320508075688772},"5":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"u":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"12":{"tf":1.0},"2":{"tf":1.0}}}},"df":0,"docs":{}}}},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":7,"docs":{"0":{"tf":1.0},"11":{"tf":1.4142135623730951},"14":{"tf":1.0},"2":{"tf":1.4142135623730951},"3":{"tf":1.0},"4":{"tf":1.0},"6":{"tf":1.0}}}}},"df":0,"docs":{}},"w":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}}},"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"10":{"tf":1.0},"5":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":3,"docs":{"0":{"tf":1.0},"3":{"tf":1.4142135623730951},"5":{"tf":1.0}}},"i":{"c":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}}}},"df":1,"docs":{"13":{"tf":2.0}},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"18":{"tf":1.0},"4":{"tf":1.0}}}}},"df":2,"docs":{"5":{"tf":1.0},"9":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":5,"docs":{"11":{"tf":1.0},"13":{"tf":1.0},"6":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}},"h":{"a":{"df":0,"docs":{},"v":{"df":1,"docs":{"11":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"15":{"tf":1.0},"2":{"tf":1.0}}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"12":{"tf":1.4142135623730951},"13":{"tf":1.0}}}},"w":{"df":8,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"12":{"tf":1.4142135623730951},"2":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.7320508075688772},"8":{"tf":1.7320508075688772},"9":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":12,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":2.0},"17":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"5":{"tf":2.449489742783178},"6":{"tf":2.0},"7":{"tf":1.0},"9":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"n":{"d":{"df":2,"docs":{"13":{"tf":1.4142135623730951},"5":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":5,"docs":{"10":{"tf":1.0},"13":{"tf":1.4142135623730951},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"x":{"df":5,"docs":{"11":{"tf":2.23606797749979},"12":{"tf":1.0},"2":{"tf":1.7320508075688772},"3":{"tf":1.0},"4":{"tf":1.4142135623730951}}}},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":3,"docs":{"11":{"tf":1.4142135623730951},"13":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"i":{"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"11":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}}}}},"w":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"0":{"tf":1.0},"3":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"4":{"tf":2.6457513110645907}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":5,"docs":{"11":{"tf":1.0},"12":{"tf":1.7320508075688772},"2":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":2.8284271247461903}}}}}}}},"c":{"a":{"df":0,"docs":{},"l":{"c":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":4,"docs":{"11":{"tf":1.0},"15":{"tf":1.0},"5":{"tf":1.0},"9":{"tf":1.0}}}},"n":{"df":0,"docs":{},"v":{"a":{"df":1,"docs":{"4":{"tf":1.0}},"n":{"df":1,"docs":{"4":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":1,"docs":{"8":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}}},"r":{"d":{"df":1,"docs":{"11":{"tf":1.0}}},"df":1,"docs":{"8":{"tf":1.4142135623730951}},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}}}},"t":{"df":1,"docs":{"8":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":5,"docs":{"10":{"tf":1.0},"6":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"t":{"=":{"\"":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":2,"docs":{"11":{"tf":1.0},"9":{"tf":1.7320508075688772}}}},"p":{"df":0,"docs":{},"p":{"df":1,"docs":{"9":{"tf":2.0}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"10":{"tf":1.0}}}}}}},"df":3,"docs":{"11":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"11":{"tf":1.0},"9":{"tf":1.7320508075688772}}}}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"10":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"10":{"tf":1.7320508075688772},"13":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"g":{"df":4,"docs":{"17":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.0},"9":{"tf":1.0}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":2.8284271247461903}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"14":{"tf":1.4142135623730951}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":2,"docs":{"15":{"tf":1.0},"4":{"tf":1.4142135623730951}}}}}},"i":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"4":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"k":{"df":6,"docs":{"10":{"tf":1.0},"12":{"tf":1.7320508075688772},"2":{"tf":1.7320508075688772},"3":{"tf":1.0},"4":{"tf":2.8284271247461903},"7":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"3":{"tf":1.7320508075688772}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}}}}},"m":{"a":{"df":1,"docs":{"11":{"tf":1.0}}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"12":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"5":{"tf":1.0}}},"m":{"a":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"14":{"tf":1.4142135623730951}}}}},"p":{"a":{"df":0,"docs":{},"t":{"df":5,"docs":{"15":{"tf":1.7320508075688772},"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"18":{"tf":1.0},"2":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"13":{"tf":1.0},"5":{"tf":1.0}}},"x":{"df":2,"docs":{"0":{"tf":1.0},"3":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"2":{"tf":1.4142135623730951}}}}}}},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"13":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"6":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"12":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"t":{":":{"c":{"a":{"df":0,"docs":{},"t":{"=":{"\"":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":1,"docs":{"9":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"=":{"\"":{"a":{"d":{"df":0,"docs":{},"v":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":1,"docs":{"9":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":2,"docs":{"0":{"tf":1.0},"9":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"7":{"tf":1.0}},"t":{"df":2,"docs":{"18":{"tf":1.4142135623730951},"8":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":5,"docs":{"10":{"tf":1.0},"3":{"tf":1.0},"7":{"tf":2.449489742783178},"8":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}},"x":{"df":0,"docs":{},"t":{"df":4,"docs":{"11":{"tf":1.0},"2":{"tf":1.7320508075688772},"3":{"tf":1.7320508075688772},"9":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"3":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"3":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"[":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"=":{"\"":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":1,"docs":{"10":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"0":{"tf":1.0},"10":{"tf":3.1622776601683795}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"10":{"tf":1.0}}}}}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"a":{"df":7,"docs":{"0":{"tf":1.0},"13":{"tf":1.4142135623730951},"2":{"tf":2.8284271247461903},"3":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"df":9,"docs":{"10":{"tf":1.7320508075688772},"12":{"tf":1.4142135623730951},"13":{"tf":1.7320508075688772},"2":{"tf":1.4142135623730951},"3":{"tf":1.4142135623730951},"4":{"tf":1.0},"6":{"tf":1.7320508075688772},"7":{"tf":3.0},"9":{"tf":2.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"8":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"10":{"tf":1.0},"13":{"tf":1.0}}}},"df":3,"docs":{"11":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"14":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"4":{"tf":2.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"v":{"df":1,"docs":{"12":{"tf":1.0}},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}}}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"2":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"11":{"tf":1.4142135623730951},"13":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.4142135623730951},"8":{"tf":1.0}}}}}}}}},"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":5,"docs":{"0":{"tf":1.0},"11":{"tf":1.0},"18":{"tf":1.4142135623730951},"2":{"tf":1.0},"4":{"tf":1.0}}},"df":0,"docs":{}}},"d":{"]":{"df":0,"docs":{},"o":{"df":1,"docs":{"6":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"11":{"tf":1.0},"5":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":5,"docs":{"13":{"tf":1.4142135623730951},"17":{"tf":1.0},"2":{"tf":1.4142135623730951},"3":{"tf":1.0},"6":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"4":{"tf":1.0},"5":{"tf":1.4142135623730951},"9":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"12":{"tf":1.0},"6":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"4":{"tf":1.0}}}}},"p":{"[":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"!":{"=":{"/":{".":{"*":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"=":{"\"":{"d":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":1,"docs":{"10":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"d":{"df":6,"docs":{"0":{"tf":1.0},"10":{"tf":1.7320508075688772},"16":{"tf":1.0},"3":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"s":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"13":{"tf":1.0},"14":{"tf":1.0}}}}}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"2":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"13":{"tf":1.0},"2":{"tf":1.0}}}}}}}}},"i":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"13":{"tf":1.4142135623730951},"15":{"tf":1.7320508075688772},"17":{"tf":2.0},"3":{"tf":1.0},"5":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.7320508075688772}}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"10":{"tf":1.4142135623730951},"13":{"tf":1.7320508075688772},"17":{"tf":1.0},"9":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":5,"docs":{"13":{"tf":1.4142135623730951},"17":{"tf":1.0},"4":{"tf":1.0},"6":{"tf":1.7320508075688772},"9":{"tf":1.0}}}}}},"df":0,"docs":{}}},"s":{"a":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":2,"docs":{"10":{"tf":2.0},"7":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":2,"docs":{"2":{"tf":1.0},"3":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"n":{"c":{"df":3,"docs":{"13":{"tf":2.6457513110645907},"16":{"tf":1.4142135623730951},"6":{"tf":2.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"4":{"tf":1.0}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"0":{"tf":1.0},"11":{"tf":1.0},"16":{"tf":1.0},"2":{"tf":1.7320508075688772},"6":{"tf":1.0}}}}}}}},"df":0,"docs":{},"g":{"df":2,"docs":{"11":{"tf":1.4142135623730951},"5":{"tf":1.0}},"s":{"/":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"/":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"11":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":8,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"13":{"tf":2.23606797749979},"14":{"tf":1.0},"4":{"tf":1.4142135623730951},"5":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":2.8284271247461903}}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"6":{"tf":1.0}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"n":{"df":2,"docs":{"2":{"tf":1.0},"4":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":3,"docs":{"4":{"tf":1.0},"7":{"tf":1.7320508075688772},"9":{"tf":1.0}}}}},"t":{"[":{"2":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"10":{"tf":1.0}}}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"g":{"df":11,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.4142135623730951},"13":{"tf":2.6457513110645907},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"3":{"tf":1.4142135623730951},"4":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}}}},"a":{"c":{"df":0,"docs":{},"h":{"df":8,"docs":{"10":{"tf":1.7320508075688772},"11":{"tf":2.23606797749979},"12":{"tf":1.0},"2":{"tf":1.4142135623730951},"3":{"tf":1.4142135623730951},"4":{"tf":1.0},"5":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"g":{"df":7,"docs":{"0":{"tf":1.4142135623730951},"10":{"tf":1.0},"13":{"tf":2.23606797749979},"4":{"tf":2.449489742783178},"5":{"tf":1.0},"8":{"tf":1.7320508075688772},"9":{"tf":1.7320508075688772}},"e":{"'":{"df":1,"docs":{"4":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":1,"docs":{"3":{"tf":1.0}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"16":{"tf":1.0},"18":{"tf":1.0}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":8,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"12":{"tf":1.4142135623730951},"13":{"tf":2.0},"5":{"tf":2.449489742783178},"6":{"tf":2.0},"7":{"tf":1.0},"9":{"tf":2.0}}}}}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"l":{"df":2,"docs":{"15":{"tf":1.0},"2":{"tf":1.0}}}}},"n":{"d":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"11":{"tf":1.7320508075688772},"12":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"4":{"tf":1.0},"6":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"12":{"tf":1.0},"2":{"tf":1.0}}},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"10":{"tf":2.0},"7":{"tf":2.6457513110645907}}},"y":{"!":{"=":{"\"":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"10":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"=":{"\"":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"10":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}}}},"l":{"a":{"c":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"6":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"18":{"tf":1.0},"2":{"tf":1.0}}}}}},"t":{"c":{"df":5,"docs":{"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"2":{"tf":1.0},"3":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}},"x":{"a":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"13":{"tf":1.0},"4":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"7":{"tf":1.0}}}},"p":{"df":0,"docs":{},"l":{"df":6,"docs":{"11":{"tf":2.0},"12":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951},"7":{"tf":2.6457513110645907},"8":{"tf":2.6457513110645907}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"11":{"tf":1.0}}},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}}},"l":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"6":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"11":{"tf":3.872983346207417},"12":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":7,"docs":{"10":{"tf":1.4142135623730951},"2":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.0},"6":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"8":{"tf":2.23606797749979}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"s":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"10":{"tf":1.0}}}}},"r":{"a":{"df":1,"docs":{"4":{"tf":1.0}}},"df":0,"docs":{}}}}},"f":{"df":1,"docs":{"8":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":2,"docs":{"2":{"tf":1.0},"4":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"12":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"2":{"tf":1.0},"6":{"tf":1.0}}}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"6":{"tf":1.0},"8":{"tf":1.0}}}},"d":{"df":7,"docs":{"10":{"tf":1.4142135623730951},"12":{"tf":1.0},"13":{"tf":1.0},"6":{"tf":1.7320508075688772},"7":{"tf":2.23606797749979},"8":{"tf":2.6457513110645907},"9":{"tf":2.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":11,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":2.23606797749979},"17":{"tf":1.0},"2":{"tf":1.0},"4":{"tf":2.0},"5":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"3":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":10,"docs":{"10":{"tf":1.7320508075688772},"11":{"tf":1.4142135623730951},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"6":{"tf":2.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772},"9":{"tf":1.4142135623730951}}}}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}}},"df":10,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"13":{"tf":1.0},"2":{"tf":2.23606797749979},"3":{"tf":1.0},"4":{"tf":1.7320508075688772},"6":{"tf":2.23606797749979},"7":{"tf":2.0},"8":{"tf":1.7320508075688772},"9":{"tf":1.0}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"10":{"tf":1.0},"2":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"6":{"tf":1.0}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"12":{"tf":2.449489742783178}}},"df":0,"docs":{}}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"7":{"tf":1.0}}}}},"n":{"c":{"!":{"=":{"\"":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"=":{"\"":{"d":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"a":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"4":{"tf":1.0},"9":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"10":{"tf":1.0},"13":{"tf":1.0},"9":{"tf":1.0}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"11":{"tf":1.0},"7":{"tf":1.0}}}}}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"12":{"tf":1.4142135623730951},"5":{"tf":1.0},"8":{"tf":1.0}}}},"r":{"df":1,"docs":{"11":{"tf":1.0}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":5,"docs":{"11":{"tf":1.0},"12":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}},"n":{"df":2,"docs":{"11":{"tf":1.0},"4":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"10":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":5,"docs":{"0":{"tf":1.0},"12":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0},"9":{"tf":1.0}},"i":{"c":{"df":1,"docs":{"4":{"tf":1.0}}},"df":0,"docs":{}}}},"y":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"6":{"tf":1.0}}}}}},"df":0,"docs":{}},"i":{"d":{"df":2,"docs":{"3":{"tf":1.0},"7":{"tf":1.0}},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"o":{"df":1,"docs":{"10":{"tf":1.7320508075688772}},"u":{"df":0,"docs":{},"p":{"df":2,"docs":{"12":{"tf":1.0},"2":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"m":{"df":5,"docs":{"10":{"tf":1.7320508075688772},"12":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":2.449489742783178},"9":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"13":{"tf":1.0},"4":{"tf":1.0}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"13":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"7":{"tf":2.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"df":1,"docs":{"0":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"11":{"tf":1.0},"5":{"tf":1.0},"9":{"tf":1.0}},"i":{"df":1,"docs":{"13":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}}}}}}},"t":{"df":2,"docs":{"11":{"tf":1.4142135623730951},"3":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"d":{"df":4,"docs":{"13":{"tf":1.4142135623730951},"2":{"tf":1.0},"5":{"tf":1.0},"9":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.0}}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"10":{"tf":1.0},"3":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{":":{"/":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":1,"docs":{"0":{"tf":1.0}}}}}}},"df":0,"docs":{},"w":{"df":0,"docs":{},"w":{"df":0,"docs":{},"w":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"s":{":":{"/":{"/":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"#":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"3":{"tf":1.0}}}}}}}}}}},"i":{".":{"df":3,"docs":{"13":{"tf":1.4142135623730951},"4":{"tf":1.0},"8":{"tf":1.0}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"2":{"tf":1.0},"3":{"tf":1.0},"6":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"13":{"tf":2.23606797749979},"7":{"tf":1.0}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"13":{"tf":1.0},"14":{"tf":1.0}}}}}}}},"m":{"a":{"df":0,"docs":{},"g":{"df":4,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"2":{"tf":1.0},"4":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"4":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"14":{"tf":1.0},"8":{"tf":1.0}}}}}}},"i":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"1":{"tf":1.0},"11":{"tf":1.0},"9":{"tf":1.0}}}}}}},"n":{"[":{"1":{"df":1,"docs":{"11":{"tf":1.0}}},"5":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":5,"docs":{"11":{"tf":1.0},"13":{"tf":1.0},"17":{"tf":1.4142135623730951},"7":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"13":{"tf":2.23606797749979},"16":{"tf":1.4142135623730951},"6":{"tf":1.0},"9":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"13":{"tf":1.0},"6":{"tf":1.0}}}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"u":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":4,"docs":{"12":{"tf":1.0},"3":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"=":{"\"":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"7":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"12":{"tf":1.0},"3":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"d":{"df":3,"docs":{"6":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}},"f":{"a":{"c":{"df":4,"docs":{"0":{"tf":1.0},"1":{"tf":1.7320508075688772},"12":{"tf":1.0},"2":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"n":{"df":1,"docs":{"11":{"tf":1.7320508075688772}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}},"t":{"'":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"3":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"3":{"tf":1.0}}}}}}}},"j":{"df":0,"docs":{},"j":{"df":1,"docs":{"11":{"tf":1.0}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":2,"docs":{"11":{"tf":1.0},"3":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"9":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"l":{"a":{"b":{"df":0,"docs":{},"e":{"df":1,"docs":{"5":{"tf":1.0}},"l":{"[":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"=":{"\"":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"13":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":4,"docs":{"13":{"tf":2.6457513110645907},"4":{"tf":1.7320508075688772},"8":{"tf":1.0},"9":{"tf":2.0}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"0":{"tf":1.0},"2":{"tf":1.7320508075688772},"5":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"11":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"10":{"tf":1.0},"13":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"y":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{",":{"3":{",":{"4":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":8,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"11":{"tf":1.7320508075688772},"13":{"tf":2.449489742783178},"2":{"tf":1.0},"3":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":1.0}}}}}},"df":1,"docs":{"14":{"tf":1.0}},"e":{"a":{"d":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"0":{"tf":1.0},"11":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":6,"docs":{"1":{"tf":1.0},"13":{"tf":1.7320508075688772},"14":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"4":{"tf":1.7320508075688772},"9":{"tf":1.0}}}},"g":{"a":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"m":{"a":{"!":{"=":{"\"":{"b":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"=":{"\"":{"b":{"df":2,"docs":{"18":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951}}},"df":0,"docs":{},"g":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}}},"/":{"(":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"|":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"v":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":5,"docs":{"11":{"tf":1.4142135623730951},"12":{"tf":1.7320508075688772},"3":{"tf":1.0},"7":{"tf":2.0},"8":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"13":{"tf":1.4142135623730951},"14":{"tf":1.0},"16":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"3":{"tf":1.0}}},"df":1,"docs":{"3":{"tf":1.4142135623730951}}}}},"x":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"10":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"i":{"b":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.4142135623730951}}}}},"n":{"df":0,"docs":{},"e":{"df":3,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"2":{"tf":1.0}}},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"5":{"tf":1.0}}}}}}},"k":{"df":1,"docs":{"4":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"t":{"df":7,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"2":{"tf":1.4142135623730951},"3":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0}}}}},"o":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}},"t":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"10":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"k":{"df":3,"docs":{"11":{"tf":1.0},"6":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"m":{"a":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"11":{"tf":1.4142135623730951}},"i":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"11":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"3":{"tf":1.0}}}},"k":{"df":0,"docs":{},"e":{"df":3,"docs":{"2":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}},"n":{"df":0,"docs":{},"i":{"df":2,"docs":{"2":{"tf":1.0},"7":{"tf":1.0}}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"k":{"df":5,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"3":{"tf":1.0},"6":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":9,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":2.6457513110645907},"2":{"tf":1.7320508075688772},"3":{"tf":1.7320508075688772},"4":{"tf":1.4142135623730951},"6":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":3,"docs":{"13":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"3":{"tf":1.0}}}}}}}},"df":1,"docs":{"13":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"n":{"df":5,"docs":{"11":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":2.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":3,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"3":{"tf":1.0}}}},"t":{"a":{":":{":":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"=":{"\"":{"2":{"0":{"df":1,"docs":{"18":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"o":{"c":{"=":{"\"":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":3,"docs":{"11":{"tf":2.23606797749979},"6":{"tf":1.7320508075688772},"7":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"18":{"tf":2.0},"6":{"tf":1.0}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"11":{"tf":1.0}},"s":{"=":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"1":{",":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"2":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{",":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{";":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"=":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"11":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"i":{"d":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"4":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"d":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":5,"docs":{"15":{"tf":2.0},"16":{"tf":1.4142135623730951},"17":{"tf":1.7320508075688772},"18":{"tf":1.4142135623730951},"2":{"tf":1.0}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":3,"docs":{"2":{"tf":1.0},"4":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"11":{"tf":1.0}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"11":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":8,"docs":{"0":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"2":{"tf":1.4142135623730951},"3":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.7320508075688772},"9":{"tf":1.0}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"3":{"tf":1.0}}}}},"u":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"0":{"tf":1.4142135623730951}},"p":{"df":0,"docs":{},"l":{"df":9,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"13":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"3":{"tf":1.0},"4":{"tf":1.4142135623730951},"6":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":1.0}}}}}}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":2.449489742783178}}}},",":{"df":0,"docs":{},"m":{"df":1,"docs":{"13":{"tf":2.23606797749979}}}},"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":7,"docs":{"11":{"tf":2.23606797749979},"12":{"tf":1.0},"2":{"tf":1.4142135623730951},"3":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"5":{"tf":1.0},"7":{"tf":2.449489742783178}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":6,"docs":{"10":{"tf":1.0},"14":{"tf":1.0},"3":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":2.23606797749979},"9":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"df":2,"docs":{"13":{"tf":1.0},"8":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"d":{"df":3,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"17":{"tf":1.0}}},"df":0,"docs":{}},"g":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"7":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}},"w":{"df":5,"docs":{"12":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"2":{"tf":1.0},"4":{"tf":1.0},"7":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}}},"x":{"df":0,"docs":{},"t":{"df":4,"docs":{"12":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.0},"6":{"tf":1.0}}}}},"n":{"]":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}}}},"df":1,"docs":{"11":{"tf":1.0}}},"o":{"d":{"df":0,"docs":{},"e":{"df":9,"docs":{"0":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.7320508075688772},"13":{"tf":2.449489742783178},"14":{"tf":2.23606797749979},"17":{"tf":3.0},"4":{"tf":4.795831523312719},"5":{"tf":2.0},"9":{"tf":2.8284271247461903}}}},"df":0,"docs":{},"n":{"df":7,"docs":{"10":{"tf":1.0},"13":{"tf":1.0},"17":{"tf":2.0},"4":{"tf":1.4142135623730951},"5":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.4142135623730951}},"e":{"df":1,"docs":{"9":{"tf":1.0}}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"16":{"tf":1.0},"18":{"tf":1.0},"3":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":9,"docs":{"10":{"tf":1.0},"11":{"tf":1.7320508075688772},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"9":{"tf":1.0}}},"h":{"df":1,"docs":{"11":{"tf":1.0}}}},"w":{"df":1,"docs":{"8":{"tf":1.0}}}},"p":{"[":{"1":{"df":1,"docs":{"11":{"tf":1.0}}},"2":{"df":1,"docs":{"11":{"tf":1.0}}},"3":{"df":1,"docs":{"11":{"tf":1.0}}},"4":{"df":1,"docs":{"11":{"tf":1.0}}},"6":{"df":1,"docs":{"11":{"tf":1.0}}},"7":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":2,"docs":{"11":{"tf":1.0},"9":{"tf":1.4142135623730951}},"s":{"[":{"6":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"11":{"tf":1.4142135623730951},"12":{"tf":1.0},"2":{"tf":1.0},"5":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}},"s":{"=":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"11":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"6":{"tf":1.0}}}}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":1,"docs":{"8":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"10":{"tf":1.7320508075688772},"13":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}}},"c":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"10":{"tf":1.0}},"r":{"df":1,"docs":{"8":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"b":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}}}},"df":1,"docs":{"8":{"tf":1.4142135623730951}},"l":{"d":{"df":1,"docs":{"15":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"16":{"tf":1.0},"2":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"c":{"df":4,"docs":{"2":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0},"9":{"tf":1.0}}},"df":9,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"13":{"tf":1.0},"2":{"tf":1.0},"4":{"tf":1.0},"6":{"tf":1.7320508075688772},"7":{"tf":1.7320508075688772},"8":{"tf":1.7320508075688772},"9":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":8,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.4142135623730951},"2":{"tf":1.0},"4":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":1.0}}},"r":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":11,"docs":{"10":{"tf":1.4142135623730951},"13":{"tf":2.23606797749979},"14":{"tf":1.7320508075688772},"17":{"tf":2.0},"18":{"tf":1.0},"4":{"tf":2.23606797749979},"5":{"tf":2.23606797749979},"6":{"tf":2.23606797749979},"7":{"tf":1.7320508075688772},"8":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":7,"docs":{"11":{"tf":1.7320508075688772},"15":{"tf":1.0},"2":{"tf":2.23606797749979},"5":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.7320508075688772}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"11":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"6":{"tf":1.0},"7":{"tf":1.0}}}}},"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.0}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":2.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"2":{"tf":1.0},"3":{"tf":1.0}},"l":{"a":{"df":0,"docs":{},"p":{"df":5,"docs":{"10":{"tf":1.4142135623730951},"13":{"tf":1.0},"14":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"p":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":2,"docs":{"2":{"tf":1.0},"3":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"12":{"tf":1.0},"5":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":2.449489742783178}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}},"t":{"df":11,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":2.0},"12":{"tf":1.7320508075688772},"13":{"tf":1.4142135623730951},"18":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.7320508075688772},"8":{"tf":1.0},"9":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"11":{"tf":1.4142135623730951},"17":{"tf":1.0},"2":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":2,"docs":{"12":{"tf":1.4142135623730951},"16":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"6":{"tf":1.0},"8":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"10":{"tf":2.23606797749979},"7":{"tf":1.4142135623730951}}}}}}},"h":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":2,"docs":{"7":{"tf":1.0},"9":{"tf":1.0}}}}},"df":0,"docs":{}}},"i":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":2,"docs":{"6":{"tf":1.0},"8":{"tf":1.0}}}}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":3,"docs":{"10":{"tf":1.0},"6":{"tf":1.0},"9":{"tf":1.0}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"u":{"df":2,"docs":{"3":{"tf":1.0},"8":{"tf":1.0}}}},"o":{"df":5,"docs":{"11":{"tf":1.4142135623730951},"12":{"tf":1.0},"7":{"tf":1.7320508075688772},"8":{"tf":1.0},"9":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"10":{"tf":3.3166247903554},"13":{"tf":1.4142135623730951},"8":{"tf":1.0},"9":{"tf":1.0}}}}},"s":{"=":{"\"":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":1,"docs":{"18":{"tf":1.4142135623730951}}}},"r":{"b":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"/":{"df":0,"docs":{},"v":{"df":0,"docs":{},"v":{"[":{"df":0,"docs":{},"p":{"df":0,"docs":{},"z":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}}}},"df":2,"docs":{"7":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"2":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.0},"7":{"tf":1.4142135623730951}}},"x":{"df":1,"docs":{"8":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":9,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"2":{"tf":1.4142135623730951},"4":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":2.23606797749979},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"7":{"tf":1.0}}}}}}}},"p":{"[":{"1":{"df":1,"docs":{"11":{"tf":1.0}}},"5":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"9":{"tf":2.0}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"d":{"df":5,"docs":{"10":{"tf":1.0},"13":{"tf":2.449489742783178},"16":{"tf":1.4142135623730951},"6":{"tf":1.7320508075688772},"8":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"12":{"tf":1.0}}}}},"s":{"df":3,"docs":{"11":{"tf":1.0},"2":{"tf":1.0},"6":{"tf":1.0}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"15":{"tf":1.0}}}}}}},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"11":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"12":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"3":{"tf":1.0}}},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"3":{"tf":1.0}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":15,"docs":{"0":{"tf":1.0},"10":{"tf":2.449489742783178},"11":{"tf":1.7320508075688772},"12":{"tf":2.6457513110645907},"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951},"2":{"tf":3.0},"3":{"tf":1.4142135623730951},"4":{"tf":3.0},"5":{"tf":1.7320508075688772},"6":{"tf":1.7320508075688772},"7":{"tf":2.0},"8":{"tf":1.4142135623730951},"9":{"tf":2.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"y":{"df":1,"docs":{"4":{"tf":1.0}}}},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"15":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"4":{"tf":1.0},"6":{"tf":1.4142135623730951},"8":{"tf":1.0}}}},"df":1,"docs":{"5":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"2":{"tf":1.0}}}}},"df":0,"docs":{},"g":{"df":2,"docs":{"13":{"tf":1.0},"6":{"tf":1.0}}}}},"b":{"df":1,"docs":{"9":{"tf":1.0}}},"df":1,"docs":{"14":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"d":{"df":2,"docs":{"10":{"tf":1.0},"3":{"tf":1.0}}},"df":0,"docs":{},"f":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"=":{"\"":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"7":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":2,"docs":{"10":{"tf":1.0},"7":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"10":{"tf":2.23606797749979},"17":{"tf":1.4142135623730951},"3":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":2.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"17":{"tf":2.23606797749979}}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"8":{"tf":1.0}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"3":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":4,"docs":{"4":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":2.449489742783178}}}},"df":0,"docs":{}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":6,"docs":{"10":{"tf":3.3166247903554},"11":{"tf":1.0},"13":{"tf":1.7320508075688772},"5":{"tf":2.0},"6":{"tf":1.0},"9":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":4,"docs":{"10":{"tf":1.0},"13":{"tf":1.4142135623730951},"4":{"tf":1.0},"7":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"2":{"tf":1.0}}}},"i":{"df":1,"docs":{"8":{"tf":1.0}}}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"l":{"a":{"c":{"df":3,"docs":{"12":{"tf":1.0},"18":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":1,"docs":{"4":{"tf":1.0}}}},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":2,"docs":{"11":{"tf":1.0},"7":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"5":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":11,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"11":{"tf":2.8284271247461903},"12":{"tf":1.4142135623730951},"18":{"tf":1.0},"2":{"tf":2.0},"3":{"tf":2.6457513110645907},"4":{"tf":1.0},"6":{"tf":1.4142135623730951},"8":{"tf":1.0},"9":{"tf":1.7320508075688772}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":3,"docs":{"11":{"tf":1.4142135623730951},"2":{"tf":1.0},"9":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"16":{"tf":1.0}}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"0":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":6,"docs":{"1":{"tf":1.0},"13":{"tf":1.7320508075688772},"14":{"tf":1.4142135623730951},"2":{"tf":1.0},"4":{"tf":1.0},"9":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}},"w":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"8":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"s":{"[":{"1":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":5,"docs":{"13":{"tf":2.23606797749979},"17":{"tf":1.7320508075688772},"4":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.7320508075688772}}}}},"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"11":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}}}}}}}}},"df":1,"docs":{"14":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":15,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.0},"10":{"tf":2.0},"11":{"tf":2.6457513110645907},"12":{"tf":1.4142135623730951},"13":{"tf":1.0},"15":{"tf":1.0},"2":{"tf":3.0},"3":{"tf":2.449489742783178},"4":{"tf":2.23606797749979},"5":{"tf":1.7320508075688772},"6":{"tf":3.1622776601683795},"7":{"tf":2.6457513110645907},"8":{"tf":3.4641016151377544},"9":{"tf":3.3166247903554}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"13":{"tf":1.0}}}}},"df":9,"docs":{"10":{"tf":1.0},"12":{"tf":1.0},"17":{"tf":1.4142135623730951},"4":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"10":{"tf":2.23606797749979}}}}}},"df":6,"docs":{"10":{"tf":1.0},"2":{"tf":1.0},"4":{"tf":1.7320508075688772},"5":{"tf":1.0},"8":{"tf":1.7320508075688772},"9":{"tf":1.7320508075688772}},"m":{"df":1,"docs":{"18":{"tf":1.0}}}},"g":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"13":{"tf":2.0},"2":{"tf":1.0},"3":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":7,"docs":{"11":{"tf":1.4142135623730951},"12":{"tf":1.0},"2":{"tf":2.23606797749979},"3":{"tf":1.0},"4":{"tf":1.7320508075688772},"6":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"11":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"6":{"tf":1.0},"7":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"6":{"tf":1.0},"9":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"11":{"tf":2.6457513110645907},"6":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":3,"docs":{"11":{"tf":1.0},"2":{"tf":1.0},"9":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"1":{"tf":1.0},"11":{"tf":1.0},"2":{"tf":1.0}}}}}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":5,"docs":{"10":{"tf":1.0},"6":{"tf":1.7320508075688772},"7":{"tf":1.4142135623730951},"8":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"w":{"df":5,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"12":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.7320508075688772}},"n":{"df":5,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"2":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":6,"docs":{"1":{"tf":1.4142135623730951},"13":{"tf":1.0},"14":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"10":{"tf":1.0}}},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"6":{"tf":1.0}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":4,"docs":{"6":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"9":{"tf":1.0}},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}}}}}}}}}}},"i":{"df":6,"docs":{"11":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}}},"z":{"df":0,"docs":{},"e":{"df":1,"docs":{"13":{"tf":1.0}}}}},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":3,"docs":{"11":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"15":{"tf":1.0},"8":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"11":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"2":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":6,"docs":{"0":{"tf":1.0},"11":{"tf":1.4142135623730951},"13":{"tf":2.23606797749979},"14":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":2.6457513110645907}}}},"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":3,"docs":{"13":{"tf":2.0},"5":{"tf":1.0},"9":{"tf":1.0}},"i":{"df":11,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":2.23606797749979},"12":{"tf":1.0},"13":{"tf":3.0},"14":{"tf":1.4142135623730951},"4":{"tf":2.0},"5":{"tf":2.0},"6":{"tf":1.7320508075688772},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"h":{"df":7,"docs":{"10":{"tf":1.0},"11":{"tf":2.0},"12":{"tf":1.7320508075688772},"3":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":1,"docs":{"11":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"11":{"tf":1.4142135623730951},"8":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"d":{"df":3,"docs":{"15":{"tf":1.0},"17":{"tf":1.4142135623730951},"8":{"tf":1.0}}},"df":0,"docs":{}}},"df":3,"docs":{"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"'":{",":{"'":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"'":{",":{"'":{"1":{"1":{"3":{"1":{"8":{"6":{"1":{"6":{"'":{",":{"'":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{",":{"'":{"a":{"df":0,"docs":{},"j":{"0":{"'":{",":{"'":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{",":{"'":{"df":0,"docs":{},"j":{"df":0,"docs":{},"j":{"df":1,"docs":{"11":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"11":{"tf":1.4142135623730951}}},"u":{"df":1,"docs":{"2":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"18":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":3,"docs":{"11":{"tf":2.8284271247461903},"6":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"0":{"tf":1.7320508075688772},"7":{"tf":1.0},"9":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"u":{"b":{"df":1,"docs":{"13":{"tf":1.7320508075688772}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"h":{"df":9,"docs":{"0":{"tf":1.0},"10":{"tf":1.4142135623730951},"11":{"tf":1.4142135623730951},"2":{"tf":1.0},"3":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"2":{"tf":1.0},"9":{"tf":1.0}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"2":{"tf":1.0},"4":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"2":{"tf":1.0},"3":{"tf":1.0}}}},"df":0,"docs":{}}}},"y":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":2,"docs":{"4":{"tf":1.4142135623730951},"8":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"9":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"x":{"df":5,"docs":{"0":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":1.0},"8":{"tf":1.7320508075688772},"9":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"a":{"b":{"df":6,"docs":{"1":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"2":{"tf":1.0},"4":{"tf":1.0},"9":{"tf":1.4142135623730951}},"l":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":2,"docs":{"11":{"tf":1.0},"8":{"tf":1.0}}}},"df":1,"docs":{"8":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":2,"docs":{"10":{"tf":1.0},"7":{"tf":1.0}}}},"r":{"df":0,"docs":{},"m":{"df":3,"docs":{"6":{"tf":1.4142135623730951},"8":{"tf":1.0},"9":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":5,"docs":{"10":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"5":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}},"x":{"df":0,"docs":{},"t":{"df":6,"docs":{"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"16":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.7320508075688772},"5":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"11":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":4,"docs":{"11":{"tf":1.0},"4":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"9":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{"c":{"a":{"df":0,"docs":{},"t":{"=":{"\"":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":1,"docs":{"5":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"e":{"df":2,"docs":{"4":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"9":{"tf":1.0}}}},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"5":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"3":{"tf":1.0}}}}},"k":{"!":{"=":{"\"":{"b":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"=":{"\"":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"/":{"c":{"a":{"df":1,"docs":{"8":{"tf":1.0}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"[":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":8,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.4142135623730951},"12":{"tf":1.7320508075688772},"16":{"tf":2.0},"4":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"12":{"tf":1.0}}},"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":13,"docs":{"10":{"tf":1.0},"11":{"tf":3.3166247903554},"12":{"tf":2.0},"13":{"tf":3.0},"14":{"tf":1.0},"2":{"tf":1.4142135623730951},"3":{"tf":2.0},"4":{"tf":1.4142135623730951},"5":{"tf":1.7320508075688772},"6":{"tf":2.23606797749979},"7":{"tf":2.0},"8":{"tf":1.0},"9":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}}}}}}}}},"o":{"df":0,"docs":{},"l":{"b":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"3":{"tf":1.7320508075688772},"4":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"11":{"tf":1.0}},"s":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"/":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"p":{"df":4,"docs":{"2":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":6,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"3":{"tf":1.0},"5":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":2.0}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"11":{"tf":1.4142135623730951}},"s":{"'":{",":{"'":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"'":{",":{"'":{"1":{"1":{"3":{"1":{"8":{"7":{"6":{"0":{"'":{",":{"'":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"c":{"'":{",":{"'":{"a":{"df":0,"docs":{},"j":{"0":{"'":{",":{"'":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"c":{"'":{",":{"'":{"df":0,"docs":{},"j":{"df":0,"docs":{},"j":{"df":1,"docs":{"11":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"13":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"11":{"tf":1.0}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"2":{"tf":1.0}}}}}}},"w":{"df":0,"docs":{},"o":{"df":4,"docs":{"10":{"tf":1.7320508075688772},"12":{"tf":1.0},"13":{"tf":2.0},"6":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"!":{"=":{"\"":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"7":{"tf":1.0}}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"=":{"\"":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"6":{"tf":1.0}}}}}}}}}}}},"df":0,"docs":{}},"df":6,"docs":{"10":{"tf":1.7320508075688772},"13":{"tf":1.0},"2":{"tf":1.0},"4":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"8":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"10":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"3":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"10":{"tf":2.0}}}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"4":{"tf":1.0},"5":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"df":1,"docs":{"3":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}}}},"i":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}}}}}}},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"4":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":3,"docs":{"2":{"tf":1.0},"3":{"tf":1.0},"6":{"tf":1.0}}},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"3":{"tf":1.0}}}},"s":{"df":13,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.0},"10":{"tf":2.8284271247461903},"11":{"tf":2.6457513110645907},"13":{"tf":2.0},"2":{"tf":1.7320508075688772},"3":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"6":{"tf":2.23606797749979},"7":{"tf":2.6457513110645907},"8":{"tf":3.3166247903554},"9":{"tf":2.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"1":{"tf":1.0},"11":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"2":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"u":{"df":7,"docs":{"12":{"tf":2.0},"13":{"tf":2.0},"4":{"tf":1.7320508075688772},"5":{"tf":1.4142135623730951},"7":{"tf":1.7320508075688772},"8":{"tf":1.0},"9":{"tf":1.7320508075688772}}}},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"7":{"tf":1.0}},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"0":{"tf":1.0},"8":{"tf":1.0}}}}}}}},"b":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"b":{"df":3,"docs":{"10":{"tf":1.4142135623730951},"7":{"tf":2.0},"8":{"tf":2.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"14":{"tf":1.4142135623730951},"15":{"tf":1.0},"16":{"tf":1.0},"2":{"tf":1.0}}}}}}}},"h":{"df":1,"docs":{"8":{"tf":1.0}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":5,"docs":{"10":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"3":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"0":{"tf":1.0},"10":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"3":{"tf":1.0}}}},"df":0,"docs":{}}}},"p":{"[":{"1":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"v":{"d":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}},"df":2,"docs":{"7":{"tf":1.4142135623730951},"8":{"tf":2.0}},"g":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}},"p":{"df":2,"docs":{"10":{"tf":1.0},"8":{"tf":1.0}}},"z":{"df":2,"docs":{"10":{"tf":1.0},"8":{"tf":1.0}}}}},"w":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"6":{"tf":1.0},"9":{"tf":1.0}}}},"y":{"df":2,"docs":{"10":{"tf":1.0},"4":{"tf":1.0}}}},"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"d":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"k":{"a":{"df":1,"docs":{"11":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.7320508075688772}}}}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"10":{"tf":1.0},"12":{"tf":1.0},"5":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"10":{"tf":1.0},"7":{"tf":1.4142135623730951}}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":2,"docs":{"10":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"e":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"11":{"tf":1.0}}}}}}},"l":{"d":{"c":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"4":{"tf":1.0},"8":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{}}}},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":3,"docs":{"2":{"tf":1.0},"3":{"tf":2.0},"6":{"tf":1.0}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"14":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"7":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"r":{"d":{"df":6,"docs":{"2":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.0},"6":{"tf":2.0},"7":{"tf":1.0},"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"x":{":":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"=":{"df":0,"docs":{},"n":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"=":{"df":0,"docs":{},"n":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"8":{"tf":1.7320508075688772}}}}}}}},"breadcrumbs":{"root":{"0":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}},"1":{",":{"1":{"0":{"0":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"0":{"df":2,"docs":{"16":{"tf":1.0},"6":{"tf":1.0}}},"df":1,"docs":{"6":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"0":{"0":{"df":1,"docs":{"6":{"tf":1.0}}},"df":1,"docs":{"3":{"tf":1.0}}},"1":{"3":{"1":{"8":{"6":{"1":{"1":{"'":{",":{"'":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"6":{"'":{",":{"'":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"c":{"'":{",":{"'":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"'":{",":{"'":{"1":{"1":{"3":{"1":{"8":{"6":{"8":{"8":{"'":{",":{"'":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"c":{"'":{",":{"'":{"a":{"df":0,"docs":{},"j":{"0":{"'":{",":{"'":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"c":{"'":{",":{"'":{"df":0,"docs":{},"j":{"df":0,"docs":{},"j":{"df":1,"docs":{"11":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{"5":{"7":{"'":{",":{"'":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"11":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"df":1,"docs":{"11":{"tf":1.0}}},"_":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{":":{"c":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":10,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":2.0},"17":{"tf":2.23606797749979},"3":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":2.6457513110645907},"7":{"tf":1.7320508075688772},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}},"2":{"0":{"df":1,"docs":{"2":{"tf":1.0}}},"_":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{":":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"w":{"df":0,"docs":{},"s":{"5":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"o":{"df":1,"docs":{"11":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":10,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.7320508075688772},"17":{"tf":2.0},"3":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":2.6457513110645907},"7":{"tf":1.7320508075688772},"8":{"tf":1.0},"9":{"tf":1.0}}},"3":{",":{"4":{"df":1,"docs":{"13":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":4,"docs":{"11":{"tf":1.4142135623730951},"13":{"tf":1.7320508075688772},"17":{"tf":2.23606797749979},"6":{"tf":1.0}}},"4":{"df":2,"docs":{"11":{"tf":1.7320508075688772},"13":{"tf":1.7320508075688772}}},"5":{"0":{"0":{"df":1,"docs":{"12":{"tf":1.0}}},"df":3,"docs":{"13":{"tf":1.4142135623730951},"16":{"tf":1.7320508075688772},"6":{"tf":1.0}}},"df":2,"docs":{"11":{"tf":1.0},"6":{"tf":1.0}}},"6":{"df":1,"docs":{"11":{"tf":2.8284271247461903}}},"7":{"df":1,"docs":{"11":{"tf":1.0}}},"9":{"df":1,"docs":{"11":{"tf":1.0}}},"_":{"=":{"_":{"df":2,"docs":{"13":{"tf":1.0},"7":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"_":{"df":2,"docs":{"13":{"tf":1.0},"7":{"tf":1.7320508075688772}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"l":{"_":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}},"o":{"_":{"df":2,"docs":{"13":{"tf":1.0},"17":{"tf":2.23606797749979}}},"df":0,"docs":{},"l":{"_":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}},"r":{"_":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"_":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}}},"a":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":6,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"13":{"tf":1.4142135623730951},"2":{"tf":1.0},"6":{"tf":1.4142135623730951},"8":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"c":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"13":{"tf":1.0}}}}},"df":0,"docs":{}},"d":{"d":{"df":4,"docs":{"11":{"tf":1.4142135623730951},"12":{"tf":1.7320508075688772},"4":{"tf":1.7320508075688772},"6":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":6,"docs":{"0":{"tf":1.0},"11":{"tf":1.0},"17":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0}}}}},"df":1,"docs":{"7":{"tf":1.0}},"j":{"a":{"c":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"v":{"df":1,"docs":{"9":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"b":{"df":1,"docs":{"9":{"tf":1.4142135623730951}},"i":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.0}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":2,"docs":{"0":{"tf":1.0},"13":{"tf":1.4142135623730951}}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":7,"docs":{"17":{"tf":1.0},"18":{"tf":1.7320508075688772},"2":{"tf":1.0},"3":{"tf":2.0},"4":{"tf":1.7320508075688772},"5":{"tf":1.0},"6":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"10":{"tf":1.0},"4":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":4,"docs":{"2":{"tf":1.0},"3":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.0}}}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":3,"docs":{"6":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"13":{"tf":1.0},"9":{"tf":1.0}}}}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"12":{"tf":3.3166247903554}}}},"z":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}}}},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"14":{"tf":1.0}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"10":{"tf":1.0}}}},"n":{"df":0,"docs":{},"i":{"df":19,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":2.23606797749979},"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":2.23606797749979},"3":{"tf":1.7320508075688772},"4":{"tf":1.0},"5":{"tf":2.449489742783178},"6":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}},"s":{"3":{"df":2,"docs":{"14":{"tf":1.0},"2":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"t":{"df":11,"docs":{"0":{"tf":1.4142135623730951},"10":{"tf":2.449489742783178},"11":{"tf":4.242640687119285},"12":{"tf":1.7320508075688772},"13":{"tf":2.23606797749979},"3":{"tf":2.6457513110645907},"4":{"tf":2.449489742783178},"5":{"tf":2.0},"7":{"tf":5.0990195135927845},"8":{"tf":2.0},"9":{"tf":2.6457513110645907}}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":5,"docs":{"10":{"tf":1.0},"13":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"6":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"df":6,"docs":{"11":{"tf":1.0},"13":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"18":{"tf":1.0},"4":{"tf":1.0},"7":{"tf":2.23606797749979}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"10":{"tf":1.0}}}}}}}}},"q":{"df":0,"docs":{},"l":{"df":17,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"11":{"tf":1.7320508075688772},"12":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":1.7320508075688772},"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"18":{"tf":1.0},"2":{"tf":1.4142135623730951},"4":{"tf":1.0},"5":{"tf":2.23606797749979},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}},"r":{"a":{"b":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"10":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"10":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"a":{"df":3,"docs":{"1":{"tf":1.0},"11":{"tf":1.0},"13":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"13":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"4":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"4":{"tf":1.0}}}}}},"s":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":2,"docs":{"10":{"tf":1.0},"8":{"tf":1.7320508075688772}}}}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":5,"docs":{"11":{"tf":3.3166247903554},"13":{"tf":1.7320508075688772},"5":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"u":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"12":{"tf":1.0},"2":{"tf":1.0}}}},"df":0,"docs":{}}}},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":7,"docs":{"0":{"tf":1.0},"11":{"tf":1.4142135623730951},"14":{"tf":1.0},"2":{"tf":1.4142135623730951},"3":{"tf":1.0},"4":{"tf":1.0},"6":{"tf":1.0}}}}},"df":0,"docs":{}},"w":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}}},"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"10":{"tf":1.0},"5":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":3,"docs":{"0":{"tf":1.0},"3":{"tf":1.4142135623730951},"5":{"tf":1.0}}},"i":{"c":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}}}},"df":1,"docs":{"13":{"tf":2.0}},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"18":{"tf":1.0},"4":{"tf":1.0}}}}},"df":2,"docs":{"5":{"tf":1.0},"9":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":5,"docs":{"11":{"tf":1.0},"13":{"tf":1.0},"6":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}},"h":{"a":{"df":0,"docs":{},"v":{"df":1,"docs":{"11":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"15":{"tf":1.0},"2":{"tf":1.0}}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"12":{"tf":1.4142135623730951},"13":{"tf":1.0}}}},"w":{"df":8,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"12":{"tf":1.4142135623730951},"2":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.7320508075688772},"8":{"tf":1.7320508075688772},"9":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":12,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":2.0},"17":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"5":{"tf":2.449489742783178},"6":{"tf":2.0},"7":{"tf":1.0},"9":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"n":{"d":{"df":2,"docs":{"13":{"tf":1.4142135623730951},"5":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":5,"docs":{"10":{"tf":1.0},"13":{"tf":1.4142135623730951},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"x":{"df":5,"docs":{"11":{"tf":2.23606797749979},"12":{"tf":1.0},"2":{"tf":1.7320508075688772},"3":{"tf":1.0},"4":{"tf":1.4142135623730951}}}},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":3,"docs":{"11":{"tf":1.4142135623730951},"13":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"i":{"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"11":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}}}}},"w":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"0":{"tf":1.0},"3":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"4":{"tf":3.0}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":5,"docs":{"11":{"tf":1.0},"12":{"tf":1.7320508075688772},"2":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":2.8284271247461903}}}}}}}},"c":{"a":{"df":0,"docs":{},"l":{"c":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":4,"docs":{"11":{"tf":1.0},"15":{"tf":1.0},"5":{"tf":1.0},"9":{"tf":1.0}}}},"n":{"df":0,"docs":{},"v":{"a":{"df":1,"docs":{"4":{"tf":1.0}},"n":{"df":1,"docs":{"4":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":1,"docs":{"8":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}}},"r":{"d":{"df":1,"docs":{"11":{"tf":1.0}}},"df":1,"docs":{"8":{"tf":1.4142135623730951}},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}}}},"t":{"df":1,"docs":{"8":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":5,"docs":{"10":{"tf":1.0},"6":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"t":{"=":{"\"":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":2,"docs":{"11":{"tf":1.0},"9":{"tf":1.7320508075688772}}}},"p":{"df":0,"docs":{},"p":{"df":1,"docs":{"9":{"tf":2.0}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"10":{"tf":1.0}}}}}}},"df":3,"docs":{"11":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"11":{"tf":1.0},"9":{"tf":1.7320508075688772}}}}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"10":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"10":{"tf":1.7320508075688772},"13":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"g":{"df":4,"docs":{"17":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.0},"9":{"tf":1.0}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":2.8284271247461903}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"14":{"tf":1.4142135623730951}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":2,"docs":{"15":{"tf":1.0},"4":{"tf":1.4142135623730951}}}}}},"i":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"4":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"k":{"df":6,"docs":{"10":{"tf":1.0},"12":{"tf":1.7320508075688772},"2":{"tf":1.7320508075688772},"3":{"tf":1.0},"4":{"tf":2.8284271247461903},"7":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"3":{"tf":1.7320508075688772}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}}}}},"m":{"a":{"df":1,"docs":{"11":{"tf":1.0}}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"12":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"5":{"tf":1.0}}},"m":{"a":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"14":{"tf":1.4142135623730951}}}}},"p":{"a":{"df":0,"docs":{},"t":{"df":5,"docs":{"15":{"tf":2.23606797749979},"16":{"tf":1.4142135623730951},"17":{"tf":1.7320508075688772},"18":{"tf":1.4142135623730951},"2":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":3,"docs":{"13":{"tf":1.7320508075688772},"14":{"tf":1.0},"5":{"tf":1.0}}},"x":{"df":2,"docs":{"0":{"tf":1.0},"3":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"2":{"tf":1.4142135623730951}}}}}}},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"13":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"6":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"12":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"t":{":":{"c":{"a":{"df":0,"docs":{},"t":{"=":{"\"":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":1,"docs":{"9":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"=":{"\"":{"a":{"d":{"df":0,"docs":{},"v":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":1,"docs":{"9":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":2,"docs":{"0":{"tf":1.0},"9":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"7":{"tf":1.0}},"t":{"df":2,"docs":{"18":{"tf":1.4142135623730951},"8":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":5,"docs":{"10":{"tf":1.0},"3":{"tf":1.0},"7":{"tf":2.449489742783178},"8":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}},"x":{"df":0,"docs":{},"t":{"df":4,"docs":{"11":{"tf":1.0},"2":{"tf":1.7320508075688772},"3":{"tf":1.7320508075688772},"9":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"3":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"3":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"[":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"=":{"\"":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":1,"docs":{"10":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"0":{"tf":1.0},"10":{"tf":3.1622776601683795}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"10":{"tf":1.0}}}}}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"a":{"df":7,"docs":{"0":{"tf":1.0},"13":{"tf":1.4142135623730951},"2":{"tf":2.8284271247461903},"3":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"df":9,"docs":{"10":{"tf":1.7320508075688772},"12":{"tf":1.4142135623730951},"13":{"tf":1.7320508075688772},"2":{"tf":1.4142135623730951},"3":{"tf":1.4142135623730951},"4":{"tf":1.0},"6":{"tf":1.7320508075688772},"7":{"tf":3.0},"9":{"tf":2.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"8":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"10":{"tf":1.0},"13":{"tf":1.0}}}},"df":3,"docs":{"11":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"14":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"4":{"tf":2.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"v":{"df":1,"docs":{"12":{"tf":1.0}},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}}}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"2":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"11":{"tf":1.4142135623730951},"13":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.4142135623730951},"8":{"tf":1.0}}}}}}}}},"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":5,"docs":{"0":{"tf":1.0},"11":{"tf":1.0},"18":{"tf":1.4142135623730951},"2":{"tf":1.0},"4":{"tf":1.0}}},"df":0,"docs":{}}},"d":{"]":{"df":0,"docs":{},"o":{"df":1,"docs":{"6":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"11":{"tf":1.0},"5":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":5,"docs":{"13":{"tf":1.4142135623730951},"17":{"tf":1.0},"2":{"tf":1.4142135623730951},"3":{"tf":1.0},"6":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"4":{"tf":1.0},"5":{"tf":1.4142135623730951},"9":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"12":{"tf":1.0},"6":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"4":{"tf":1.0}}}}},"p":{"[":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"!":{"=":{"/":{".":{"*":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"=":{"\"":{"d":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":1,"docs":{"10":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"d":{"df":6,"docs":{"0":{"tf":1.0},"10":{"tf":1.7320508075688772},"16":{"tf":1.0},"3":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"s":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"13":{"tf":1.0},"14":{"tf":1.0}}}}}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"2":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"13":{"tf":1.0},"2":{"tf":1.0}}}}}}}}},"i":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":9,"docs":{"13":{"tf":1.4142135623730951},"15":{"tf":2.23606797749979},"16":{"tf":1.0},"17":{"tf":2.23606797749979},"18":{"tf":1.0},"3":{"tf":1.0},"5":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.7320508075688772}}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"10":{"tf":1.4142135623730951},"13":{"tf":1.7320508075688772},"17":{"tf":1.0},"9":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":5,"docs":{"13":{"tf":1.4142135623730951},"17":{"tf":1.0},"4":{"tf":1.0},"6":{"tf":1.7320508075688772},"9":{"tf":1.0}}}}}},"df":0,"docs":{}}},"s":{"a":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":2,"docs":{"10":{"tf":2.0},"7":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":2,"docs":{"2":{"tf":1.0},"3":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"n":{"c":{"df":3,"docs":{"13":{"tf":2.6457513110645907},"16":{"tf":1.7320508075688772},"6":{"tf":2.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"4":{"tf":1.0}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"0":{"tf":1.0},"11":{"tf":1.0},"16":{"tf":1.0},"2":{"tf":1.7320508075688772},"6":{"tf":1.0}}}}}}}},"df":0,"docs":{},"g":{"df":2,"docs":{"11":{"tf":1.4142135623730951},"5":{"tf":1.0}},"s":{"/":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"/":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"11":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":8,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"13":{"tf":2.23606797749979},"14":{"tf":1.0},"4":{"tf":1.4142135623730951},"5":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":2.8284271247461903}}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"6":{"tf":1.0}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"n":{"df":2,"docs":{"2":{"tf":1.0},"4":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":3,"docs":{"4":{"tf":1.0},"7":{"tf":1.7320508075688772},"9":{"tf":1.0}}}}},"t":{"[":{"2":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"10":{"tf":1.0}}}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"g":{"df":11,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.4142135623730951},"13":{"tf":2.6457513110645907},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"3":{"tf":1.4142135623730951},"4":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}}}},"a":{"c":{"df":0,"docs":{},"h":{"df":8,"docs":{"10":{"tf":1.7320508075688772},"11":{"tf":2.23606797749979},"12":{"tf":1.0},"2":{"tf":1.4142135623730951},"3":{"tf":1.4142135623730951},"4":{"tf":1.0},"5":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"g":{"df":7,"docs":{"0":{"tf":1.4142135623730951},"10":{"tf":1.0},"13":{"tf":2.23606797749979},"4":{"tf":2.449489742783178},"5":{"tf":1.0},"8":{"tf":1.7320508075688772},"9":{"tf":1.7320508075688772}},"e":{"'":{"df":1,"docs":{"4":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":1,"docs":{"3":{"tf":1.0}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"16":{"tf":1.0},"18":{"tf":1.0}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":8,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"12":{"tf":1.4142135623730951},"13":{"tf":2.0},"5":{"tf":2.449489742783178},"6":{"tf":2.0},"7":{"tf":1.0},"9":{"tf":2.0}}}}}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"l":{"df":2,"docs":{"15":{"tf":1.0},"2":{"tf":1.0}}}}},"n":{"d":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"11":{"tf":1.7320508075688772},"12":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"4":{"tf":1.0},"6":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"12":{"tf":1.0},"2":{"tf":1.0}}},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"10":{"tf":2.0},"7":{"tf":2.6457513110645907}}},"y":{"!":{"=":{"\"":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"10":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"=":{"\"":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"10":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}}}},"l":{"a":{"c":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"6":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"18":{"tf":1.0},"2":{"tf":1.0}}}}}},"t":{"c":{"df":5,"docs":{"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"2":{"tf":1.0},"3":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}},"x":{"a":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"13":{"tf":1.0},"4":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"7":{"tf":1.0}}}},"p":{"df":0,"docs":{},"l":{"df":6,"docs":{"11":{"tf":2.0},"12":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951},"7":{"tf":2.6457513110645907},"8":{"tf":2.6457513110645907}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"11":{"tf":1.0}}},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}}},"l":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"6":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"11":{"tf":4.123105625617661},"12":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":7,"docs":{"10":{"tf":1.4142135623730951},"2":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.0},"6":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"8":{"tf":2.6457513110645907}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"s":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"10":{"tf":1.0}}}}},"r":{"a":{"df":1,"docs":{"4":{"tf":1.0}}},"df":0,"docs":{}}}}},"f":{"df":1,"docs":{"8":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":2,"docs":{"2":{"tf":1.0},"4":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"12":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"2":{"tf":1.0},"6":{"tf":1.0}}}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"6":{"tf":1.0},"8":{"tf":1.0}}}},"d":{"df":7,"docs":{"10":{"tf":1.4142135623730951},"12":{"tf":1.0},"13":{"tf":1.0},"6":{"tf":1.7320508075688772},"7":{"tf":2.23606797749979},"8":{"tf":2.6457513110645907},"9":{"tf":2.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":11,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":2.23606797749979},"17":{"tf":1.0},"2":{"tf":1.0},"4":{"tf":2.0},"5":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"3":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":10,"docs":{"10":{"tf":1.7320508075688772},"11":{"tf":1.4142135623730951},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"6":{"tf":2.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772},"9":{"tf":1.4142135623730951}}}}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}}},"df":10,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"13":{"tf":1.0},"2":{"tf":2.6457513110645907},"3":{"tf":1.0},"4":{"tf":1.7320508075688772},"6":{"tf":2.6457513110645907},"7":{"tf":2.0},"8":{"tf":1.7320508075688772},"9":{"tf":1.0}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"10":{"tf":1.0},"2":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"6":{"tf":1.0}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"12":{"tf":2.8284271247461903}}},"df":0,"docs":{}}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"7":{"tf":1.0}}}}},"n":{"c":{"!":{"=":{"\"":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"=":{"\"":{"d":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"a":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"4":{"tf":1.0},"9":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"10":{"tf":1.0},"13":{"tf":1.0},"9":{"tf":1.0}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"11":{"tf":1.0},"7":{"tf":1.0}}}}}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"12":{"tf":1.4142135623730951},"5":{"tf":1.0},"8":{"tf":1.0}}}},"r":{"df":1,"docs":{"11":{"tf":1.0}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":5,"docs":{"11":{"tf":1.0},"12":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}},"n":{"df":2,"docs":{"11":{"tf":1.0},"4":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"10":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":5,"docs":{"0":{"tf":1.0},"12":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0},"9":{"tf":1.0}},"i":{"c":{"df":1,"docs":{"4":{"tf":1.0}}},"df":0,"docs":{}}}},"y":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"6":{"tf":1.0}}}}}},"df":0,"docs":{}},"i":{"d":{"df":2,"docs":{"3":{"tf":1.0},"7":{"tf":1.0}},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"o":{"df":1,"docs":{"10":{"tf":1.7320508075688772}},"u":{"df":0,"docs":{},"p":{"df":2,"docs":{"12":{"tf":1.0},"2":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"m":{"df":5,"docs":{"10":{"tf":1.7320508075688772},"12":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":2.449489742783178},"9":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"13":{"tf":1.0},"4":{"tf":1.0}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"13":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"7":{"tf":2.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"df":1,"docs":{"0":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"11":{"tf":1.0},"5":{"tf":1.0},"9":{"tf":1.0}},"i":{"df":1,"docs":{"13":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}}}}}}},"t":{"df":2,"docs":{"11":{"tf":1.4142135623730951},"3":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"d":{"df":4,"docs":{"13":{"tf":1.4142135623730951},"2":{"tf":1.0},"5":{"tf":1.0},"9":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.0}}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"10":{"tf":1.0},"3":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{":":{"/":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":1,"docs":{"0":{"tf":1.0}}}}}}},"df":0,"docs":{},"w":{"df":0,"docs":{},"w":{"df":0,"docs":{},"w":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"s":{":":{"/":{"/":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"#":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"3":{"tf":1.0}}}}}}}}}}},"i":{".":{"df":3,"docs":{"13":{"tf":1.4142135623730951},"4":{"tf":1.0},"8":{"tf":1.0}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"2":{"tf":1.0},"3":{"tf":1.0},"6":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"13":{"tf":2.23606797749979},"7":{"tf":1.0}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"13":{"tf":1.0},"14":{"tf":1.0}}}}}}}},"m":{"a":{"df":0,"docs":{},"g":{"df":4,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"2":{"tf":1.0},"4":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"4":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"14":{"tf":1.0},"8":{"tf":1.0}}}}}}},"i":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"1":{"tf":1.0},"11":{"tf":1.0},"9":{"tf":1.0}}}}}}},"n":{"[":{"1":{"df":1,"docs":{"11":{"tf":1.0}}},"5":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":5,"docs":{"11":{"tf":1.0},"13":{"tf":1.0},"17":{"tf":1.4142135623730951},"7":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"13":{"tf":2.23606797749979},"16":{"tf":1.7320508075688772},"6":{"tf":1.0},"9":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"13":{"tf":1.0},"6":{"tf":1.0}}}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"u":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":4,"docs":{"12":{"tf":1.0},"3":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"=":{"\"":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"7":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"12":{"tf":1.0},"3":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"d":{"df":3,"docs":{"6":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}},"f":{"a":{"c":{"df":6,"docs":{"0":{"tf":1.0},"1":{"tf":2.23606797749979},"12":{"tf":1.0},"2":{"tf":1.4142135623730951},"3":{"tf":1.0},"4":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"n":{"df":1,"docs":{"11":{"tf":1.7320508075688772}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}},"t":{"'":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"3":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"3":{"tf":1.0}}}}}}}},"j":{"df":0,"docs":{},"j":{"df":1,"docs":{"11":{"tf":1.0}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":2,"docs":{"11":{"tf":1.0},"3":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"9":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"l":{"a":{"b":{"df":0,"docs":{},"e":{"df":1,"docs":{"5":{"tf":1.0}},"l":{"[":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"=":{"\"":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"13":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":4,"docs":{"13":{"tf":2.6457513110645907},"4":{"tf":1.7320508075688772},"8":{"tf":1.0},"9":{"tf":2.0}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":16,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":1.7320508075688772},"5":{"tf":2.23606797749979},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"11":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"10":{"tf":1.0},"13":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"y":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{",":{"3":{",":{"4":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":8,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"11":{"tf":1.7320508075688772},"13":{"tf":2.449489742783178},"2":{"tf":1.0},"3":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":1.0}}}}}},"df":1,"docs":{"14":{"tf":1.0}},"e":{"a":{"d":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"0":{"tf":1.0},"11":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":6,"docs":{"1":{"tf":1.0},"13":{"tf":1.7320508075688772},"14":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"4":{"tf":1.7320508075688772},"9":{"tf":1.0}}}},"g":{"a":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"m":{"a":{"!":{"=":{"\"":{"b":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"=":{"\"":{"b":{"df":2,"docs":{"18":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951}}},"df":0,"docs":{},"g":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}}},"/":{"(":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"|":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"v":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":5,"docs":{"11":{"tf":1.4142135623730951},"12":{"tf":1.7320508075688772},"3":{"tf":1.0},"7":{"tf":2.0},"8":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"13":{"tf":1.4142135623730951},"14":{"tf":1.0},"16":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"3":{"tf":1.0}}},"df":1,"docs":{"3":{"tf":1.4142135623730951}}}}},"x":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"10":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"i":{"b":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.7320508075688772}}}}},"n":{"df":0,"docs":{},"e":{"df":3,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"2":{"tf":1.0}}},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"5":{"tf":1.0}}}}}}},"k":{"df":1,"docs":{"4":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"t":{"df":8,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.7320508075688772},"14":{"tf":1.0},"2":{"tf":1.4142135623730951},"3":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0}}}}},"o":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}},"t":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"10":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"k":{"df":3,"docs":{"11":{"tf":1.0},"6":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"m":{"a":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"11":{"tf":1.4142135623730951}},"i":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"11":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"3":{"tf":1.0}}}},"k":{"df":0,"docs":{},"e":{"df":3,"docs":{"2":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}},"n":{"df":0,"docs":{},"i":{"df":2,"docs":{"2":{"tf":1.0},"7":{"tf":1.0}}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"k":{"df":5,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"3":{"tf":1.0},"6":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":9,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":2.6457513110645907},"2":{"tf":1.7320508075688772},"3":{"tf":1.7320508075688772},"4":{"tf":1.4142135623730951},"6":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":3,"docs":{"13":{"tf":1.4142135623730951},"16":{"tf":1.7320508075688772},"3":{"tf":1.0}}}}}}}},"df":1,"docs":{"13":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"n":{"df":5,"docs":{"11":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":2.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":3,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"3":{"tf":1.0}}}},"t":{"a":{":":{":":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"=":{"\"":{"2":{"0":{"df":1,"docs":{"18":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"o":{"c":{"=":{"\"":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":3,"docs":{"11":{"tf":2.23606797749979},"6":{"tf":1.7320508075688772},"7":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"18":{"tf":2.23606797749979},"6":{"tf":1.0}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"11":{"tf":1.0}},"s":{"=":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"1":{",":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"2":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{",":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{";":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"=":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"11":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"i":{"d":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"4":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"d":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":5,"docs":{"15":{"tf":2.449489742783178},"16":{"tf":1.7320508075688772},"17":{"tf":2.0},"18":{"tf":1.7320508075688772},"2":{"tf":1.0}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":3,"docs":{"2":{"tf":1.0},"4":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"11":{"tf":1.0}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"11":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":8,"docs":{"0":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"2":{"tf":1.4142135623730951},"3":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.7320508075688772},"9":{"tf":1.0}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"3":{"tf":1.0}}}}},"u":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"0":{"tf":1.4142135623730951}},"p":{"df":0,"docs":{},"l":{"df":9,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"13":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"3":{"tf":1.0},"4":{"tf":1.4142135623730951},"6":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":1.0}}}}}}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":2.449489742783178}}}},",":{"df":0,"docs":{},"m":{"df":1,"docs":{"13":{"tf":2.23606797749979}}}},"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":7,"docs":{"11":{"tf":2.23606797749979},"12":{"tf":1.0},"2":{"tf":1.4142135623730951},"3":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"5":{"tf":1.0},"7":{"tf":2.449489742783178}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":6,"docs":{"10":{"tf":1.0},"14":{"tf":1.0},"3":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":2.23606797749979},"9":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"df":2,"docs":{"13":{"tf":1.0},"8":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"d":{"df":3,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"17":{"tf":1.0}}},"df":0,"docs":{}},"g":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"7":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}},"w":{"df":5,"docs":{"12":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"2":{"tf":1.0},"4":{"tf":1.0},"7":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}}},"x":{"df":0,"docs":{},"t":{"df":4,"docs":{"12":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.0},"6":{"tf":1.0}}}}},"n":{"]":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}}}},"df":1,"docs":{"11":{"tf":1.0}}},"o":{"d":{"df":0,"docs":{},"e":{"df":9,"docs":{"0":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.7320508075688772},"13":{"tf":2.449489742783178},"14":{"tf":2.23606797749979},"17":{"tf":3.0},"4":{"tf":4.795831523312719},"5":{"tf":2.0},"9":{"tf":2.8284271247461903}}}},"df":0,"docs":{},"n":{"df":7,"docs":{"10":{"tf":1.0},"13":{"tf":1.0},"17":{"tf":2.23606797749979},"4":{"tf":1.4142135623730951},"5":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.4142135623730951}},"e":{"df":1,"docs":{"9":{"tf":1.0}}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"16":{"tf":1.0},"18":{"tf":1.0},"3":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":9,"docs":{"10":{"tf":1.0},"11":{"tf":1.7320508075688772},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"9":{"tf":1.0}}},"h":{"df":1,"docs":{"11":{"tf":1.0}}}},"w":{"df":1,"docs":{"8":{"tf":1.0}}}},"p":{"[":{"1":{"df":1,"docs":{"11":{"tf":1.0}}},"2":{"df":1,"docs":{"11":{"tf":1.0}}},"3":{"df":1,"docs":{"11":{"tf":1.0}}},"4":{"df":1,"docs":{"11":{"tf":1.0}}},"6":{"df":1,"docs":{"11":{"tf":1.0}}},"7":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":2,"docs":{"11":{"tf":1.0},"9":{"tf":1.4142135623730951}},"s":{"[":{"6":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"11":{"tf":1.4142135623730951},"12":{"tf":1.0},"2":{"tf":1.0},"5":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}},"s":{"=":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"11":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"6":{"tf":1.0}}}}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":1,"docs":{"8":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"10":{"tf":1.7320508075688772},"13":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}}},"c":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"10":{"tf":1.0}},"r":{"df":1,"docs":{"8":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"b":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}}}},"df":1,"docs":{"8":{"tf":1.4142135623730951}},"l":{"d":{"df":1,"docs":{"15":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"16":{"tf":1.0},"2":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"c":{"df":4,"docs":{"2":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0},"9":{"tf":1.0}}},"df":9,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"13":{"tf":1.0},"2":{"tf":1.0},"4":{"tf":1.0},"6":{"tf":1.7320508075688772},"7":{"tf":1.7320508075688772},"8":{"tf":1.7320508075688772},"9":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":8,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.4142135623730951},"2":{"tf":1.0},"4":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":1.0}}},"r":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":11,"docs":{"10":{"tf":1.4142135623730951},"13":{"tf":2.6457513110645907},"14":{"tf":2.23606797749979},"17":{"tf":2.23606797749979},"18":{"tf":1.0},"4":{"tf":2.23606797749979},"5":{"tf":2.23606797749979},"6":{"tf":2.23606797749979},"7":{"tf":1.7320508075688772},"8":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":7,"docs":{"11":{"tf":1.7320508075688772},"15":{"tf":1.0},"2":{"tf":2.23606797749979},"5":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.7320508075688772}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"11":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"6":{"tf":1.0},"7":{"tf":1.0}}}}},"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.0}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":2.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"2":{"tf":1.0},"3":{"tf":1.0}},"l":{"a":{"df":0,"docs":{},"p":{"df":5,"docs":{"10":{"tf":1.4142135623730951},"13":{"tf":1.0},"14":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"p":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":2,"docs":{"2":{"tf":1.0},"3":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"12":{"tf":1.0},"5":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":2.449489742783178}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}},"t":{"df":11,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":2.0},"12":{"tf":1.7320508075688772},"13":{"tf":1.4142135623730951},"18":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.7320508075688772},"8":{"tf":1.0},"9":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"11":{"tf":1.4142135623730951},"17":{"tf":1.0},"2":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":2,"docs":{"12":{"tf":1.4142135623730951},"16":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"6":{"tf":1.0},"8":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"10":{"tf":2.23606797749979},"7":{"tf":1.4142135623730951}}}}}}},"h":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":2,"docs":{"7":{"tf":1.0},"9":{"tf":1.0}}}}},"df":0,"docs":{}}},"i":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":2,"docs":{"6":{"tf":1.0},"8":{"tf":1.0}}}}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":3,"docs":{"10":{"tf":1.0},"6":{"tf":1.0},"9":{"tf":1.0}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"u":{"df":2,"docs":{"3":{"tf":1.0},"8":{"tf":1.0}}}},"o":{"df":5,"docs":{"11":{"tf":1.4142135623730951},"12":{"tf":1.0},"7":{"tf":1.7320508075688772},"8":{"tf":1.0},"9":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"10":{"tf":3.605551275463989},"13":{"tf":1.4142135623730951},"8":{"tf":1.0},"9":{"tf":1.0}}}}},"s":{"=":{"\"":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":1,"docs":{"18":{"tf":1.4142135623730951}}}},"r":{"b":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"/":{"df":0,"docs":{},"v":{"df":0,"docs":{},"v":{"[":{"df":0,"docs":{},"p":{"df":0,"docs":{},"z":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}}}},"df":2,"docs":{"7":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"2":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.0},"7":{"tf":1.4142135623730951}}},"x":{"df":1,"docs":{"8":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":9,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"2":{"tf":1.4142135623730951},"4":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":2.23606797749979},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"7":{"tf":1.0}}}}}}}},"p":{"[":{"1":{"df":1,"docs":{"11":{"tf":1.0}}},"5":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"9":{"tf":2.0}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"d":{"df":5,"docs":{"10":{"tf":1.0},"13":{"tf":2.449489742783178},"16":{"tf":1.7320508075688772},"6":{"tf":1.7320508075688772},"8":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"12":{"tf":1.0}}}}},"s":{"df":3,"docs":{"11":{"tf":1.0},"2":{"tf":1.0},"6":{"tf":1.0}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"15":{"tf":1.0}}}}}}},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"11":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"12":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"3":{"tf":1.0}}},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"3":{"tf":1.0}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":18,"docs":{"0":{"tf":1.0},"10":{"tf":2.6457513110645907},"11":{"tf":2.0},"12":{"tf":2.8284271247461903},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":1.7320508075688772},"18":{"tf":1.7320508075688772},"2":{"tf":3.0},"3":{"tf":1.4142135623730951},"4":{"tf":3.3166247903554},"5":{"tf":2.23606797749979},"6":{"tf":2.0},"7":{"tf":2.23606797749979},"8":{"tf":1.7320508075688772},"9":{"tf":2.23606797749979}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"y":{"df":1,"docs":{"4":{"tf":1.0}}}},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"15":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"4":{"tf":1.0},"6":{"tf":1.4142135623730951},"8":{"tf":1.0}}}},"df":1,"docs":{"5":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"2":{"tf":1.0}}}}},"df":0,"docs":{},"g":{"df":2,"docs":{"13":{"tf":1.0},"6":{"tf":1.0}}}}},"b":{"df":1,"docs":{"9":{"tf":1.0}}},"df":1,"docs":{"14":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"d":{"df":2,"docs":{"10":{"tf":1.0},"3":{"tf":1.0}}},"df":0,"docs":{},"f":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"=":{"\"":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"7":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":2,"docs":{"10":{"tf":1.0},"7":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"10":{"tf":2.23606797749979},"17":{"tf":1.4142135623730951},"3":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":2.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"17":{"tf":2.449489742783178}}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"8":{"tf":1.0}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"3":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":4,"docs":{"4":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":2.8284271247461903}}}},"df":0,"docs":{}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":6,"docs":{"10":{"tf":3.605551275463989},"11":{"tf":1.0},"13":{"tf":1.7320508075688772},"5":{"tf":2.0},"6":{"tf":1.0},"9":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":4,"docs":{"10":{"tf":1.0},"13":{"tf":1.4142135623730951},"4":{"tf":1.0},"7":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"2":{"tf":1.0}}}},"i":{"df":1,"docs":{"8":{"tf":1.0}}}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"l":{"a":{"c":{"df":3,"docs":{"12":{"tf":1.0},"18":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":1,"docs":{"4":{"tf":1.0}}}},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":2,"docs":{"11":{"tf":1.0},"7":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"5":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":11,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"11":{"tf":3.1622776601683795},"12":{"tf":1.4142135623730951},"18":{"tf":1.0},"2":{"tf":2.0},"3":{"tf":3.0},"4":{"tf":1.0},"6":{"tf":1.4142135623730951},"8":{"tf":1.0},"9":{"tf":1.7320508075688772}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":3,"docs":{"11":{"tf":1.4142135623730951},"2":{"tf":1.0},"9":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"16":{"tf":1.0}}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"0":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":6,"docs":{"1":{"tf":1.0},"13":{"tf":1.7320508075688772},"14":{"tf":1.4142135623730951},"2":{"tf":1.0},"4":{"tf":1.0},"9":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}},"w":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"8":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"s":{"[":{"1":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":5,"docs":{"13":{"tf":2.23606797749979},"17":{"tf":1.7320508075688772},"4":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.7320508075688772}}}}},"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"11":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}}}}}}}}},"df":1,"docs":{"14":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":15,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.0},"10":{"tf":2.449489742783178},"11":{"tf":2.6457513110645907},"12":{"tf":1.4142135623730951},"13":{"tf":1.0},"15":{"tf":1.0},"2":{"tf":3.3166247903554},"3":{"tf":2.449489742783178},"4":{"tf":2.23606797749979},"5":{"tf":1.7320508075688772},"6":{"tf":3.4641016151377544},"7":{"tf":3.0},"8":{"tf":3.7416573867739413},"9":{"tf":3.605551275463989}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"13":{"tf":1.0}}}}},"df":9,"docs":{"10":{"tf":1.0},"12":{"tf":1.0},"17":{"tf":1.4142135623730951},"4":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"10":{"tf":2.23606797749979}}}}}},"df":6,"docs":{"10":{"tf":1.0},"2":{"tf":1.0},"4":{"tf":1.7320508075688772},"5":{"tf":1.0},"8":{"tf":1.7320508075688772},"9":{"tf":1.7320508075688772}},"m":{"df":1,"docs":{"18":{"tf":1.0}}}},"g":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"13":{"tf":2.0},"2":{"tf":1.0},"3":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":7,"docs":{"11":{"tf":1.4142135623730951},"12":{"tf":1.0},"2":{"tf":2.23606797749979},"3":{"tf":1.0},"4":{"tf":1.7320508075688772},"6":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"11":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"6":{"tf":1.0},"7":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"6":{"tf":1.0},"9":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"11":{"tf":2.6457513110645907},"6":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":3,"docs":{"11":{"tf":1.0},"2":{"tf":1.0},"9":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"1":{"tf":1.0},"11":{"tf":1.0},"2":{"tf":1.0}}}}}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":5,"docs":{"10":{"tf":1.0},"6":{"tf":1.7320508075688772},"7":{"tf":1.4142135623730951},"8":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"w":{"df":5,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"12":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.7320508075688772}},"n":{"df":5,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"2":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":6,"docs":{"1":{"tf":1.4142135623730951},"13":{"tf":1.0},"14":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"10":{"tf":1.0}}},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"6":{"tf":1.0}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":4,"docs":{"6":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"9":{"tf":1.0}},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}}}}}}}}}}},"i":{"df":6,"docs":{"11":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}}},"z":{"df":0,"docs":{},"e":{"df":1,"docs":{"13":{"tf":1.0}}}}},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":3,"docs":{"11":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"15":{"tf":1.0},"8":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"11":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"2":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":6,"docs":{"0":{"tf":1.0},"11":{"tf":1.4142135623730951},"13":{"tf":2.23606797749979},"14":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":2.6457513110645907}}}},"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":3,"docs":{"13":{"tf":2.0},"5":{"tf":1.0},"9":{"tf":1.0}},"i":{"df":11,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":2.23606797749979},"12":{"tf":1.0},"13":{"tf":3.0},"14":{"tf":1.4142135623730951},"4":{"tf":2.0},"5":{"tf":2.0},"6":{"tf":1.7320508075688772},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"h":{"df":7,"docs":{"10":{"tf":1.0},"11":{"tf":2.0},"12":{"tf":1.7320508075688772},"3":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":1,"docs":{"11":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"11":{"tf":1.4142135623730951},"8":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"d":{"df":3,"docs":{"15":{"tf":1.0},"17":{"tf":1.4142135623730951},"8":{"tf":1.0}}},"df":0,"docs":{}}},"df":3,"docs":{"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"'":{",":{"'":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"'":{",":{"'":{"1":{"1":{"3":{"1":{"8":{"6":{"1":{"6":{"'":{",":{"'":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{",":{"'":{"a":{"df":0,"docs":{},"j":{"0":{"'":{",":{"'":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{",":{"'":{"df":0,"docs":{},"j":{"df":0,"docs":{},"j":{"df":1,"docs":{"11":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"11":{"tf":1.4142135623730951}}},"u":{"df":1,"docs":{"2":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"18":{"tf":1.7320508075688772}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":3,"docs":{"11":{"tf":2.8284271247461903},"6":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"0":{"tf":1.7320508075688772},"7":{"tf":1.0},"9":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"u":{"b":{"df":1,"docs":{"13":{"tf":1.7320508075688772}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"h":{"df":9,"docs":{"0":{"tf":1.0},"10":{"tf":1.4142135623730951},"11":{"tf":1.4142135623730951},"2":{"tf":1.0},"3":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"2":{"tf":1.0},"9":{"tf":1.0}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"2":{"tf":1.0},"4":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"2":{"tf":1.0},"3":{"tf":1.0}}}},"df":0,"docs":{}}}},"y":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":2,"docs":{"4":{"tf":1.4142135623730951},"8":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"9":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"x":{"df":5,"docs":{"0":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":1.0},"8":{"tf":1.7320508075688772},"9":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"a":{"b":{"df":6,"docs":{"1":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"2":{"tf":1.0},"4":{"tf":1.0},"9":{"tf":1.4142135623730951}},"l":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":2,"docs":{"11":{"tf":1.0},"8":{"tf":1.0}}}},"df":1,"docs":{"8":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":2,"docs":{"10":{"tf":1.0},"7":{"tf":1.0}}}},"r":{"df":0,"docs":{},"m":{"df":3,"docs":{"6":{"tf":1.4142135623730951},"8":{"tf":1.0},"9":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":5,"docs":{"10":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"5":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}},"x":{"df":0,"docs":{},"t":{"df":6,"docs":{"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"16":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.7320508075688772},"5":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"11":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":4,"docs":{"11":{"tf":1.0},"4":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"9":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{"c":{"a":{"df":0,"docs":{},"t":{"=":{"\"":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":1,"docs":{"5":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"e":{"df":2,"docs":{"4":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"9":{"tf":1.0}}}},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"5":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"3":{"tf":1.0}}}}},"k":{"!":{"=":{"\"":{"b":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"=":{"\"":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"/":{"c":{"a":{"df":1,"docs":{"8":{"tf":1.0}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"[":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":8,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.4142135623730951},"12":{"tf":1.7320508075688772},"16":{"tf":2.0},"4":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"12":{"tf":1.0}}},"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":13,"docs":{"10":{"tf":1.0},"11":{"tf":3.3166247903554},"12":{"tf":2.0},"13":{"tf":3.0},"14":{"tf":1.0},"2":{"tf":1.4142135623730951},"3":{"tf":2.0},"4":{"tf":1.4142135623730951},"5":{"tf":1.7320508075688772},"6":{"tf":2.23606797749979},"7":{"tf":2.0},"8":{"tf":1.0},"9":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}}}}}}}}},"o":{"df":0,"docs":{},"l":{"b":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"3":{"tf":1.7320508075688772},"4":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"11":{"tf":1.0}},"s":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"/":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"p":{"df":4,"docs":{"2":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":6,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"3":{"tf":1.0},"5":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":2.449489742783178}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"11":{"tf":1.4142135623730951}},"s":{"'":{",":{"'":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"'":{",":{"'":{"1":{"1":{"3":{"1":{"8":{"7":{"6":{"0":{"'":{",":{"'":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"c":{"'":{",":{"'":{"a":{"df":0,"docs":{},"j":{"0":{"'":{",":{"'":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"c":{"'":{",":{"'":{"df":0,"docs":{},"j":{"df":0,"docs":{},"j":{"df":1,"docs":{"11":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"13":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"11":{"tf":1.0}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"2":{"tf":1.0}}}}}}},"w":{"df":0,"docs":{},"o":{"df":4,"docs":{"10":{"tf":1.7320508075688772},"12":{"tf":1.0},"13":{"tf":2.0},"6":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"!":{"=":{"\"":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"7":{"tf":1.0}}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"=":{"\"":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"6":{"tf":1.0}}}}}}}}}}}},"df":0,"docs":{}},"df":6,"docs":{"10":{"tf":1.7320508075688772},"13":{"tf":1.0},"2":{"tf":1.0},"4":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"8":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"10":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"3":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"10":{"tf":2.0}}}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"4":{"tf":1.0},"5":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"df":1,"docs":{"3":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}}}},"i":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.4142135623730951}}}}}}}}}},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"4":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":3,"docs":{"2":{"tf":1.0},"3":{"tf":1.0},"6":{"tf":1.0}}},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"3":{"tf":1.0}}}},"s":{"df":13,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.7320508075688772},"10":{"tf":2.8284271247461903},"11":{"tf":2.6457513110645907},"13":{"tf":2.0},"2":{"tf":2.0},"3":{"tf":1.7320508075688772},"4":{"tf":1.7320508075688772},"5":{"tf":1.4142135623730951},"6":{"tf":2.23606797749979},"7":{"tf":2.6457513110645907},"8":{"tf":3.605551275463989},"9":{"tf":2.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"1":{"tf":1.0},"11":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"2":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"u":{"df":7,"docs":{"12":{"tf":2.0},"13":{"tf":2.0},"4":{"tf":1.7320508075688772},"5":{"tf":1.4142135623730951},"7":{"tf":1.7320508075688772},"8":{"tf":1.0},"9":{"tf":1.7320508075688772}}}},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"7":{"tf":1.0}},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"0":{"tf":1.0},"8":{"tf":1.0}}}}}}}},"b":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"b":{"df":3,"docs":{"10":{"tf":1.4142135623730951},"7":{"tf":2.0},"8":{"tf":2.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"14":{"tf":1.4142135623730951},"15":{"tf":1.0},"16":{"tf":1.0},"2":{"tf":1.0}}}}}}}},"h":{"df":1,"docs":{"8":{"tf":1.0}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":5,"docs":{"10":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"3":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"0":{"tf":1.0},"10":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"3":{"tf":1.0}}}},"df":0,"docs":{}}}},"p":{"[":{"1":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"v":{"d":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}},"df":2,"docs":{"7":{"tf":1.4142135623730951},"8":{"tf":2.0}},"g":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}},"p":{"df":2,"docs":{"10":{"tf":1.0},"8":{"tf":1.0}}},"z":{"df":2,"docs":{"10":{"tf":1.0},"8":{"tf":1.0}}}}},"w":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"6":{"tf":1.0},"9":{"tf":1.0}}}},"y":{"df":2,"docs":{"10":{"tf":1.0},"4":{"tf":1.0}}}},"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"d":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"k":{"a":{"df":1,"docs":{"11":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.7320508075688772}}}}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"10":{"tf":1.0},"12":{"tf":1.0},"5":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"10":{"tf":1.0},"7":{"tf":1.4142135623730951}}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":2,"docs":{"10":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"e":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"11":{"tf":1.0}}}}}}},"l":{"d":{"c":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"4":{"tf":1.0},"8":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{}}}},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":3,"docs":{"2":{"tf":1.0},"3":{"tf":2.449489742783178},"6":{"tf":1.0}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"14":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"7":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"r":{"d":{"df":6,"docs":{"2":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.0},"6":{"tf":2.449489742783178},"7":{"tf":1.0},"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"x":{":":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"=":{"df":0,"docs":{},"n":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"=":{"df":0,"docs":{},"n":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"8":{"tf":1.7320508075688772}}}}}}}},"title":{"root":{"5":{"0":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"18":{"tf":1.0}}}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":2,"docs":{"1":{"tf":1.0},"5":{"tf":1.0}}},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"q":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.0}}}}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"4":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"15":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":2,"docs":{"2":{"tf":1.0},"6":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"a":{"c":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}}},"o":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"16":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"18":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"17":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"4":{"tf":1.0},"5":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"11":{"tf":1.0},"3":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":6,"docs":{"10":{"tf":1.0},"2":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"18":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}}}}}}},"s":{"df":2,"docs":{"1":{"tf":1.0},"8":{"tf":1.0}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"3":{"tf":1.0}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"lang":"English","pipeline":["trimmer","stopWordFilter","stemmer"],"ref":"id","version":"0.9.5"},"results_options":{"limit_results":30,"teaser_word_count":30},"search_options":{"bool":"OR","expand":true,"fields":{"body":{"boost":1},"breadcrumbs":{"boost":1},"title":{"boost":2}}}});