/*
 * graphANNIS
 * Access the graphANNIS corpora and execute AQL queries with this service. 
 *
 * The version of the OpenAPI document: 0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.corpus_tools.annis.api;

import org.corpus_tools.annis.ApiCallback;
import org.corpus_tools.annis.ApiClient;
import org.corpus_tools.annis.ApiException;
import org.corpus_tools.annis.ApiResponse;
import org.corpus_tools.annis.Configuration;
import org.corpus_tools.annis.Pair;
import org.corpus_tools.annis.ProgressRequestBody;
import org.corpus_tools.annis.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import java.io.File;
import org.corpus_tools.annis.api.model.Group;
import org.corpus_tools.annis.api.model.ImportResult;
import org.corpus_tools.annis.api.model.InlineObject;
import org.corpus_tools.annis.api.model.InlineResponse202;
import org.corpus_tools.annis.api.model.Job;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AdministrationApi {
    private ApiClient localVarApiClient;

    public AdministrationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AdministrationApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for deleteGroup
     * @param name  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Group was deleted successfully. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Access is forbidden if the requesting client does not have administrator privileges. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteGroupCall(String name, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/groups/{name}"
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "bearerAuth" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteGroupValidateBeforeCall(String name, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteGroup(Async)");
        }
        

        okhttp3.Call localVarCall = deleteGroupCall(name, _callback);
        return localVarCall;

    }

    /**
     * Delete the user group given by its name
     * 
     * @param name  (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Group was deleted successfully. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Access is forbidden if the requesting client does not have administrator privileges. </td><td>  -  </td></tr>
     </table>
     */
    public void deleteGroup(String name) throws ApiException {
        deleteGroupWithHttpInfo(name);
    }

    /**
     * Delete the user group given by its name
     * 
     * @param name  (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Group was deleted successfully. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Access is forbidden if the requesting client does not have administrator privileges. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteGroupWithHttpInfo(String name) throws ApiException {
        okhttp3.Call localVarCall = deleteGroupValidateBeforeCall(name, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete the user group given by its name (asynchronously)
     * 
     * @param name  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Group was deleted successfully. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Access is forbidden if the requesting client does not have administrator privileges. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteGroupAsync(String name, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteGroupValidateBeforeCall(name, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for exportPost
     * @param inlineObject  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Corpus export started. Returns a UUID for the background job which can be used with the &#x60;/jobs&#x60; endpoint </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call exportPostCall(InlineObject inlineObject, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = inlineObject;

        // create path and map variables
        String localVarPath = "/export";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "bearerAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call exportPostValidateBeforeCall(InlineObject inlineObject, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'inlineObject' is set
        if (inlineObject == null) {
            throw new ApiException("Missing the required parameter 'inlineObject' when calling exportPost(Async)");
        }
        

        okhttp3.Call localVarCall = exportPostCall(inlineObject, _callback);
        return localVarCall;

    }

    /**
     * Get all requested corpora as ZIP-file
     * 
     * @param inlineObject  (required)
     * @return InlineResponse202
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Corpus export started. Returns a UUID for the background job which can be used with the &#x60;/jobs&#x60; endpoint </td><td>  -  </td></tr>
     </table>
     */
    public InlineResponse202 exportPost(InlineObject inlineObject) throws ApiException {
        ApiResponse<InlineResponse202> localVarResp = exportPostWithHttpInfo(inlineObject);
        return localVarResp.getData();
    }

    /**
     * Get all requested corpora as ZIP-file
     * 
     * @param inlineObject  (required)
     * @return ApiResponse&lt;InlineResponse202&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Corpus export started. Returns a UUID for the background job which can be used with the &#x60;/jobs&#x60; endpoint </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<InlineResponse202> exportPostWithHttpInfo(InlineObject inlineObject) throws ApiException {
        okhttp3.Call localVarCall = exportPostValidateBeforeCall(inlineObject, null);
        Type localVarReturnType = new TypeToken<InlineResponse202>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get all requested corpora as ZIP-file (asynchronously)
     * 
     * @param inlineObject  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Corpus export started. Returns a UUID for the background job which can be used with the &#x60;/jobs&#x60; endpoint </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call exportPostAsync(InlineObject inlineObject, final ApiCallback<InlineResponse202> _callback) throws ApiException {

        okhttp3.Call localVarCall = exportPostValidateBeforeCall(inlineObject, _callback);
        Type localVarReturnType = new TypeToken<InlineResponse202>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getJob
     * @param uuid  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Job is still running </td><td>  -  </td></tr>
        <tr><td> 200 </td><td> Job was finished successfully and result can be downloaded from the body </td><td>  -  </td></tr>
        <tr><td> 303 </td><td> Job was finished successfully </td><td>  -  </td></tr>
        <tr><td> 410 </td><td> Job failed </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Job not found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getJobCall(String uuid, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/jobs/{uuid}"
            .replaceAll("\\{" + "uuid" + "\\}", localVarApiClient.escapeString(uuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "bearerAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getJobValidateBeforeCall(String uuid, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'uuid' is set
        if (uuid == null) {
            throw new ApiException("Missing the required parameter 'uuid' when calling getJob(Async)");
        }
        

        okhttp3.Call localVarCall = getJobCall(uuid, _callback);
        return localVarCall;

    }

    /**
     * Get the status of the background job with the UUID
     * 
     * @param uuid  (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Job is still running </td><td>  -  </td></tr>
        <tr><td> 200 </td><td> Job was finished successfully and result can be downloaded from the body </td><td>  -  </td></tr>
        <tr><td> 303 </td><td> Job was finished successfully </td><td>  -  </td></tr>
        <tr><td> 410 </td><td> Job failed </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Job not found </td><td>  -  </td></tr>
     </table>
     */
    public void getJob(String uuid) throws ApiException {
        getJobWithHttpInfo(uuid);
    }

    /**
     * Get the status of the background job with the UUID
     * 
     * @param uuid  (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Job is still running </td><td>  -  </td></tr>
        <tr><td> 200 </td><td> Job was finished successfully and result can be downloaded from the body </td><td>  -  </td></tr>
        <tr><td> 303 </td><td> Job was finished successfully </td><td>  -  </td></tr>
        <tr><td> 410 </td><td> Job failed </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Job not found </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> getJobWithHttpInfo(String uuid) throws ApiException {
        okhttp3.Call localVarCall = getJobValidateBeforeCall(uuid, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Get the status of the background job with the UUID (asynchronously)
     * 
     * @param uuid  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Job is still running </td><td>  -  </td></tr>
        <tr><td> 200 </td><td> Job was finished successfully and result can be downloaded from the body </td><td>  -  </td></tr>
        <tr><td> 303 </td><td> Job was finished successfully </td><td>  -  </td></tr>
        <tr><td> 410 </td><td> Job failed </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Job not found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getJobAsync(String uuid, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = getJobValidateBeforeCall(uuid, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for importPost
     * @param body  (required)
     * @param overrideExisting If true, existing corpora will be overwritten by the uploaded ones. (optional, default to false)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Corpus import started. Returns a UUID for the background job which can be used with the &#x60;/jobs&#x60; endpoint </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call importPostCall(File body, Boolean overrideExisting, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/import";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (overrideExisting != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("override_existing", overrideExisting));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/octet-stream"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "bearerAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call importPostValidateBeforeCall(File body, Boolean overrideExisting, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling importPost(Async)");
        }
        

        okhttp3.Call localVarCall = importPostCall(body, overrideExisting, _callback);
        return localVarCall;

    }

    /**
     * Import all corpora which are part of the uploaded ZIP-file
     * This will search for all GraphML and relANNIS files in the uploaded ZIP file and imports them.
     * @param body  (required)
     * @param overrideExisting If true, existing corpora will be overwritten by the uploaded ones. (optional, default to false)
     * @return ImportResult
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Corpus import started. Returns a UUID for the background job which can be used with the &#x60;/jobs&#x60; endpoint </td><td>  -  </td></tr>
     </table>
     */
    public ImportResult importPost(File body, Boolean overrideExisting) throws ApiException {
        ApiResponse<ImportResult> localVarResp = importPostWithHttpInfo(body, overrideExisting);
        return localVarResp.getData();
    }

    /**
     * Import all corpora which are part of the uploaded ZIP-file
     * This will search for all GraphML and relANNIS files in the uploaded ZIP file and imports them.
     * @param body  (required)
     * @param overrideExisting If true, existing corpora will be overwritten by the uploaded ones. (optional, default to false)
     * @return ApiResponse&lt;ImportResult&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Corpus import started. Returns a UUID for the background job which can be used with the &#x60;/jobs&#x60; endpoint </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ImportResult> importPostWithHttpInfo(File body, Boolean overrideExisting) throws ApiException {
        okhttp3.Call localVarCall = importPostValidateBeforeCall(body, overrideExisting, null);
        Type localVarReturnType = new TypeToken<ImportResult>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Import all corpora which are part of the uploaded ZIP-file (asynchronously)
     * This will search for all GraphML and relANNIS files in the uploaded ZIP file and imports them.
     * @param body  (required)
     * @param overrideExisting If true, existing corpora will be overwritten by the uploaded ones. (optional, default to false)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Corpus import started. Returns a UUID for the background job which can be used with the &#x60;/jobs&#x60; endpoint </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call importPostAsync(File body, Boolean overrideExisting, final ApiCallback<ImportResult> _callback) throws ApiException {

        okhttp3.Call localVarCall = importPostValidateBeforeCall(body, overrideExisting, _callback);
        Type localVarReturnType = new TypeToken<ImportResult>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listGroups
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> All available user groups with their name and the corpora the user is allowed to access. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Access is forbidden if the requesting client does not have administrator privileges. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listGroupsCall(final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/groups";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "bearerAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listGroupsValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = listGroupsCall(_callback);
        return localVarCall;

    }

    /**
     * Get all available user groups
     * 
     * @return List&lt;Group&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> All available user groups with their name and the corpora the user is allowed to access. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Access is forbidden if the requesting client does not have administrator privileges. </td><td>  -  </td></tr>
     </table>
     */
    public List<Group> listGroups() throws ApiException {
        ApiResponse<List<Group>> localVarResp = listGroupsWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * Get all available user groups
     * 
     * @return ApiResponse&lt;List&lt;Group&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> All available user groups with their name and the corpora the user is allowed to access. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Access is forbidden if the requesting client does not have administrator privileges. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<Group>> listGroupsWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = listGroupsValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<Group>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get all available user groups (asynchronously)
     * 
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> All available user groups with their name and the corpora the user is allowed to access. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Access is forbidden if the requesting client does not have administrator privileges. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listGroupsAsync(final ApiCallback<List<Group>> _callback) throws ApiException {

        okhttp3.Call localVarCall = listGroupsValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<Group>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for putGroup
     * @param name  (required)
     * @param group The group to add (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Group was added or replaced successfully. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Access is forbidden if the requesting client does not have administrator privileges. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call putGroupCall(String name, Group group, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = group;

        // create path and map variables
        String localVarPath = "/groups/{name}"
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "bearerAuth" };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call putGroupValidateBeforeCall(String name, Group group, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling putGroup(Async)");
        }
        
        // verify the required parameter 'group' is set
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling putGroup(Async)");
        }
        

        okhttp3.Call localVarCall = putGroupCall(name, group, _callback);
        return localVarCall;

    }

    /**
     * Add or replace the user group given by its name
     * 
     * @param name  (required)
     * @param group The group to add (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Group was added or replaced successfully. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Access is forbidden if the requesting client does not have administrator privileges. </td><td>  -  </td></tr>
     </table>
     */
    public void putGroup(String name, Group group) throws ApiException {
        putGroupWithHttpInfo(name, group);
    }

    /**
     * Add or replace the user group given by its name
     * 
     * @param name  (required)
     * @param group The group to add (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Group was added or replaced successfully. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Access is forbidden if the requesting client does not have administrator privileges. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> putGroupWithHttpInfo(String name, Group group) throws ApiException {
        okhttp3.Call localVarCall = putGroupValidateBeforeCall(name, group, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Add or replace the user group given by its name (asynchronously)
     * 
     * @param name  (required)
     * @param group The group to add (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Group was added or replaced successfully. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Access is forbidden if the requesting client does not have administrator privileges. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call putGroupAsync(String name, Group group, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = putGroupValidateBeforeCall(name, group, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}
