/*
 * graphANNIS
 * Access the graphANNIS corpora and execute AQL queries with this service. 
 *
 * The version of the OpenAPI document: 0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.corpus_tools.annis.api;

import org.corpus_tools.annis.ApiCallback;
import org.corpus_tools.annis.ApiClient;
import org.corpus_tools.annis.ApiException;
import org.corpus_tools.annis.ApiResponse;
import org.corpus_tools.annis.Configuration;
import org.corpus_tools.annis.Pair;
import org.corpus_tools.annis.ProgressRequestBody;
import org.corpus_tools.annis.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import org.corpus_tools.annis.api.model.Annotation;
import org.corpus_tools.annis.api.model.AnnotationComponentType;
import org.corpus_tools.annis.api.model.Component;
import org.corpus_tools.annis.api.model.CorpusConfiguration;
import java.io.File;
import org.corpus_tools.annis.api.model.QueryLanguage;
import org.corpus_tools.annis.api.model.SubgraphWithContext;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CorporaApi {
    private ApiClient localVarApiClient;

    public CorporaApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CorporaApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for components
     * @param corpus The name of the corpus to get the components for. (required)
     * @param type Only return components with this type. (optional)
     * @param name Only return components with this name. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The list of components </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Corpus not found or access to corpus not allowed </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call componentsCall(String corpus, String type, String name, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/corpora/{corpus}/components"
            .replaceAll("\\{" + "corpus" + "\\}", localVarApiClient.escapeString(corpus.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (type != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("type", type));
        }

        if (name != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("name", name));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "bearerAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call componentsValidateBeforeCall(String corpus, String type, String name, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'corpus' is set
        if (corpus == null) {
            throw new ApiException("Missing the required parameter 'corpus' when calling components(Async)");
        }
        

        okhttp3.Call localVarCall = componentsCall(corpus, type, name, _callback);
        return localVarCall;

    }

    /**
     * List all edge components of the corpus.
     * 
     * @param corpus The name of the corpus to get the components for. (required)
     * @param type Only return components with this type. (optional)
     * @param name Only return components with this name. (optional)
     * @return List&lt;Component&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The list of components </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Corpus not found or access to corpus not allowed </td><td>  -  </td></tr>
     </table>
     */
    public List<Component> components(String corpus, String type, String name) throws ApiException {
        ApiResponse<List<Component>> localVarResp = componentsWithHttpInfo(corpus, type, name);
        return localVarResp.getData();
    }

    /**
     * List all edge components of the corpus.
     * 
     * @param corpus The name of the corpus to get the components for. (required)
     * @param type Only return components with this type. (optional)
     * @param name Only return components with this name. (optional)
     * @return ApiResponse&lt;List&lt;Component&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The list of components </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Corpus not found or access to corpus not allowed </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<Component>> componentsWithHttpInfo(String corpus, String type, String name) throws ApiException {
        okhttp3.Call localVarCall = componentsValidateBeforeCall(corpus, type, name, null);
        Type localVarReturnType = new TypeToken<List<Component>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List all edge components of the corpus. (asynchronously)
     * 
     * @param corpus The name of the corpus to get the components for. (required)
     * @param type Only return components with this type. (optional)
     * @param name Only return components with this name. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The list of components </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Corpus not found or access to corpus not allowed </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call componentsAsync(String corpus, String type, String name, final ApiCallback<List<Component>> _callback) throws ApiException {

        okhttp3.Call localVarCall = componentsValidateBeforeCall(corpus, type, name, _callback);
        Type localVarReturnType = new TypeToken<List<Component>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for corpusConfiguration
     * @param corpus The name of the corpus to get the configuration for. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Corpus not found or access to corpus not allowed </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call corpusConfigurationCall(String corpus, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/corpora/{corpus}/configuration"
            .replaceAll("\\{" + "corpus" + "\\}", localVarApiClient.escapeString(corpus.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "bearerAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call corpusConfigurationValidateBeforeCall(String corpus, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'corpus' is set
        if (corpus == null) {
            throw new ApiException("Missing the required parameter 'corpus' when calling corpusConfiguration(Async)");
        }
        

        okhttp3.Call localVarCall = corpusConfigurationCall(corpus, _callback);
        return localVarCall;

    }

    /**
     * Get the corpus configuration object.
     * The corpus configuration is created by the corpus authors to configure how the corpus should be displayed in query engines and visualizers.
     * @param corpus The name of the corpus to get the configuration for. (required)
     * @return CorpusConfiguration
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Corpus not found or access to corpus not allowed </td><td>  -  </td></tr>
     </table>
     */
    public CorpusConfiguration corpusConfiguration(String corpus) throws ApiException {
        ApiResponse<CorpusConfiguration> localVarResp = corpusConfigurationWithHttpInfo(corpus);
        return localVarResp.getData();
    }

    /**
     * Get the corpus configuration object.
     * The corpus configuration is created by the corpus authors to configure how the corpus should be displayed in query engines and visualizers.
     * @param corpus The name of the corpus to get the configuration for. (required)
     * @return ApiResponse&lt;CorpusConfiguration&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Corpus not found or access to corpus not allowed </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CorpusConfiguration> corpusConfigurationWithHttpInfo(String corpus) throws ApiException {
        okhttp3.Call localVarCall = corpusConfigurationValidateBeforeCall(corpus, null);
        Type localVarReturnType = new TypeToken<CorpusConfiguration>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get the corpus configuration object. (asynchronously)
     * The corpus configuration is created by the corpus authors to configure how the corpus should be displayed in query engines and visualizers.
     * @param corpus The name of the corpus to get the configuration for. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Corpus not found or access to corpus not allowed </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call corpusConfigurationAsync(String corpus, final ApiCallback<CorpusConfiguration> _callback) throws ApiException {

        okhttp3.Call localVarCall = corpusConfigurationValidateBeforeCall(corpus, _callback);
        Type localVarReturnType = new TypeToken<CorpusConfiguration>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteCorpus
     * @param corpus  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Deletion successful </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Corpus was not found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteCorpusCall(String corpus, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/corpora/{corpus}"
            .replaceAll("\\{" + "corpus" + "\\}", localVarApiClient.escapeString(corpus.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "bearerAuth" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteCorpusValidateBeforeCall(String corpus, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'corpus' is set
        if (corpus == null) {
            throw new ApiException("Missing the required parameter 'corpus' when calling deleteCorpus(Async)");
        }
        

        okhttp3.Call localVarCall = deleteCorpusCall(corpus, _callback);
        return localVarCall;

    }

    /**
     * Delete the given corpus.
     * 
     * @param corpus  (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Deletion successful </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Corpus was not found </td><td>  -  </td></tr>
     </table>
     */
    public void deleteCorpus(String corpus) throws ApiException {
        deleteCorpusWithHttpInfo(corpus);
    }

    /**
     * Delete the given corpus.
     * 
     * @param corpus  (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Deletion successful </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Corpus was not found </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteCorpusWithHttpInfo(String corpus) throws ApiException {
        okhttp3.Call localVarCall = deleteCorpusValidateBeforeCall(corpus, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete the given corpus. (asynchronously)
     * 
     * @param corpus  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Deletion successful </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Corpus was not found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteCorpusAsync(String corpus, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteCorpusValidateBeforeCall(corpus, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for edgeAnnotations
     * @param corpus The name of the corpus to get the configuration for. (required)
     * @param type The component type. (required)
     * @param layer The component layer. (required)
     * @param name The component name. (required)
     * @param listValues If true, possible values are returned. (optional, default to false)
     * @param onlyMostFrequentValues If true, only the most frequent value per annotation is returned. (optional, default to false)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The list of annotations </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Corpus not found or access to corpus not allowed </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call edgeAnnotationsCall(String corpus, String type, String layer, String name, Boolean listValues, Boolean onlyMostFrequentValues, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/corpora/{corpus}/edge-annotations/{type}/{layer}/{name}/"
            .replaceAll("\\{" + "corpus" + "\\}", localVarApiClient.escapeString(corpus.toString()))
            .replaceAll("\\{" + "type" + "\\}", localVarApiClient.escapeString(type.toString()))
            .replaceAll("\\{" + "layer" + "\\}", localVarApiClient.escapeString(layer.toString()))
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (listValues != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("list_values", listValues));
        }

        if (onlyMostFrequentValues != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("only_most_frequent_values", onlyMostFrequentValues));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "bearerAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call edgeAnnotationsValidateBeforeCall(String corpus, String type, String layer, String name, Boolean listValues, Boolean onlyMostFrequentValues, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'corpus' is set
        if (corpus == null) {
            throw new ApiException("Missing the required parameter 'corpus' when calling edgeAnnotations(Async)");
        }
        
        // verify the required parameter 'type' is set
        if (type == null) {
            throw new ApiException("Missing the required parameter 'type' when calling edgeAnnotations(Async)");
        }
        
        // verify the required parameter 'layer' is set
        if (layer == null) {
            throw new ApiException("Missing the required parameter 'layer' when calling edgeAnnotations(Async)");
        }
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling edgeAnnotations(Async)");
        }
        

        okhttp3.Call localVarCall = edgeAnnotationsCall(corpus, type, layer, name, listValues, onlyMostFrequentValues, _callback);
        return localVarCall;

    }

    /**
     * List all annotations of the corpus for a given edge component
     * 
     * @param corpus The name of the corpus to get the configuration for. (required)
     * @param type The component type. (required)
     * @param layer The component layer. (required)
     * @param name The component name. (required)
     * @param listValues If true, possible values are returned. (optional, default to false)
     * @param onlyMostFrequentValues If true, only the most frequent value per annotation is returned. (optional, default to false)
     * @return List&lt;Annotation&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The list of annotations </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Corpus not found or access to corpus not allowed </td><td>  -  </td></tr>
     </table>
     */
    public List<Annotation> edgeAnnotations(String corpus, String type, String layer, String name, Boolean listValues, Boolean onlyMostFrequentValues) throws ApiException {
        ApiResponse<List<Annotation>> localVarResp = edgeAnnotationsWithHttpInfo(corpus, type, layer, name, listValues, onlyMostFrequentValues);
        return localVarResp.getData();
    }

    /**
     * List all annotations of the corpus for a given edge component
     * 
     * @param corpus The name of the corpus to get the configuration for. (required)
     * @param type The component type. (required)
     * @param layer The component layer. (required)
     * @param name The component name. (required)
     * @param listValues If true, possible values are returned. (optional, default to false)
     * @param onlyMostFrequentValues If true, only the most frequent value per annotation is returned. (optional, default to false)
     * @return ApiResponse&lt;List&lt;Annotation&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The list of annotations </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Corpus not found or access to corpus not allowed </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<Annotation>> edgeAnnotationsWithHttpInfo(String corpus, String type, String layer, String name, Boolean listValues, Boolean onlyMostFrequentValues) throws ApiException {
        okhttp3.Call localVarCall = edgeAnnotationsValidateBeforeCall(corpus, type, layer, name, listValues, onlyMostFrequentValues, null);
        Type localVarReturnType = new TypeToken<List<Annotation>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List all annotations of the corpus for a given edge component (asynchronously)
     * 
     * @param corpus The name of the corpus to get the configuration for. (required)
     * @param type The component type. (required)
     * @param layer The component layer. (required)
     * @param name The component name. (required)
     * @param listValues If true, possible values are returned. (optional, default to false)
     * @param onlyMostFrequentValues If true, only the most frequent value per annotation is returned. (optional, default to false)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The list of annotations </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Corpus not found or access to corpus not allowed </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call edgeAnnotationsAsync(String corpus, String type, String layer, String name, Boolean listValues, Boolean onlyMostFrequentValues, final ApiCallback<List<Annotation>> _callback) throws ApiException {

        okhttp3.Call localVarCall = edgeAnnotationsValidateBeforeCall(corpus, type, layer, name, listValues, onlyMostFrequentValues, _callback);
        Type localVarReturnType = new TypeToken<List<Annotation>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getFile
     * @param corpus The name of the corpus to get the configuration for. (required)
     * @param name The name of the file node. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returns the content of the requested file. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Corpus or file not found. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getFileCall(String corpus, String name, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/corpora/{corpus}/files/{name}"
            .replaceAll("\\{" + "corpus" + "\\}", localVarApiClient.escapeString(corpus.toString()))
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "default"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "bearerAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getFileValidateBeforeCall(String corpus, String name, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'corpus' is set
        if (corpus == null) {
            throw new ApiException("Missing the required parameter 'corpus' when calling getFile(Async)");
        }
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getFile(Async)");
        }
        

        okhttp3.Call localVarCall = getFileCall(corpus, name, _callback);
        return localVarCall;

    }

    /**
     * Get an associated file for the corpus by its name.
     * The annotation graph of a corpus can contain special nodes of the type \&quot;file\&quot;,  which are connected to (sub-) corpus and document nodes with a &#x60;PartOf&#x60; relation. This endpoint allows to access the content of these file nodes. It supports [HTTP range requests](https://developer.mozilla.org/en-US/docs/Web/HTTP/Range_requests)  if you only need to access parts of the file. 
     * @param corpus The name of the corpus to get the configuration for. (required)
     * @param name The name of the file node. (required)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returns the content of the requested file. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Corpus or file not found. </td><td>  -  </td></tr>
     </table>
     */
    public File getFile(String corpus, String name) throws ApiException {
        ApiResponse<File> localVarResp = getFileWithHttpInfo(corpus, name);
        return localVarResp.getData();
    }

    /**
     * Get an associated file for the corpus by its name.
     * The annotation graph of a corpus can contain special nodes of the type \&quot;file\&quot;,  which are connected to (sub-) corpus and document nodes with a &#x60;PartOf&#x60; relation. This endpoint allows to access the content of these file nodes. It supports [HTTP range requests](https://developer.mozilla.org/en-US/docs/Web/HTTP/Range_requests)  if you only need to access parts of the file. 
     * @param corpus The name of the corpus to get the configuration for. (required)
     * @param name The name of the file node. (required)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returns the content of the requested file. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Corpus or file not found. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<File> getFileWithHttpInfo(String corpus, String name) throws ApiException {
        okhttp3.Call localVarCall = getFileValidateBeforeCall(corpus, name, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get an associated file for the corpus by its name. (asynchronously)
     * The annotation graph of a corpus can contain special nodes of the type \&quot;file\&quot;,  which are connected to (sub-) corpus and document nodes with a &#x60;PartOf&#x60; relation. This endpoint allows to access the content of these file nodes. It supports [HTTP range requests](https://developer.mozilla.org/en-US/docs/Web/HTTP/Range_requests)  if you only need to access parts of the file. 
     * @param corpus The name of the corpus to get the configuration for. (required)
     * @param name The name of the file node. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returns the content of the requested file. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Corpus or file not found. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getFileAsync(String corpus, String name, final ApiCallback<File> _callback) throws ApiException {

        okhttp3.Call localVarCall = getFileValidateBeforeCall(corpus, name, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listCorpora
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listCorporaCall(final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/corpora";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "bearerAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listCorporaValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = listCorporaCall(_callback);
        return localVarCall;

    }

    /**
     * Get a list of all corpora the user is authorized to use.
     * 
     * @return List&lt;String&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public List<String> listCorpora() throws ApiException {
        ApiResponse<List<String>> localVarResp = listCorporaWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * Get a list of all corpora the user is authorized to use.
     * 
     * @return ApiResponse&lt;List&lt;String&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<String>> listCorporaWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = listCorporaValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<String>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get a list of all corpora the user is authorized to use. (asynchronously)
     * 
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listCorporaAsync(final ApiCallback<List<String>> _callback) throws ApiException {

        okhttp3.Call localVarCall = listCorporaValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<String>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listFiles
     * @param corpus The name of the corpus to get the configuration for. (required)
     * @param node If given, only the files for the (sub-) corpus or document with this ID are returned. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returns the list of files </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listFilesCall(String corpus, String node, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/corpora/{corpus}/files"
            .replaceAll("\\{" + "corpus" + "\\}", localVarApiClient.escapeString(corpus.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (node != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("node", node));
        }

        final String[] localVarAccepts = {
            "default"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "bearerAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listFilesValidateBeforeCall(String corpus, String node, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'corpus' is set
        if (corpus == null) {
            throw new ApiException("Missing the required parameter 'corpus' when calling listFiles(Async)");
        }
        

        okhttp3.Call localVarCall = listFilesCall(corpus, node, _callback);
        return localVarCall;

    }

    /**
     * List the names of all associated file for the corpus.
     * 
     * @param corpus The name of the corpus to get the configuration for. (required)
     * @param node If given, only the files for the (sub-) corpus or document with this ID are returned. (optional)
     * @return List&lt;String&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returns the list of files </td><td>  -  </td></tr>
     </table>
     */
    public List<String> listFiles(String corpus, String node) throws ApiException {
        ApiResponse<List<String>> localVarResp = listFilesWithHttpInfo(corpus, node);
        return localVarResp.getData();
    }

    /**
     * List the names of all associated file for the corpus.
     * 
     * @param corpus The name of the corpus to get the configuration for. (required)
     * @param node If given, only the files for the (sub-) corpus or document with this ID are returned. (optional)
     * @return ApiResponse&lt;List&lt;String&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returns the list of files </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<String>> listFilesWithHttpInfo(String corpus, String node) throws ApiException {
        okhttp3.Call localVarCall = listFilesValidateBeforeCall(corpus, node, null);
        Type localVarReturnType = new TypeToken<List<String>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List the names of all associated file for the corpus. (asynchronously)
     * 
     * @param corpus The name of the corpus to get the configuration for. (required)
     * @param node If given, only the files for the (sub-) corpus or document with this ID are returned. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returns the list of files </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listFilesAsync(String corpus, String node, final ApiCallback<List<String>> _callback) throws ApiException {

        okhttp3.Call localVarCall = listFilesValidateBeforeCall(corpus, node, _callback);
        Type localVarReturnType = new TypeToken<List<String>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for nodeAnnotations
     * @param corpus The name of the corpus to get the configuration for. (required)
     * @param listValues If true, possible values are returned. (optional, default to false)
     * @param onlyMostFrequentValues If true, only the most frequent value per annotation is returned. (optional, default to false)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The list of annotations </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Corpus not found or access to corpus not allowed </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call nodeAnnotationsCall(String corpus, Boolean listValues, Boolean onlyMostFrequentValues, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/corpora/{corpus}/node-annotations"
            .replaceAll("\\{" + "corpus" + "\\}", localVarApiClient.escapeString(corpus.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (listValues != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("list_values", listValues));
        }

        if (onlyMostFrequentValues != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("only_most_frequent_values", onlyMostFrequentValues));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "bearerAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call nodeAnnotationsValidateBeforeCall(String corpus, Boolean listValues, Boolean onlyMostFrequentValues, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'corpus' is set
        if (corpus == null) {
            throw new ApiException("Missing the required parameter 'corpus' when calling nodeAnnotations(Async)");
        }
        

        okhttp3.Call localVarCall = nodeAnnotationsCall(corpus, listValues, onlyMostFrequentValues, _callback);
        return localVarCall;

    }

    /**
     * List all node annotations of the corpus.
     * 
     * @param corpus The name of the corpus to get the configuration for. (required)
     * @param listValues If true, possible values are returned. (optional, default to false)
     * @param onlyMostFrequentValues If true, only the most frequent value per annotation is returned. (optional, default to false)
     * @return List&lt;Annotation&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The list of annotations </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Corpus not found or access to corpus not allowed </td><td>  -  </td></tr>
     </table>
     */
    public List<Annotation> nodeAnnotations(String corpus, Boolean listValues, Boolean onlyMostFrequentValues) throws ApiException {
        ApiResponse<List<Annotation>> localVarResp = nodeAnnotationsWithHttpInfo(corpus, listValues, onlyMostFrequentValues);
        return localVarResp.getData();
    }

    /**
     * List all node annotations of the corpus.
     * 
     * @param corpus The name of the corpus to get the configuration for. (required)
     * @param listValues If true, possible values are returned. (optional, default to false)
     * @param onlyMostFrequentValues If true, only the most frequent value per annotation is returned. (optional, default to false)
     * @return ApiResponse&lt;List&lt;Annotation&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The list of annotations </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Corpus not found or access to corpus not allowed </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<Annotation>> nodeAnnotationsWithHttpInfo(String corpus, Boolean listValues, Boolean onlyMostFrequentValues) throws ApiException {
        okhttp3.Call localVarCall = nodeAnnotationsValidateBeforeCall(corpus, listValues, onlyMostFrequentValues, null);
        Type localVarReturnType = new TypeToken<List<Annotation>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List all node annotations of the corpus. (asynchronously)
     * 
     * @param corpus The name of the corpus to get the configuration for. (required)
     * @param listValues If true, possible values are returned. (optional, default to false)
     * @param onlyMostFrequentValues If true, only the most frequent value per annotation is returned. (optional, default to false)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The list of annotations </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Corpus not found or access to corpus not allowed </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call nodeAnnotationsAsync(String corpus, Boolean listValues, Boolean onlyMostFrequentValues, final ApiCallback<List<Annotation>> _callback) throws ApiException {

        okhttp3.Call localVarCall = nodeAnnotationsValidateBeforeCall(corpus, listValues, onlyMostFrequentValues, _callback);
        Type localVarReturnType = new TypeToken<List<Annotation>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for subgraphForNodes
     * @param corpus The name of the corpus to get the subgraph for. (required)
     * @param subgraphWithContext The definition of the subgraph to extract. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The subgraph in the GraphML format with the graphANNIS data model. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call subgraphForNodesCall(String corpus, SubgraphWithContext subgraphWithContext, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = subgraphWithContext;

        // create path and map variables
        String localVarPath = "/corpora/{corpus}/subgraph"
            .replaceAll("\\{" + "corpus" + "\\}", localVarApiClient.escapeString(corpus.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/xml"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "bearerAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call subgraphForNodesValidateBeforeCall(String corpus, SubgraphWithContext subgraphWithContext, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'corpus' is set
        if (corpus == null) {
            throw new ApiException("Missing the required parameter 'corpus' when calling subgraphForNodes(Async)");
        }
        
        // verify the required parameter 'subgraphWithContext' is set
        if (subgraphWithContext == null) {
            throw new ApiException("Missing the required parameter 'subgraphWithContext' when calling subgraphForNodes(Async)");
        }
        

        okhttp3.Call localVarCall = subgraphForNodesCall(corpus, subgraphWithContext, _callback);
        return localVarCall;

    }

    /**
     * Get a subgraph of the corpus format given a list of nodes and a context.
     * This creates a subgraph for node IDs, which can e.g. generated by executing a &#x60;find&#x60; query. The subgraph contains  - the given nodes,  - all tokens that are covered by the given nodes, - all tokens left and right in the given context from the tokens covered by the give nodes, - all other nodes covering the tokens of the given context. The annotation graph also includes all edges between the included nodes. 
     * @param corpus The name of the corpus to get the subgraph for. (required)
     * @param subgraphWithContext The definition of the subgraph to extract. (required)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The subgraph in the GraphML format with the graphANNIS data model. </td><td>  -  </td></tr>
     </table>
     */
    public File subgraphForNodes(String corpus, SubgraphWithContext subgraphWithContext) throws ApiException {
        ApiResponse<File> localVarResp = subgraphForNodesWithHttpInfo(corpus, subgraphWithContext);
        return localVarResp.getData();
    }

    /**
     * Get a subgraph of the corpus format given a list of nodes and a context.
     * This creates a subgraph for node IDs, which can e.g. generated by executing a &#x60;find&#x60; query. The subgraph contains  - the given nodes,  - all tokens that are covered by the given nodes, - all tokens left and right in the given context from the tokens covered by the give nodes, - all other nodes covering the tokens of the given context. The annotation graph also includes all edges between the included nodes. 
     * @param corpus The name of the corpus to get the subgraph for. (required)
     * @param subgraphWithContext The definition of the subgraph to extract. (required)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The subgraph in the GraphML format with the graphANNIS data model. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<File> subgraphForNodesWithHttpInfo(String corpus, SubgraphWithContext subgraphWithContext) throws ApiException {
        okhttp3.Call localVarCall = subgraphForNodesValidateBeforeCall(corpus, subgraphWithContext, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get a subgraph of the corpus format given a list of nodes and a context. (asynchronously)
     * This creates a subgraph for node IDs, which can e.g. generated by executing a &#x60;find&#x60; query. The subgraph contains  - the given nodes,  - all tokens that are covered by the given nodes, - all tokens left and right in the given context from the tokens covered by the give nodes, - all other nodes covering the tokens of the given context. The annotation graph also includes all edges between the included nodes. 
     * @param corpus The name of the corpus to get the subgraph for. (required)
     * @param subgraphWithContext The definition of the subgraph to extract. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The subgraph in the GraphML format with the graphANNIS data model. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call subgraphForNodesAsync(String corpus, SubgraphWithContext subgraphWithContext, final ApiCallback<File> _callback) throws ApiException {

        okhttp3.Call localVarCall = subgraphForNodesValidateBeforeCall(corpus, subgraphWithContext, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for subgraphForQuery
     * @param corpus The name of the corpus to get the subgraph for. (required)
     * @param query The query which defines the nodes to include. (required)
     * @param queryLanguage  (optional, default to AQL)
     * @param componentTypeFilter If given, restricts the included edges to components with the given type. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The subgraph in the GraphML format with the graphANNIS data model. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call subgraphForQueryCall(String corpus, String query, QueryLanguage queryLanguage, AnnotationComponentType componentTypeFilter, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/corpora/{corpus}/subgraph-for-query"
            .replaceAll("\\{" + "corpus" + "\\}", localVarApiClient.escapeString(corpus.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (query != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("query", query));
        }

        if (queryLanguage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("query_language", queryLanguage));
        }

        if (componentTypeFilter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("component_type_filter", componentTypeFilter));
        }

        final String[] localVarAccepts = {
            "application/xml"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "bearerAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call subgraphForQueryValidateBeforeCall(String corpus, String query, QueryLanguage queryLanguage, AnnotationComponentType componentTypeFilter, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'corpus' is set
        if (corpus == null) {
            throw new ApiException("Missing the required parameter 'corpus' when calling subgraphForQuery(Async)");
        }
        
        // verify the required parameter 'query' is set
        if (query == null) {
            throw new ApiException("Missing the required parameter 'query' when calling subgraphForQuery(Async)");
        }
        

        okhttp3.Call localVarCall = subgraphForQueryCall(corpus, query, queryLanguage, componentTypeFilter, _callback);
        return localVarCall;

    }

    /**
     * Get a subgraph of the corpus format given a list of nodes and a context.
     * This only includes the nodes that are the result of the given query and no context is created automatically. The annotation graph also includes all edges between the included nodes. 
     * @param corpus The name of the corpus to get the subgraph for. (required)
     * @param query The query which defines the nodes to include. (required)
     * @param queryLanguage  (optional, default to AQL)
     * @param componentTypeFilter If given, restricts the included edges to components with the given type. (optional)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The subgraph in the GraphML format with the graphANNIS data model. </td><td>  -  </td></tr>
     </table>
     */
    public File subgraphForQuery(String corpus, String query, QueryLanguage queryLanguage, AnnotationComponentType componentTypeFilter) throws ApiException {
        ApiResponse<File> localVarResp = subgraphForQueryWithHttpInfo(corpus, query, queryLanguage, componentTypeFilter);
        return localVarResp.getData();
    }

    /**
     * Get a subgraph of the corpus format given a list of nodes and a context.
     * This only includes the nodes that are the result of the given query and no context is created automatically. The annotation graph also includes all edges between the included nodes. 
     * @param corpus The name of the corpus to get the subgraph for. (required)
     * @param query The query which defines the nodes to include. (required)
     * @param queryLanguage  (optional, default to AQL)
     * @param componentTypeFilter If given, restricts the included edges to components with the given type. (optional)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The subgraph in the GraphML format with the graphANNIS data model. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<File> subgraphForQueryWithHttpInfo(String corpus, String query, QueryLanguage queryLanguage, AnnotationComponentType componentTypeFilter) throws ApiException {
        okhttp3.Call localVarCall = subgraphForQueryValidateBeforeCall(corpus, query, queryLanguage, componentTypeFilter, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get a subgraph of the corpus format given a list of nodes and a context. (asynchronously)
     * This only includes the nodes that are the result of the given query and no context is created automatically. The annotation graph also includes all edges between the included nodes. 
     * @param corpus The name of the corpus to get the subgraph for. (required)
     * @param query The query which defines the nodes to include. (required)
     * @param queryLanguage  (optional, default to AQL)
     * @param componentTypeFilter If given, restricts the included edges to components with the given type. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The subgraph in the GraphML format with the graphANNIS data model. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call subgraphForQueryAsync(String corpus, String query, QueryLanguage queryLanguage, AnnotationComponentType componentTypeFilter, final ApiCallback<File> _callback) throws ApiException {

        okhttp3.Call localVarCall = subgraphForQueryValidateBeforeCall(corpus, query, queryLanguage, componentTypeFilter, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
