/*
 * graphANNIS
 * Access the graphANNIS corpora and execute AQL queries with this service. 
 *
 * The version of the OpenAPI document: 0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.corpus_tools.annis.api;

import org.corpus_tools.annis.ApiCallback;
import org.corpus_tools.annis.ApiClient;
import org.corpus_tools.annis.ApiException;
import org.corpus_tools.annis.ApiResponse;
import org.corpus_tools.annis.Configuration;
import org.corpus_tools.annis.Pair;
import org.corpus_tools.annis.ProgressRequestBody;
import org.corpus_tools.annis.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import org.corpus_tools.annis.api.model.AnnotationComponentType;
import org.corpus_tools.annis.api.model.BadRequestError;
import org.corpus_tools.annis.api.model.CountExtra;
import org.corpus_tools.annis.api.model.CountQuery;
import java.io.File;
import org.corpus_tools.annis.api.model.FindQuery;
import org.corpus_tools.annis.api.model.FrequencyQuery;
import org.corpus_tools.annis.api.model.FrequencyTableRow;
import org.corpus_tools.annis.api.model.QueryAttributeDescription;
import org.corpus_tools.annis.api.model.QueryLanguage;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SearchApi {
    private ApiClient localVarApiClient;

    public SearchApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SearchApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for count
     * @param countQuery The definition of the query to execute. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The extended count result. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Query could not be parsed or corpus does not exist </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call countCall(CountQuery countQuery, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = countQuery;

        // create path and map variables
        String localVarPath = "/search/count";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "bearerAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call countValidateBeforeCall(CountQuery countQuery, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'countQuery' is set
        if (countQuery == null) {
            throw new ApiException("Missing the required parameter 'countQuery' when calling count(Async)");
        }
        

        okhttp3.Call localVarCall = countCall(countQuery, _callback);
        return localVarCall;

    }

    /**
     * Count the number of results for a query.
     * 
     * @param countQuery The definition of the query to execute. (required)
     * @return CountExtra
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The extended count result. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Query could not be parsed or corpus does not exist </td><td>  -  </td></tr>
     </table>
     */
    public CountExtra count(CountQuery countQuery) throws ApiException {
        ApiResponse<CountExtra> localVarResp = countWithHttpInfo(countQuery);
        return localVarResp.getData();
    }

    /**
     * Count the number of results for a query.
     * 
     * @param countQuery The definition of the query to execute. (required)
     * @return ApiResponse&lt;CountExtra&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The extended count result. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Query could not be parsed or corpus does not exist </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CountExtra> countWithHttpInfo(CountQuery countQuery) throws ApiException {
        okhttp3.Call localVarCall = countValidateBeforeCall(countQuery, null);
        Type localVarReturnType = new TypeToken<CountExtra>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Count the number of results for a query. (asynchronously)
     * 
     * @param countQuery The definition of the query to execute. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The extended count result. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Query could not be parsed or corpus does not exist </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call countAsync(CountQuery countQuery, final ApiCallback<CountExtra> _callback) throws ApiException {

        okhttp3.Call localVarCall = countValidateBeforeCall(countQuery, _callback);
        Type localVarReturnType = new TypeToken<CountExtra>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for find
     * @param findQuery The definition of the query to execute. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The matches for the given query. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Query could not be parsed or corpus does not exist </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call findCall(FindQuery findQuery, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = findQuery;

        // create path and map variables
        String localVarPath = "/search/find";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "text/plain", "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "bearerAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call findValidateBeforeCall(FindQuery findQuery, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'findQuery' is set
        if (findQuery == null) {
            throw new ApiException("Missing the required parameter 'findQuery' when calling find(Async)");
        }
        

        okhttp3.Call localVarCall = findCall(findQuery, _callback);
        return localVarCall;

    }

    /**
     * Find results for a query and return the IDs of the matched nodes.
     * 
     * @param findQuery The definition of the query to execute. (required)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The matches for the given query. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Query could not be parsed or corpus does not exist </td><td>  -  </td></tr>
     </table>
     */
    public File find(FindQuery findQuery) throws ApiException {
        ApiResponse<File> localVarResp = findWithHttpInfo(findQuery);
        return localVarResp.getData();
    }

    /**
     * Find results for a query and return the IDs of the matched nodes.
     * 
     * @param findQuery The definition of the query to execute. (required)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The matches for the given query. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Query could not be parsed or corpus does not exist </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<File> findWithHttpInfo(FindQuery findQuery) throws ApiException {
        okhttp3.Call localVarCall = findValidateBeforeCall(findQuery, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Find results for a query and return the IDs of the matched nodes. (asynchronously)
     * 
     * @param findQuery The definition of the query to execute. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The matches for the given query. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Query could not be parsed or corpus does not exist </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call findAsync(FindQuery findQuery, final ApiCallback<File> _callback) throws ApiException {

        okhttp3.Call localVarCall = findValidateBeforeCall(findQuery, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for frequency
     * @param frequencyQuery The definition of the query to execute. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Frequency of different annotation values as table </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Query could not be parsed or corpus does not exist </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call frequencyCall(FrequencyQuery frequencyQuery, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = frequencyQuery;

        // create path and map variables
        String localVarPath = "/search/frequency";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "bearerAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call frequencyValidateBeforeCall(FrequencyQuery frequencyQuery, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'frequencyQuery' is set
        if (frequencyQuery == null) {
            throw new ApiException("Missing the required parameter 'frequencyQuery' when calling frequency(Async)");
        }
        

        okhttp3.Call localVarCall = frequencyCall(frequencyQuery, _callback);
        return localVarCall;

    }

    /**
     * Find results for a query and return the IDs of the matched nodes.
     * 
     * @param frequencyQuery The definition of the query to execute. (required)
     * @return List&lt;FrequencyTableRow&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Frequency of different annotation values as table </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Query could not be parsed or corpus does not exist </td><td>  -  </td></tr>
     </table>
     */
    public List<FrequencyTableRow> frequency(FrequencyQuery frequencyQuery) throws ApiException {
        ApiResponse<List<FrequencyTableRow>> localVarResp = frequencyWithHttpInfo(frequencyQuery);
        return localVarResp.getData();
    }

    /**
     * Find results for a query and return the IDs of the matched nodes.
     * 
     * @param frequencyQuery The definition of the query to execute. (required)
     * @return ApiResponse&lt;List&lt;FrequencyTableRow&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Frequency of different annotation values as table </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Query could not be parsed or corpus does not exist </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<FrequencyTableRow>> frequencyWithHttpInfo(FrequencyQuery frequencyQuery) throws ApiException {
        okhttp3.Call localVarCall = frequencyValidateBeforeCall(frequencyQuery, null);
        Type localVarReturnType = new TypeToken<List<FrequencyTableRow>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Find results for a query and return the IDs of the matched nodes. (asynchronously)
     * 
     * @param frequencyQuery The definition of the query to execute. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Frequency of different annotation values as table </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Query could not be parsed or corpus does not exist </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call frequencyAsync(FrequencyQuery frequencyQuery, final ApiCallback<List<FrequencyTableRow>> _callback) throws ApiException {

        okhttp3.Call localVarCall = frequencyValidateBeforeCall(frequencyQuery, _callback);
        Type localVarReturnType = new TypeToken<List<FrequencyTableRow>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for nodeDescriptions
     * @param query The query to parse (optional)
     * @param queryLanguage  (optional, default to AQL)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List of query node descriptions </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Query could not be parsed </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call nodeDescriptionsCall(String query, QueryLanguage queryLanguage, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/search/node-descriptions";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (query != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("query", query));
        }

        if (queryLanguage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("query_language", queryLanguage));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "bearerAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call nodeDescriptionsValidateBeforeCall(String query, QueryLanguage queryLanguage, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = nodeDescriptionsCall(query, queryLanguage, _callback);
        return localVarCall;

    }

    /**
     * Parses a query and returns a description for all the nodes in the query.
     * 
     * @param query The query to parse (optional)
     * @param queryLanguage  (optional, default to AQL)
     * @return List&lt;QueryAttributeDescription&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List of query node descriptions </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Query could not be parsed </td><td>  -  </td></tr>
     </table>
     */
    public List<QueryAttributeDescription> nodeDescriptions(String query, QueryLanguage queryLanguage) throws ApiException {
        ApiResponse<List<QueryAttributeDescription>> localVarResp = nodeDescriptionsWithHttpInfo(query, queryLanguage);
        return localVarResp.getData();
    }

    /**
     * Parses a query and returns a description for all the nodes in the query.
     * 
     * @param query The query to parse (optional)
     * @param queryLanguage  (optional, default to AQL)
     * @return ApiResponse&lt;List&lt;QueryAttributeDescription&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List of query node descriptions </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Query could not be parsed </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<QueryAttributeDescription>> nodeDescriptionsWithHttpInfo(String query, QueryLanguage queryLanguage) throws ApiException {
        okhttp3.Call localVarCall = nodeDescriptionsValidateBeforeCall(query, queryLanguage, null);
        Type localVarReturnType = new TypeToken<List<QueryAttributeDescription>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Parses a query and returns a description for all the nodes in the query. (asynchronously)
     * 
     * @param query The query to parse (optional)
     * @param queryLanguage  (optional, default to AQL)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List of query node descriptions </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Query could not be parsed </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call nodeDescriptionsAsync(String query, QueryLanguage queryLanguage, final ApiCallback<List<QueryAttributeDescription>> _callback) throws ApiException {

        okhttp3.Call localVarCall = nodeDescriptionsValidateBeforeCall(query, queryLanguage, _callback);
        Type localVarReturnType = new TypeToken<List<QueryAttributeDescription>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for subgraphForQuery
     * @param corpus The name of the corpus to get the subgraph for. (required)
     * @param query The query which defines the nodes to include. (required)
     * @param queryLanguage  (optional, default to AQL)
     * @param componentTypeFilter If given, restricts the included edges to components with the given type. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The subgraph in the GraphML format with the graphANNIS data model. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call subgraphForQueryCall(String corpus, String query, QueryLanguage queryLanguage, AnnotationComponentType componentTypeFilter, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/corpora/{corpus}/subgraph-for-query"
            .replaceAll("\\{" + "corpus" + "\\}", localVarApiClient.escapeString(corpus.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (query != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("query", query));
        }

        if (queryLanguage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("query_language", queryLanguage));
        }

        if (componentTypeFilter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("component_type_filter", componentTypeFilter));
        }

        final String[] localVarAccepts = {
            "application/xml"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "bearerAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call subgraphForQueryValidateBeforeCall(String corpus, String query, QueryLanguage queryLanguage, AnnotationComponentType componentTypeFilter, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'corpus' is set
        if (corpus == null) {
            throw new ApiException("Missing the required parameter 'corpus' when calling subgraphForQuery(Async)");
        }
        
        // verify the required parameter 'query' is set
        if (query == null) {
            throw new ApiException("Missing the required parameter 'query' when calling subgraphForQuery(Async)");
        }
        

        okhttp3.Call localVarCall = subgraphForQueryCall(corpus, query, queryLanguage, componentTypeFilter, _callback);
        return localVarCall;

    }

    /**
     * Get a subgraph of the corpus format given a list of nodes and a context.
     * This only includes the nodes that are the result of the given query and no context is created automatically. The annotation graph also includes all edges between the included nodes. 
     * @param corpus The name of the corpus to get the subgraph for. (required)
     * @param query The query which defines the nodes to include. (required)
     * @param queryLanguage  (optional, default to AQL)
     * @param componentTypeFilter If given, restricts the included edges to components with the given type. (optional)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The subgraph in the GraphML format with the graphANNIS data model. </td><td>  -  </td></tr>
     </table>
     */
    public File subgraphForQuery(String corpus, String query, QueryLanguage queryLanguage, AnnotationComponentType componentTypeFilter) throws ApiException {
        ApiResponse<File> localVarResp = subgraphForQueryWithHttpInfo(corpus, query, queryLanguage, componentTypeFilter);
        return localVarResp.getData();
    }

    /**
     * Get a subgraph of the corpus format given a list of nodes and a context.
     * This only includes the nodes that are the result of the given query and no context is created automatically. The annotation graph also includes all edges between the included nodes. 
     * @param corpus The name of the corpus to get the subgraph for. (required)
     * @param query The query which defines the nodes to include. (required)
     * @param queryLanguage  (optional, default to AQL)
     * @param componentTypeFilter If given, restricts the included edges to components with the given type. (optional)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The subgraph in the GraphML format with the graphANNIS data model. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<File> subgraphForQueryWithHttpInfo(String corpus, String query, QueryLanguage queryLanguage, AnnotationComponentType componentTypeFilter) throws ApiException {
        okhttp3.Call localVarCall = subgraphForQueryValidateBeforeCall(corpus, query, queryLanguage, componentTypeFilter, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get a subgraph of the corpus format given a list of nodes and a context. (asynchronously)
     * This only includes the nodes that are the result of the given query and no context is created automatically. The annotation graph also includes all edges between the included nodes. 
     * @param corpus The name of the corpus to get the subgraph for. (required)
     * @param query The query which defines the nodes to include. (required)
     * @param queryLanguage  (optional, default to AQL)
     * @param componentTypeFilter If given, restricts the included edges to components with the given type. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The subgraph in the GraphML format with the graphANNIS data model. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call subgraphForQueryAsync(String corpus, String query, QueryLanguage queryLanguage, AnnotationComponentType componentTypeFilter, final ApiCallback<File> _callback) throws ApiException {

        okhttp3.Call localVarCall = subgraphForQueryValidateBeforeCall(corpus, query, queryLanguage, componentTypeFilter, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
