/*
 * graphANNIS
 * Access the graphANNIS corpora and execute AQL queries with this service. 
 *
 * The version of the OpenAPI document: 0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.corpus_tools.annis.api.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.corpus_tools.annis.api.model.QueryLanguage;
import java.io.Serializable;

/**
 * Query definition to find matches
 */
@ApiModel(description = "Query definition to find matches")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2021-08-17T18:58:55.674+02:00[Europe/Berlin]")
public class FindQuery implements Serializable {
  private static final long serialVersionUID = 1L;

  public static final String SERIALIZED_NAME_QUERY = "query";
  @SerializedName(SERIALIZED_NAME_QUERY)
  private String query;

  public static final String SERIALIZED_NAME_QUERY_LANGUAGE = "query_language";
  @SerializedName(SERIALIZED_NAME_QUERY_LANGUAGE)
  private QueryLanguage queryLanguage = QueryLanguage.AQL;

  public static final String SERIALIZED_NAME_CORPORA = "corpora";
  @SerializedName(SERIALIZED_NAME_CORPORA)
  private List<String> corpora = null;

  public static final String SERIALIZED_NAME_LIMIT = "limit";
  @SerializedName(SERIALIZED_NAME_LIMIT)
  private Integer limit;

  public static final String SERIALIZED_NAME_OFFSET = "offset";
  @SerializedName(SERIALIZED_NAME_OFFSET)
  private Integer offset = 0;

  /**
   * Gets or Sets order
   */
  @JsonAdapter(OrderEnum.Adapter.class)
  public enum OrderEnum {
    NORMAL("Normal"),
    
    INVERTED("Inverted"),
    
    RANDOMIZED("Randomized"),
    
    NOTSORTED("NotSorted");

    private String value;

    OrderEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static OrderEnum fromValue(String value) {
      for (OrderEnum b : OrderEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<OrderEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final OrderEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public OrderEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return OrderEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_ORDER = "order";
  @SerializedName(SERIALIZED_NAME_ORDER)
  private OrderEnum order = OrderEnum.NORMAL;


  public FindQuery query(String query) {
    
    this.query = query;
    return this;
  }

   /**
   * The query to execute.
   * @return query
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "tok", value = "The query to execute.")

  public String getQuery() {
    return query;
  }


  public void setQuery(String query) {
    this.query = query;
  }


  public FindQuery queryLanguage(QueryLanguage queryLanguage) {
    
    this.queryLanguage = queryLanguage;
    return this;
  }

   /**
   * Get queryLanguage
   * @return queryLanguage
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public QueryLanguage getQueryLanguage() {
    return queryLanguage;
  }


  public void setQueryLanguage(QueryLanguage queryLanguage) {
    this.queryLanguage = queryLanguage;
  }


  public FindQuery corpora(List<String> corpora) {
    
    this.corpora = corpora;
    return this;
  }

  public FindQuery addCorporaItem(String corporaItem) {
    if (this.corpora == null) {
      this.corpora = new ArrayList<>();
    }
    this.corpora.add(corporaItem);
    return this;
  }

   /**
   * List of corpus names/identifiers.
   * @return corpora
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "[\"GUM\",\"pcc2.1\"]", value = "List of corpus names/identifiers.")

  public List<String> getCorpora() {
    return corpora;
  }


  public void setCorpora(List<String> corpora) {
    this.corpora = corpora;
  }


  public FindQuery limit(Integer limit) {
    
    this.limit = limit;
    return this;
  }

   /**
   * Return at most &#x60;n&#x60; matches, where &#x60;n&#x60; is the limit.  Use &#x60;null&#x60; to allow unlimited result sizes.
   * @return limit
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "10", value = "Return at most `n` matches, where `n` is the limit.  Use `null` to allow unlimited result sizes.")

  public Integer getLimit() {
    return limit;
  }


  public void setLimit(Integer limit) {
    this.limit = limit;
  }


  public FindQuery offset(Integer offset) {
    
    this.offset = offset;
    return this;
  }

   /**
   * Skip the &#x60;n&#x60; first results, where &#x60;n&#x60; is the offset.
   * @return offset
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Skip the `n` first results, where `n` is the offset.")

  public Integer getOffset() {
    return offset;
  }


  public void setOffset(Integer offset) {
    this.offset = offset;
  }


  public FindQuery order(OrderEnum order) {
    
    this.order = order;
    return this;
  }

   /**
   * Get order
   * @return order
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public OrderEnum getOrder() {
    return order;
  }


  public void setOrder(OrderEnum order) {
    this.order = order;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FindQuery findQuery = (FindQuery) o;
    return Objects.equals(this.query, findQuery.query) &&
        Objects.equals(this.queryLanguage, findQuery.queryLanguage) &&
        Objects.equals(this.corpora, findQuery.corpora) &&
        Objects.equals(this.limit, findQuery.limit) &&
        Objects.equals(this.offset, findQuery.offset) &&
        Objects.equals(this.order, findQuery.order);
  }

  @Override
  public int hashCode() {
    return Objects.hash(query, queryLanguage, corpora, limit, offset, order);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FindQuery {\n");
    sb.append("    query: ").append(toIndentedString(query)).append("\n");
    sb.append("    queryLanguage: ").append(toIndentedString(queryLanguage)).append("\n");
    sb.append("    corpora: ").append(toIndentedString(corpora)).append("\n");
    sb.append("    limit: ").append(toIndentedString(limit)).append("\n");
    sb.append("    offset: ").append(toIndentedString(offset)).append("\n");
    sb.append("    order: ").append(toIndentedString(order)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

