/*
 * graphANNIS
 * Access the graphANNIS corpora and execute AQL queries with this service. 
 *
 * The version of the OpenAPI document: 0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.corpus_tools.annis.api.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.io.Serializable;

/**
 * A rule when to trigger a visualizer for a specific result.
 */
@ApiModel(description = "A rule when to trigger a visualizer for a specific result.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2021-08-17T18:58:55.674+02:00[Europe/Berlin]")
public class VisualizerRule implements Serializable {
  private static final long serialVersionUID = 1L;

  /**
   * On which element type to trigger the visualizer on
   */
  @JsonAdapter(ElementEnum.Adapter.class)
  public enum ElementEnum {
    NODE("node"),
    
    EDGE("edge");

    private String value;

    ElementEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static ElementEnum fromValue(String value) {
      for (ElementEnum b : ElementEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<ElementEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final ElementEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public ElementEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return ElementEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_ELEMENT = "element";
  @SerializedName(SERIALIZED_NAME_ELEMENT)
  private ElementEnum element;

  public static final String SERIALIZED_NAME_LAYER = "layer";
  @SerializedName(SERIALIZED_NAME_LAYER)
  private String layer;

  public static final String SERIALIZED_NAME_VIS_TYPE = "vis_type";
  @SerializedName(SERIALIZED_NAME_VIS_TYPE)
  private String visType;

  public static final String SERIALIZED_NAME_DISPLAY_NAME = "display_name";
  @SerializedName(SERIALIZED_NAME_DISPLAY_NAME)
  private String displayName;

  /**
   * The default display state of the visualizer before any user interaction.
   */
  @JsonAdapter(VisibilityEnum.Adapter.class)
  public enum VisibilityEnum {
    HIDDEN("hidden"),
    
    VISIBLE("visible"),
    
    PERMANENT("permanent"),
    
    PRELOADED("preloaded");

    private String value;

    VisibilityEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static VisibilityEnum fromValue(String value) {
      for (VisibilityEnum b : VisibilityEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<VisibilityEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final VisibilityEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public VisibilityEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return VisibilityEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_VISIBILITY = "visibility";
  @SerializedName(SERIALIZED_NAME_VISIBILITY)
  private VisibilityEnum visibility;

  public static final String SERIALIZED_NAME_MAPPINGS = "mappings";
  @SerializedName(SERIALIZED_NAME_MAPPINGS)
  private Map<String, String> mappings = null;


  public VisualizerRule element(ElementEnum element) {
    
    this.element = element;
    return this;
  }

   /**
   * On which element type to trigger the visualizer on
   * @return element
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "On which element type to trigger the visualizer on")

  public ElementEnum getElement() {
    return element;
  }


  public void setElement(ElementEnum element) {
    this.element = element;
  }


  public VisualizerRule layer(String layer) {
    
    this.layer = layer;
    return this;
  }

   /**
   * In which layer the element needs to be part of to trigger this visualizer.  Only relevant for edges, since only they are part of layers. If not given, elements of all layers trigger this visualization. 
   * @return layer
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "In which layer the element needs to be part of to trigger this visualizer.  Only relevant for edges, since only they are part of layers. If not given, elements of all layers trigger this visualization. ")

  public String getLayer() {
    return layer;
  }


  public void setLayer(String layer) {
    this.layer = layer;
  }


  public VisualizerRule visType(String visType) {
    
    this.visType = visType;
    return this;
  }

   /**
   * The abstract type of visualization, e.g. \&quot;tree\&quot;, \&quot;discourse\&quot;, \&quot;grid\&quot;, ...
   * @return visType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The abstract type of visualization, e.g. \"tree\", \"discourse\", \"grid\", ...")

  public String getVisType() {
    return visType;
  }


  public void setVisType(String visType) {
    this.visType = visType;
  }


  public VisualizerRule displayName(String displayName) {
    
    this.displayName = displayName;
    return this;
  }

   /**
   * A text displayed to the user describing this visualization
   * @return displayName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A text displayed to the user describing this visualization")

  public String getDisplayName() {
    return displayName;
  }


  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }


  public VisualizerRule visibility(VisibilityEnum visibility) {
    
    this.visibility = visibility;
    return this;
  }

   /**
   * The default display state of the visualizer before any user interaction.
   * @return visibility
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The default display state of the visualizer before any user interaction.")

  public VisibilityEnum getVisibility() {
    return visibility;
  }


  public void setVisibility(VisibilityEnum visibility) {
    this.visibility = visibility;
  }


  public VisualizerRule mappings(Map<String, String> mappings) {
    
    this.mappings = mappings;
    return this;
  }

  public VisualizerRule putMappingsItem(String key, String mappingsItem) {
    if (this.mappings == null) {
      this.mappings = new HashMap<>();
    }
    this.mappings.put(key, mappingsItem);
    return this;
  }

   /**
   * Additional configuration given as generic map of key values to the visualizer.
   * @return mappings
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Additional configuration given as generic map of key values to the visualizer.")

  public Map<String, String> getMappings() {
    return mappings;
  }


  public void setMappings(Map<String, String> mappings) {
    this.mappings = mappings;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    VisualizerRule visualizerRule = (VisualizerRule) o;
    return Objects.equals(this.element, visualizerRule.element) &&
        Objects.equals(this.layer, visualizerRule.layer) &&
        Objects.equals(this.visType, visualizerRule.visType) &&
        Objects.equals(this.displayName, visualizerRule.displayName) &&
        Objects.equals(this.visibility, visualizerRule.visibility) &&
        Objects.equals(this.mappings, visualizerRule.mappings);
  }

  @Override
  public int hashCode() {
    return Objects.hash(element, layer, visType, displayName, visibility, mappings);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class VisualizerRule {\n");
    sb.append("    element: ").append(toIndentedString(element)).append("\n");
    sb.append("    layer: ").append(toIndentedString(layer)).append("\n");
    sb.append("    visType: ").append(toIndentedString(visType)).append("\n");
    sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
    sb.append("    visibility: ").append(toIndentedString(visibility)).append("\n");
    sb.append("    mappings: ").append(toIndentedString(mappings)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

