/*
 * Copyright 2012 SFB 632.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
package org.corpus_tools.annis.gui.objects;

import com.google.common.base.Joiner;
import java.util.ArrayList;

/**
 * This is an a list of several {@link FrequencyTableEntry} entries.
 *
 * @author Thomas Krause {@literal <krauseto@hu-berlin.de>}
 */
public class FrequencyTableQuery extends ArrayList<FrequencyTableEntry> {

  /**
   * 
   */
  private static final long serialVersionUID = -6469357245564126773L;


  @Override
  public String toString() {
    return Joiner.on(',').join(this);
  }


}
