/*
 * Copyright 2009-2011 Collaborative Research Centre SFB 632
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
package org.corpus_tools.annis.gui.visualizers.component.tree.backends.staticimg;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

public class GraphicsItemGroup extends AbstractImageGraphicsItem {

  @Override
  public void draw(Graphics2D canvas) {}

  @Override
  public Rectangle2D getBounds() {
    Rectangle2D r = new Rectangle2D.Double();
    for (AbstractImageGraphicsItem c : getChildren()) {
      Rectangle2D childBounds = c.getBounds();
      if (childBounds != null) {
        r.add(childBounds);
      }
    }
    return r;
  }

}
