/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.api.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Configuration for configuring context in subgraph queries.")
public class CorpusConfigurationContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_DEFAULT = "default";
    @SerializedName(value="default")
    private Integer _default;
    public static final String SERIALIZED_NAME_SIZES = "sizes";
    @SerializedName(value="sizes")
    private List<Integer> sizes = null;
    public static final String SERIALIZED_NAME_MAX = "max";
    @SerializedName(value="max")
    private Integer max;
    public static final String SERIALIZED_NAME_SEGMENTATION = "segmentation";
    @SerializedName(value="segmentation")
    private String segmentation;

    public CorpusConfigurationContext _default(Integer _default) {
        this._default = _default;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The default context size.")
    public Integer getDefault() {
        return this._default;
    }

    public void setDefault(Integer _default) {
        this._default = _default;
    }

    public CorpusConfigurationContext sizes(List<Integer> sizes) {
        this.sizes = sizes;
        return this;
    }

    public CorpusConfigurationContext addSizesItem(Integer sizesItem) {
        if (this.sizes == null) {
            this.sizes = new ArrayList<Integer>();
        }
        this.sizes.add(sizesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[1,2,5,10]", value="Available context sizes to choose from.")
    public List<Integer> getSizes() {
        return this.sizes;
    }

    public void setSizes(List<Integer> sizes) {
        this.sizes = sizes;
    }

    public CorpusConfigurationContext max(Integer max) {
        this.max = max;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="25", value="If set, a maximum context size which should be enforced by the query system.")
    public Integer getMax() {
        return this.max;
    }

    public void setMax(Integer max) {
        this.max = max;
    }

    public CorpusConfigurationContext segmentation(String segmentation) {
        this.segmentation = segmentation;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="dipl", value="Default segmentation to use for defining the context, Set to null or omit it if tokens should be used.")
    public String getSegmentation() {
        return this.segmentation;
    }

    public void setSegmentation(String segmentation) {
        this.segmentation = segmentation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CorpusConfigurationContext corpusConfigurationContext = (CorpusConfigurationContext)o;
        return Objects.equals(this._default, corpusConfigurationContext._default) && Objects.equals(this.sizes, corpusConfigurationContext.sizes) && Objects.equals(this.max, corpusConfigurationContext.max) && Objects.equals(this.segmentation, corpusConfigurationContext.segmentation);
    }

    public int hashCode() {
        return Objects.hash(this._default, this.sizes, this.max, this.segmentation);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CorpusConfigurationContext {\n");
        sb.append("    _default: ").append(this.toIndentedString(this._default)).append("\n");
        sb.append("    sizes: ").append(this.toIndentedString(this.sizes)).append("\n");
        sb.append("    max: ").append(this.toIndentedString(this.max)).append("\n");
        sb.append("    segmentation: ").append(this.toIndentedString(this.segmentation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

