/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.api.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Configuration how the results of a query should be shown")
public class CorpusConfigurationView
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_BASE_TEXT_SEGMENTATION = "base_text_segmentation";
    @SerializedName(value="base_text_segmentation")
    private String baseTextSegmentation;
    public static final String SERIALIZED_NAME_PAGE_SIZE = "page_size";
    @SerializedName(value="page_size")
    private Integer pageSize;
    public static final String SERIALIZED_NAME_HIDDEN_ANNOS = "hidden_annos";
    @SerializedName(value="hidden_annos")
    private List<String> hiddenAnnos = null;

    public CorpusConfigurationView baseTextSegmentation(String baseTextSegmentation) {
        this.baseTextSegmentation = baseTextSegmentation;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="dipl", value="Default segmentation to use for the displaying the text, Set to null or omit it if tokens should be used.")
    public String getBaseTextSegmentation() {
        return this.baseTextSegmentation;
    }

    public void setBaseTextSegmentation(String baseTextSegmentation) {
        this.baseTextSegmentation = baseTextSegmentation;
    }

    public CorpusConfigurationView pageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="10", value="Default number of results to show at once for paginated queries.")
    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public CorpusConfigurationView hiddenAnnos(List<String> hiddenAnnos) {
        this.hiddenAnnos = hiddenAnnos;
        return this;
    }

    public CorpusConfigurationView addHiddenAnnosItem(String hiddenAnnosItem) {
        if (this.hiddenAnnos == null) {
            this.hiddenAnnos = new ArrayList<String>();
        }
        this.hiddenAnnos.add(hiddenAnnosItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of fully qualified annotation names that should be hidden when displayed.")
    public List<String> getHiddenAnnos() {
        return this.hiddenAnnos;
    }

    public void setHiddenAnnos(List<String> hiddenAnnos) {
        this.hiddenAnnos = hiddenAnnos;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CorpusConfigurationView corpusConfigurationView = (CorpusConfigurationView)o;
        return Objects.equals(this.baseTextSegmentation, corpusConfigurationView.baseTextSegmentation) && Objects.equals(this.pageSize, corpusConfigurationView.pageSize) && Objects.equals(this.hiddenAnnos, corpusConfigurationView.hiddenAnnos);
    }

    public int hashCode() {
        return Objects.hash(this.baseTextSegmentation, this.pageSize, this.hiddenAnnos);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CorpusConfigurationView {\n");
        sb.append("    baseTextSegmentation: ").append(this.toIndentedString(this.baseTextSegmentation)).append("\n");
        sb.append("    pageSize: ").append(this.toIndentedString(this.pageSize)).append("\n");
        sb.append("    hiddenAnnos: ").append(this.toIndentedString(this.hiddenAnnos)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

