/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.api.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.corpus_tools.annis.api.model.QueryLanguage;

@ApiModel(description="Query definition for counting matches.")
public class CountQuery
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_QUERY = "query";
    @SerializedName(value="query")
    private String query;
    public static final String SERIALIZED_NAME_QUERY_LANGUAGE = "query_language";
    @SerializedName(value="query_language")
    private QueryLanguage queryLanguage = QueryLanguage.AQL;
    public static final String SERIALIZED_NAME_CORPORA = "corpora";
    @SerializedName(value="corpora")
    private List<String> corpora = null;

    public CountQuery query(String query) {
        this.query = query;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="tok", value="The query to execute.")
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public CountQuery queryLanguage(QueryLanguage queryLanguage) {
        this.queryLanguage = queryLanguage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public QueryLanguage getQueryLanguage() {
        return this.queryLanguage;
    }

    public void setQueryLanguage(QueryLanguage queryLanguage) {
        this.queryLanguage = queryLanguage;
    }

    public CountQuery corpora(List<String> corpora) {
        this.corpora = corpora;
        return this;
    }

    public CountQuery addCorporaItem(String corporaItem) {
        if (this.corpora == null) {
            this.corpora = new ArrayList<String>();
        }
        this.corpora.add(corporaItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"GUM\",\"pcc2.1\"]", value="List of corpus names/identifiers.")
    public List<String> getCorpora() {
        return this.corpora;
    }

    public void setCorpora(List<String> corpora) {
        this.corpora = corpora;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CountQuery countQuery = (CountQuery)o;
        return Objects.equals(this.query, countQuery.query) && Objects.equals((Object)this.queryLanguage, (Object)countQuery.queryLanguage) && Objects.equals(this.corpora, countQuery.corpora);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.query, this.queryLanguage, this.corpora});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CountQuery {\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    queryLanguage: ").append(this.toIndentedString((Object)this.queryLanguage)).append("\n");
        sb.append("    corpora: ").append(this.toIndentedString(this.corpora)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

