/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.api.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.corpus_tools.annis.api.model.QueryLanguage;

@ApiModel(description="Query definition to find matches")
public class FindQuery
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_QUERY = "query";
    @SerializedName(value="query")
    private String query;
    public static final String SERIALIZED_NAME_QUERY_LANGUAGE = "query_language";
    @SerializedName(value="query_language")
    private QueryLanguage queryLanguage = QueryLanguage.AQL;
    public static final String SERIALIZED_NAME_CORPORA = "corpora";
    @SerializedName(value="corpora")
    private List<String> corpora = null;
    public static final String SERIALIZED_NAME_LIMIT = "limit";
    @SerializedName(value="limit")
    private Integer limit;
    public static final String SERIALIZED_NAME_OFFSET = "offset";
    @SerializedName(value="offset")
    private Integer offset = 0;
    public static final String SERIALIZED_NAME_ORDER = "order";
    @SerializedName(value="order")
    private OrderEnum order = OrderEnum.NORMAL;

    public FindQuery query(String query) {
        this.query = query;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="tok", value="The query to execute.")
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public FindQuery queryLanguage(QueryLanguage queryLanguage) {
        this.queryLanguage = queryLanguage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public QueryLanguage getQueryLanguage() {
        return this.queryLanguage;
    }

    public void setQueryLanguage(QueryLanguage queryLanguage) {
        this.queryLanguage = queryLanguage;
    }

    public FindQuery corpora(List<String> corpora) {
        this.corpora = corpora;
        return this;
    }

    public FindQuery addCorporaItem(String corporaItem) {
        if (this.corpora == null) {
            this.corpora = new ArrayList<String>();
        }
        this.corpora.add(corporaItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"GUM\",\"pcc2.1\"]", value="List of corpus names/identifiers.")
    public List<String> getCorpora() {
        return this.corpora;
    }

    public void setCorpora(List<String> corpora) {
        this.corpora = corpora;
    }

    public FindQuery limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="10", value="Return at most `n` matches, where `n` is the limit.  Use `null` to allow unlimited result sizes.")
    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public FindQuery offset(Integer offset) {
        this.offset = offset;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Skip the `n` first results, where `n` is the offset.")
    public Integer getOffset() {
        return this.offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public FindQuery order(OrderEnum order) {
        this.order = order;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public OrderEnum getOrder() {
        return this.order;
    }

    public void setOrder(OrderEnum order) {
        this.order = order;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FindQuery findQuery = (FindQuery)o;
        return Objects.equals(this.query, findQuery.query) && Objects.equals((Object)this.queryLanguage, (Object)findQuery.queryLanguage) && Objects.equals(this.corpora, findQuery.corpora) && Objects.equals(this.limit, findQuery.limit) && Objects.equals(this.offset, findQuery.offset) && Objects.equals((Object)this.order, (Object)findQuery.order);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.query, this.queryLanguage, this.corpora, this.limit, this.offset, this.order});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FindQuery {\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    queryLanguage: ").append(this.toIndentedString((Object)this.queryLanguage)).append("\n");
        sb.append("    corpora: ").append(this.toIndentedString(this.corpora)).append("\n");
        sb.append("    limit: ").append(this.toIndentedString(this.limit)).append("\n");
        sb.append("    offset: ").append(this.toIndentedString(this.offset)).append("\n");
        sb.append("    order: ").append(this.toIndentedString((Object)this.order)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum OrderEnum {
        NORMAL("Normal"),
        INVERTED("Inverted"),
        RANDOMIZED("Randomized"),
        NOTSORTED("NotSorted");

        private String value;

        private OrderEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static OrderEnum fromValue(String value) {
            for (OrderEnum b : OrderEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<OrderEnum> {
            public void write(JsonWriter jsonWriter, OrderEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public OrderEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return OrderEnum.fromValue(value);
            }
        }
    }
}

